/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui.widgets;

import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.IconPositionPreset;
import net.minecraft.util.Mth;

public class AnnouncementIconAnimator {
    public static final AnnouncementIconAnimator INSTANCE = new AnnouncementIconAnimator();
    private static final float HOVER_SCALE = 1.3f;
    private static final float CLICK_SCALE = 0.9f;
    private static final float IDLE_SCALE = 1.0f;
    private static final int WIGGLE_INTERVAL_TICKS = 80;
    private static final int WIGGLE_DURATION_TICKS = 5;
    private static final float WIGGLE_MAX_ANGLE_DEGREES = 50.0f;
    private static final int CLICK_ANIMATION_DURATION_TICKS = 2;
    private static final double STIFFNESS = 3.0;
    private static final double DAMPING = 4.5;
    private static final double MASS = 7.0;
    private static final float ROTATION_KICK_INTENSITY = 0.2f;
    private static final int WOBBLE_DURATION_TICKS = 30;
    private static final float WOBBLE_DECAY_POWER = 2.7f;
    private static final float WOBBLE_OSCILLATIONS = 12.0f;
    private static final float WOBBLE_BASE_VEL_MULTIPLIER = 50.0f;
    private static final float WOBBLE_MAX_ICON_FRACTION = 0.35f;
    private static final float WOBBLE_MIN_ICON_FRACTION = 0.08f;
    private double currentX;
    private double currentY;
    private double currentScale = 1.0;
    private double currentAngle = 0.0;
    private double prevX;
    private double prevY;
    private double prevScale = 1.0;
    private double prevAngle = 0.0;
    private double velocityX;
    private double velocityY;
    private double scaleVelocity;
    private double angularVelocity = 0.0;
    private float iconPixelSize = 16.0f;
    private double targetX;
    private double targetY;
    private float targetScale = 1.0f;
    private float targetAngle = 0.0f;
    private float wiggleAngle = 0.0f;
    private int wiggleTimer = 0;
    private int clickAnimationTicks = 0;
    private int settleWobbleTicks = 0;
    private double wobbleAngle = 0.0;
    private double wobbleMagnitude = 0.0;
    private double lastVelocityX = 0.0;
    private double lastVelocityY = 0.0;
    private float lastRenderDelta = 0.0f;

    public void updatePhysicsForRender(float tickDelta) {
        float deltaTicks = tickDelta - this.lastRenderDelta;
        if (deltaTicks < 0.0f) {
            deltaTicks = tickDelta;
        }
        this.lastRenderDelta = tickDelta;
        if (deltaTicks <= 0.0f) {
            return;
        }
        double errX_before = this.currentX - this.targetX;
        double errY_before = this.currentY - this.targetY;
        double velX_before = this.velocityX;
        double velY_before = this.velocityY;
        this.updatePhysicsPropertyTimed(this.currentX, this.velocityX, this.targetX, deltaTicks, (val, vel) -> {
            this.currentX = val;
            this.velocityX = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentY, this.velocityY, this.targetY, deltaTicks, (val, vel) -> {
            this.currentY = val;
            this.velocityY = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentScale, this.scaleVelocity, this.targetScale, deltaTicks, (val, vel) -> {
            this.currentScale = val;
            this.scaleVelocity = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentAngle, this.angularVelocity, this.targetAngle, deltaTicks, (val, vel) -> {
            this.currentAngle = val;
            this.angularVelocity = vel;
        });
        this.lastVelocityX = this.velocityX;
        this.lastVelocityY = this.velocityY;
        if (this.settleWobbleTicks == 0) {
            boolean crossedX;
            double errX_after = this.currentX - this.targetX;
            double errY_after = this.currentY - this.targetY;
            boolean bl = errX_before == 0.0 ? false : (crossedX = errX_before * errX_after < 0.0);
            boolean crossedY = errY_before == 0.0 ? false : errY_before * errY_after < 0.0;
            boolean crossed = crossedX || crossedY;
            double speed_before = Math.sqrt(velX_before * velX_before + velY_before * velY_before);
            if (crossed) {
                this.settleWobbleTicks = 30;
                this.wobbleAngle = Math.atan2(-velY_before, -velX_before);
                float rawKick = (float)(speed_before * 50.0);
                float maxPx = 0.35f * this.iconPixelSize;
                float minPx = 0.08f * this.iconPixelSize;
                this.wobbleMagnitude = Math.max(minPx, Math.min(rawKick, maxPx));
            }
        }
    }

    private void updatePhysicsPropertyTimed(double current, double velocity, double target, double delta, PropertyUpdater updater) {
        double springForce = -3.0 * (current - target);
        double dampingForce = -4.5 * velocity;
        double acceleration = (springForce + dampingForce) / 7.0;
        double newVelocity = velocity + acceleration * delta;
        double newValue = current + newVelocity * delta;
        updater.update(newValue, newVelocity);
    }

    private AnnouncementIconAnimator() {
    }

    public void updateTargetPosition(int screenWidth, int screenHeight) {
        double newTargetY;
        AhpConfig config = Configs.AHP;
        IconPositionPreset preset = (IconPositionPreset)((Object)config.hudIconPositionPreset.get());
        double scale = ((Float)config.hudIconScale.get()).floatValue();
        int iconWidth = 16;
        int iconHeight = 16;
        this.iconPixelSize = (float)((double)Math.max(iconWidth, iconHeight) * scale);
        double newTargetX = switch (preset) {
            default -> throw new MatchException(null, null);
            case IconPositionPreset.TOP_LEFT, IconPositionPreset.BOTTOM_LEFT -> ((Integer)config.hudIconOffsetX.get()).intValue();
            case IconPositionPreset.TOP_RIGHT, IconPositionPreset.BOTTOM_RIGHT -> (double)screenWidth - (double)iconWidth * scale - (double)((Integer)config.hudIconOffsetX.get()).intValue();
        };
        switch (preset) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP_LEFT: 
            case TOP_RIGHT: {
                double d = ((Integer)config.hudIconOffsetY.get()).intValue();
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                double d = newTargetY = (double)screenHeight - (double)iconHeight * scale - (double)((Integer)config.hudIconOffsetY.get()).intValue();
            }
        }
        if (newTargetX != this.targetX || newTargetY != this.targetY) {
            this.startTransition(newTargetX, newTargetY);
        }
    }

    public void tick(boolean isGuiOpen) {
        this.prevX = this.currentX;
        this.prevY = this.currentY;
        this.prevScale = this.currentScale;
        this.prevAngle = this.currentAngle;
        this.lastRenderDelta = 0.0f;
        if (this.clickAnimationTicks > 0) {
            --this.clickAnimationTicks;
            this.targetScale = 0.9f;
        }
        ++this.wiggleTimer;
        if (this.wiggleTimer > 85) {
            this.wiggleTimer = 0;
        }
        if (this.settleWobbleTicks > 0) {
            --this.settleWobbleTicks;
        }
        this.targetAngle = (float)(this.velocityX * (double)0.2f);
        this.lastVelocityX = this.velocityX;
        this.lastVelocityY = this.velocityY;
        this.updatePhysicsPropertyTimed(this.currentX, this.velocityX, this.targetX, 1.0, (val, vel) -> {
            this.currentX = val;
            this.velocityX = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentY, this.velocityY, this.targetY, 1.0, (val, vel) -> {
            this.currentY = val;
            this.velocityY = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentScale, this.scaleVelocity, this.targetScale, 1.0, (val, vel) -> {
            this.currentScale = val;
            this.scaleVelocity = vel;
        });
        this.updatePhysicsPropertyTimed(this.currentAngle, this.angularVelocity, this.targetAngle, 1.0, (val, vel) -> {
            this.currentAngle = val;
            this.angularVelocity = vel;
        });
    }

    public void startTransition(double newTargetX, double newTargetY) {
        this.targetX = newTargetX;
        this.targetY = newTargetY;
    }

    public void triggerClickAnimation() {
        this.clickAnimationTicks = 2;
        this.targetScale = 0.9f;
    }

    public void setHovered(boolean hovered) {
        if (this.clickAnimationTicks == 0) {
            this.targetScale = hovered ? 1.3f : 1.0f;
        }
    }

    public double getTargetX() {
        return this.targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    private void updatePhysicsProperty(double current, double velocity, double target, PropertyUpdater updater) {
        double springForce = -3.0 * (current - target);
        double dampingForce = -4.5 * velocity;
        double acceleration = (springForce + dampingForce) / 7.0;
        double newVelocity = velocity + acceleration;
        double newValue = current + newVelocity;
        updater.update(newValue, newVelocity);
    }

    public void updateHudPosition(double x, double y) {
        this.targetX = x;
        this.targetY = y;
        this.currentX = x;
        this.currentY = y;
        this.prevX = x;
        this.prevY = y;
        this.velocityX = 0.0;
        this.velocityY = 0.0;
    }

    public float getRenderScale(float tickDelta) {
        this.updatePhysicsForRender(tickDelta);
        return (float)this.currentScale;
    }

    public float getRenderAngle(float tickDelta) {
        this.updatePhysicsForRender(tickDelta);
        float physicsAngle = (float)this.currentAngle;
        float wiggleTarget = 0.0f;
        if (this.wiggleTimer > 80) {
            float progress = ((float)(this.wiggleTimer - 80) + tickDelta) / 5.0f;
            wiggleTarget = Mth.sin((float)(progress * (float)Math.PI * 2.0f)) * 50.0f;
        }
        this.wiggleAngle += (wiggleTarget - this.wiggleAngle) * 0.4f * tickDelta;
        return physicsAngle + this.wiggleAngle;
    }

    public double getRenderX(float tickDelta) {
        this.updatePhysicsForRender(tickDelta);
        double physicalX = this.currentX;
        if (this.settleWobbleTicks > 0) {
            float progress = (30.0f - ((float)this.settleWobbleTicks - tickDelta)) / 30.0f;
            double decay = Math.pow(1.0 - (double)progress, 2.7f);
            double sineWave = Math.sin((double)progress * Math.PI * 2.0 * 12.0);
            return physicalX + Math.cos(this.wobbleAngle) * this.wobbleMagnitude * sineWave * decay;
        }
        return physicalX;
    }

    public double getRenderY(float tickDelta) {
        this.updatePhysicsForRender(tickDelta);
        double physicalY = this.currentY;
        if (this.settleWobbleTicks > 0) {
            float progress = (30.0f - ((float)this.settleWobbleTicks - tickDelta)) / 30.0f;
            double decay = Math.pow(1.0 - (double)progress, 2.7f);
            double sineWave = Math.sin((double)progress * Math.PI * 2.0 * 12.0);
            return physicalY + Math.sin(this.wobbleAngle) * this.wobbleMagnitude * sineWave * decay;
        }
        return physicalY;
    }

    @FunctionalInterface
    private static interface PropertyUpdater {
        public void update(double var1, double var3);
    }
}

