/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.dawson.adorablehamsterpets.client.render.LeafJiggleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LeafJiggleRenderer {
    private static final float AMPLITUDE = 0.05f;
    private static final float ROTATION_AMPLITUDE = 4.0f;
    private static final float OSCILLATION_CYCLES = 6.0f;

    public static void render(Minecraft client, PoseStack matrices, MultiBufferSource vertexConsumers, Vec3 cameraPos, float tickDelta) {
        if (client.level == null) {
            return;
        }
        long worldTime = client.level.getGameTime();
        BlockRenderDispatcher blockRenderManager = client.getBlockRenderer();
        for (Long2ObjectMap.Entry<LeafJiggleManager.Jiggle> entry : LeafJiggleManager.INSTANCE.getActiveJiggles()) {
            LeafJiggleManager.Jiggle jiggle;
            float age;
            BlockState state;
            long posLong = entry.getLongKey();
            BlockPos pos = BlockPos.of((long)posLong);
            if (!client.level.hasChunk(pos.getX() >> 4, pos.getZ() >> 4) || !(state = client.level.getBlockState(pos)).is(BlockTags.LEAVES) || (age = (float)(worldTime - (jiggle = (LeafJiggleManager.Jiggle)entry.getValue()).startTick()) + tickDelta) < 0.0f || age > 20.0f) continue;
            float p = age / 20.0f;
            float envelope = 0.5f - 0.5f * Mth.cos((float)((float)(Math.PI * 2 * (double)p)));
            float w = 1.8849556f;
            RandomSource r = RandomSource.create((long)jiggle.seed());
            float phaseX = r.nextFloat() * ((float)Math.PI * 2);
            float phaseZ = r.nextFloat() * ((float)Math.PI * 2);
            float phaseRotX = r.nextFloat() * ((float)Math.PI * 2);
            float phaseRotY = r.nextFloat() * ((float)Math.PI * 2);
            float phaseRotZ = r.nextFloat() * ((float)Math.PI * 2);
            float dx = envelope * 0.05f * Mth.cos((float)(w * age + phaseX));
            float dy = 0.0f;
            float dz = envelope * 0.05f * Mth.sin((float)(w * age + phaseZ));
            float rotX = envelope * 4.0f * Mth.sin((float)(w * age + phaseRotX));
            float rotY = envelope * 4.0f * Mth.cos((float)(w * age + phaseRotY));
            float rotZ = envelope * 4.0f * Mth.sin((float)(w * age + phaseRotZ));
            matrices.pushPose();
            matrices.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
            matrices.translate(0.5, 0.5, 0.5);
            matrices.translate(dx, dy, dz);
            matrices.mulPose(Axis.XP.rotationDegrees(rotX));
            matrices.mulPose(Axis.YP.rotationDegrees(rotY));
            matrices.mulPose(Axis.ZP.rotationDegrees(rotZ));
            matrices.translate(-0.5, -0.5, -0.5);
            int light = LevelRenderer.getLightColor((BlockAndTintGetter)client.level, (BlockState)state, (BlockPos)pos);
            BakedModel model = blockRenderManager.getBlockModel(state);
            VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.cutoutMipped());
            blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)client.level, model, state, pos, matrices, buffer, false, RandomSource.create(), state.getSeed(pos), OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
    }
}

