/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HamsterFleeGoal<T extends LivingEntity>
extends AvoidEntityGoal<T> {
    private final HamsterEntity hamster;

    public HamsterFleeGoal(HamsterEntity hamster, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
        super((PathfinderMob)hamster, fleeFromType, distance, slowSpeed, fastSpeed, livingEntity -> HamsterFleeGoal.shouldFlee(hamster, livingEntity));
        this.hamster = hamster;
    }

    public void start() {
        super.start();
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void stop() {
        super.stop();
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public static boolean isPlayerSafe(Player player) {
        if (!player.isShiftKeyDown()) {
            return false;
        }
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        boolean holdingCucumber = mainHandStack.is((Item)ModItems.SLICED_CUCUMBER.get()) || offHandStack.is((Item)ModItems.SLICED_CUCUMBER.get());
        return holdingCucumber;
    }

    private static boolean shouldFlee(HamsterEntity hamster, LivingEntity livingToFleeFrom) {
        if (hamster.isTame()) {
            return false;
        }
        if (livingToFleeFrom instanceof Monster) {
            return true;
        }
        if (livingToFleeFrom instanceof Player) {
            Player player = (Player)livingToFleeFrom;
            return !HamsterFleeGoal.isPlayerSafe(player);
        }
        return false;
    }
}

