/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.FollowOwnerGoalAccessor;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class HamsterFollowOwnerGoal
extends FollowOwnerGoal {
    private final HamsterEntity hamster;
    private static final double BUFFED_FOLLOW_SPEED = 1.5;

    public HamsterFollowOwnerGoal(HamsterEntity hamster, double speed, float minDistance, float maxDistance) {
        super((TamableAnimal)hamster, speed, minDistance, maxDistance);
        this.hamster = hamster;
    }

    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingRetrieval() || this.hamster.isWanderModeActive()) {
            return false;
        }
        float minDist = ((FollowOwnerGoalAccessor)((Object)this)).getMinDistance();
        LivingEntity owner = ((FollowOwnerGoalAccessor)((Object)this)).getOwner();
        if (owner == null) {
            return false;
        }
        if (this.hamster.unableToMoveToOwner()) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            minDist += 5.0f;
        }
        return !(this.hamster.distanceToSqr((Entity)owner) < (double)(minDist * minDist));
    }

    public boolean canContinueToUse() {
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingRetrieval()) {
            return false;
        }
        float maxDist = ((FollowOwnerGoalAccessor)((Object)this)).getMaxDistance();
        LivingEntity owner = ((FollowOwnerGoalAccessor)((Object)this)).getOwner();
        if (owner == null) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            maxDist += 5.0f;
        }
        return !this.hamster.getNavigation().isDone() && this.hamster.distanceToSqr((Entity)owner) > (double)(maxDist * maxDist);
    }

    public void start() {
        super.start();
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.hamster.hasGreenBeanBuff() ? " (Zoomies)" : ""));
        AdorableHamsterPets.LOGGER.trace("[FollowGoal-{}] start: Goal has started. IsBuffed: {}", (Object)this.hamster.getId(), (Object)this.hamster.hasGreenBeanBuff());
    }

    public void tick() {
        FollowOwnerGoalAccessor accessor = (FollowOwnerGoalAccessor)((Object)this);
        LivingEntity owner = ((FollowOwnerGoalAccessor)((Object)this)).getOwner();
        if (owner == null) {
            return;
        }
        boolean shouldTeleport = this.hamster.shouldTryTeleportToOwner();
        if (!shouldTeleport) {
            this.hamster.getLookControl().setLookAt((Entity)owner, 25.0f, 25.0f);
        }
        int currentTicks = accessor.getUpdateCountdownTicks() - 1;
        accessor.setUpdateCountdownTicks(currentTicks);
        if (currentTicks <= 0) {
            accessor.setUpdateCountdownTicks(this.adjustedTickDelay(10));
            if (shouldTeleport) {
                this.hamster.tryToTeleportToOwner();
            } else if (this.hamster.hasGreenBeanBuff()) {
                Vec3 targetPos = LandRandomPos.getPosTowards((PathfinderMob)this.hamster, (int)8, (int)5, (Vec3)Vec3.atCenterOf((Vec3i)owner.blockPosition()));
                if (targetPos != null) {
                    this.hamster.getNavigation().moveTo(targetPos.x, targetPos.y, targetPos.z, 1.5);
                }
            } else {
                this.hamster.getNavigation().moveTo((Entity)owner, accessor.getSpeed());
            }
        }
    }

    public void stop() {
        super.stop();
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }
}

