/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.Optional;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;

public class HamsterGoToBedAndSleepGoal
extends Goal {
    private static final int MIN_START_DELAY_TICKS = 5;
    private static final int MAX_START_DELAY_TICKS = 100;
    private final HamsterEntity hamster;
    private final Level world;
    private State currentState = State.MOVING_TO_BED;
    private int pounceTicks;
    @Nullable
    private Vec3 pounceStartPos;
    private int startDelay = 0;
    private boolean wasLured = false;
    private int awakeTimer = 0;
    private int pathfindingFailureCount = 0;

    public HamsterGoToBedAndSleepGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (!this.hamster.isWanderModeActive() || this.hamster.isOrderedToSit() || !((Boolean)Configs.AHP.allowSleepInBed.get()).booleanValue()) {
            return false;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.dimension() != bedPosOptional.get().dimension()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get().pos();
        BlockState bedState = this.world.getBlockState(bedPos);
        BlockEntity be = this.world.getBlockEntity(bedPos);
        if (!(bedState.getBlock() instanceof HamsterBedBlock) || ((Boolean)bedState.getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue() || !(be instanceof HamsterBedBlockEntity)) {
            return false;
        }
        HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
        if (!bedEntity.isSleepingAllowed()) {
            return false;
        }
        if (this.hamster.getLureToBedTimer() > 0) {
            return true;
        }
        if (bedEntity.isNewlyPlaced()) {
            return true;
        }
        if (this.hamster.getGoToBedCooldown() > 0) {
            return false;
        }
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            if (this.awakeTimer > 0) {
                --this.awakeTimer;
                return false;
            }
            return true;
        }
        boolean isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? this.world.isDay() : this.world.isNight();
        return isSleepTime;
    }

    public boolean canContinueToUse() {
        if (this.hamster.isOrderedToSit() || !this.hamster.isWanderModeActive()) {
            return false;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.dimension() != bedPosOptional.get().dimension()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get().pos();
        BlockState bedState = this.world.getBlockState(bedPos);
        return bedState.getBlock() instanceof HamsterBedBlock && (Boolean)bedState.getValue((Property)HamsterBedBlock.OCCUPIED) == false;
    }

    public void start() {
        boolean isLured;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        this.hamster.setOnTheWayToBed(true);
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.awakeTimer = this.hamster.getRandom().nextIntBetweenInclusive(min, max);
        }
        this.wasLured = isLured = this.hamster.getLureToBedTimer() > 0;
        boolean isNewBed = false;
        boolean shouldBypass = this.hamster.shouldBypassNextSleepDelay();
        Optional<GlobalPos> bedPosOpt = this.hamster.getLinkedBedPos();
        if (bedPosOpt.isPresent()) {
            BlockEntity be;
            BlockPos bedPos = bedPosOpt.get().pos();
            if (this.world.dimension() == bedPosOpt.get().dimension() && (be = this.world.getBlockEntity(bedPos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                isNewBed = bedEntity.isNewlyPlaced();
            }
        }
        if (isLured || isNewBed || shouldBypass || ((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            this.startDelay = 0;
            if (isLured) {
                this.hamster.setLureToBedTimer(0);
            }
            if (shouldBypass) {
                this.hamster.setBypassNextSleepDelay(false);
            }
        } else {
            this.startDelay = this.hamster.getRandom().nextIntBetweenInclusive(5, 100);
        }
        this.hamster.setGoToBedDelayTicks(this.startDelay);
        this.currentState = State.MOVING_TO_BED;
    }

    public void stop() {
        this.hamster.getNavigation().stop();
        this.currentState = State.MOVING_TO_BED;
        this.pounceStartPos = null;
        this.wasLured = false;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.hamster.setOnTheWayToBed(false);
        this.hamster.setGoToBedDelayTicks(this.startDelay);
    }

    public void tick() {
        if (this.startDelay > 0) {
            --this.startDelay;
            this.hamster.setGoToBedDelayTicks(this.startDelay);
            return;
        }
        Optional<GlobalPos> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty()) {
            this.stop();
            return;
        }
        BlockPos bedPos = bedPosOptional.get().pos();
        if (this.currentState == State.MOVING_TO_BED && this.hamster.getNavigation().isDone()) {
            this.hamster.getNavigation().moveTo((double)bedPos.getX() + 0.5, (double)bedPos.getY(), (double)bedPos.getZ() + 0.5, 0.75);
        }
        if (this.currentState == State.MOVING_TO_BED && (this.hamster.getNavigation().isDone() || this.hamster.tickCount % 20 == 0)) {
            boolean success = this.hamster.getNavigation().moveTo((double)bedPos.getX() + 0.5, (double)bedPos.getY(), (double)bedPos.getZ() + 0.5, 0.75);
            if (!success) {
                ++this.pathfindingFailureCount;
                if (this.pathfindingFailureCount > 5 && !this.hamster.isStuckSearchingForBed()) {
                    this.hamster.setStuckSearchingForBed(true);
                }
            } else {
                this.pathfindingFailureCount = 0;
                if (this.hamster.isStuckSearchingForBed()) {
                    this.hamster.setStuckSearchingForBed(false);
                }
            }
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                String settleAnimId;
                this.hamster.getLookControl().setLookAt(Vec3.atCenterOf((Vec3i)bedPos));
                if (this.wasLured && !this.world.isClientSide() && !this.hamster.getNavigation().isDone()) {
                    ParticleEffectsUtil.spawnBreadcrumbs((ServerLevel)this.world, this.hamster.getNavigation().getPath());
                }
                if (this.hamster.getNavigation().isDone()) {
                    this.stop();
                    return;
                }
                if (!this.hamster.blockPosition().closerThan((Vec3i)bedPos, 1.2)) break;
                this.hamster.getNavigation().stop();
                this.currentState = State.POUNCING_INTO_BED;
                this.pounceTicks = 5;
                this.pounceStartPos = this.hamster.position();
                this.hamster.setDeltaMovement(this.hamster.getDeltaMovement().x, 0.4, this.hamster.getDeltaMovement().z);
                this.hamster.hasImpulse = true;
                this.hamster.suffocationGracePeriod = 40;
                this.world.playSound(null, this.hamster.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.35f, 1.0f + this.hamster.getRandom().nextFloat() * 0.5f);
                int choice = this.hamster.getRandom().nextInt(3);
                this.hamster.getEntityData().set(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)(switch (choice) {
                    case 0 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep1";
                        yield "anim_hamster_sleep_pose1";
                    }
                    case 1 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep2";
                        yield "anim_hamster_sleep_pose2";
                    }
                    default -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep3";
                        yield "anim_hamster_sleep_pose3";
                    }
                }));
                this.hamster.triggerAnimOnServer("mainController", settleAnimId);
                break;
            }
            case 1: {
                --this.pounceTicks;
                this.hamster.getLookControl().setLookAt(Vec3.atCenterOf((Vec3i)bedPos));
                if (this.pounceStartPos != null && this.pounceTicks >= 0) {
                    double progress = 1.0 - (double)this.pounceTicks / 5.0;
                    double easedProgress = progress * progress;
                    Vec3 targetCenter = Vec3.atCenterOf((Vec3i)bedPos).add(0.0, 0.1, 0.0);
                    double newX = this.pounceStartPos.x + easedProgress * (targetCenter.x - this.pounceStartPos.x);
                    double newZ = this.pounceStartPos.z + easedProgress * (targetCenter.z - this.pounceStartPos.z);
                    this.hamster.setPos(newX, this.hamster.getY(), newZ);
                }
                if (this.pounceTicks >= 0) break;
                Vec3 targetCenter = Vec3.atCenterOf((Vec3i)bedPos).add(0.0, 0.1, 0.0);
                this.hamster.setPos(targetCenter.x, targetCenter.y, targetCenter.z);
                this.hamster.setDeltaMovement(Vec3.ZERO);
                this.hamster.hasImpulse = true;
                this.hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                this.hamster.setSleeping(true);
                this.hamster.setInSittingPose(true);
                this.world.setBlock(bedPos, (BlockState)this.world.getBlockState(bedPos).setValue((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                this.hamster.startNapTimer();
                BlockEntity be = this.world.getBlockEntity(bedPos);
                if (be instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_occupied");
                }
                this.hamster.startBedSleepEffects();
                if (!(be instanceof HamsterBedBlockEntity)) break;
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.markAsUsed();
            }
        }
    }

    private static enum State {
        MOVING_TO_BED,
        POUNCING_INTO_BED;

    }
}

