/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.LookAtEntityGoalAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;

public class HamsterLookAtEntityGoal
extends LookAtPlayerGoal {
    private final Mob hamsterMob;
    private final float chance;

    public HamsterLookAtEntityGoal(Mob mob, Class<? extends LivingEntity> targetType, float range) {
        super(mob, targetType, range);
        this.hamsterMob = mob;
        this.chance = 0.02f;
    }

    public HamsterLookAtEntityGoal(Mob mob, Class<? extends LivingEntity> targetType, float range, float chance) {
        super(mob, targetType, range, chance);
        this.hamsterMob = mob;
        this.chance = chance;
    }

    public HamsterLookAtEntityGoal(Mob mob, Class<? extends LivingEntity> targetType, float range, float chance, boolean lookForward) {
        super(mob, targetType, range, chance, lookForward);
        this.hamsterMob = mob;
        this.chance = chance;
    }

    public boolean canUse() {
        HamsterEntity hamster;
        Mob mob = this.hamsterMob;
        if (mob instanceof HamsterEntity && ((hamster = (HamsterEntity)mob).isOrderedToSit() || hamster.isSleeping() || hamster.isKnockedOut() || hamster.isSulking() || hamster.isHoldingInterestItem() || hamster.getActiveCustomGoalDebugName().equals(HamsterWanderAroundFarGoal.class.getSimpleName()))) {
            return false;
        }
        boolean superCanStart = super.canUse();
        if (!superCanStart) {
            AdorableHamsterPets.LOGGER.trace("[LookAtGoal-{}] canStart FAILED: super.canStart() returned false (chance or no target).", (Object)this.hamsterMob.getId());
            return false;
        }
        AdorableHamsterPets.LOGGER.trace("[LookAtGoal-{}] canStart SUCCEEDED. All checks passed.", (Object)this.hamsterMob.getId());
        return true;
    }

    public void start() {
        super.start();
        int baseDuration = (Integer)Configs.AHP.lookAtDuration.get();
        int calculatedDuration = baseDuration + this.mob.getRandom().nextInt(80);
        ((LookAtEntityGoalAccessor)((Object)this)).setLookTime(this.adjustedTickDelay(calculatedDuration));
        Mob mob = this.mob;
        if (mob instanceof HamsterEntity) {
            HamsterEntity he = (HamsterEntity)mob;
            he.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
            he.getEntityData().set(HamsterEntity.CURRENT_LOOK_UP_ANIM_ID, (Object)he.getRandom().nextIntBetweenInclusive(1, 3));
            AdorableHamsterPets.LOGGER.trace("[AI Goal Start] Hamster {} started LookAtEntityGoal with duration {} ticks (Base: {} + Random).", new Object[]{he.getId(), calculatedDuration, baseDuration});
        }
    }

    public boolean canContinueToUse() {
        HamsterEntity hamster;
        Mob mob = this.hamsterMob;
        if (mob instanceof HamsterEntity && ((hamster = (HamsterEntity)mob).isOrderedToSit() || hamster.isSleeping() || hamster.isKnockedOut() || hamster.isSulking() || hamster.isHoldingInterestItem())) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void stop() {
        HamsterEntity he;
        super.stop();
        Mob mob = this.mob;
        if (mob instanceof HamsterEntity && (he = (HamsterEntity)mob).getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            he.setActiveCustomGoalDebugName("None");
        }
    }

    public void tick() {
        LookAtEntityGoalAccessor accessor = (LookAtEntityGoalAccessor)((Object)this);
        Entity target = accessor.getTarget();
        if (target != null && target.isAlive()) {
            double targetY = accessor.getLookForward() ? this.mob.getEyeY() : target.getEyeY();
            this.mob.getLookControl().setLookAt(target.getX(), targetY, target.getZ(), 25.0f, 25.0f);
            accessor.setLookTime(accessor.getLookTime() - 1);
        }
    }
}

