/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class HamsterMateGoal
extends Goal {
    private final HamsterEntity hamster;
    private HamsterEntity targetMate;
    private final double speed;
    private int timer;

    public HamsterMateGoal(HamsterEntity hamster, double speed) {
        this.hamster = hamster;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.hamster.isOrderedToSit()) {
            return false;
        }
        boolean inLove = this.hamster.isInCustomLove();
        if (inLove) {
            this.targetMate = this.getNearbyMate();
            return this.targetMate != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.targetMate != null && this.targetMate.isAlive() && this.hamster.isInCustomLove() && this.timer < 60;
    }

    public void start() {
        this.timer = 0;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void stop() {
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.targetMate = null;
    }

    public void tick() {
        this.hamster.getNavigation().moveTo((Entity)this.targetMate, this.speed);
        this.hamster.getLookControl().setLookAt((Entity)this.targetMate, 25.0f, 25.0f);
        ++this.timer;
        if (this.timer >= 60) {
            this.breed();
        }
    }

    private HamsterEntity getNearbyMate() {
        AdorableHamsterPets.LOGGER.trace("[MateGoal {} Tick {}] getNearbyMate() searching...", (Object)this.hamster.getId(), (Object)this.hamster.level().getGameTime());
        List candidates = this.hamster.level().getEntitiesOfClass(HamsterEntity.class, this.hamster.getBoundingBox().inflate(8.0), h -> {
            boolean potential = h != this.hamster && h.isInCustomLove() && h.getAge() == 0;
            AdorableHamsterPets.LOGGER.trace("  - Checking candidate {}: isInCustomLove={}, getBreedingAge={}, isSelf={}, Result={}", new Object[]{h.getId(), h.isInCustomLove(), h.getAge(), h == this.hamster, potential});
            return potential;
        });
        HamsterEntity found = candidates.stream().findAny().orElse(null);
        AdorableHamsterPets.LOGGER.trace("[MateGoal {} Tick {}] getNearbyMate() found: {}", new Object[]{this.hamster.getId(), this.hamster.level().getGameTime(), found != null ? Integer.valueOf(found.getId()) : "null"});
        return found;
    }

    private void breed() {
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int cooldown = (Integer)config.breedingCooldownTicks.get();
        this.hamster.setAge(cooldown);
        this.targetMate.setAge(cooldown);
        this.hamster.customLoveTimer = 0;
        this.targetMate.customLoveTimer = 0;
        HamsterEntity baby = (HamsterEntity)this.hamster.getBreedOffspring((ServerLevel)this.hamster.level(), (AgeableMob)this.targetMate);
        if (baby != null) {
            baby.moveTo(this.hamster.getX(), this.hamster.getY(), this.hamster.getZ(), 0.0f, 0.0f);
            this.hamster.level().addFreshEntity((Entity)baby);
        }
    }
}

