/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.MeleeAttackGoalAccessor;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class HamsterMeleeAttackGoal
extends MeleeAttackGoal {
    private final HamsterEntity hamster;
    private static final int CUSTOM_ATTACK_COOLDOWN_TICKS = 35;

    public HamsterMeleeAttackGoal(HamsterEntity hamster, double speed, boolean pauseWhenMobIdle) {
        super((PathfinderMob)hamster, speed, pauseWhenMobIdle);
        this.hamster = hamster;
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackCooldown();
            AdorableHamsterPets.LOGGER.trace("[AttackGoal {} Tick {}] Attack condition met (cooldown {}, in range), attacking target {}. Cooldown reset to {}.", new Object[]{this.hamster.getId(), this.hamster.level().getGameTime(), this.getTicksUntilNextAttack(), target.getId(), this.getAttackInterval()});
            SoundEvent attackSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_ATTACK_SOUNDS, this.hamster.getRandom());
            if (attackSound != null) {
                this.hamster.playSound(attackSound, 1.2f, this.hamster.getVoicePitch());
                AdorableHamsterPets.LOGGER.trace("[AttackGoal {} Tick {}] Played attack sound: {}", new Object[]{this.hamster.getId(), this.hamster.level().getGameTime(), attackSound.getLocation()});
            }
            this.hamster.triggerAnimOnServer("mainController", "attack");
            DamageSource damageSource = this.hamster.damageSources().mobAttack((LivingEntity)this.hamster);
            float damageAmount = (float)this.hamster.getAttributeValue(Attributes.ATTACK_DAMAGE);
            target.hurt(damageSource, damageAmount);
            AdorableHamsterPets.LOGGER.trace("[AttackGoal {} Tick {}] Called tryAttack() on target {}.", new Object[]{this.hamster.getId(), this.hamster.level().getGameTime(), target.getId()});
        }
    }

    protected int getAttackInterval() {
        return 35;
    }

    protected void resetAttackCooldown() {
        ((MeleeAttackGoalAccessor)((Object)this)).setCooldown(this.getAttackInterval());
    }

    public boolean canUse() {
        if (this.hamster.isOrderedToSit()) {
            return false;
        }
        return super.canUse();
    }

    public void start() {
        super.start();
        AdorableHamsterPets.LOGGER.trace("[AttackGoal {} Tick {}] Goal started.", (Object)this.hamster.getId(), (Object)this.hamster.level().getGameTime());
        ((MeleeAttackGoalAccessor)((Object)this)).setCooldown(0);
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void stop() {
        super.stop();
        AdorableHamsterPets.LOGGER.trace("[AttackGoal {} Tick {}] Goal stopped.", (Object)this.hamster.getId(), (Object)this.hamster.level().getGameTime());
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            this.checkAndPerformAttack(target);
        }
    }
}

