/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterPlayWithItemGoal
extends Goal {
    private static final int LUNGE_DURATION_TICKS = 5;
    private final HamsterEntity hamster;
    private final Level world;
    @Nullable
    private ItemEntity targetItem;
    @Nullable
    private Player owner;
    @Nullable
    private Vec3 pounceStartPos;
    @Nullable
    private Vec3 repositionTarget;
    private int bounceSoundDelayTicks;
    private int playAnimSettleTicks;
    private int repositionAttempts;
    private int lungeTicks;
    private int itemInterestTimer;
    private boolean isFriendlyDelivery = false;
    private State currentState = State.SCANNING;

    public HamsterPlayWithItemGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        HamsterArmorItem armorItem;
        Item item3;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Evaluating canStart...", (Object)this.hamster.getId());
        if (this.hamster.isHoldingInterestItem()) {
            if (this.hamster.isOrderedToSit()) {
                return false;
            }
            if (!(this.hamster.getOwner() instanceof Player)) {
                return false;
            }
            this.owner = (Player)this.hamster.getOwner();
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED: Resuming existing interaction.", (Object)this.hamster.getId());
            return true;
        }
        if (!Configs.AHP.enableItemCarrying) {
            return false;
        }
        if (this.hamster.isHoldingInterestItem() || this.hamster.isOrderedToSit()) {
            return false;
        }
        long currentTime = this.world.getGameTime();
        if (this.hamster.interestCooldownEndTick > currentTime) {
            return false;
        }
        LivingEntity livingEntity = this.hamster.getOwner();
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player playerOwner = (Player)livingEntity;
        this.owner = playerOwner;
        List nearbyItems = this.world.getEntitiesOfClass(ItemEntity.class, this.hamster.getBoundingBox().inflate(10.0), itemEntity -> (ConfigDataCache.isStealableItem(itemEntity.getItem()) || ConfigDataCache.isRetrievableItem(itemEntity.getItem())) && itemEntity.onGround());
        Optional<ItemEntity> closestItem = nearbyItems.stream().filter(item -> this.hamster.getNavigation().createPath((Entity)item, 0) != null).min((item1, item2) -> Float.compare(item1.distanceTo((Entity)this.hamster), item2.distanceTo((Entity)this.hamster)));
        if (closestItem.isEmpty()) {
            return false;
        }
        this.targetItem = closestItem.get();
        ItemStack stack = this.targetItem.getItem();
        boolean isRetrievable = ConfigDataCache.isRetrievableItem(stack);
        boolean isStealable = ConfigDataCache.isStealableItem(stack);
        boolean hasDiamondArmor = false;
        ItemStack armor = this.hamster.getArmorStack();
        if (!armor.isEmpty() && (item3 = armor.getItem()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item3).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND) {
            hasDiamondArmor = true;
        }
        if (isRetrievable || isStealable && hasDiamondArmor) {
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Guaranteed). Target: {}.", (Object)this.hamster.getId(), (Object)stack.getItem());
            return true;
        }
        if (isStealable) {
            float chance;
            float randomVal = this.hamster.getRandom().nextFloat();
            if (randomVal > (chance = ((Float)Configs.AHP.itemThieveryChance.get()).floatValue())) {
                return false;
            }
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Thievery Roll Passed). Target: {}.", (Object)this.hamster.getId(), (Object)stack.getItem());
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.hamster.isOrderedToSit()) {
            return false;
        }
        if (this.owner == null || !this.owner.isAlive()) {
            return false;
        }
        if (this.itemInterestTimer <= 0) {
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.RETURNING || this.currentState == State.PLAYING_WITH_ITEM) {
            if (!this.hamster.isHoldingInterestItem()) {
                AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] shouldContinue check failed: Player retrieved item.", (Object)this.hamster.getId());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_ITEM && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.isAlive())) {
            return false;
        }
        return true;
    }

    public void start() {
        ItemStack interestStack;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isHoldingInterestItem()) {
            interestStack = this.hamster.getInterestItemStack();
        } else if (this.targetItem != null) {
            interestStack = this.targetItem.getItem();
        } else {
            this.stop();
            return;
        }
        this.determineMode(interestStack);
        if (this.hamster.isHoldingInterestItem()) {
            this.itemInterestTimer = this.hamster.getItemInterestTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Resuming interaction. Mode: Friendly={}", (Object)this.hamster.getId(), (Object)this.isFriendlyDelivery);
            this.currentState = this.isFriendlyDelivery ? State.RETURNING : (this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.PLAYING_WITH_ITEM);
        } else {
            this.currentState = State.MOVING_TO_ITEM;
            this.hamster.getNavigation().moveTo((Entity)this.targetItem, 1.5);
            this.itemInterestTimer = this.hamster.getRandom().nextIntBetweenInclusive((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal started fresh. State: MOVING_TO_ITEM. Duration: {} ticks. Friendly: {}", new Object[]{this.hamster.getId(), this.itemInterestTimer, this.isFriendlyDelivery});
        }
    }

    public void stop() {
        ItemStack itemHeldInMouthStack;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.getId(), (Object)this.currentState);
        this.hamster.interestCooldownEndTick = this.world.getGameTime() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isHoldingInterestItem() && this.itemInterestTimer <= 0 && !(itemHeldInMouthStack = this.hamster.getInterestItemStack()).isEmpty()) {
            this.world.addFreshEntity((Entity)new ItemEntity(this.world, this.hamster.getX(), this.hamster.getY(), this.hamster.getZ(), itemHeldInMouthStack.copy()));
            this.hamster.playSound(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.getRandom()), 1.0f, 1.0f);
            SoundEvent pounceSound = ModSounds.getDynamicItemSound(itemHeldInMouthStack);
            float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
            this.world.playSound(null, this.hamster.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
        }
        this.hamster.setInterestItemStack(ItemStack.EMPTY);
        this.hamster.setItemInterestTimer(0);
        this.hamster.setTauntingWithItem(false);
        this.hamster.setPresentingItem(false);
        this.hamster.setHoldingInterestItem(false);
        this.hamster.getNavigation().stop();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void tick() {
        if (this.itemInterestTimer > 0) {
            --this.itemInterestTimer;
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.playSound((SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.getVoicePitch() * 1.2f);
            }
        }
        switch (this.currentState.ordinal()) {
            case 1: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.getLookControl().setLookAt((Entity)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.getNavigation().isDone()) {
                    this.currentState = State.REPOSITIONING;
                    return;
                }
                if (!((double)this.hamster.distanceTo((Entity)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.position();
                this.hamster.getNavigation().stop();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_pounce_on_item");
                this.bounceSoundDelayTicks = 5;
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.getRandom());
                if (celebrationSound == null) break;
                this.hamster.playSound(celebrationSound, 0.7f, this.hamster.getVoicePitch());
                break;
            }
            case 2: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    this.itemInterestTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = LandRandomPos.getPosTowards((PathfinderMob)this.hamster, (int)2, (int)3, (Vec3)Vec3.atCenterOf((Vec3i)this.targetItem.blockPosition()));
                    if (this.repositionTarget != null) {
                        this.hamster.getNavigation().moveTo(this.repositionTarget.x, this.repositionTarget.y, this.repositionTarget.z, 1.55);
                    } else {
                        this.itemInterestTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.getNavigation().isDone()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_ITEM;
                this.hamster.getNavigation().moveTo((Entity)this.targetItem, 1.5);
                break;
            }
            case 3: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.x + easedProgress * (this.targetItem.getX() - this.pounceStartPos.x);
                    double newZ = this.pounceStartPos.z + easedProgress * (this.targetItem.getZ() - this.pounceStartPos.z);
                    this.hamster.setPos(newX, this.hamster.getY(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                ItemStack stackToSteal = this.targetItem.getItem().copy();
                if (stackToSteal.isEmpty()) {
                    this.itemInterestTimer = 0;
                    return;
                }
                this.hamster.setInterestItemStack(stackToSteal);
                this.targetItem.discard();
                this.hamster.setHoldingInterestItem(true);
                SoundEvent pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
                this.world.playSound(null, this.hamster.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                if (!this.world.isClientSide) {
                    ParticleEffectsUtil.spawnParticles(this.world, new Vec3(this.hamster.getX(), this.hamster.getY() + 0.5, this.hamster.getZ()), ParticleTypes.END_ROD, 5, new Vec3(0.1, 0.1, 0.1), 0.05);
                    ParticleEffectsUtil.spawnParticles(this.world, new Vec3(this.hamster.getX(), this.hamster.getY() + 0.5, this.hamster.getZ()), new ItemParticleOption(ParticleTypes.ITEM, stackToSteal), 18, new Vec3(0.2, 0.2, 0.2), 0.1);
                }
                if (this.isFriendlyDelivery) {
                    this.currentState = State.RETURNING;
                    break;
                }
                this.currentState = State.FLEEING;
                break;
            }
            case 4: {
                this.hamster.setTauntingWithItem(false);
                if (this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    Vec3 fleePos = LandRandomPos.getPosAway((PathfinderMob)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (Vec3)this.owner.position());
                    if (fleePos == null) break;
                    this.hamster.getNavigation().moveTo(fleePos.x, fleePos.y, fleePos.z, 1.5);
                    break;
                }
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.getNavigation().stop();
                break;
            }
            case 5: {
                this.hamster.setPresentingItem(false);
                this.hamster.getNavigation().moveTo((Entity)this.owner, 1.5);
                double distToOwner = this.hamster.distanceTo((Entity)this.owner);
                if (!(distToOwner <= 2.5)) break;
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.getNavigation().stop();
                break;
            }
            case 6: {
                this.hamster.getLookControl().setLookAt((Entity)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTauntingWithItem() && !this.hamster.isPresentingItem() && this.playAnimSettleTicks == 0) {
                    this.playAnimSettleTicks = 5;
                }
                if (this.playAnimSettleTicks > 0) {
                    --this.playAnimSettleTicks;
                }
                if (this.hamster.getNavigation().isDone() && this.playAnimSettleTicks == 0) {
                    if (this.isFriendlyDelivery) {
                        this.hamster.setPresentingItem(true);
                    } else {
                        this.hamster.setTauntingWithItem(true);
                    }
                }
                if (this.isFriendlyDelivery) {
                    if (!((double)this.hamster.distanceTo((Entity)this.owner) > 5.0)) break;
                    this.currentState = State.RETURNING;
                    this.hamster.setPresentingItem(false);
                    this.playAnimSettleTicks = 0;
                    break;
                }
                if (!(this.hamster.distanceTo((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTauntingWithItem(false);
                this.playAnimSettleTicks = 0;
            }
        }
    }

    private void determineMode(ItemStack stack) {
        if (ConfigDataCache.isRetrievableItem(stack)) {
            this.isFriendlyDelivery = true;
            return;
        }
        if (ConfigDataCache.isStealableItem(stack)) {
            HamsterArmorItem armorItem;
            Item item;
            ItemStack armor = this.hamster.getArmorStack();
            this.isFriendlyDelivery = !armor.isEmpty() && (item = armor.getItem()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND;
            return;
        }
        this.isFriendlyDelivery = false;
    }

    private static enum State {
        SCANNING,
        MOVING_TO_ITEM,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        RETURNING,
        PLAYING_WITH_ITEM;

    }
}

