/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public class HamsterSleepGoal
extends Goal {
    private static final int CHECK_INTERVAL = 20;
    private final HamsterEntity hamster;
    private int checkTimer = 0;

    public HamsterSleepGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.hamster.isTame() || this.hamster.isSleeping() || this.hamster.isOrderedToSit() || this.hamster.isKnockedOut()) {
            return false;
        }
        if (!this.hamster.level().isDay()) {
            return false;
        }
        if (!this.hamster.onGround()) {
            return false;
        }
        if (this.checkTimer > 0) {
            --this.checkTimer;
            return false;
        }
        this.checkTimer = 20;
        double radius = 5.0;
        boolean threatNearby = !this.hamster.level().getEntities((Entity)this.hamster, this.hamster.getBoundingBox().inflate(radius), this::isThreat).isEmpty();
        return !threatNearby;
    }

    public void start() {
        SoundEvent sleepSound;
        this.hamster.getNavigation().stop();
        this.hamster.setTarget(null);
        this.hamster.setSleeping(true);
        this.hamster.setInSittingPose(true);
        if (!this.hamster.level().isClientSide()) {
            String settleAnimId;
            int choice = this.hamster.getRandom().nextInt(3);
            this.hamster.getEntityData().set(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)(switch (choice) {
                case 0 -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep1";
                    yield "anim_hamster_sleep_pose1";
                }
                case 1 -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep2";
                    yield "anim_hamster_sleep_pose2";
                }
                default -> {
                    settleAnimId = "anim_hamster_stand_settle_sleep3";
                    yield "anim_hamster_sleep_pose3";
                }
            }));
            this.hamster.triggerAnimOnServer("mainController", settleAnimId);
            this.hamster.triggerSettleEffects(0.24f, 14, 0.27f);
        }
        if (!this.hamster.level().isClientSide() && (sleepSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.hamster.getRandom())) != null) {
            this.hamster.level().playSound(null, this.hamster.blockPosition(), sleepSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean canContinueToUse() {
        if (this.hamster.isTame() || !this.hamster.level().isDay()) {
            return false;
        }
        if (this.checkTimer > 0) {
            --this.checkTimer;
            return true;
        }
        this.checkTimer = 20;
        double radius = 5.0;
        boolean threatNearby = !this.hamster.level().getEntities((Entity)this.hamster, this.hamster.getBoundingBox().inflate(radius), this::isThreat).isEmpty();
        return !threatNearby;
    }

    public void stop() {
        if (this.hamster.isSleeping()) {
            this.hamster.triggerWakeUpFromSleepAnimation(false);
        }
        this.hamster.setSleeping(false);
        this.hamster.setInSittingPose(false);
        this.checkTimer = 0;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    private boolean isThreat(Entity entity) {
        if (entity instanceof Monster) {
            return true;
        }
        return entity instanceof Player;
    }
}

