/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HamsterTemptGoal
extends TemptGoal {
    private final HamsterEntity hamster;
    private int recheckTimer = 0;

    public HamsterTemptGoal(HamsterEntity hamster, double speed, boolean canBeScared) {
        super((PathfinderMob)hamster, speed, ConfigDataCache::isTamingFood, canBeScared);
        this.hamster = hamster;
    }

    public void start() {
        super.start();
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean canUse() {
        if (this.hamster.isOrderedToSit() || this.hamster.isCelebratingDiamond()) {
            return false;
        }
        if (!super.canUse()) {
            return false;
        }
        if (this.hamster.isTame()) {
            return this.hamster.isOwnedBy((LivingEntity)this.player);
        }
        return true;
    }

    public boolean canContinueToUse() {
        if (this.hamster.isOrderedToSit() || this.hamster.isCelebratingDiamond()) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void tick() {
        super.tick();
        if (this.recheckTimer > 0) {
            --this.recheckTimer;
            return;
        }
        this.recheckTimer = 5;
        Level world = this.hamster.level();
        Player temptingPlayer = this.player;
        if (temptingPlayer != null && temptingPlayer.isAlive() && this.hamster.distanceToSqr((Entity)temptingPlayer) < 64.0) {
            this.hamster.setBegging(this.isHoldingTemptItem(temptingPlayer));
        } else {
            this.hamster.setBegging(false);
        }
    }

    public void stop() {
        super.stop();
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.hamster.setBegging(false);
        this.recheckTimer = 0;
    }

    private boolean isHoldingTemptItem(Player player) {
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        return ConfigDataCache.isTamingFood(mainHandStack) || ConfigDataCache.isTamingFood(offHandStack);
    }
}

