/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.util.HamsterPlacementUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterWanderAroundFarGoal
extends WaterAvoidingRandomStrollGoal {
    private final HamsterEntity hamster;
    private static final double BUFFED_WANDER_SPEED = 0.9;

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed) {
        super((PathfinderMob)hamster, speed);
        this.hamster = hamster;
        this.setInterval(110);
    }

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed, float probability) {
        super((PathfinderMob)hamster, speed, probability);
        this.hamster = hamster;
        this.setInterval(110);
    }

    public boolean canUse() {
        if (this.hamster.isOrderedToSit() || this.hamster.isSleeping() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingRetrieval()) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            if (this.mob.getRandom().nextInt(3) != 0) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - On cooldown.", (Object)this.hamster.getId());
                return false;
            }
            Vec3 target = this.getPosition();
            if (target == null) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - No valid target found.", (Object)this.hamster.getId());
                return false;
            }
            this.wantedX = target.x;
            this.wantedY = target.y;
            this.wantedZ = target.z;
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): SUCCEEDED. Target: ({}, {}, {})", new Object[]{this.hamster.getId(), String.format("%.2f", target.x), String.format("%.2f", target.y), String.format("%.2f", target.z)});
            return true;
        }
        int interval = (Integer)Configs.AHP.wanderInterval.get();
        if (interval <= 0) {
            return false;
        }
        this.setInterval(interval);
        boolean canStartNormal = super.canUse();
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Normal): Result: {}", (Object)this.hamster.getId(), (Object)canStartNormal);
        return canStartNormal;
    }

    public boolean canContinueToUse() {
        if (this.hamster.hasGreenBeanBuff()) {
            return !this.hamster.isOrderedToSit() && !this.hamster.isSleeping() && !this.hamster.isKnockedOut() && !this.mob.getNavigation().isDone();
        }
        return super.canContinueToUse();
    }

    public void tick() {
        if (this.hamster.hasGreenBeanBuff() && this.mob.getNavigation().isDone()) {
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] tick (Zoomies): Navigation is idle. Finding new target.", (Object)this.hamster.getId());
            Vec3 newTarget = this.getPosition();
            if (newTarget != null) {
                this.mob.getNavigation().moveTo(newTarget.x, newTarget.y, newTarget.z, 0.9);
            }
        }
    }

    public void start() {
        double currentSpeed = this.hamster.hasGreenBeanBuff() ? 0.9 : this.speedModifier;
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, currentSpeed);
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.hamster.hasGreenBeanBuff() ? " (Zoomies)" : ""));
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] start: Goal has started. IsBuffed: {}", (Object)this.hamster.getId(), (Object)this.hamster.hasGreenBeanBuff());
    }

    @Nullable
    protected Vec3 getPosition() {
        Optional<GlobalPos> bedPosOptional;
        if (this.hamster.hasGreenBeanBuff()) {
            return this.getPreciseZoomiesTarget().map(Vec3::atCenterOf).orElse(null);
        }
        if (this.hamster.isWanderModeActive() && (bedPosOptional = this.hamster.getLinkedBedPos()).isPresent()) {
            GlobalPos bedGlobalPos = bedPosOptional.get();
            if (this.hamster.level().dimension() == bedGlobalPos.dimension()) {
                BlockPos bedPos = bedGlobalPos.pos();
                BlockEntity be = this.hamster.level().getBlockEntity(bedPos);
                if (be instanceof HamsterBedBlockEntity) {
                    int radius;
                    HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                    WanderDistance distance = bedEntity.getWanderDistance();
                    switch (distance) {
                        case NEAR: {
                            int n = (Integer)Configs.AHP.wanderDistanceNear.get();
                            break;
                        }
                        case FAR: {
                            int n = (Integer)Configs.AHP.wanderDistanceFar.get();
                            break;
                        }
                        default: {
                            int n = radius = ((Integer)Configs.AHP.wanderDistanceMedium.get()).intValue();
                        }
                    }
                    if (this.hamster.blockPosition().distSqr((Vec3i)bedPos) > (double)(radius * radius)) {
                        Vec3 directionToBed = Vec3.atCenterOf((Vec3i)bedPos).subtract(this.hamster.position());
                        return LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)7, (int)7, (Vec3)directionToBed);
                    }
                    for (int i = 0; i < 10; ++i) {
                        BlockPos validatedPos;
                        int dz;
                        int dx = this.hamster.getRandom().nextInt(2 * radius + 1) - radius;
                        BlockPos potentialTarget = bedPos.offset(dx, 0, dz = this.hamster.getRandom().nextInt(2 * radius + 1) - radius);
                        if (!(bedPos.distSqr((Vec3i)potentialTarget) <= (double)(radius * radius)) || (validatedPos = LandRandomPos.movePosUpOutOfSolid((PathfinderMob)this.mob, (BlockPos)potentialTarget)) == null) continue;
                        return Vec3.atBottomCenterOf((Vec3i)validatedPos);
                    }
                    return null;
                }
            }
        }
        return super.getPosition();
    }

    private Optional<BlockPos> getPreciseZoomiesTarget() {
        LivingEntity livingEntity = this.hamster.getOwner();
        if (!(livingEntity instanceof Player)) {
            return Optional.empty();
        }
        Player owner = (Player)livingEntity;
        double lastAngle = this.hamster.getLastZoomiesAngle();
        boolean isClockwise = this.hamster.getZoomiesIsClockwise();
        double angleStep = Math.toRadians(this.hamster.getRandom().nextIntBetweenInclusive(40, 70));
        double newAngle = isClockwise ? lastAngle + angleStep : lastAngle - angleStep;
        this.hamster.setLastZoomiesAngle(newAngle);
        int radiusModifier = this.hamster.getZoomiesRadiusModifier();
        double radius = this.hamster.getRandom().nextIntBetweenInclusive(3 + radiusModifier, 5 + radiusModifier);
        double targetX = owner.getX() + radius * Math.cos(newAngle);
        double targetZ = owner.getZ() + radius * Math.sin(newAngle);
        BlockPos idealPos = new BlockPos((int)targetX, (int)this.hamster.getY(), (int)targetZ);
        Optional<BlockPos> finalTargetPos = HamsterPlacementUtil.findSafeSpawnPosition(idealPos, this.hamster.level(), 2, this.hamster);
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] getPreciseZoomiesTarget:\n  - IsClockwise: {}\n  - LastAngle(rad): {}\n  - AngleStep(rad): {}\n  - NewAngle(rad): {}\n  - Radius: {}\n  - IdealPos: {}\n  - FinalTarget: {}", new Object[]{this.hamster.getId(), isClockwise, String.format("%.2f", lastAngle), String.format("%.2f", angleStep), String.format("%.2f", newAngle), String.format("%.2f", radius), idealPos, finalTargetPos.map(Vec3i::toString).orElse("null")});
        return finalTargetPos;
    }

    public void stop() {
        super.stop();
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] stop: Goal has stopped.", (Object)this.hamster.getId());
    }
}

