/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterModel
extends GeoModel<HamsterEntity> {
    private static final float ADULT_SCALE = 0.8f;
    private static final float ADULT_HEAD_SCALE = 1.0f;
    private static final float BABY_SCALE = 0.5f;
    private static final float BABY_HEAD_SCALE = 1.2f;

    public ResourceLocation getModelResource(HamsterEntity animatable, @Nullable GeoRenderer<HamsterEntity> renderer) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"geo/hamster.geo.json");
    }

    public ResourceLocation getTextureResource(HamsterEntity animatable, @Nullable GeoRenderer<HamsterEntity> renderer) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/entity/hamster/orange.png");
    }

    public ResourceLocation getAnimationResource(HamsterEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"animations/anim_hamster.animation.json");
    }

    public void setCustomAnimations(HamsterEntity entity, long instanceId, AnimationState<HamsterEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        GeoBone rootBone = this.getAnimationProcessor().getBone("root");
        GeoBone headParentBone = this.getAnimationProcessor().getBone("head_parent");
        GeoBone leftCheekDefBone = this.getAnimationProcessor().getBone("left_cheek_deflated");
        GeoBone rightCheekDefBone = this.getAnimationProcessor().getBone("right_cheek_deflated");
        GeoBone leftCheekInfBone = this.getAnimationProcessor().getBone("left_cheek_inflated");
        GeoBone rightCheekInfBone = this.getAnimationProcessor().getBone("right_cheek_inflated");
        GeoBone rightEarBone = this.getAnimationProcessor().getBone("right_ear");
        GeoBone acornHatBone = this.getAnimationProcessor().getBone("acorn_hat");
        GeoBone petalHeadBone = this.getAnimationProcessor().getBone("pink_petal_head");
        GeoBone petalSideBone = this.getAnimationProcessor().getBone("pink_petal_side");
        GeoBone petalBackBone = this.getAnimationProcessor().getBone("pink_petal_lower_back");
        if (petalHeadBone != null) {
            petalHeadBone.setHidden(true);
        }
        if (petalSideBone != null) {
            petalSideBone.setHidden(true);
        }
        if (petalBackBone != null) {
            petalBackBone.setHidden(true);
        }
        if (leftCheekDefBone != null && leftCheekInfBone != null) {
            boolean leftFull = entity.isLeftCheekFull();
            leftCheekDefBone.setHidden(leftFull);
            leftCheekInfBone.setHidden(!leftFull);
        }
        if (rightCheekDefBone != null && rightCheekInfBone != null) {
            boolean rightFull = entity.isRightCheekFull();
            rightCheekDefBone.setHidden(rightFull);
            rightCheekInfBone.setHidden(!rightFull);
        }
        if (rightEarBone != null) {
            ItemStack armorStack;
            boolean shouldHideEar = false;
            boolean shouldShowHat = false;
            ItemStack blingStack = entity.getAccessoryStack();
            if (blingStack.is((Item)ModItems.ACORN_HAT.get())) {
                shouldHideEar = true;
                shouldShowHat = true;
            }
            if ((armorStack = entity.getArmorStack()).is((Item)ModItems.HAMSTER_ARMOR_ACORN.get()) && ((Boolean)Configs.AHP.renderAcornHat.get()).booleanValue()) {
                shouldHideEar = true;
                shouldShowHat = true;
            }
            rightEarBone.setHidden(shouldHideEar);
            if (acornHatBone != null) {
                acornHatBone.setHidden(!shouldShowHat);
            }
        }
        if (rootBone != null && headParentBone != null) {
            float baseScale = entity.isBaby() ? 0.5f : 0.8f;
            float headScale = entity.isBaby() ? 1.2f : 1.0f;
            rootBone.setScaleX(baseScale);
            rootBone.setScaleY(baseScale);
            rootBone.setScaleZ(baseScale);
            if (entity.isShoulderPet()) {
                rootBone.setScaleY(baseScale * entity.dynamicScaleY);
            }
            headParentBone.setScaleX(headScale);
            headParentBone.setScaleY(headScale);
            headParentBone.setScaleZ(headScale);
            if (entity.isThrown()) {
                Vec3 velocity = entity.getDeltaMovement();
                double horizontalSpeed = Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
                float targetPitch = (float)Math.atan2(velocity.y, horizontalSpeed);
                rootBone.setRotX(targetPitch);
            } else if (entity.clientFallPitchProgress > 0.0f || entity.prevClientFallPitchProgress > 0.0f) {
                float partialTick = animationState.getPartialTick();
                float lerpedProgress = Mth.lerp((float)partialTick, (float)entity.prevClientFallPitchProgress, (float)entity.clientFallPitchProgress);
                float t = entity.clientFallPitchProgress;
                float interpolated = (1.0f - Mth.cos((float)(lerpedProgress * (float)Math.PI))) * 0.5f;
                float targetPitch = -1.5707964f;
                rootBone.setRotX(targetPitch * interpolated);
                rootBone.setRotX(targetPitch * interpolated);
            } else {
                rootBone.setRotX(0.0f);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getModelResource(HamsterEntity animatable) {
        return this.getModelResource(animatable, null);
    }

    @Deprecated(forRemoval=true)
    public ResourceLocation getTextureResource(HamsterEntity animatable) {
        return this.getTextureResource(animatable, null);
    }
}

