/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.sound.HamsterCleaningSoundInstance;
import net.dawson.adorablehamsterpets.entity.client.HamsterModel;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterAcornHatLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterArmorLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterOverlayLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterPinkPetalOverlayLayer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterMouthItemOffsets;
import net.dawson.adorablehamsterpets.util.HamsterSeatOffsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<HamsterEntity> {
    private final float adultShadowRadius;
    private static final Map<Integer, HamsterCleaningSoundInstance> activeCleaningSounds = new HashMap<Integer, HamsterCleaningSoundInstance>();
    public static final ThreadLocal<Boolean> IS_RENDERING_PASSENGER = ThreadLocal.withInitial(() -> false);
    private static final String SEAT_BONE = "body_child";

    public HamsterRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new HamsterModel());
        this.shadowRadius = this.adultShadowRadius = 0.2f;
        this.addRenderLayer(new HamsterOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterArmorLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterPinkPetalOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterAcornHatLayer((GeoRenderer<HamsterEntity>)this));
    }

    public ResourceLocation getTextureLocation(HamsterEntity entity) {
        HamsterVariant variant = HamsterVariant.byId(entity.getVariant());
        String baseTextureName = variant.getBaseTextureName();
        return ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + baseTextureName + ".png"));
    }

    public void preRender(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        model.getBone("left_foot").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone("nose").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone(SEAT_BONE).ifPresent(bone -> bone.setTrackingMatrices(true));
    }

    public void render(HamsterEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        AnimatableManager manager;
        AnimatableInstanceCache cache;
        boolean isCleaning = entity.isCleaning();
        HamsterCleaningSoundInstance sound = activeCleaningSounds.get(entity.getId());
        if (isCleaning && (sound == null || sound.isStopped())) {
            sound = new HamsterCleaningSoundInstance(entity);
            activeCleaningSounds.put(entity.getId(), sound);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
        } else if (!isCleaning && sound != null) {
            sound.stop();
            activeCleaningSounds.remove(entity.getId());
        }
        this.shadowRadius = entity.isBaby() ? this.adultShadowRadius * 0.5f : this.adultShadowRadius;
        AdorableHamsterPetsClient.onHamsterRendered(entity.getId());
        poseStack.pushPose();
        float targetYOffset = 0.0f;
        BlockPos pos = entity.blockPosition();
        BlockState blockState = entity.level().getBlockState(pos);
        if (blockState.is(Blocks.SNOW)) {
            targetYOffset = 0.125f;
        }
        entity.renderedSnowYOffset += (targetYOffset - entity.renderedSnowYOffset) * 0.15f;
        poseStack.translate(0.0, (double)entity.renderedSnowYOffset, 0.0);
        if (!entity.isShoulderPet() && (cache = entity.getAnimatableInstanceCache()) != null && (manager = cache.getManagerForId((long)entity.getId())) != null) {
            manager.updatedAt(0.0);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public void renderFinal(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
        if (!animatable.getPassengers().isEmpty()) {
            model.getBone(SEAT_BONE).ifPresent(bone -> this.renderPassengersForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, partialTick));
        }
        if (animatable.isHoldingInterestItem()) {
            model.getBone("nose").ifPresent(bone -> this.renderItemForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, packedOverlay));
        }
        if (animatable.particleEffectId != null) {
            this.handleParticleKeyframes(animatable, model);
        }
        if (animatable.soundEffectId != null) {
            this.handleSoundKeyframes(animatable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPassengersForBone(PoseStack matrices, HamsterEntity hamster, GeoBone bone, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        Minecraft client = Minecraft.getInstance();
        EntityRenderDispatcher dispatcher = client.getEntityRenderDispatcher();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        dispatcher.setRenderShadow(false);
        try {
            for (Entity passenger : hamster.getPassengers()) {
                if (!(passenger instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)passenger;
                if (passenger == client.player && client.options.getCameraType().isFirstPerson()) continue;
                matrices.pushPose();
                try {
                    matrices.last().pose().set((Matrix4fc)modelBase);
                    matrices.last().normal().set((Matrix3fc)modelBaseNormal);
                    Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
                    Vector3f t = bonePose.getTranslation(new Vector3f());
                    Quaternionf r = bonePose.getUnnormalizedRotation(new Quaternionf());
                    Matrix4f boneTR = new Matrix4f().identity().translate((Vector3fc)t).rotate((Quaternionfc)r);
                    matrices.last().pose().mul((Matrix4fc)boneTR);
                    matrices.last().normal().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.last().pose()).invert().transpose());
                    float mountScale = hamster.getScale();
                    if (mountScale != 1.0f) {
                        float inv = 1.0f / mountScale;
                        matrices.scale(inv, inv, inv);
                    }
                    Vec3 seat = HamsterSeatOffsets.visualSeatOffset(living, hamster.getScale());
                    matrices.translate(seat.x, seat.y, seat.z);
                    float passengerYaw = Mth.rotLerp((float)partialTick, (float)passenger.yRotO, (float)passenger.getYRot());
                    matrices.mulPose(Axis.YP.rotationDegrees(passengerYaw - 180.0f));
                    IS_RENDERING_PASSENGER.set(true);
                    try {
                        dispatcher.render(passenger, 0.0, 0.0, 0.0, passengerYaw, partialTick, matrices, bufferSource, packedLight);
                    }
                    finally {
                        IS_RENDERING_PASSENGER.set(false);
                    }
                }
                finally {
                    matrices.popPose();
                }
            }
        }
        finally {
            dispatcher.setRenderShadow(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderItemForBone(PoseStack matrices, HamsterEntity hamster, GeoBone bone, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack itemStack = hamster.getInterestItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        matrices.pushPose();
        try {
            matrices.last().pose().set((Matrix4fc)modelBase);
            matrices.last().normal().set((Matrix3fc)modelBaseNormal);
            Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
            matrices.last().pose().mul((Matrix4fc)bonePose);
            matrices.last().normal().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.last().pose()).invert().transpose());
            HamsterMouthItemOffsets.applyMouthItemTransforms(matrices);
            itemRenderer.renderStatic(itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, packedOverlay, matrices, bufferSource, hamster.level(), hamster.getId());
        }
        finally {
            matrices.popPose();
        }
    }

    private void handleParticleKeyframes(HamsterEntity animatable, BakedGeoModel model) {
        RandomSource random = animatable.getRandom();
        switch (animatable.particleEffectId) {
            case "attack_poof": {
                model.getBone("left_foot").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    for (int i = 0; i < 8; ++i) {
                        double d = random.nextGaussian() * 0.1;
                        double e = random.nextGaussian() * 0.2;
                        double f = random.nextGaussian() * 0.1;
                        animatable.level().addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, pos.x + d, pos.y + e, pos.z + f, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05);
                    }
                });
                break;
            }
            case "seeking_dust": {
                model.getBone("nose").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    BlockPos blockBelow = BlockPos.containing((double)pos.x, (double)(pos.y - 0.1), (double)pos.z).below();
                    BlockState state = animatable.level().getBlockState(blockBelow);
                    if (state.isAir()) {
                        state = Blocks.DIRT.defaultBlockState();
                    }
                    for (int i = 0; i < 12; ++i) {
                        double d = random.nextGaussian() * 0.2;
                        double e = random.nextGaussian() * 0.03;
                        double f = random.nextGaussian() * 0.2;
                        animatable.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), pos.x + d, pos.y + e, pos.z + f, 0.0, 0.0, 0.0);
                    }
                });
            }
        }
        animatable.particleEffectId = null;
    }

    private void handleSoundKeyframes(HamsterEntity animatable) {
        Minecraft client = Minecraft.getInstance();
        switch (animatable.soundEffectId) {
            case "hamster_step_sound": {
                BlockPos pos = animatable.blockPosition();
                BlockState blockState = animatable.level().getBlockState(pos.below());
                if (blockState.isAir()) {
                    blockState = animatable.level().getBlockState(pos.below(2));
                }
                if (blockState.isAir()) break;
                SoundType group = blockState.getSoundType();
                float volume = blockState.is(Blocks.GRAVEL) ? 0.060000002f : 0.1f;
                client.getSoundManager().play((SoundInstance)new SimpleSoundInstance(group.getStepSound(), SoundSource.NEUTRAL, volume, group.getPitch() * 1.5f, animatable.getRandom(), animatable.getX(), animatable.getY(), animatable.getZ()));
                break;
            }
            case "hamster_beg_bounce": {
                SoundEvent bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, animatable.getRandom());
                if (bounceSound == null) break;
                float basePitch = animatable.getVoicePitch();
                float randomPitchAddition = animatable.getRandom().nextFloat() * 0.2f;
                float finalPitch = basePitch * 1.2f + randomPitchAddition;
                client.getSoundManager().play((SoundInstance)new SimpleSoundInstance(bounceSound, SoundSource.NEUTRAL, 0.6f, finalPitch, animatable.getRandom(), animatable.getX(), animatable.getY(), animatable.getZ()));
                break;
            }
            case "hamster_thump_sound": {
                float thumpPitch = 1.0f + animatable.getRandom().nextFloat() * 0.4f;
                client.getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, 0.3f, thumpPitch, animatable.getRandom(), animatable.getX(), animatable.getY(), animatable.getZ()));
            }
        }
        animatable.soundEffectId = null;
    }
}

