/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class HamsterAcornHatLayer
extends GeoRenderLayer<HamsterEntity> {
    private static final ResourceLocation ACORN_HAT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/entity/hamster/armor/acorn_hat.png");

    public HamsterAcornHatLayer(GeoRenderer<HamsterEntity> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ItemStack armorStack;
        boolean shouldRender = false;
        ItemStack blingStack = animatable.getAccessoryStack();
        if (blingStack.is((Item)ModItems.ACORN_HAT.get())) {
            shouldRender = true;
        }
        if (!shouldRender && (armorStack = animatable.getArmorStack()).is((Item)ModItems.HAMSTER_ARMOR_ACORN.get()) && ((Boolean)Configs.AHP.renderAcornHat.get()).booleanValue()) {
            shouldRender = true;
        }
        if (shouldRender) {
            RenderType hatRenderType = RenderType.entityCutoutNoCull((ResourceLocation)ACORN_HAT_TEXTURE);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, hatRenderType, bufferSource.getBuffer(hatRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        }
    }
}

