/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class HamsterPinkPetalOverlayLayer
extends GeoRenderLayer<HamsterEntity> {
    private static final ResourceLocation PETAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/entity/hamster/overlay_pink_petal.png");

    public HamsterPinkPetalOverlayLayer(GeoRenderer<HamsterEntity> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        GeoBone targetBone;
        int petalType = (Integer)animatable.getEntityData().get(HamsterEntity.PINK_PETAL_TYPE);
        if (petalType == 0) {
            return;
        }
        GeoBone headBone = this.getRenderer().getGeoModel().getAnimationProcessor().getBone("pink_petal_head");
        GeoBone sideBone = this.getRenderer().getGeoModel().getAnimationProcessor().getBone("pink_petal_side");
        GeoBone backBone = this.getRenderer().getGeoModel().getAnimationProcessor().getBone("pink_petal_lower_back");
        switch (petalType) {
            case 1: {
                GeoBone geoBone = headBone;
                break;
            }
            case 2: {
                GeoBone geoBone = sideBone;
                break;
            }
            case 3: {
                GeoBone geoBone = backBone;
                break;
            }
            default: {
                GeoBone geoBone = targetBone = null;
            }
        }
        if (targetBone != null) {
            targetBone.setHidden(false);
            RenderType petalRenderType = RenderType.entityCutoutNoCull((ResourceLocation)PETAL_TEXTURE);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, petalRenderType, bufferSource.getBuffer(petalRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            targetBone.setHidden(true);
        }
    }
}

