/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.AppliedPinkPetalCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.CheekPouchUnlockedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.FedHamsterSteamedBeansCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterAutoFedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterBedLinkedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterOnShoulderCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterPouchFilledCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterSleptInBedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.MountPriority;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterGoToBedAndSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterPlayWithItemGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSniffForOreGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.AI.navigation.HamsterNavigation;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.control.HamsterBodyControl;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.item.custom.HamsterBedItem;
import net.dawson.adorablehamsterpets.networking.payload.PlayDistantSoundPayload;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterScreenHandlerFactory;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModBiomeTags;
import net.dawson.adorablehamsterpets.util.HamsterAnimationScheduler;
import net.dawson.adorablehamsterpets.util.HamsterPlacementUtil;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.util.HamsterSeatOffsets;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends TamableAnimal
implements GeoEntity,
ImplementedInventory {
    private static final double WALK_TO_RUN_THRESHOLD_SQUARED = 0.002;
    private static final double RUN_TO_SPRINT_THRESHOLD_SQUARED = 0.008;
    public static final float FAST_YAW_CHANGE = 25.0f;
    public static final float FAST_PITCH_CHANGE = 25.0f;
    private static final int INVENTORY_SIZE = 8;
    private static final int CHEEK_POUCH_SIZE = 6;
    public static final int ACCESSORY_SLOT_INDEX = 6;
    public static final int ARMOR_SLOT_INDEX = 7;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    private static final ResourceLocation ARMOR_SPEED_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"armor_speed_boost");
    private static final ResourceLocation ARMOR_KNOCKBACK_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"armor_knockback_resistance");
    private static final int NORMAL_FALL_PITCH_DURATION = 15;
    private static final int PITCH_RESET_DURATION = 3;
    private static final int RIDER_JUMP_COOLDOWN_TICKS = 8;
    private static final double RIDER_JUMP_VELOCITY = 0.6;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    public static final int SLEEPING_FLAG = 1;
    public static final int SITTING_FLAG = 2;
    public static final int BEGGING_FLAG = 4;
    public static final int IN_LOVE_FLAG = 8;
    public static final int REFUSING_FOOD_FLAG = 16;
    public static final int THROWN_FLAG = 32;
    public static final int LEFT_CHEEK_FULL_FLAG = 64;
    public static final int RIGHT_CHEEK_FULL_FLAG = 128;
    public static final int KNOCKED_OUT_FLAG = 256;
    public static final int CHEEK_POUCH_UNLOCKED_FLAG = 512;
    public static final int CONSIDERING_AUTO_EAT_FLAG = 1024;
    public static final int SULKING_FLAG = 2048;
    public static final int CELEBRATING_DIAMOND_FLAG = 4096;
    public static final int CLEANING_FLAG = 8192;
    public static final int HOLDING_INTEREST_ITEM_FLAG = 16384;
    public static final int TAUNTING_WITH_ITEM_FLAG = 32768;
    public static final int PRESENTING_ITEM_FLAG = 0x100000;
    public static final int CELEBRATING_RETRIEVAL_FLAG = 65536;
    public static final int IS_SHOULDER_PET_FLAG = 131072;
    public static final int IS_WANDER_MODE_ACTIVE_FLAG = 262144;
    public static final int ON_THE_WAY_TO_BED_FLAG = 524288;
    public static final int STUCK_SEARCHING_FOR_BED_FLAG = 0x200000;
    public static final int RESCUE_SLEEPING_FLAG = 0x400000;
    private static final EntityDataAccessor<Integer> HAMSTER_FLAGS = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ANIMATION_PERSONALITY_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> PINK_PETAL_TYPE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DOZING_PHASE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> CURRENT_DEEP_SLEEP_ANIM_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> ITEM_INTEREST_TIMER = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<ItemStack> INTEREST_ITEM_STACK = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Long> GREEN_BEAN_BUFF_DURATION = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    public static final EntityDataAccessor<Integer> CURRENT_LOOK_UP_ANIM_ID = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SHOULDER_ANIMATION_STATE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> TRACKED_ACCESSORY_STACK = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<ItemStack> TRACKED_ARMOR_STACK = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> FALL_IMMUNITY_ACTIVE = SynchedEntityData.defineId(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_FROM_KO_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup_from_ko");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation STANDING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standing_headshake");
    private static final RawAnimation SITTING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_headshake");
    private static final RawAnimation MOVING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_moving_headshake");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SIT_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep1");
    private static final RawAnimation SIT_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep2");
    private static final RawAnimation SIT_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep3");
    private static final RawAnimation STAND_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep1");
    private static final RawAnimation STAND_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep2");
    private static final RawAnimation STAND_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep3");
    private static final RawAnimation SIT1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit1");
    private static final RawAnimation SIT2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit2");
    private static final RawAnimation SIT3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit3");
    private static final RawAnimation STANDUP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup1");
    private static final RawAnimation STANDUP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup2");
    private static final RawAnimation STANDUP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup3");
    private static final RawAnimation WAKE_UP_1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup1");
    private static final RawAnimation WAKE_UP_2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup2");
    private static final RawAnimation WAKE_UP_3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup3");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sprinting");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle1");
    private static final RawAnimation IDLE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle2");
    private static final RawAnimation IDLE_LOOKING_UP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up1");
    private static final RawAnimation IDLE_LOOKING_UP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up2");
    private static final RawAnimation IDLE_LOOKING_UP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up3");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    private static final RawAnimation SEEKING_ORE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_ore");
    private static final RawAnimation WANTS_TO_SEEK_ORE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_ore");
    private static final RawAnimation POUNCE_ON_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_pounce_on_item");
    private static final RawAnimation TAUNT_WITH_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_taunt_with_item");
    private static final RawAnimation PRESENTING_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_presenting_item");
    private static final RawAnimation CELEBRATE_CHASE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_celebrate_chase");
    private static final RawAnimation LAYING_DOWN_HEAD_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_head");
    private static final RawAnimation LAYING_DOWN_RIGHT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_right_shoulder");
    private static final RawAnimation LAYING_DOWN_LEFT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_left_shoulder");
    @Unique
    public int interactionCooldown = 0;
    @Unique
    public int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public BlockPos currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    @Unique
    public long interestCooldownEndTick = 0L;
    @Unique
    private int celebrationRetrievalTicks = 0;
    @Unique
    private boolean zoomiesIsClockwise = false;
    @Unique
    private double lastZoomiesAngle = 0.0;
    @Unique
    private int zoomiesRadiusModifier = 0;
    @Unique
    public transient float renderedSnowYOffset = 0.0f;
    @Unique
    public transient ShoulderLocation shoulderLocation = ShoulderLocation.RIGHT_SHOULDER;
    @Unique
    public int suffocationGracePeriod = 0;
    @Unique
    public transient float dynamicScaleY = 1.0f;
    @Unique
    private Optional<GlobalPos> linkedBedPos = Optional.empty();
    @Unique
    private int goToBedCooldown = 0;
    @Unique
    private int lureToBedTimer = 0;
    @Unique
    public int goToBedDelayTicks = 0;
    @Unique
    private int wakeUpFromBedDelay = 0;
    @Unique
    public int bedLeafParticleTicks = 0;
    @Unique
    private boolean bypassNextSleepDelay = false;
    @Unique
    private int napInBedDurationTimer = 0;
    @Unique
    private int thumpSoundDelayTicks = 0;
    @Unique
    private float thumpSoundVolume = 0.2f;
    @Unique
    public int pathingFailures = 0;
    @Unique
    @Nullable
    public BlockPos lastFailedTarget = null;
    @Unique
    private boolean hasPlayedIncomingSound = false;
    @Unique
    private boolean isLoadingNbt = false;
    @Unique
    private boolean isSilentInventoryUpdate = false;
    private boolean armorAbsorbedDamage = false;
    private boolean performDeferredArmorUpdate = false;
    @Unique
    public float clientFallPitchProgress = 0.0f;
    @Unique
    public float prevClientFallPitchProgress = 0.0f;
    @Unique
    private int riderJumpCooldown = 0;
    @Unique
    private boolean riderJumpHeld = false;
    @Unique
    private boolean riderJumpQueued = false;
    @Unique
    private boolean riderSprintHeld = false;
    @Unique
    private int localSpawnImmunityTicks = 60;
    private final NonNullList<ItemStack> items = ImplementedInventory.create(8);
    private ItemStack lastArmorStack = ItemStack.EMPTY;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final HamsterAnimationScheduler animScheduler = new HamsterAnimationScheduler();
    private int refuseTimer = 0;
    private ItemStack lastFoodItem = ItemStack.EMPTY;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    public long throwCooldownEndTick = 0L;
    private long greenBeanBuffEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;

    private static HamsterVariant determineVariantForBiome(Holder<Biome> biomeEntry, RandomSource random) {
        String biomeName = biomeEntry.unwrapKey().map(k -> k.location().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = HamsterEntity.canSpawnBlue(biomeEntry) ? (random.nextInt(10) < 7 ? HamsterEntity.getRandomVariant(BLUE_VARIANTS, random) : HamsterVariant.WHITE) : (HamsterEntity.canSpawnLavender(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (HamsterEntity.canSpawnWhite(biomeEntry) ? HamsterVariant.WHITE : (HamsterEntity.canSpawnGray(biomeEntry) ? (random.nextBoolean() ? HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random)) : (HamsterEntity.canSpawnBlack(biomeEntry) ? HamsterVariant.BLACK : (HamsterEntity.canSpawnCream(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (HamsterEntity.canSpawnChocolate(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static boolean canSpawnBlue(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlueBiome(biomeEntry);
    }

    private static boolean canSpawnLavender(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isLavenderBiome(biomeEntry);
    }

    private static boolean canSpawnWhite(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isWhiteBiome(biomeEntry);
    }

    private static boolean canSpawnGray(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isGrayBiome(biomeEntry);
    }

    private static boolean canSpawnBlack(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlackBiome(biomeEntry);
    }

    private static boolean canSpawnCream(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isCreamBiome(biomeEntry);
    }

    private static boolean canSpawnChocolate(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isChocolateBiome(biomeEntry);
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, RandomSource random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.nextInt(variantPool.size()));
    }

    public static AttributeSupplier.Builder createHamsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)Configs.AHP.wildMaxHealth.get()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(ServerLevel world, Player player, CompoundTag nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.getName().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)world);
        if (hamster != null) {
            hamster.setUUID(data.entityUuid());
            hamster.setVariant(data.variantId());
            hamster.setHealth(data.health());
            hamster.setOwnerUUID(player.getUUID());
            hamster.setTame(true, true);
            hamster.setAge(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.getEntityData().set(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.getEntityData().set(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            hamster.getEntityData().set(HAMSTER_FLAGS, (Object)data.hamsterFlags());
            hamster.setHamsterFlag(2, false);
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.setCustomName((Component)Component.literal((String)name));
                }
            });
            RegistryAccess registries = world.registryAccess();
            if (!data.inventoryNbt().isEmpty()) {
                ContainerHelper.loadAllItems((CompoundTag)data.inventoryNbt(), hamster.items, (HolderLookup.Provider)registries);
                hamster.updateCheekTrackers();
                hamster.updateEquipmentTrackers();
            }
            HamsterShoulderData.GreenBeanBuffData buffData = data.greenBeanBuffData();
            hamster.greenBeanBuffEndTick = buffData.greenBeanBuffEndTick();
            hamster.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)buffData.greenBeanBuffDuration());
            CompoundTag effectsNbt = buffData.activeEffectsNbt();
            if (effectsNbt.contains("active_effects", 9)) {
                ListTag effectsList = effectsNbt.getList("active_effects", 10);
                for (Tag effectElement : effectsList) {
                    CompoundTag effectInstanceNbt;
                    MobEffectInstance effectInstance;
                    if (!(effectElement instanceof CompoundTag) || (effectInstance = MobEffectInstance.load((CompoundTag)(effectInstanceNbt = (CompoundTag)effectElement))) == null) continue;
                    hamster.addEffect(effectInstance);
                }
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            HamsterShoulderData.WanderModeData wanderData = data.wanderModeData();
            hamster.linkedBedPos = wanderData.linkedBedPos();
            hamster.bypassNextSleepDelay = wanderData.bypassNextSleepDelay();
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
            hamster.setHamsterFlag(8192, false);
            hamster.setDozingPhase(DozingPhase.NONE);
        }
        return hamster;
    }

    public static void spawnFromNbt(ServerLevel world, Player player, CompoundTag nbt, boolean wasDiamondAlertActive, @Nullable HamsterEntity preconfiguredHamster) {
        HamsterEntity hamster;
        HamsterEntity hamsterEntity = hamster = preconfiguredHamster != null ? preconfiguredHamster : HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        hamster.suffocationGracePeriod = 200;
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.getId());
        }
        if (hamster.isThrown()) {
            world.addFreshEntity((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned THROWN Hamster ID {} from NBT data near Player {}.", (Object)hamster.getId(), (Object)player.getName().getString());
        } else {
            BlockPos ultimateFallbackPos = player.blockPosition();
            HitResult hitResult = player.pick(4.5, 0.0f, false);
            BlockPos initialSearchPos = hitResult.getType() == HitResult.Type.BLOCK ? ((BlockHitResult)hitResult).getBlockPos() : ultimateFallbackPos;
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(initialSearchPos, (Level)world, 5, hamster);
            safePosOpt.ifPresentOrElse(safePos -> {
                hamster.moveTo((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5, player.getYRot(), player.getXRot());
                AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.getName().getString());
            }, () -> {
                AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.getName().getString());
                hamster.moveTo((double)ultimateFallbackPos.getX() + 0.5, ultimateFallbackPos.getY(), (double)ultimateFallbackPos.getZ() + 0.5, player.getYRot(), player.getXRot());
            });
            world.addFreshEntityWithPassengers((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.getId(), (Object)player.getName().getString());
        }
    }

    public static void tryThrowFromShoulder(ServerPlayer player) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!config.enableHamsterThrowing) {
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throwing_disabled"), true);
            return;
        }
        if (!playerAccessor.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Player {} tried to throw, but has no shoulder hamster.", (Object)player.getName().getString());
            return;
        }
        playerAccessor.adorablehamsterpets$dismountShoulderHamster(true);
    }

    public HamsterEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 3;
        this.setPathfindingMalus(PathType.WATER, 16.0f);
        this.setPathfindingMalus(PathType.LAVA, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variantId) {
        this.entityData.set(VARIANT, (Object)variantId);
    }

    public boolean isSleeping() {
        return this.getHamsterFlag(1);
    }

    public void setSleeping(boolean sleeping) {
        this.setHamsterFlag(1, sleeping);
    }

    public boolean isOrderedToSit() {
        return this.getHamsterFlag(2) || this.getHamsterFlag(1) || this.getHamsterFlag(256) || this.getHamsterFlag(2048);
    }

    public boolean isCleaning() {
        return this.getHamsterFlag(8192);
    }

    public boolean isBegging() {
        return this.getHamsterFlag(4);
    }

    public void setBegging(boolean value) {
        this.setHamsterFlag(4, value);
    }

    public boolean isInLove() {
        return this.getHamsterFlag(8);
    }

    public void setInLove(boolean value) {
        this.setHamsterFlag(8, value);
    }

    public boolean isRefusingFood() {
        return this.getHamsterFlag(16);
    }

    public void setRefusingFood(boolean value) {
        this.setHamsterFlag(16, value);
    }

    public boolean isThrown() {
        return this.getHamsterFlag(32);
    }

    public void setThrown(boolean thrown) {
        this.setHamsterFlag(32, thrown);
        if (thrown) {
            this.hasPlayedIncomingSound = false;
        }
    }

    public boolean isLeftCheekFull() {
        return this.getHamsterFlag(64);
    }

    public void setLeftCheekFull(boolean full) {
        this.setHamsterFlag(64, full);
    }

    public boolean isRightCheekFull() {
        return this.getHamsterFlag(128);
    }

    public void setRightCheekFull(boolean full) {
        this.setHamsterFlag(128, full);
    }

    public boolean isKnockedOut() {
        return this.getHamsterFlag(256);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.setHamsterFlag(256, knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return this.getHamsterFlag(1024);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.entityData.get(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.entityData.set(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.entityData.set(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.entityData.get(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return this.getHamsterFlag(2048);
    }

    public boolean isCelebratingDiamond() {
        return this.getHamsterFlag(4096);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.setHamsterFlag(4096, celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.level().isClientSide()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.setHamsterFlag(2048, sulking);
        if (sulking) {
            if (!this.level().isClientSide()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    public boolean isHoldingInterestItem() {
        return this.getHamsterFlag(16384);
    }

    public void setHoldingInterestItem(boolean holding) {
        this.setHamsterFlag(16384, holding);
    }

    public int getItemInterestTimer() {
        return (Integer)this.entityData.get(ITEM_INTEREST_TIMER);
    }

    public void setItemInterestTimer(int ticks) {
        this.entityData.set(ITEM_INTEREST_TIMER, (Object)ticks);
    }

    public boolean isTauntingWithItem() {
        return this.getHamsterFlag(32768);
    }

    public void setTauntingWithItem(boolean taunting) {
        this.setHamsterFlag(32768, taunting);
    }

    public boolean isPresentingItem() {
        return this.getHamsterFlag(0x100000);
    }

    public void setPresentingItem(boolean presenting) {
        this.setHamsterFlag(0x100000, presenting);
    }

    public ItemStack getInterestItemStack() {
        return (ItemStack)this.entityData.get(INTEREST_ITEM_STACK);
    }

    public void setInterestItemStack(ItemStack stack) {
        this.entityData.set(INTEREST_ITEM_STACK, (Object)stack);
    }

    public boolean isCelebratingRetrieval() {
        return this.getHamsterFlag(65536);
    }

    public void setCelebratingRetrieval(boolean celebrating) {
        this.setHamsterFlag(65536, celebrating);
    }

    public boolean hasGreenBeanBuff() {
        return (Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION) > this.level().getGameTime();
    }

    public boolean getZoomiesIsClockwise() {
        return this.zoomiesIsClockwise;
    }

    public double getLastZoomiesAngle() {
        return this.lastZoomiesAngle;
    }

    public void setLastZoomiesAngle(double angle) {
        this.lastZoomiesAngle = angle;
    }

    public int getZoomiesRadiusModifier() {
        return this.zoomiesRadiusModifier;
    }

    public boolean isShoulderPet() {
        return this.getHamsterFlag(131072);
    }

    public void setShoulderPet(boolean isShoulderPet) {
        this.setHamsterFlag(131072, isShoulderPet);
    }

    public boolean isWanderModeActive() {
        return this.getHamsterFlag(262144);
    }

    public void setWanderModeActive(boolean active) {
        this.setHamsterFlag(262144, active);
    }

    public Optional<GlobalPos> getLinkedBedPos() {
        return this.linkedBedPos;
    }

    public void setLinkedBedPos(Optional<GlobalPos> pos) {
        this.linkedBedPos = pos;
    }

    public int getGoToBedCooldown() {
        return this.goToBedCooldown;
    }

    public boolean isStuckSearchingForBed() {
        return this.getHamsterFlag(0x200000);
    }

    public void setStuckSearchingForBed(boolean stuck) {
        this.setHamsterFlag(0x200000, stuck);
    }

    public boolean isRescueSleeping() {
        return this.getHamsterFlag(0x400000);
    }

    public void setRescueSleeping(boolean rescueSleeping) {
        this.setHamsterFlag(0x400000, rescueSleeping);
    }

    public void setFallFlyImmunityTicks(int ticks) {
        if (ticks <= 0) {
            this.entityData.set(FALL_IMMUNITY_ACTIVE, (Object)false);
            this.localSpawnImmunityTicks = 0;
        } else {
            this.entityData.set(FALL_IMMUNITY_ACTIVE, (Object)true);
            this.localSpawnImmunityTicks = ticks;
        }
    }

    public void wakeUpFromBed(boolean isManualWakeUp) {
        if (!this.isSleeping()) {
            return;
        }
        this.triggerWakeUpFromSleepAnimation(isManualWakeUp);
        this.setSleeping(false);
        this.setRescueSleeping(false);
        this.setInSittingPose(false);
        if (isManualWakeUp) {
            this.goToBedCooldown = (Integer)Configs.AHP.bedWakeUpCooldown.get();
            this.setBypassNextSleepDelay(true);
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.level().dimension() == globalPos.dimension()) {
                BlockEntity be;
                BlockPos bedPos = globalPos.pos();
                BlockState bedState = this.level().getBlockState(bedPos);
                ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atBottomCenterOf((Vec3i)bedPos).add(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.getValue(HamsterBedBlock.WOOD_VARIANT)))), 50, new Vec3(0.2, 0.5, 0.2), 0.0);
                SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.random);
                if (rustleSound != null) {
                    this.level().playSound(null, this.blockPosition(), rustleSound, SoundSource.NEUTRAL, 0.2f, 1.8f);
                }
                if (bedState.is((Block)ModBlocks.HAMSTER_BED.get()) && ((Boolean)bedState.getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                    this.level().setBlock(bedPos, (BlockState)bedState.setValue((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)), 3);
                }
                if ((be = this.level().getBlockEntity(bedPos)) instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_unoccupied");
                }
                for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)bedPos.offset(-1, 0, -1), (BlockPos)bedPos.offset(1, 0, 1))) {
                    if (checkPos.equals((Object)bedPos) || !HamsterPlacementUtil.isSafeSpawnLocation(checkPos, this.level(), this)) continue;
                    this.getNavigation().moveTo((double)checkPos.getX() + 0.5, (double)checkPos.getY(), (double)checkPos.getZ() + 0.5, 1.2);
                    return;
                }
            }
        });
    }

    public int getGoToBedDelayTicks() {
        return this.goToBedDelayTicks;
    }

    public void setGoToBedDelayTicks(int ticks) {
        this.goToBedDelayTicks = ticks;
    }

    public int getLureToBedTimer() {
        return this.lureToBedTimer;
    }

    public void setLureToBedTimer(int ticks) {
        this.lureToBedTimer = ticks;
    }

    public void lureToBed() {
        this.lureToBedTimer = 20;
    }

    public boolean isOnTheWayToBed() {
        return this.getHamsterFlag(524288);
    }

    public void setOnTheWayToBed(boolean onTheWay) {
        this.setHamsterFlag(524288, onTheWay);
    }

    public boolean shouldBypassNextSleepDelay() {
        return this.bypassNextSleepDelay;
    }

    public void setBypassNextSleepDelay(boolean bypass) {
        this.bypassNextSleepDelay = bypass;
    }

    public void startNapTimer() {
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.napInBedDurationTimer = this.random.nextIntBetweenInclusive(min, max);
        }
    }

    public void triggerSettleEffects(float swishVolume, int thumpDelay, float thumpVolume) {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, swishVolume, 1.0f + this.random.nextFloat() * 0.5f);
        }
        this.thumpSoundDelayTicks = thumpDelay;
        this.thumpSoundVolume = thumpVolume;
    }

    public void triggerWakeUpFromSleepAnimation(boolean isManualWakeUp) {
        SoundEvent affectionSound;
        String currentSleepAnim;
        if (this.level().isClientSide()) {
            return;
        }
        this.triggerAnimOnServer("mainController", switch (currentSleepAnim = (String)this.getEntityData().get(CURRENT_DEEP_SLEEP_ANIM_ID)) {
            case "anim_hamster_sleep_pose2" -> "wakeup2";
            case "anim_hamster_sleep_pose3" -> "wakeup3";
            default -> "wakeup1";
        });
        this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.random.nextFloat() * 0.5f);
        if (isManualWakeUp && (affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random)) != null) {
            this.level().playSound(null, this.blockPosition(), affectionSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public boolean isPathThroughUnlinkedBed(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        BlockPos linkedBed = this.getLinkedBedPos().map(GlobalPos::pos).orElse(null);
        for (int i = 0; i < path.getNodeCount(); ++i) {
            Node node = path.getNode(i);
            BlockPos pos = node.asBlockPos();
            if (!this.isUnlinkedBed(pos, linkedBed) && !this.isUnlinkedBed(pos.below(), linkedBed)) continue;
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Path intersects unlinked bed at {}, linkedBed={} for hamster {}", new Object[]{pos, linkedBed, this.getUUID()});
            return true;
        }
        return false;
    }

    public boolean isUnlinkedBed(BlockPos pos, BlockPos linkedBed) {
        if (this.level().getBlockState(pos).getBlock() instanceof HamsterBedBlock) {
            return linkedBed == null || !pos.equals((Object)linkedBed);
        }
        return false;
    }

    public void updateNavigation() {
        if (this.level().isClientSide()) {
            return;
        }
        boolean useCustomNav = Configs.AHP.avoidUnlinkedBeds;
        boolean isCurrentlyCustom = this.navigation instanceof HamsterNavigation;
        if (useCustomNav && !isCurrentlyCustom) {
            this.navigation = this.createNavigation(this.level());
        } else if (!useCustomNav && isCurrentlyCustom) {
            this.navigation = this.createNavigation(this.level());
        }
    }

    public boolean tryShoulderMount(Player player, ItemStack stack) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        ShoulderLocation availableSlot = null;
        MountPriority priority = (MountPriority)((Object)Configs.AHP.mountPriority.get());
        if (priority == MountPriority.HEAD_FIRST) {
            if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).isEmpty()) {
                availableSlot = ShoulderLocation.HEAD;
            } else if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).isEmpty()) {
                availableSlot = ShoulderLocation.RIGHT_SHOULDER;
            } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).isEmpty()) {
                availableSlot = ShoulderLocation.LEFT_SHOULDER;
            }
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).isEmpty()) {
            availableSlot = ShoulderLocation.RIGHT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).isEmpty()) {
            availableSlot = ShoulderLocation.LEFT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).isEmpty()) {
            availableSlot = ShoulderLocation.HEAD;
        }
        if (availableSlot != null) {
            this.setWanderModeActive(false);
            HamsterShoulderData data = this.saveToShoulderData();
            playerAccessor.setShoulderHamster(availableSlot, data.toNbt());
            playerAccessor.adorablehamsterpets$getMountOrderQueue().addLast(availableSlot);
            BlockPos hamsterPosForMountSound = this.blockPosition();
            this.discard();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((HamsterOnShoulderCriterion)((Object)ModCriteria.HAMSTER_ON_SHOULDER.get())).trigger(serverPlayer);
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.shoulder_mount_success"), true);
            SoundEvent mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.random);
            if (mountSound != null) {
                this.level().playSound(null, player.blockPosition(), mountSound, SoundSource.PLAYERS, 1.0f, this.getVoicePitch());
            }
            if (ConfigDataCache.isLureItem(stack)) {
                SoundEvent mountLureSound = ModSounds.getDynamicItemSound(stack);
                this.level().playSound(null, hamsterPosForMountSound, mountLureSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atCenterOf((Vec3i)hamsterPosForMountSound), new ItemParticleOption(ParticleTypes.ITEM, stack.copy()), 8, new Vec3(0.25, 0.25, 0.25), 0.05);
                if (!player.getAbilities().instabuild && Configs.AHP.consumeLureItem) {
                    stack.shrink(1);
                }
            }
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.shoulder_occupied"), true);
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_WALL)) {
            this.suffocationGracePeriod = 40;
            return false;
        }
        this.armorAbsorbedDamage = false;
        boolean result = super.hurt(source, amount);
        if (this.armorAbsorbedDamage) {
            return true;
        }
        return result;
    }

    protected void actuallyHurt(DamageSource source, float amount) {
        ItemStack realArmorStack;
        if (!this.level().isClientSide && !source.is(DamageTypeTags.BYPASSES_WOLF_ARMOR) && !(realArmorStack = (ItemStack)this.items.get(7)).isEmpty() && realArmorStack.getItem() instanceof HamsterArmorItem && this.shouldArmorAbsorb(source, realArmorStack)) {
            this.armorAbsorbedDamage = true;
            ItemStack particleStack = realArmorStack.copy();
            int armorDamage = (int)Math.ceil(amount);
            realArmorStack.hurtAndBreak(armorDamage, (LivingEntity)this, EquipmentSlot.BODY);
            if (realArmorStack.isEmpty()) {
                this.playSound(SoundEvents.WOLF_ARMOR_BREAK, 0.5f, 1.2f);
                ParticleEffectsUtil.spawnParticles(this.level(), new Vec3(this.getX(), this.getY(0.5), this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, particleStack), 15, new Vec3(0.2, 0.2, 0.2), 0.1);
                this.performDeferredArmorUpdate = true;
            } else {
                this.playSound(SoundEvents.WOLF_ARMOR_DAMAGE, 0.5f, 1.2f);
                ParticleEffectsUtil.spawnParticles(this.level(), new Vec3(this.getX(), this.getY(0.5), this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, particleStack), 5, new Vec3(0.2, 0.2, 0.2), 0.05);
            }
            return;
        }
        super.actuallyHurt(source, amount);
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isThrown();
    }

    public boolean isPushable() {
        if (this.isThrown() || this.isSleeping() && this.getLinkedBedPos().isPresent()) {
            return false;
        }
        return super.isPushable();
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack oldStack = ((ItemStack)this.items.get(slot)).copy();
        this.getItems().set(slot, (Object)stack);
        if (!(this.level().isClientSide || slot != 6 && slot != 7)) {
            this.updateEquipmentTrackers();
        }
        if (!(this.level().isClientSide || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, stack);
        }
        this.setChanged();
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack oldStack = this.getItem(slot).copy();
        ItemStack result = ImplementedInventory.super.removeItemNoUpdate(slot);
        ItemStack newStack = this.getItem(slot);
        if (!(this.level().isClientSide || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, newStack);
        }
        return result;
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        ItemStack oldStack = this.getItem(slot).copy();
        ItemStack result = ImplementedInventory.super.removeItem(slot, amount);
        ItemStack newStack = this.getItem(slot);
        if (!(this.level().isClientSide || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, newStack);
        }
        return result;
    }

    public boolean shouldRenderFlying() {
        if (this.isOrderedToSit()) {
            return false;
        }
        if (this.isThrown()) {
            return true;
        }
        if (((Boolean)this.entityData.get(FALL_IMMUNITY_ACTIVE)).booleanValue() && this.localSpawnImmunityTicks > 0) {
            return false;
        }
        return !this.onGround() && this.getDeltaMovement().y < -0.01;
    }

    public void putPlayerOnBack(Player player) {
        if (!this.hasPassenger((Entity)player)) {
            player.startRiding((Entity)this);
            this.setSitting(false, false);
            if (this.isOwnedBy((LivingEntity)player)) {
                this.setWanderModeActive(false);
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity passenger;
        Entity firstPassenger;
        if (this.isTame() && (firstPassenger = this.getFirstPassenger()) instanceof LivingEntity && this.isOwnedBy(passenger = (LivingEntity)firstPassenger)) {
            return passenger;
        }
        return null;
    }

    public void travel(Vec3 movementInput) {
        if (this.isAlive()) {
            LivingEntity passenger = this.getControllingPassenger();
            if (this.isTame() && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.setYRot(player.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(player.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float forwardSpeed = player.zza;
                float sidewaysSpeed = player.xxa;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.25f;
                }
                AhpConfig config = AdorableHamsterPets.CONFIG;
                boolean hasMovement = (double)Math.abs(forwardSpeed) > 1.0E-5 || (double)Math.abs(sidewaysSpeed) > 1.0E-5;
                boolean isSprinting = this.riderSprintHeld && hasMovement;
                this.setSprinting(isSprinting);
                double speedMultiplier = isSprinting ? (Double)config.ridingSprintSpeedMultiplier.get() : (Double)config.ridingBaseSpeedMultiplier.get();
                float attributeSpeed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                float finalSpeed = (float)((double)attributeSpeed * speedMultiplier);
                if (this.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                    finalSpeed += 0.1f;
                }
                this.setSpeed(finalSpeed);
                if (this.riderJumpCooldown > 0) {
                    --this.riderJumpCooldown;
                } else if (this.riderJumpQueued) {
                    this.riderJumpQueued = false;
                    this.tryRiderJump();
                }
                if (this.isControlledByLocalInstance()) {
                    super.travel(new Vec3((double)sidewaysSpeed, 0.0, (double)forwardSpeed));
                } else if (player instanceof LocalPlayer) {
                    super.travel(new Vec3((double)sidewaysSpeed, 0.0, (double)forwardSpeed));
                }
                return;
            }
        }
        super.travel(movementInput);
    }

    public void setRiderInput(boolean jump, boolean sprint) {
        if (jump && !this.riderJumpHeld) {
            this.riderJumpQueued = true;
            if (!this.level().isClientSide()) {
                AdorableHamsterPets.LOGGER.info("[AHP JUMP][SERVER] hamsterId={} queuedJump=true", (Object)this.getId());
            }
        }
        this.riderJumpHeld = jump;
        this.riderSprintHeld = sprint;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        if (slot == EquipmentSlot.FEET) {
            return (ItemStack)this.items.get(7);
        }
        return super.getItemBySlot(slot);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.FEET) {
            this.setItem(7, stack);
            return;
        }
        super.setItemSlot(slot, stack);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of((ItemStack)this.items.get(7));
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void setChanged() {
        if (!this.level().isClientSide()) {
            this.updateCheekTrackers();
            this.updateAccessoryState();
        }
    }

    public ItemStack getArmorStack() {
        return (ItemStack)this.entityData.get(TRACKED_ARMOR_STACK);
    }

    public ItemStack getAccessoryStack() {
        return (ItemStack)this.entityData.get(TRACKED_ACCESSORY_STACK);
    }

    public void setArmorStack(ItemStack stack) {
        this.setItem(7, stack);
    }

    public Component getDisplayName() {
        if (this.hasCustomName()) {
            return super.getDisplayName();
        }
        if (Configs.AHP.useHampterName) {
            return Component.translatable((String)"entity.adorablehamsterpets.hampter");
        }
        return super.getDisplayName();
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot < 6) {
            return !this.isItemDisallowed(stack);
        }
        if (slot == 6) {
            return stack.is((Item)ModItems.ACORN_HAT.get()) || stack.is(Items.PINK_PETALS);
        }
        if (slot == 7) {
            return stack.getItem() instanceof HamsterArmorItem;
        }
        return false;
    }

    public void updateCheekTrackers() {
        LivingEntity livingEntity;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.level().isClientSide() && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ((HamsterPouchFilledCriterion)((Object)ModCriteria.HAMSTER_POUCH_FILLED.get())).trigger(serverPlayerOwner, this);
            }
        }
    }

    public void updateEquipmentTrackers() {
        if (this.level().isClientSide() && !this.isShoulderPet()) {
            return;
        }
        ItemStack accessory = (ItemStack)this.items.get(6);
        ItemStack armor = (ItemStack)this.items.get(7);
        this.entityData.set(TRACKED_ACCESSORY_STACK, (Object)accessory);
        this.entityData.set(TRACKED_ARMOR_STACK, (Object)armor);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("HamsterVariant", this.getVariant());
        if (this.isTame()) {
            nbt.putBoolean("Sitting", this.getHamsterFlag(2));
        }
        nbt.putBoolean("KnockedOut", this.getHamsterFlag(256));
        nbt.putBoolean("CheekPouchUnlocked", this.getHamsterFlag(512));
        if (this.isTame()) {
            nbt.putBoolean("IsSleeping", this.getHamsterFlag(1));
        } else {
            nbt.putBoolean("IsSleeping", false);
        }
        nbt.putLong("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.putLong("GreenBeanBuffDuration", ((Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION)).longValue());
        nbt.putInt("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.putInt("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.putInt("PinkPetalType", ((Integer)this.entityData.get(PINK_PETAL_TYPE)).intValue());
        nbt.putInt("AnimationPersonalityId", ((Integer)this.entityData.get(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.putInt("DozingPhase", this.getDozingPhase().ordinal());
        nbt.putString("CurrentDeepSleepAnimId", (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.putInt("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.putInt("DriftingOffTimer", this.driftingOffTimer);
        nbt.putInt("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        HolderLookup.Provider registries = this.getRegistryLookup();
        CompoundTag inventoryWrapperNbt = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)inventoryWrapperNbt, this.items, (HolderLookup.Provider)registries);
        nbt.put("Inventory", (Tag)inventoryWrapperNbt);
        nbt.putBoolean("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.putLong("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.putInt("OreTargetX", this.currentOreTarget.getX());
            nbt.putInt("OreTargetY", this.currentOreTarget.getY());
            nbt.putInt("OreTargetZ", this.currentOreTarget.getZ());
        }
        nbt.putBoolean("IsSulking", this.getHamsterFlag(2048));
        nbt.putBoolean("IsCelebratingDiamond", this.getHamsterFlag(4096));
        if (this.isHoldingInterestItem()) {
            nbt.putBoolean("isHoldingInterestItem", true);
            nbt.putInt("ItemInterestTimer", this.getItemInterestTimer());
            if (!this.getInterestItemStack().isEmpty()) {
                nbt.put("InterestItemStack", this.getInterestItemStack().save(registries));
            }
        }
        nbt.putBoolean("IsWanderModeActive", this.isWanderModeActive());
        this.linkedBedPos.ifPresent(globalPos -> nbt.put("LinkedBedPos", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), globalPos).getOrThrow()));
        nbt.putBoolean("BypassNextSleepDelay", this.bypassNextSleepDelay);
        nbt.putBoolean("StuckSearchingForBed", this.isStuckSearchingForBed());
        nbt.putBoolean("IsRescueSleeping", this.isRescueSleeping());
        nbt.putBoolean("HasPlayedIncomingSound", this.hasPlayedIncomingSound);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.isLoadingNbt = true;
        super.readAdditionalSaveData(nbt);
        this.setVariant(nbt.getInt("HamsterVariant"));
        boolean wasSittingNbt = this.isTame() && nbt.getBoolean("Sitting");
        this.setSitting(wasSittingNbt, true);
        this.setHamsterFlag(256, nbt.getBoolean("KnockedOut"));
        this.setHamsterFlag(512, nbt.getBoolean("CheekPouchUnlocked"));
        this.setHamsterFlag(2048, nbt.getBoolean("IsSulking"));
        this.setHamsterFlag(4096, nbt.getBoolean("IsCelebratingDiamond"));
        boolean loadedSleeping = nbt.getBoolean("IsSleeping");
        if (!this.isTame()) {
            loadedSleeping = false;
        }
        this.setHamsterFlag(1, loadedSleeping);
        this.throwCooldownEndTick = nbt.getLong("ThrowCooldownEnd");
        this.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)nbt.getLong("GreenBeanBuffDuration"));
        this.autoEatCooldownTicks = nbt.getInt("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.contains("EjectionCheckCooldown", 3) ? nbt.getInt("EjectionCheckCooldown") : 20;
        this.entityData.set(PINK_PETAL_TYPE, (Object)nbt.getInt("PinkPetalType"));
        if (!nbt.contains("AnimationPersonalityId", 3)) {
            int personalityId = this.random.nextIntBetweenInclusive(1, 3);
            this.entityData.set(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.debug("[NBT READ] Hamster ID {}: NBT had no personality, assigned new ID {}", (Object)this.getId(), (Object)personalityId);
        } else {
            this.entityData.set(ANIMATION_PERSONALITY_ID, (Object)nbt.getInt("AnimationPersonalityId"));
        }
        if (nbt.contains("DozingPhase", 3)) {
            int phaseOrdinal = nbt.getInt("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                DozingPhase phase = DozingPhase.values()[phaseOrdinal];
                this.setDozingPhase(phase);
                if (phase == DozingPhase.DEEP_SLEEP) {
                    this.setHamsterFlag(1, true);
                }
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.entityData.set(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.getString("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.getInt("QuiescentSitTimer");
        this.driftingOffTimer = nbt.getInt("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.getInt("SettleSleepCooldown");
        this.items.clear();
        HolderLookup.Provider registries = this.getRegistryLookup();
        if (nbt.contains("Inventory", 10)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("Inventory"), this.items, (HolderLookup.Provider)registries);
        }
        if (!this.hasInventoryData(nbt) && !this.isTame()) {
            this.generateWildLoot();
        }
        this.updateCheekTrackers();
        this.updateEquipmentTrackers();
        this.isPrimedToSeekDiamonds = nbt.getBoolean("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.getLong("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.contains("OreTargetX") && nbt.contains("OreTargetY") && nbt.contains("OreTargetZ") ? new BlockPos(nbt.getInt("OreTargetX"), nbt.getInt("OreTargetY"), nbt.getInt("OreTargetZ")) : null;
        this.setHoldingInterestItem(nbt.getBoolean("isHoldingInterestItem"));
        if (this.isHoldingInterestItem()) {
            this.setItemInterestTimer(nbt.getInt("ItemInterestTimer"));
            if (nbt.contains("InterestItemStack", 10)) {
                ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt.get("InterestItemStack")).ifPresent(this::setInterestItemStack);
            }
        } else {
            this.setItemInterestTimer(0);
            this.setInterestItemStack(ItemStack.EMPTY);
        }
        this.setWanderModeActive(nbt.getBoolean("IsWanderModeActive"));
        this.linkedBedPos = nbt.contains("LinkedBedPos") ? GlobalPos.CODEC.parse((DynamicOps)this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("LinkedBedPos")).result() : Optional.empty();
        this.bypassNextSleepDelay = nbt.getBoolean("BypassNextSleepDelay");
        this.setStuckSearchingForBed(nbt.getBoolean("StuckSearchingForBed"));
        this.setRescueSleeping(nbt.getBoolean("IsRescueSleeping"));
        if (this.isRescueSleeping()) {
            this.setHamsterFlag(1, true);
        }
        this.hasPlayedIncomingSound = nbt.getBoolean("HasPlayedIncomingSound");
        this.isLoadingNbt = false;
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        CompoundTag inventoryNbt = new CompoundTag();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ContainerHelper.saveAllItems((CompoundTag)inventoryNbt, this.items, (HolderLookup.Provider)serverWorld.registryAccess());
        }
        CompoundTag effectsNbt = new CompoundTag();
        if (!this.getActiveEffects().isEmpty()) {
            ListTag effectsList = new ListTag();
            for (MobEffectInstance effectInstance : this.getActiveEffects()) {
                effectsList.add((Object)effectInstance.save());
            }
            effectsNbt.put("active_effects", (Tag)effectsList);
        }
        Optional<String> nameOptional = Optional.ofNullable(this.getCustomName()).map(Component::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget));
        HamsterShoulderData.GreenBeanBuffData buffData = new HamsterShoulderData.GreenBeanBuffData(this.greenBeanBuffEndTick, (Long)this.getEntityData().get(GREEN_BEAN_BUFF_DURATION), effectsNbt);
        HamsterShoulderData.WanderModeData wanderData = new HamsterShoulderData.WanderModeData(this.linkedBedPos, this.bypassNextSleepDelay);
        return new HamsterShoulderData(this.getUUID(), this.getVariant(), this.getHealth(), inventoryNbt, this.getAge(), this.throwCooldownEndTick, buffData, this.autoEatCooldownTicks, nameOptional, (Integer)this.entityData.get(PINK_PETAL_TYPE), (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID), seekingData, wanderData, (Integer)this.entityData.get(HAMSTER_FLAGS));
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void turn(double cursorX, double cursorY) {
        if (this.isSleeping()) {
            return;
        }
        super.turn(cursorX, cursorY);
    }

    public void setOrderedToSit(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        boolean wasSitting = this.isOrderedToSit();
        if (sitting && !wasSitting) {
            int personalityId = (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "sit2";
                case 3 -> "sit3";
                default -> "sit1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
            this.triggerSettleEffects(0.12f, 7, 0.2f);
        } else if (!sitting && wasSitting) {
            if (!this.level().isClientSide()) {
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.random.nextFloat() * 0.5f);
            }
            int personalityId = (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "standup2";
                case 3 -> "standup3";
                default -> "standup1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
        }
        if (!sitting && this.isTame() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.setHamsterFlag(2, sitting);
        this.setInSittingPose(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (this.getHamsterFlag(8192)) {
                this.setHamsterFlag(8192, false);
            }
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        AABB hamsterBox = this.getBoundingBox();
        AABB attackBox = hamsterBox.inflate(0.7, 0.0, 0.7);
        boolean intersects = attackBox.intersects(entity.getBoundingBox());
        return intersects;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TraceableEntity ownableFallback;
        Entity fallbackOwnerEntity;
        UUID ownerUuid = owner.getUUID();
        AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Hamster: {}, Target: {}, Owner: {}", new Object[]{this.getName().getString(), target.getName().getString(), owner.getName().getString()});
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof Player && target.getUUID().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tameablePet = (TamableAnimal)target;
            UUID petOwnerUuid = tameablePet.getOwnerUUID();
            if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is a TameableEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof AbstractHorse) {
            AbstractHorse horsePet = (AbstractHorse)target;
            LivingEntity horseOwnerEntity = horsePet.getOwner();
            if (horseOwnerEntity != null && horseOwnerEntity.getUUID().equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an AbstractHorseEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).getOwner()) != null && fallbackOwnerEntity.getUUID().equals(ownerUuid)) {
            AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an Ownable (fallback) owned by the same player. Preventing attack.");
            return false;
        }
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.hasPassenger((Entity)player)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Level world = this.level();
        AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.getId(), world.getGameTime(), player.getName().getString(), hand, stack.getItem()});
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.getId(), world.getGameTime(), this.interactionCooldown});
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() && stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.isClientSide) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                MutableComponent message = Component.translatable((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).withStyle(newSetting ? ChatFormatting.WHITE : ChatFormatting.RED);
                player.displayClientMessage((Component)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.getName().getString(), newSetting, this.getId()});
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player) && stack.getItem() instanceof HamsterBedItem) {
            if (!world.isClientSide) {
                UUID linkedUuid = (UUID)stack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
                Object nameToSet = this.hasCustomName() ? this.getName() : this.getDisplayName().copy().append(" " + this.getId());
                if (linkedUuid == null) {
                    ItemStack newStack = stack.copy();
                    newStack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get(), (Object)this.getUUID());
                    newStack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get(), nameToSet);
                    newStack.set((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get(), (Object)((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())));
                    player.setItemInHand(hand, newStack);
                    world.playSound(null, this.blockPosition(), SoundEvents.BAMBOO_WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY(0.5), this.getZ()), ParticleTypes.HAPPY_VILLAGER, 10, new Vec3(0.5, 0.5, 0.5), 0.0);
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.getName()}), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((HamsterBedLinkedCriterion)((Object)ModCriteria.HAMSTER_BED_LINKED.get())).trigger(serverPlayer);
                    }
                } else if (linkedUuid.equals(this.getUUID())) {
                    WanderDistance currentDistance = (WanderDistance)((Object)stack.getOrDefault((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get(), (Object)((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get()))));
                    WanderDistance[] values = WanderDistance.values();
                    WanderDistance nextDistance = values[(currentDistance.ordinal() + 1) % values.length];
                    stack.set((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get(), (Object)nextDistance);
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.getName(), nextDistance.getSerializedName()}), true);
                    world.playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                } else {
                    ItemStack newStack = stack.copy();
                    newStack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get(), (Object)this.getUUID());
                    newStack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get(), nameToSet);
                    newStack.set((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get(), (Object)((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())));
                    player.setItemInHand(hand, newStack);
                    world.playSound(null, this.blockPosition(), SoundEvents.BAMBOO_WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY(0.5), this.getZ()), ParticleTypes.HAPPY_VILLAGER, 10, new Vec3(0.5, 0.5, 0.5), 0.0);
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (!this.isTame()) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.getId(), (Object)world.getGameTime());
            if (player.isShiftKeyDown() && ConfigDataCache.isTamingFood(stack)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.getId(), (Object)world.getGameTime());
                if (!world.isClientSide) {
                    this.tryTame(player, stack);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.getId(), (Object)world.getGameTime());
            return super.mobInteract(player, hand);
        }
        if (this.isOwnedBy((LivingEntity)player)) {
            boolean isPotentialFood;
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.getId(), (Object)world.getGameTime());
            boolean isSneaking = player.isShiftKeyDown();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (!player.isShiftKeyDown() && stack.getItem() instanceof HamsterArmorItem) {
                if (!world.isClientSide) {
                    ItemStack currentArmor = this.getArmorStack();
                    ItemStack newArmor = stack.split(1);
                    this.setArmorStack(newArmor);
                    world.playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_WOLF.value(), SoundSource.NEUTRAL, 0.6f, 1.2f);
                    if (!currentArmor.isEmpty() && !player.getInventory().add(currentArmor)) {
                        player.drop(currentArmor, false);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            if (this.isSleeping()) {
                if (!world.isClientSide()) {
                    this.wakeUpFromBed(true);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.getDozingPhase() != DozingPhase.NONE) {
                this.resetSleepSequence("Player interacted with hamster.");
            }
            if (this.isHoldingInterestItem() && this.isOwnedBy((LivingEntity)player)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Passed 'isHoldingInterestItem' check.", (Object)this.getId());
                if (!world.isClientSide) {
                    ItemStack retrievedStack = this.getInterestItemStack().copy();
                    player.getInventory().placeItemBackInInventory(this.getInterestItemStack().copy());
                    this.setInterestItemStack(ItemStack.EMPTY);
                    this.setItemInterestTimer(0);
                    this.setHoldingInterestItem(false);
                    this.setCelebratingRetrieval(true);
                    this.celebrationRetrievalTicks = 30;
                    this.triggerAnimOnServer("mainController", "anim_hamster_celebrate_chase");
                    world.playSound(null, this.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random), SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    if (!retrievedStack.isEmpty()) {
                        SoundEvent pounceSound = ModSounds.getDynamicItemSound(retrievedStack);
                        float volume = pounceSound == SoundEvents.GENERIC_EAT ? 0.35f : 1.0f;
                        world.playSound(null, this.blockPosition(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY(0.5), this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, retrievedStack), 10, new Vec3(0.2, 0.2, 0.2), 0.05);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Item returned to player and goal stopped.", (Object)this.getId());
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isKnockedOut()) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.getId(), (Object)world.getGameTime());
                if (!world.isClientSide()) {
                    SoundEvent wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.random);
                    if (wakeUpSound != null) {
                        world.playSound(null, this.blockPosition(), wakeUpSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.setKnockedOut(false);
                    this.setSitting(false, true);
                    this.triggerAnimOnServer("mainController", "wakeup_from_ko");
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isCelebratingDiamond()) {
                if (!world.isClientSide()) {
                    this.setCelebratingDiamond(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random);
                    if (affectionSound != null) {
                        world.playSound(null, this.blockPosition(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    } else {
                        world.playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.isSulking()) {
                if (!world.isClientSide()) {
                    this.setSulking(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.random);
                    if (affectionSound != null) {
                        world.playSound(null, this.blockPosition(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
                    } else {
                        world.playSound(null, this.blockPosition(), SoundEvents.CHICKEN_STEP, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (this.canPlaceItem(6, stack) && !player.isShiftKeyDown()) {
                if (!world.isClientSide) {
                    ItemStack currentAccessory = (ItemStack)this.items.get(6);
                    if (stack.is(Items.PINK_PETALS) && currentAccessory.is(Items.PINK_PETALS)) {
                        int currentPetalType = (Integer)this.entityData.get(PINK_PETAL_TYPE);
                        int nextPetalType = currentPetalType % 3 + 1;
                        this.entityData.set(PINK_PETAL_TYPE, (Object)nextPetalType);
                        world.playSound(null, this.blockPosition(), SoundEvents.PINK_PETALS_PLACE, SoundSource.PLAYERS, 0.7f, 1.0f + this.random.nextFloat() * 0.2f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY() + (double)this.getBbHeight() * 0.75, this.getZ()), ParticleTypes.FALLING_SPORE_BLOSSOM, 7, new Vec3((double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0), 0.0);
                        AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Cycled pink petal to type {}.", (Object)this.getId(), (Object)nextPetalType);
                    } else {
                        ItemStack toEquip = stack.split(1);
                        ItemStack toReturn = currentAccessory.copy();
                        this.setItem(6, toEquip);
                        if (!toReturn.isEmpty()) {
                            this.spawnAtLocation(toReturn);
                        }
                        world.playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY() + (double)this.getBbHeight() * 0.75, this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, toEquip), 7, new Vec3((double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0), 0.0);
                        if (toEquip.is(Items.PINK_PETALS) && player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ((AppliedPinkPetalCriterion)((Object)ModCriteria.APPLIED_PINK_PETAL.get())).trigger(serverPlayer, this);
                        }
                    }
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (stack.is(Items.SHEARS) && !player.isShiftKeyDown()) {
                boolean actionTaken = false;
                ItemStack armorStack = this.getArmorStack();
                if (!armorStack.isEmpty() && armorStack.getItem() instanceof HamsterArmorItem) {
                    if (!world.isClientSide) {
                        this.spawnAtLocation(armorStack);
                        this.isSilentInventoryUpdate = true;
                        this.setArmorStack(ItemStack.EMPTY);
                        this.isSilentInventoryUpdate = false;
                        this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF, 0.8f, 1.5f);
                        if (!player.getAbilities().instabuild) {
                            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                    }
                    actionTaken = true;
                }
                ItemStack accessoryStack = (ItemStack)this.items.get(6);
                if (!actionTaken && !accessoryStack.isEmpty()) {
                    if (!world.isClientSide) {
                        ItemStack particleStack = accessoryStack.copy();
                        this.spawnAtLocation(accessoryStack);
                        this.isSilentInventoryUpdate = true;
                        this.setItem(6, ItemStack.EMPTY);
                        this.isSilentInventoryUpdate = false;
                        this.updateAccessoryState();
                        world.playSound(null, this.blockPosition(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.9f, 1.0f + this.random.nextFloat() * 0.1f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, particleStack), 5, new Vec3((double)this.getBbWidth() / 2.0, (double)this.getBbHeight() / 2.0, (double)this.getBbWidth() / 2.0), 0.05);
                        if (!player.getAbilities().instabuild) {
                            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                    }
                    actionTaken = true;
                }
                if (actionTaken) {
                    return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            }
            boolean isUsingItem = ConfigDataCache.isLureItem(stack);
            if (ConfigDataCache.isLureItem(stack)) {
                if (!world.isClientSide) {
                    this.tryShoulderMount(player, stack);
                } else {
                    player.swing(hand);
                }
                return InteractionResult.CONSUME;
            }
            if (!world.isClientSide() && isSneaking) {
                if (this.getHamsterFlag(512) || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new HamsterScreenHandlerFactory(this));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.cheek_pouch_locked").withStyle(ChatFormatting.WHITE), true);
                    this.playRefusalAnimation();
                }
                return InteractionResult.CONSUME;
            }
            boolean bl = isPotentialFood = ConfigDataCache.isStandardFood(stack) || ConfigDataCache.isBuffFood(stack) || ConfigDataCache.isPouchUnlockFood(stack);
            if (!world.isClientSide() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.getId(), (Object)world.getGameTime());
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.getId(), (Object)world.getGameTime());
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.getId(), (Object)world.getGameTime());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.getId(), (Object)world.getGameTime());
                    this.lastFoodItem = stack.copy();
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.getId(), (Object)world.getGameTime());
            }
            if (!(isSneaking || isPotentialFood || ConfigDataCache.isLureItem(stack) || stack.is(Items.PINK_PETALS))) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.getId(), (Object)world.getGameTime());
                InteractionResult vanillaResult = super.mobInteract(player, hand);
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.getId(), world.getGameTime(), vanillaResult});
                if (vanillaResult.consumesAction()) {
                    return vanillaResult;
                }
            }
            if (!world.isClientSide() && !isSneaking) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.getId(), (Object)world.getGameTime());
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.CONSUME_PARTIAL;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.getId(), (Object)world.getGameTime());
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.getId(), (Object)world.getGameTime());
        return super.mobInteract(player, hand);
    }

    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        if (tamed) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.tamedMaxHealth.get()).doubleValue());
            this.setHealth(this.getMaxHealth());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(Player player) {
        this.customLoveTimer = 600;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)18);
        }
    }

    public void setBaby(boolean baby) {
        this.setAge(baby ? -24000 : 0);
    }

    public void setInSittingPose(boolean inSittingPose) {
        super.setInSittingPose(inSittingPose);
        if (this.getHamsterFlag(2) != inSittingPose) {
            this.setHamsterFlag(2, inSittingPose);
        }
        if (!inSittingPose) {
            if (this.isSleeping()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.random.nextInt(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.setBaby(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.random.nextBoolean() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.random.nextInt(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.getOwnerUUID();
        if (ownerUUID != null) {
            baby.setOwnerUUID(ownerUUID);
            baby.setTame(true, true);
        }
        baby.setBaby(true);
        return baby;
    }

    public boolean isFood(ItemStack stack) {
        return ConfigDataCache.isStandardFood(stack);
    }

    public void tick() {
        Level world;
        ItemStack currentArmor;
        int chanceDenominator;
        if (!this.level().isClientSide()) {
            this.animScheduler.tick(this.level().getGameTime());
        }
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.suffocationGracePeriod > 0) {
            --this.suffocationGracePeriod;
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.goToBedCooldown > 0) {
            --this.goToBedCooldown;
        }
        if (this.lureToBedTimer > 0) {
            --this.lureToBedTimer;
        }
        if (this.wakeUpFromBedDelay > 0) {
            --this.wakeUpFromBedDelay;
        }
        if (this.napInBedDurationTimer > 0) {
            --this.napInBedDurationTimer;
        }
        if (this.localSpawnImmunityTicks > 0) {
            --this.localSpawnImmunityTicks;
        }
        if (this.thumpSoundDelayTicks > 0) {
            --this.thumpSoundDelayTicks;
            if (this.thumpSoundDelayTicks == 0 && !this.level().isClientSide()) {
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, this.thumpSoundVolume, 1.5f);
            }
        }
        if (this.bedLeafParticleTicks > 0) {
            if (!this.level().isClientSide()) {
                int particleCount = 0;
                if (this.bedLeafParticleTicks == 3) {
                    particleCount = 15;
                } else if (this.bedLeafParticleTicks == 2) {
                    particleCount = 10;
                } else if (this.bedLeafParticleTicks == 1) {
                    particleCount = 5;
                }
                if (particleCount > 0 && this.getLinkedBedPos().isPresent()) {
                    BlockPos bedPos = this.getLinkedBedPos().get().pos();
                    BlockState bedState = this.level().getBlockState(bedPos);
                    ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atBottomCenterOf((Vec3i)bedPos).add(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)bedState.getValue(HamsterBedBlock.WOOD_VARIANT))), particleCount, new Vec3(0.2, 0.3, 0.2), 1.0);
                }
            }
            --this.bedLeafParticleTicks;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.level().isClientSide) {
                    this.setHamsterFlag(8192, false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.isKnockedOut() && this.getHamsterFlag(8192)) {
            this.setHamsterFlag(8192, false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.level().isClientSide() && this.isTame() && this.isOrderedToSit() && !this.getHamsterFlag(8192) && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.random.nextInt(chanceDenominator) == 0) {
            this.cleaningTimer = this.random.nextIntBetweenInclusive(30, 60);
            this.setHamsterFlag(8192, true);
        }
        if (this.isCelebratingRetrieval()) {
            if (this.celebrationRetrievalTicks > 0) {
                if (this.getOwner() != null) {
                    this.getLookControl().setLookAt((Entity)this.getOwner(), 25.0f, 25.0f);
                }
                --this.celebrationRetrievalTicks;
            } else {
                this.setCelebratingRetrieval(false);
            }
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            Vec3 currentPos = this.position();
            Vec3 currentVel = this.getDeltaMovement();
            Vec3 nextPos = currentPos.add(currentVel);
            Level world2 = this.level();
            BlockHitResult blockHit = world2.clip(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            boolean stopped = false;
            if (blockHit.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = blockHit;
                BlockPos hitPos = blockHitResult.getBlockPos();
                if (world2.getBlockState(hitPos).is(Blocks.OAK_LEAVES) && !world2.isClientSide()) {
                    TreeHeistUtil.TreeScanResult scanResult = TreeHeistUtil.scanForTree(world2, hitPos);
                    if (HamsterTreeSearcherEntity.isTreeBlocked(world2, scanResult.treeId())) {
                        LivingEntity livingEntity = this.getOwner();
                        if (livingEntity instanceof Player) {
                            Player owner = (Player)livingEntity;
                            owner.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.tree_heist.occupied").withStyle(ChatFormatting.RED), true);
                        }
                    } else {
                        this.triggerLeafPopEffects(hitPos, true);
                        HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)((EntityType)ModEntities.HAMSTER_TREE_SEARCHER.get()).create(world2);
                        if (searcher != null) {
                            CompoundTag nbt = new CompoundTag();
                            this.saveWithoutId(nbt);
                            searcher.initializeSearch(hitPos, scanResult, nbt);
                            world2.addFreshEntity((Entity)searcher);
                            this.discard();
                            return;
                        }
                    }
                }
                BlockPos adjacentPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                this.setPos((double)adjacentPos.getX() + 0.5, adjacentPos.getY(), (double)adjacentPos.getZ() + 0.5);
                this.setDeltaMovement(currentVel.multiply(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.broadcastImpactSound(SoundEvents.GENERIC_SMALL_FALL, 1.2f);
                this.setKnockedOut(true);
                this.setInSittingPose(true);
                if (!world2.isClientSide()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)world2, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.getBoundingBox().expandTowards(currentVel).inflate(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.getEntity() != null) {
                    Entity hitEntity = entityHit.getEntity();
                    BlockPos impactPos = hitEntity.blockPosition();
                    boolean playEffects = false;
                    if (hitEntity instanceof ArmorStand) {
                        playEffects = true;
                    } else if (hitEntity instanceof LivingEntity) {
                        boolean damaged;
                        Item item;
                        LivingEntity livingHit = (LivingEntity)hitEntity;
                        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
                        float damageAmount = ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue();
                        ItemStack armorStack = this.getArmorStack();
                        if (!armorStack.isEmpty() && (item = armorStack.getItem()) instanceof HamsterArmorItem) {
                            HamsterArmorItem armorItem = (HamsterArmorItem)item;
                            if (((Boolean)Configs.AHP.enableArmorPerks.get()).booleanValue() && armorItem.getMaterial() == HamsterArmorItem.HamsterArmorMaterial.NETHERITE) {
                                damageAmount += ((Double)Configs.AHP.netheriteArmorThrowDamageBonus.get()).floatValue();
                            }
                        }
                        if (damaged = livingHit.hurt(damageSource, damageAmount)) {
                            livingHit.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 20, 0, false, false, false));
                            double knockbackStrength = 0.5;
                            double dx = currentVel.x;
                            double dz = currentVel.z;
                            livingHit.knockback(knockbackStrength, -dx, -dz);
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        this.broadcastImpactSound((SoundEvent)ModSounds.HAMSTER_IMPACT.get(), 1.0f);
                        ParticleEffectsUtil.spawnParticles(world2, new Vec3(this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ()), ParticleTypes.POOF, 50, new Vec3(0.4, 0.4, 0.4), 0.1);
                    }
                    Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(impactPos, world2, 2, this);
                    safePosOpt.ifPresentOrElse(safePos -> this.setPos((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.setPos((double)impactPos.getX() + 0.5, impactPos.getY(), (double)impactPos.getZ() + 0.5);
                    });
                    this.setDeltaMovement(currentVel.multiply(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.setInSittingPose(true);
                    if (!world2.isClientSide()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.level().isClientSide() && !this.hasPlayedIncomingSound) {
                    this.simulateTrajectoryAndCheckSound();
                }
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
                }
                Vec3 currentVelocity = this.getDeltaMovement();
                if (Double.isNaN(currentVelocity.x) || Double.isNaN(currentVelocity.y) || Double.isNaN(currentVelocity.z)) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    int particleDelay;
                    this.setPos(this.getX() + currentVelocity.x, this.getY() + currentVelocity.y, this.getZ() + currentVelocity.z);
                    this.hasImpulse = true;
                    int n = particleDelay = this.hasGreenBeanBuff() ? 3 : 5;
                    if (!world2.isClientSide() && this.throwTicks > particleDelay) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.xo - currentVelocity.x * offsetMultiplier;
                        double spawnY = this.yo + (double)this.getBbHeight() / 2.0 - currentVelocity.y * offsetMultiplier;
                        double spawnZ = this.zo - currentVelocity.z * offsetMultiplier;
                        ParticleEffectsUtil.spawnParticles(world2, new Vec3(spawnX, spawnY, spawnZ), ParticleTypes.GUST, 1, new Vec3(0.1, 0.1, 0.1), 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.level().isClientSide() && this.isTame() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase.ordinal()) {
                case 0: {
                    int durationTicks;
                    if (!this.isOrderedToSit() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.random.nextIntBetweenInclusive(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.getId(), (Object)durationTicks);
                    break;
                }
                case 1: {
                    if (!this.isOrderedToSit() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.getId(), (Object)this.driftingOffTimer);
                    break;
                }
                case 2: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.random.nextInt(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.entityData.set(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    this.triggerSettleEffects(0.22f, 5, 0.24f);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.getId(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case 3: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.getId(), this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case 4: {
                    if (canSustainSlumber) break;
                    this.triggerWakeUpFromSleepAnimation(false);
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.tick();
        if (!this.level().isClientSide && !ItemStack.matches((ItemStack)(currentArmor = this.getArmorStack()), (ItemStack)this.lastArmorStack)) {
            this.updateArmorModifiers(currentArmor);
            this.lastArmorStack = currentArmor.copy();
        }
        if (!this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.updateNavigation();
            this.updateArmorModifiers(this.getArmorStack());
        }
        if (!this.level().isClientSide() && this.isSulking() && !this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -1.0, 0.0));
            this.hasImpulse = true;
        }
        if (!(world = this.level()).isClientSide()) {
            if (this.performDeferredArmorUpdate) {
                this.setArmorStack(ItemStack.EMPTY);
                this.performDeferredArmorUpdate = false;
            }
            if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.isSleeping() && this.getLinkedBedPos().isPresent() && this.napInBedDurationTimer == 0 && !this.isRescueSleeping()) {
                this.wakeUpFromBed(false);
            }
            if (!((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.isSleeping() && this.getLinkedBedPos().isPresent() && !this.isRescueSleeping()) {
                boolean isSleepTime;
                boolean bl = isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? world.isDay() : world.isNight();
                if (!isSleepTime) {
                    if (this.wakeUpFromBedDelay == 0 && this.goToBedCooldown == 0) {
                        this.wakeUpFromBedDelay = this.random.nextIntBetweenInclusive(5, 60);
                    }
                } else {
                    this.wakeUpFromBedDelay = 0;
                }
            }
            if (this.wakeUpFromBedDelay == 1) {
                this.wakeUpFromBed(false);
            }
            HamsterPlacementUtil.trySuffocationRescue(this);
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean inventoryChanged = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || this.canPlaceItem(i, stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting invalid item {} from slot {}.", new Object[]{this.getId(), stack.getItem(), i});
                    Containers.dropItemStack((Level)world, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack.copy());
                    this.items.set(i, (Object)ItemStack.EMPTY);
                    inventoryChanged = true;
                }
                if (inventoryChanged) {
                    this.setChanged();
                }
            }
            if (this.isTame() && this.getHealth() < this.getMaxHealth() && !this.isAutoEating() && !this.isConsideringAutoEat() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    this.setHamsterFlag(1024, true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.getId());
                    break;
                }
            }
            if (this.isConsideringAutoEat() && this.preAutoEatDelayTicks == 0) {
                this.setHamsterFlag(1024, false);
                boolean foodStillAvailable = false;
                ItemStack foodToEat = ItemStack.EMPTY;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.isEmpty() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.getId(), foodToEat.getItem(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.playSound(SoundEvents.GENERIC_EAT, 0.7f, 1.3f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, foodToEat.split(1)), 5, new Vec3(0.1, 0.1, 0.1), 0.02);
                    if (foodToEat.isEmpty()) {
                        this.items.set(foodSlot, (Object)ItemStack.EMPTY);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.getId());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.heal(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.getId());
                LivingEntity livingEntity = this.getOwner();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                    ((HamsterAutoFedCriterion)((Object)ModCriteria.HAMSTER_AUTO_FED.get())).trigger(serverPlayerOwner, this);
                }
            }
            if (!this.level().isClientSide() && this.isCelebratingDiamond()) {
                SoundEvent sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.random)) != null) {
                    if (this.currentOreTarget != null) {
                        this.level().playSound(null, this.currentOreTarget, sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        this.level().playSound(null, this.blockPosition(), sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ParticleEffectsUtil.spawnParticlesOnEntity((Entity)this, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, 4, 0.3, 0.3, 0.01, 0.7);
                    if (this.currentOreTarget != null && this.random.nextInt(4) == 0) {
                        BlockPos particlePos = this.currentOreTarget.above();
                        ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atCenterOf((Vec3i)particlePos), ParticleTypes.FIREWORK, 1, new Vec3(0.2, 0.35, 0.2), 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.random);
                    if (celebrationSound != null) {
                        this.level().playSound(null, this.blockPosition(), celebrationSound, SoundSource.NEUTRAL, 0.8f, this.getVoicePitch());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.ALARM_ORCHESTRA_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_SHOCKED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.random.nextInt(3) == 0) {
                    BlockPos particlePos = this.currentOreTarget.above();
                    ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atCenterOf((Vec3i)particlePos), ParticleTypes.SMOKE, 2, new Vec3(0.3, 0.3, 0.3), 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.random.nextInt(5) == 0) {
                    ColorParticleOption darkGrayEffect = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.3f, (float)0.3f, (float)0.3f);
                    ParticleEffectsUtil.spawnParticlesOnEntity((Entity)this, darkGrayEffect, 1, 0.6, 0.5, 0.005, 0.1);
                }
            }
        }
        if (world.isClientSide && this.hasGreenBeanBuff() && this.random.nextInt(2) == 0) {
            ParticleEffectsUtil.spawnMotionTrail((Entity)this, ParticleTypes.WHITE_SMOKE, 3, 1.4, 0.025, 1.7, 0.17);
        }
        if (this.isTauntingWithItem() && this.random.nextInt(7) == 0) {
            ParticleEffectsUtil.spawnParticlesOnEntity((Entity)this, ParticleTypes.INSTANT_EFFECT, 2, 1.2, 0.5, 0.5, 0.2);
        }
        if (world.isClientSide) {
            this.prevClientFallPitchProgress = this.clientFallPitchProgress;
            this.clientFallPitchProgress = this.shouldRenderFlying() && !this.isThrown() ? (this.clientFallPitchProgress += 0.06666667f) : (this.clientFallPitchProgress -= 0.33333334f);
            this.clientFallPitchProgress = Mth.clamp((float)this.clientFallPitchProgress, (float)0.0f, (float)1.0f);
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.isInLove()) {
            this.setInLove(false);
        }
    }

    public void die(DamageSource source) {
        boolean respawnSuccessful;
        if (!this.level().isClientSide() && ((Boolean)Configs.AHP.enableRespawnInBed.get()).booleanValue() && (respawnSuccessful = this.tryRespawnInBed())) {
            this.discard();
            return;
        }
        Level world = this.level();
        if (!world.isClientSide()) {
            if (!this.isTame() && Configs.AHP.disableWildLootDrops) {
                this.items.clear();
            }
            for (ItemStack stack : this.items) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)world, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.die(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "mainController", 3, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.entityData.get(ANIMATION_PERSONALITY_ID);
            if (this.isShoulderPet()) {
                ShoulderAnimationState shoulderState = ShoulderAnimationState.values()[(Integer)this.entityData.get(SHOULDER_ANIMATION_STATE)];
                return switch (shoulderState) {
                    case ShoulderAnimationState.SITTING -> {
                        if (this.getHamsterFlag(8192)) {
                            yield event.setAndContinue(CLEANING_ANIM);
                        }
                        RawAnimation v1 = switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        };
                        yield event.setAndContinue(v1);
                    }
                    case ShoulderAnimationState.LAYING_DOWN -> {
                        switch (this.shoulderLocation) {
                            case LEFT_SHOULDER: {
                                yield event.setAndContinue(LAYING_DOWN_LEFT_SHOULDER_ANIM);
                            }
                            case HEAD: {
                                yield event.setAndContinue(LAYING_DOWN_HEAD_ANIM);
                            }
                        }
                        yield event.setAndContinue(LAYING_DOWN_RIGHT_SHOULDER_ANIM);
                    }
                    default -> event.setAndContinue(personality % 2 == 0 ? IDLE2_ANIM : IDLE1_ANIM);
                };
            }
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.shouldRenderFlying()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            if (this.isTauntingWithItem()) {
                return event.setAndContinue(TAUNT_WITH_ITEM_ANIM);
            }
            if (this.isPresentingItem()) {
                return event.setAndContinue(PRESENTING_ITEM_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSniffForOreGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.getDeltaMovement().horizontalDistanceSqr();
                if (horizontalSpeedSquared > 1.0E-6) {
                    return event.setAndContinue(SEEKING_ORE_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_ORE_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.isTame()) {
                switch (currentDozingPhase.ordinal()) {
                    case 2: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case 3: {
                        String targetDeepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!this.isOrderedToSit()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case 4: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.isTame() && this.isSleeping()) {
                String deepSleepId;
                RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.entityData.get(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                    case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                    case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                    default -> SLEEP_POSE1_ANIM;
                };
                return event.setAndContinue(deepSleepAnimToPlay);
            }
            if (this.isOrderedToSit() && !this.isKnockedOut()) {
                if (this.getHamsterFlag(8192)) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.getDeltaMovement().horizontalDistanceSqr();
            if (horizontalSpeedSquared > 1.0E-6) {
                if (horizontalSpeedSquared > 0.008) {
                    return event.setAndContinue(SPRINTING_ANIM);
                }
                if (horizontalSpeedSquared > 0.002) {
                    return event.setAndContinue(RUNNING_ANIM);
                }
                return event.setAndContinue(WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (activeGoalName.equals(HamsterLookAtEntityGoal.class.getSimpleName())) {
                return switch ((Integer)this.entityData.get(CURRENT_LOOK_UP_ANIM_ID)) {
                    case 2 -> event.setAndContinue(IDLE_LOOKING_UP2_ANIM);
                    case 3 -> event.setAndContinue(IDLE_LOOKING_UP3_ANIM);
                    default -> event.setAndContinue(IDLE_LOOKING_UP1_ANIM);
                };
            }
            RawAnimation current = event.getController().getCurrentRawAnimation();
            if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                return event.setAndContinue(current);
            }
            return event.setAndContinue(this.random.nextBoolean() ? IDLE1_ANIM : IDLE2_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup_from_ko", WAKE_UP_FROM_KO_ANIM).triggerableAnim("standing_headshake", STANDING_HEADSHAKE_ANIM).triggerableAnim("sitting_headshake", SITTING_HEADSHAKE_ANIM).triggerableAnim("moving_headshake", MOVING_HEADSHAKE_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("sit1", SIT1_ANIM).triggerableAnim("sit2", SIT2_ANIM).triggerableAnim("sit3", SIT3_ANIM).triggerableAnim("standup1", STANDUP1_ANIM).triggerableAnim("standup2", STANDUP2_ANIM).triggerableAnim("standup3", STANDUP3_ANIM).triggerableAnim("wakeup1", WAKE_UP_1_ANIM).triggerableAnim("wakeup2", WAKE_UP_2_ANIM).triggerableAnim("wakeup3", WAKE_UP_3_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep1", SIT_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep2", SIT_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep3", SIT_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep1", STAND_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep2", STAND_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep3", STAND_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).triggerableAnim("anim_hamster_pounce_on_item", POUNCE_ON_ITEM_ANIM).triggerableAnim("anim_hamster_celebrate_chase", CELEBRATE_CHASE_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.level().isClientSide()) {
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.getId(), controllerName, animName});
            this.animScheduler.scheduleAnimationStop(this.level().getGameTime(), controllerName, animName, this);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAMSTER_FLAGS, (Object)0);
        builder.define(VARIANT, (Object)0);
        builder.define(PINK_PETAL_TYPE, (Object)0);
        builder.define(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        builder.define(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        builder.define(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
        builder.define(ANIMATION_PERSONALITY_ID, (Object)1);
        builder.define(ITEM_INTEREST_TIMER, (Object)0);
        builder.define(INTEREST_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(GREEN_BEAN_BUFF_DURATION, (Object)0L);
        builder.define(CURRENT_LOOK_UP_ANIM_ID, (Object)1);
        builder.define(SHOULDER_ANIMATION_STATE, (Object)ShoulderAnimationState.STANDING.ordinal());
        builder.define(TRACKED_ACCESSORY_STACK, (Object)ItemStack.EMPTY);
        builder.define(TRACKED_ARMOR_STACK, (Object)ItemStack.EMPTY);
        builder.define(FALL_IMMUNITY_ACTIVE, (Object)true);
    }

    protected void registerGoals() {
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.getId(), this.level().isClientSide ? "ClientTick?" : Long.valueOf(this.level().getGameTime()), this.isSleeping(), this.isInSittingPose()});
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new HamsterSniffForOreGoal(this));
        this.goalSelector.addGoal(1, (Goal)new HamsterPlayWithItemGoal(this));
        this.goalSelector.addGoal(2, (Goal)new HamsterGoToBedAndSleepGoal(this));
        this.goalSelector.addGoal(2, (Goal)new HamsterMeleeAttackGoal(this, 1.5, true));
        this.goalSelector.addGoal(3, (Goal)new HamsterMateGoal(this, 0.75));
        this.goalSelector.addGoal(4, (Goal)new HamsterFollowOwnerGoal(this, 1.0, 4.0f, 16.0f));
        this.goalSelector.addGoal(5, new HamsterFleeGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.75, 1.5));
        this.goalSelector.addGoal(6, (Goal)new HamsterTemptGoal(this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new HamsterSitGoal(this));
        this.goalSelector.addGoal(8, (Goal)new HamsterSleepGoal(this));
        this.goalSelector.addGoal(9, (Goal)new HamsterWanderAroundFarGoal(this, 0.75));
        this.goalSelector.addGoal(10, (Goal)new HamsterLookAtEntityGoal((Mob)this, Player.class, 2.0f, 0.15f));
        this.goalSelector.addGoal(11, (Goal)new HamsterLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.getId(), this.level().isClientSide ? "ClientTick?" : Long.valueOf(this.level().getGameTime()));
    }

    protected PathNavigation createNavigation(Level world) {
        if (Configs.AHP.avoidUnlinkedBeds) {
            return new HamsterNavigation(this, world);
        }
        return new GroundPathNavigation((Mob)this, world);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == null) {
            super.setTarget(null);
            return;
        }
        if (this.isTame() && this.getOwner() != null) {
            TraceableEntity ownableFallback;
            Entity fallbackOwnerEntity;
            LivingEntity owner = this.getOwner();
            UUID ownerUuid = owner.getUUID();
            boolean preventTargeting = false;
            if (target instanceof TamableAnimal) {
                TamableAnimal tameablePet = (TamableAnimal)target;
                UUID petOwnerUuid = tameablePet.getOwnerUUID();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof AbstractHorse) {
                AbstractHorse horsePet = (AbstractHorse)target;
                LivingEntity horseOwnerEntity = horsePet.getOwner();
                if (horseOwnerEntity != null && horseOwnerEntity.getUUID().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).getOwner()) != null && fallbackOwnerEntity.getUUID().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.setTarget(null);
                return;
            }
        }
        super.setTarget(target);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        double d;
        double baseY = (double)this.getBbHeight() * 0.85;
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            d = HamsterSeatOffsets.physicsSeatAdjustY(living, this.getScale());
        } else {
            d = 0.0;
        }
        double riderAdjustY = d;
        return new Vec3(0.0, baseY + riderAdjustY, 0.0);
    }

    public void startBedSleepEffects() {
        if (this.level().isClientSide()) {
            return;
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.level().dimension() == globalPos.dimension()) {
                BlockPos bedPos = globalPos.pos();
                BlockState bedState = this.level().getBlockState(bedPos);
                ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atBottomCenterOf((Vec3i)bedPos).add(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.getValue(HamsterBedBlock.WOOD_VARIANT)))), 70, new Vec3(0.2, 0.5, 0.2), 1.0);
            }
        });
        this.bedLeafParticleTicks = 4;
        SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.random);
        if (rustleSound != null) {
            this.level().playSound(null, this.blockPosition(), rustleSound, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            ((HamsterSleptInBedCriterion)((Object)ModCriteria.HAMSTER_SLEPT_IN_BED.get())).trigger(serverPlayerOwner);
        }
    }

    protected SoundEvent getAmbientSound() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging() || this.isTauntingWithItem()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.random);
        }
        boolean playSleepSounds = false;
        if (this.isTame()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.isSleeping()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.random);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.random);
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.playSound(soundEvent, 0.8f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.random);
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.random);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.level().isClientSide()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.getId())) {
            try {
                SoundType group = state.getSoundType();
                float volume = state.is(Blocks.GRAVEL) ? 0.060000002f : 0.1f;
                this.playSound(group.getStepSound(), volume, group.getPitch() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof ArmorStand) {
            return !entity.isSpectator();
        }
        if (!entity.isSpectator() && entity.isAlive() && entity.isPickable()) {
            LivingEntity owner = this.getOwner();
            return entity != this && (owner == null || !owner.isPassengerOfSameVehicle(entity));
        }
        return false;
    }

    protected void applyGravity() {
        if (this.isThrown() && this.isNoGravity()) {
            return;
        }
        super.applyGravity();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        if (!world.isClientSide()) {
            int personalityId = this.random.nextIntBetweenInclusive(1, 3);
            this.entityData.set(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.trace("[INITIALIZE] Hamster ID {}: Assigned Personality ID {}", (Object)this.getId(), (Object)personalityId);
        }
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.CHUNK_GENERATION) {
            Holder biomeEntry = world.getBiome(this.blockPosition());
            String biomeKeyStr = biomeEntry.unwrapKey().map(key -> key.location().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((Holder<Biome>)biomeEntry, this.random);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.random.nextInt(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        if (!this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.setHealth(this.getMaxHealth());
        }
        this.generateWildLoot();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected BodyRotationControl createBodyControl() {
        return new HamsterBodyControl((Mob)this);
    }

    private boolean shouldArmorAbsorb(DamageSource source, ItemStack armorStack) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return this.getFireProtectionLevel(armorStack) > 0;
        }
        return true;
    }

    private int getFireProtectionLevel(ItemStack stack) {
        HolderLookup.RegistryLookup registry = this.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fireProt = registry.getOrThrow(Enchantments.FIRE_PROTECTION);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)fireProt, (ItemStack)stack);
    }

    private boolean tryRespawnInBed() {
        HamsterEntity newHamster;
        HamsterBedBlockEntity bedEntity;
        if (this.getLinkedBedPos().isEmpty()) {
            return false;
        }
        GlobalPos globalBedPos = this.getLinkedBedPos().get();
        MinecraftServer server = this.getServer();
        if (server == null) {
            return false;
        }
        ServerLevel bedWorld = server.getLevel(globalBedPos.dimension());
        if (bedWorld == null) {
            return false;
        }
        BlockPos bedPos = globalBedPos.pos();
        BlockState bedState = bedWorld.getBlockState(bedPos);
        if (!(bedState.getBlock() instanceof HamsterBedBlock)) {
            return false;
        }
        BlockEntity beCheck = bedWorld.getBlockEntity(bedPos);
        if (!(beCheck instanceof HamsterBedBlockEntity) || !(bedEntity = (HamsterBedBlockEntity)beCheck).isRespawnEnabled()) {
            return false;
        }
        boolean isBedFree = (Boolean)bedState.getValue((Property)HamsterBedBlock.OCCUPIED) == false;
        BlockPos finalSpawnPos = null;
        if (!isBedFree) {
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(bedPos, (Level)bedWorld, 2, this);
            if (safePosOpt.isEmpty()) {
                return false;
            }
            finalSpawnPos = safePosOpt.get();
        }
        if ((newHamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)bedWorld)) == null) {
            return false;
        }
        CompoundTag data = new CompoundTag();
        this.addAdditionalSaveData(data);
        newHamster.readAdditionalSaveData(data);
        newHamster.setOwnerUUID(this.getOwnerUUID());
        newHamster.setTame(this.isTame(), false);
        newHamster.setCustomName(this.getCustomName());
        newHamster.setKnockedOut(false);
        newHamster.interactionCooldown = 0;
        if (isBedFree) {
            Vec3 bedCenter = Vec3.atCenterOf((Vec3i)bedPos).add(0.0, 0.1, 0.0);
            newHamster.moveTo(bedCenter.x, bedCenter.y, bedCenter.z, 0.0f, 0.0f);
            newHamster.setHealth(Math.max(1.0f, newHamster.getMaxHealth() * 0.05f));
            newHamster.setDozingPhase(DozingPhase.DEEP_SLEEP);
            newHamster.setSleeping(true);
            newHamster.setInSittingPose(true);
            int personality = (Integer)newHamster.getEntityData().get(ANIMATION_PERSONALITY_ID);
            int poseIndex = personality >= 1 && personality <= 3 ? personality : 1;
            String sleepAnim = "anim_hamster_sleep_pose" + poseIndex;
            newHamster.getEntityData().set(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)sleepAnim);
            bedWorld.setBlock(bedPos, (BlockState)bedState.setValue((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
            if (bedEntity instanceof GeoBlockEntity) {
                HamsterBedBlockEntity geoBlockEntity = bedEntity;
                geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_occupied");
            }
        } else {
            newHamster.moveTo((double)finalSpawnPos.getX() + 0.5, finalSpawnPos.getY(), (double)finalSpawnPos.getZ() + 0.5, this.getYRot(), 0.0f);
            newHamster.setHealth(newHamster.getMaxHealth());
            newHamster.setOrderedToSit(false);
        }
        BlockEntity personality = bedWorld.getBlockEntity(bedPos);
        if (personality instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity finalBedEntity = (HamsterBedBlockEntity)personality;
            Component name = newHamster.hasCustomName() ? newHamster.getCustomName() : newHamster.getDisplayName();
            finalBedEntity.setLinkedHamster(newHamster.getUUID(), name, finalBedEntity.getWanderDistance());
            finalBedEntity.setRespawnEnabled(false);
        }
        bedWorld.addFreshEntity((Entity)newHamster);
        bedWorld.playSound(null, bedPos, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ParticleEffectsUtil.spawnParticles((Level)bedWorld, Vec3.atCenterOf((Vec3i)bedPos), ParticleTypes.REVERSE_PORTAL, 20, new Vec3(0.3, 0.3, 0.3), 0.1);
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            owner.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.respawn.success").withStyle(ChatFormatting.GOLD), true);
        }
        return true;
    }

    protected void removePassenger(Entity passenger) {
        LivingEntity controller = this.getControllingPassenger();
        super.removePassenger(passenger);
        if (passenger == controller) {
            this.riderJumpCooldown = 0;
            this.riderJumpHeld = false;
            this.riderSprintHeld = false;
            this.riderJumpQueued = false;
            this.setSprinting(false);
        }
    }

    private void tryRiderJump() {
        Player p;
        if (!this.onGround()) {
            return;
        }
        if (this.isInWater() || this.isInLava()) {
            return;
        }
        this.jumpFromGround();
        Vec3 v = this.getDeltaMovement();
        this.setDeltaMovement(v.x, 0.6, v.z);
        this.hasImpulse = true;
        this.fallDistance = 0.0f;
        LivingEntity livingEntity = this.getControllingPassenger();
        Player rider = livingEntity instanceof Player ? (p = (Player)livingEntity) : null;
        float randomPitch = 1.2f + (this.random.nextFloat() * 0.4f - 0.2f);
        this.level().playSound(rider, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), SoundSource.PLAYERS, 0.6f, randomPitch);
        this.riderJumpCooldown = 8;
    }

    private boolean hasInventoryData(CompoundTag nbt) {
        return nbt.contains("Inventory", 10);
    }

    private void generateWildLoot() {
        if (this.isTame() || !((ItemStack)this.items.get(0)).isEmpty()) {
            return;
        }
        float globalChance = ((Float)Configs.AHP_WORLDGEN.globalCheekLootChance.get()).floatValue();
        if (this.random.nextFloat() > globalChance) {
            return;
        }
        boolean fillBothCheeks = this.random.nextFloat() < 0.4f;
        BiConsumer<Integer, Integer> fillCheek = (startSlot, mode) -> {
            ItemStack stack;
            Item item;
            int count = 1 + this.random.nextInt(3);
            int specificSlot = startSlot + this.random.nextInt(3);
            switch (mode) {
                case 1: {
                    Item item2 = ConfigDataCache.getRandomCustomLootItem(this.random);
                    break;
                }
                case 2: {
                    Item item2 = ConfigDataCache.getRandomCaveLootItem(this.random);
                    break;
                }
                default: {
                    Item item2 = item = ConfigDataCache.getRandomDefaultLootItem(this.random);
                }
            }
            if (item != Items.AIR && !this.isItemDisallowed(stack = new ItemStack((ItemLike)item, count)) && ((ItemStack)this.items.get(specificSlot)).isEmpty()) {
                this.setItem(specificSlot, stack);
            }
        };
        boolean isCaveHamster = false;
        if (!this.level().isClientSide()) {
            boolean isDeepAndDark;
            Holder biomeEntry = this.level().getBiome(this.blockPosition());
            boolean isCaveBiome = biomeEntry.is(ModBiomeTags.IS_CAVE);
            boolean bl = isDeepAndDark = this.getY() < 50.0 && !this.level().canSeeSky(this.blockPosition());
            if (isCaveBiome || isDeepAndDark) {
                isCaveHamster = true;
            }
        }
        if (isCaveHamster) {
            float caveChance = ((Float)Configs.AHP_WORLDGEN.caveCheekLootChance.get()).floatValue();
            if (this.random.nextFloat() < caveChance) {
                if (fillBothCheeks) {
                    fillCheek.accept(0, 2);
                    fillCheek.accept(3, 2);
                } else {
                    fillCheek.accept(this.random.nextBoolean() ? 0 : 3, 2);
                }
                return;
            }
        }
        float defaultChance = ((Float)Configs.AHP_WORLDGEN.defaultCheekLootChance.get()).floatValue();
        if (this.random.nextFloat() < defaultChance) {
            if (fillBothCheeks) {
                fillCheek.accept(0, 0);
                fillCheek.accept(3, 0);
            } else {
                fillCheek.accept(this.random.nextBoolean() ? 0 : 3, 0);
            }
        }
        float customChance = ((Float)Configs.AHP_WORLDGEN.extraCheekLootChance.get()).floatValue();
        if (!Configs.AHP_WORLDGEN.extraCheekLootList.isEmpty() && this.random.nextFloat() < customChance) {
            if (fillBothCheeks) {
                fillCheek.accept(0, 1);
                fillCheek.accept(3, 1);
            } else {
                fillCheek.accept(this.random.nextBoolean() ? 0 : 3, 1);
            }
        }
    }

    public void triggerLeafPopEffects(BlockPos pos, boolean playBreakSound) {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, pos, SoundEvents.AZALEA_LEAVES_BREAK, SoundSource.NEUTRAL, 0.7f, 1.2f);
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.random);
            if (rustleSound != null) {
                this.level().playSound(null, pos, rustleSound, SoundSource.NEUTRAL, 1.7f, 1.0f);
            }
            ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atCenterOf((Vec3i)pos), ModParticles.getForVariant(WoodVariant.BAMBOO), 50, new Vec3(0.4, 0.4, 0.4), 0.0);
            ParticleEffectsUtil.spawnParticles(this.level(), Vec3.atCenterOf((Vec3i)pos), ParticleTypes.POOF, 50, new Vec3(0.5, 0.75, 0.5), 0.0);
        }
    }

    public void scheduleTreeHeistCelebration() {
        if (!this.level().isClientSide()) {
            this.animScheduler.scheduleTask(this.level().getGameTime() + 20L, "heist_celebration", () -> {
                SoundEvent sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random);
                if (sparkleSound != null) {
                    this.playSound(sparkleSound, 1.0f, 1.0f);
                }
            });
        }
    }

    public void updateAccessoryState() {
        ItemStack accessory = (ItemStack)this.items.get(6);
        if (accessory.is(Items.PINK_PETALS)) {
            if ((Integer)this.entityData.get(PINK_PETAL_TYPE) == 0) {
                this.entityData.set(PINK_PETAL_TYPE, (Object)1);
            }
        } else if ((Integer)this.entityData.get(PINK_PETAL_TYPE) != 0) {
            this.entityData.set(PINK_PETAL_TYPE, (Object)0);
        }
    }

    private void handleSlotUpdateSounds(int slot, ItemStack oldStack, ItemStack newStack) {
        boolean isEmpty = newStack.isEmpty();
        boolean wasEmpty = oldStack.isEmpty();
        if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) {
            return;
        }
        if (slot == 7) {
            if (wasEmpty && !isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_WOLF.value(), 0.6f, 1.2f);
            } else if (!wasEmpty && isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_WOLF.value(), 0.4f, 0.8f);
            } else if (!wasEmpty && !isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_WOLF.value(), 0.6f, 1.2f);
            }
        }
        if (slot == 6) {
            if (wasEmpty && !isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 0.6f, 1.2f);
            } else if (!wasEmpty && isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 0.4f, 0.8f);
            } else if (!wasEmpty && !isEmpty) {
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 0.6f, 1.2f);
            }
        }
    }

    private void updateArmorModifiers(ItemStack armorStack) {
        Item item;
        AttributeInstance speedAttribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeInstance knockbackAttribute = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        boolean perksEnabled = (Boolean)Configs.AHP.enableArmorPerks.get();
        boolean shouldHaveSpeed = false;
        boolean shouldHaveKnockback = false;
        if (perksEnabled && !armorStack.isEmpty() && (item = armorStack.getItem()) instanceof HamsterArmorItem) {
            HamsterArmorItem armorItem = (HamsterArmorItem)item;
            HamsterArmorItem.HamsterArmorMaterial material = armorItem.getMaterial();
            if (material == HamsterArmorItem.HamsterArmorMaterial.GOLD) {
                shouldHaveSpeed = true;
            } else if (material == HamsterArmorItem.HamsterArmorMaterial.NETHERITE) {
                shouldHaveKnockback = true;
            }
        }
        if (speedAttribute != null) {
            boolean hasSpeed = speedAttribute.hasModifier(ARMOR_SPEED_BOOST_ID);
            if (shouldHaveSpeed && !hasSpeed) {
                double boost = (Double)Configs.AHP.goldArmorSpeedBoost.get();
                speedAttribute.addTransientModifier(new AttributeModifier(ARMOR_SPEED_BOOST_ID, boost, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            } else if (!shouldHaveSpeed && hasSpeed) {
                speedAttribute.removeModifier(ARMOR_SPEED_BOOST_ID);
            }
        }
        if (knockbackAttribute != null) {
            boolean hasKnockback = knockbackAttribute.hasModifier(ARMOR_KNOCKBACK_RESISTANCE_ID);
            if (shouldHaveKnockback && !hasKnockback) {
                double resist = (Double)Configs.AHP.netheriteArmorKnockbackResist.get();
                knockbackAttribute.addTransientModifier(new AttributeModifier(ARMOR_KNOCKBACK_RESISTANCE_ID, resist, AttributeModifier.Operation.ADD_VALUE));
            } else if (!shouldHaveKnockback && hasKnockback) {
                knockbackAttribute.removeModifier(ARMOR_KNOCKBACK_RESISTANCE_ID);
            }
        }
    }

    private void broadcastImpactSound(SoundEvent sound, float pitch) {
        HamsterArmorItem armorItem;
        Item item;
        ItemStack armorStack;
        if (this.level().isClientSide()) {
            return;
        }
        double impactX = this.getX();
        double impactY = this.getY();
        double impactZ = this.getZ();
        SoundEvent armorSound = null;
        float armorPitch = 1.0f;
        if (this.items.size() > 7 && !(armorStack = (ItemStack)this.items.get(7)).isEmpty() && (item = armorStack.getItem()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item).getMaterial() != HamsterArmorItem.HamsterArmorMaterial.ACORN) {
            armorSound = SoundEvents.BELL_BLOCK;
            armorPitch = 2.0f + this.random.nextFloat() * 0.5f;
        }
        for (ServerPlayer player : ((ServerLevel)this.level()).players()) {
            float volume;
            double distSq = player.distanceToSqr(impactX, impactY, impactZ);
            if (!(distSq <= 2500.0)) continue;
            double distance = Math.sqrt(distSq);
            if (distance <= 16.0) {
                volume = 1.0f - 0.82f * (float)(distance / 16.0);
            } else {
                float remainingProgress = (float)(distance - 16.0) / 34.0f;
                volume = 0.18f - 0.08f * remainingProgress;
            }
            volume = Mth.clamp((float)volume, (float)0.1f, (float)1.0f);
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayDistantSoundPayload(sound.getLocation(), volume, pitch));
            if (armorSound == null) continue;
            float armorVolume = Math.min(1.0f, volume * 0.5f);
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayDistantSoundPayload(armorSound.getLocation(), armorVolume, armorPitch));
        }
    }

    private void simulateTrajectoryAndCheckSound() {
        Vec3 simPos = this.position();
        Vec3 simVel = this.getDeltaMovement();
        for (int i = 1; i <= 20; ++i) {
            if (!this.isNoGravity()) {
                simVel = simVel.add(0.0, -0.05, 0.0);
            }
            Vec3 nextPos = simPos.add(simVel);
            BlockHitResult blockHit = this.level().clip(new ClipContext(simPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)simPos, (Vec3)nextPos, (AABB)this.getBoundingBox().expandTowards(simVel).inflate(1.0), this::canHitEntity);
            Vec3 impactPos = null;
            if (entityHit != null) {
                impactPos = entityHit.getLocation();
            } else if (blockHit.getType() != HitResult.Type.MISS) {
                impactPos = blockHit.getLocation();
            }
            if (impactPos != null) {
                if (this.throwTicks + i >= 20) {
                    this.level().playSound(null, impactPos.x, impactPos.y, impactPos.z, (SoundEvent)ModSounds.HAMSTER_INCOMING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    AdorableHamsterPets.LOGGER.debug("Played Incoming sound at target: {}", (Object)impactPos);
                }
                this.hasPlayedIncomingSound = true;
                return;
            }
            simPos = nextPos;
        }
    }

    private boolean getHamsterFlag(int flag) {
        return ((Integer)this.entityData.get(HAMSTER_FLAGS) & flag) != 0;
    }

    private void setHamsterFlag(int flag, boolean value) {
        int currentFlags = (Integer)this.entityData.get(HAMSTER_FLAGS);
        if (value) {
            this.entityData.set(HAMSTER_FLAGS, (Object)(currentFlags | flag));
        } else {
            this.entityData.set(HAMSTER_FLAGS, (Object)(currentFlags & ~flag));
        }
    }

    public boolean isItemDisallowed(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (ConfigDataCache.isPouchAllowed(stack)) {
            return false;
        }
        if (ConfigDataCache.isPouchDisallowed(stack)) {
            return true;
        }
        if (ConfigDataCache.isStandardFood(stack) || ConfigDataCache.isTamingFood(stack) || ConfigDataCache.isBuffFood(stack) || ConfigDataCache.isPouchUnlockFood(stack) || ConfigDataCache.isAutoHealFood(stack)) {
            return false;
        }
        if (stack.get(DataComponents.FOOD) != null) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof SpawnEggItem;
    }

    private HolderLookup.Provider getRegistryLookup() {
        return this.level().registryAccess();
    }

    private boolean tryTame(Player player, ItemStack itemStack) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.random.nextInt(denominator) == 0) {
            this.setOwnerUUID(player.getUUID());
            this.setTame(true, true);
            this.navigation.stop();
            this.setOrderedToSit(false);
            this.setSleeping(false);
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            SoundEvent celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random);
            this.level().playSound(null, this.blockPosition(), celebrateSound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.TAME_ANIMAL.trigger(serverPlayer, (Animal)this);
            }
            return true;
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
        return false;
    }

    public void playRefusalAnimation() {
        if (!this.level().isClientSide()) {
            if (this.isOrderedToSit()) {
                this.triggerAnimOnServer("mainController", "sitting_headshake");
            } else {
                boolean isMoving;
                boolean bl = isMoving = this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
                if (isMoving) {
                    this.triggerAnimOnServer("mainController", "moving_headshake");
                } else {
                    this.triggerAnimOnServer("mainController", "standing_headshake");
                }
            }
        }
    }

    private boolean checkRepeatFoodRefusal(ItemStack currentStack, Player player) {
        if (ConfigDataCache.isRepeatableFood(currentStack)) {
            return false;
        }
        if (!this.lastFoodItem.isEmpty() && ItemStack.isSameItem((ItemStack)this.lastFoodItem, (ItemStack)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.food_refusal"), true);
            this.playRefusalAnimation();
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(Player player, ItemStack stack) {
        boolean isFood = ConfigDataCache.isStandardFood(stack);
        boolean isBuffItem = ConfigDataCache.isBuffFood(stack);
        boolean isPouchUnlockFood = ConfigDataCache.isPouchUnlockFood(stack);
        boolean canHeal = this.getHealth() < this.getMaxHealth();
        boolean readyToBreed = this.getAge() == 0 && !this.isInCustomLove();
        Level world = this.level();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.getId(), world.getGameTime(), stack.getItem(), isFood, isBuffItem, canHeal, this.getAge(), this.isInCustomLove(), readyToBreed});
        if (isPouchUnlockFood && !this.getHamsterFlag(512)) {
            this.setHamsterFlag(512, true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by {}.", (Object)this.getId(), (Object)stack.getItem());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((CheekPouchUnlockedCriterion)((Object)ModCriteria.CHEEK_POUCH_UNLOCKED.get())).trigger(serverPlayer, this);
            }
            world.playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 0.5f, 1.5f);
            ParticleEffectsUtil.spawnParticles(world, new Vec3(this.getX(), this.getY(0.2), this.getZ()), new ItemParticleOption(ParticleTypes.ITEM, stack.copy()), 25, new Vec3(0.25, 0.15, 0.25), 0.0);
            return true;
        }
        if (isBuffItem) {
            long currentTime = world.getGameTime();
            if (this.greenBeanBuffEndTick > currentTime) {
                long remainingTicks = this.greenBeanBuffEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).withStyle(ChatFormatting.RED), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.getId(), world.getGameTime(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.zoomiesIsClockwise = this.random.nextBoolean();
            this.lastZoomiesAngle = 0.0;
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, speedAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration, strengthAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, duration, absorptionAmplifier));
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration, regenAmplifier));
            this.zoomiesIsClockwise = this.random.nextBoolean();
            this.zoomiesRadiusModifier = this.random.nextIntBetweenInclusive(-2, 4);
            double dx = this.getX() - player.getX();
            double dz = this.getZ() - player.getZ();
            this.lastZoomiesAngle = Math.atan2(dz, dx);
            SoundEvent buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random);
            world.playSound(null, this.blockPosition(), buffSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            long buffDurationEnd = currentTime + (long)((Integer)config.greenBeanBuffDuration.get()).intValue();
            this.getEntityData().set(GREEN_BEAN_BUFF_DURATION, (Object)buffDurationEnd);
            this.greenBeanBuffEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.trace("[FeedAttempt {} Tick {}] Applied buffs. Duration ends at tick {}. Cooldown ends at tick {}.", new Object[]{this.getId(), world.getGameTime(), buffDurationEnd, this.greenBeanBuffEndTick});
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((FedHamsterSteamedBeansCriterion)((Object)ModCriteria.FED_HAMSTER_STEAMED_BEANS.get())).trigger(serverPlayer, this);
            }
        } else if (ConfigDataCache.isStandardFood(stack)) {
            if (canHeal) {
                this.heal(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.getId());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.getId());
            }
        }
        if (!actionTaken) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item {} was not a valid food for any action.", new Object[]{this.getId(), world.getGameTime(), stack.getItem()});
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!this.isOrderedToSit()) {
            return false;
        }
        Level world = this.level();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.isDay()) {
            return false;
        }
        if (this.isInLove()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(threatRadius), entity -> entity instanceof Monster && entity.isAlive() && !entity.isSpectator());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return this.isOrderedToSit() && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.getId(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        if (!this.level().isClientSide()) {
            HamsterRenderTracker.onEntityUnload(this.getId());
        }
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }
}

