/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.advancement.criterion.TreeHeistDepletionCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.TreeHeistStartedCriterion;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class HamsterTreeSearcherEntity
extends Entity {
    private static final Map<GlobalPos, Integer> ACTIVE_HEISTS = new ConcurrentHashMap<GlobalPos, Integer>();
    private CompoundTag hamsterNbt = new CompoundTag();
    private final List<Long> validLeafPositions = new ArrayList<Long>();
    private int searchTimer;
    private int maxSearchDuration;
    private int validationTimer;
    private int rummageTimer;
    private float dropChanceMultiplier = 1.0f;
    private boolean isExhausted = false;
    private BlockPos treeAnchor = null;
    private boolean hasAcornHat = false;
    private int dropCooldown = 0;
    private boolean isRegistered = false;
    private static final int VALIDATION_INTERVAL = 20;
    private static final int BASE_DURATION_MIN = 180;
    private static final int BASE_DURATION_MAX = 280;
    private static final float HAT_DROP_CHANCE_MULTIPLIER = 2.0f;
    private static final float BASE_DROP_CHANCE = 0.03f;
    private static final float DURATION_MULTIPLIER = 2.0f;

    public HamsterTreeSearcherEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
        this.setNoGravity(true);
        this.setInvisible(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public static boolean isTreeBlocked(Level world, BlockPos anchor) {
        if (anchor == null || world.isClientSide()) {
            return false;
        }
        GlobalPos key = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)anchor);
        return ACTIVE_HEISTS.containsKey(key);
    }

    private void registerHeist() {
        if (this.level().isClientSide() || this.treeAnchor == null || this.isRegistered) {
            return;
        }
        GlobalPos key = GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.treeAnchor);
        ACTIVE_HEISTS.put(key, this.getId());
        this.isRegistered = true;
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Registered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.toShortString(), this.getId(), ACTIVE_HEISTS.size()});
        }
    }

    private void unregisterHeist() {
        if (this.level().isClientSide() || this.treeAnchor == null || !this.isRegistered) {
            return;
        }
        GlobalPos key = GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.treeAnchor);
        if (ACTIVE_HEISTS.remove(key, this.getId())) {
            this.isRegistered = false;
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Unregistered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.toShortString(), this.getId(), ACTIVE_HEISTS.size()});
            }
        }
    }

    public BlockPos getTreeAnchor() {
        return this.treeAnchor;
    }

    public void initializeSearch(BlockPos startPos, TreeHeistUtil.TreeScanResult scanResult, CompoundTag originalHamsterNbt) {
        CompoundTag invNbt;
        this.hamsterNbt = originalHamsterNbt;
        this.setPos((double)startPos.getX() + 0.5, (double)startPos.getY() + 0.5, (double)startPos.getZ() + 0.5);
        this.validLeafPositions.clear();
        for (BlockPos pos : scanResult.validCanopyPositions()) {
            this.validLeafPositions.add(pos.asLong());
        }
        this.treeAnchor = scanResult.treeId();
        this.registerHeist();
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Init] Searcher Entity Initialized. Anchor: {}. Canopy: {}.", (Object)this.treeAnchor.toShortString(), (Object)this.validLeafPositions.size());
        }
        if (this.validLeafPositions.isEmpty()) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Init] No valid leaves found. Aborting.");
            }
            this.popOut(false);
            return;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.level(), scanResult);
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Identified Tree ID: {} | Canopy Size: {}", (Object)this.treeAnchor, (Object)this.validLeafPositions.size());
        }
        if (this.hamsterNbt.hasUUID("Owner")) {
            UUID ownerUuid = this.hamsterNbt.getUUID("Owner");
            Player player = this.level().getPlayerByUUID(ownerUuid);
            if (player instanceof PlayerEntityAccessor) {
                PlayerEntityAccessor accessor = (PlayerEntityAccessor)player;
                this.dropChanceMultiplier = accessor.ahp$getHeistProfitability(this.treeAnchor);
                accessor.ahp$registerTreeHeist(this.treeAnchor);
                if (this.dropChanceMultiplier <= 0.01f) {
                    this.isExhausted = true;
                }
                if (!this.isExhausted) {
                    TreeHeistUtil.sendHeistStartMessage(player, this.dropChanceMultiplier);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((TreeHeistStartedCriterion)((Object)ModCriteria.TREE_HEIST_STARTED.get())).trigger(serverPlayer);
                }
            }
        }
        int baseDuration = this.random.nextIntBetweenInclusive(180, 280);
        this.hasAcornHat = false;
        if (this.hamsterNbt.contains("Inventory", 10) && (invNbt = this.hamsterNbt.getCompound("Inventory")).contains("Items", 9)) {
            ListTag itemsList = invNbt.getList("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                ItemStack stack;
                CompoundTag itemTag = itemsList.getCompound(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot != 6 || !(stack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)itemTag).orElse(ItemStack.EMPTY)).is((Item)ModItems.ACORN_HAT.get())) continue;
                this.hasAcornHat = true;
                break;
            }
        }
        if (this.isExhausted) {
            baseDuration = Math.max(60, (int)((float)baseDuration * 0.1f));
        }
        this.searchTimer = baseDuration;
        this.maxSearchDuration = baseDuration;
        this.validationTimer = 20;
        if (Configs.AHP.debugTreeDetection) {
            float baseChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue();
            float estimatedFinalChance = baseChance * this.dropChanceMultiplier;
            if (this.hasAcornHat) {
                estimatedFinalChance *= 2.0f;
            }
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Stats] Heist Initialized:\n  - Tree Anchor: {}\n  - Base Profitability (History): {}%\n  - Acorn Hat Equipped: {}\n  - Hat Multiplier: {}x\n  - FINAL Drop Chance per Rummage: {}% (Base: {}%)\n", new Object[]{this.treeAnchor.toShortString(), String.format("%.1f", Float.valueOf(this.dropChanceMultiplier * 100.0f)), this.hasAcornHat, Float.valueOf(this.hasAcornHat ? 2.0f : 1.0f), String.format("%.2f", Float.valueOf(estimatedFinalChance * 100.0f)), String.format("%.2f", Float.valueOf(baseChance * 100.0f))});
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (!this.isRegistered && this.treeAnchor != null) {
            this.registerHeist();
        }
        if (this.validLeafPositions.isEmpty()) {
            if (this.tickCount > 5) {
                this.discard();
            }
            return;
        }
        if (this.dropCooldown > 0) {
            --this.dropCooldown;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.level(), this.treeAnchor, this.validLeafPositions);
        }
        if (--this.validationTimer <= 0) {
            this.validationTimer = 20;
            if (!this.validateTreeIntegrity()) {
                this.popOut(false);
                return;
            }
        }
        if (--this.rummageTimer <= 0) {
            this.rummageTimer = this.random.nextIntBetweenInclusive(3, 5);
            this.rummage();
        }
        if (--this.searchTimer <= 0) {
            this.popOut(true);
        }
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        if (!this.level().isClientSide()) {
            this.unregisterHeist();
        }
    }

    private boolean validateTreeIntegrity() {
        int samples = Math.min(3, this.validLeafPositions.size());
        int failures = 0;
        for (int i = 0; i < samples; ++i) {
            long posLong = this.validLeafPositions.get(this.random.nextInt(this.validLeafPositions.size()));
            BlockPos pos = BlockPos.of((long)posLong);
            if (this.level().getBlockState(pos).is(Blocks.OAK_LEAVES)) continue;
            ++failures;
        }
        return failures <= samples / 2;
    }

    private void rummage() {
        BlockPos currentPos = this.blockPosition();
        BlockPos targetPos = null;
        ArrayList<BlockPos> nearbyExposed = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nearbyBuried = new ArrayList<BlockPos>();
        for (Long l : this.validLeafPositions) {
            BlockPos p = BlockPos.of((long)l);
            if (p.equals((Object)currentPos) || p.distManhattan((Vec3i)currentPos) > 2) continue;
            if (this.isLeafExposed(this.level(), p)) {
                nearbyExposed.add(p);
                continue;
            }
            nearbyBuried.add(p);
        }
        if (!nearbyExposed.isEmpty()) {
            targetPos = (BlockPos)nearbyExposed.get(this.random.nextInt(nearbyExposed.size()));
        } else if (!nearbyBuried.isEmpty()) {
            targetPos = (BlockPos)nearbyBuried.get(this.random.nextInt(nearbyBuried.size()));
        } else {
            ArrayList<BlockPos> allExposed = new ArrayList<BlockPos>();
            for (Long posLong : this.validLeafPositions) {
                BlockPos p = BlockPos.of((long)posLong);
                if (!this.isLeafExposed(this.level(), p)) continue;
                allExposed.add(p);
            }
            if (!allExposed.isEmpty()) {
                targetPos = (BlockPos)allExposed.get(this.random.nextInt(allExposed.size()));
            } else {
                long l = this.validLeafPositions.get(this.random.nextInt(this.validLeafPositions.size()));
                targetPos = BlockPos.of((long)l);
            }
        }
        this.setPos((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        ParticleEffectsUtil.spawnParticles(this.level(), new Vec3(this.getX(), this.getY(), this.getZ()), ModParticles.getForVariant(WoodVariant.BAMBOO), 50, new Vec3(0.4, 0.4, 0.4), 0.0);
        ParticleEffectsUtil.spawnParticles(this.level(), new Vec3(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5), ParticleTypes.WHITE_ASH, 7, new Vec3(0.4, 0.4, 0.4), 0.1);
        float dropChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue() * this.dropChanceMultiplier;
        if (this.hasAcornHat) {
            dropChance *= 2.0f;
        }
        if (this.random.nextFloat() < dropChance && this.dropCooldown <= 0) {
            BlockPos blockPos = TreeHeistUtil.findExitPosition(this.level(), targetPos);
            ItemStack acornStack = new ItemStack((ItemLike)ModItems.ACORN.get());
            ItemEntity acornEntity = new ItemEntity(this.level(), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.7, (double)blockPos.getZ() + 0.5, acornStack);
            double velX = (this.random.nextDouble() - 0.5) * 0.7;
            double velY = 0.0;
            double velZ = (this.random.nextDouble() - 0.5) * 0.7;
            acornEntity.setDeltaMovement(velX, velY, velZ);
            SoundEvent acornPopSound = ModSounds.getDynamicItemSound(acornStack);
            this.level().playSound(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, acornPopSound, SoundSource.NEUTRAL, 0.5f, 1.8f);
            this.level().playSound(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, (SoundEvent)ModSounds.HAMSTER_DING.get(), SoundSource.NEUTRAL, 0.7f, 1.0f + (this.random.nextFloat() - 0.5f) * 0.2f);
            this.level().addFreshEntity((Entity)acornEntity);
            this.dropCooldown = 20;
        }
    }

    private boolean isLeafExposed(Level world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!world.isEmptyBlock(pos.relative(dir))) continue;
            return true;
        }
        return false;
    }

    private void popOut(boolean success) {
        if (this.level().isClientSide) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)this.level();
        this.unregisterHeist();
        BlockPos startPoint = this.blockPosition();
        BlockPos exitPos = TreeHeistUtil.findExitPosition(this.level(), startPoint);
        HamsterEntity newHamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).create((Level)serverWorld);
        if (newHamster != null) {
            SoundEvent celebrateSound;
            newHamster.load(this.hamsterNbt);
            newHamster.setFallFlyImmunityTicks(0);
            newHamster.moveTo((double)exitPos.getX() + 0.5, (double)exitPos.getY() + 0.1, (double)exitPos.getZ() + 0.5, this.random.nextFloat() * 360.0f, 0.0f);
            newHamster.setDeltaMovement(Vec3.ZERO);
            newHamster.setThrown(false);
            newHamster.setKnockedOut(false);
            newHamster.setOrderedToSit(false);
            newHamster.hasImpulse = true;
            if (success && !this.isExhausted) {
                ItemStack prize = new ItemStack((ItemLike)ModItems.ACORN.get());
                newHamster.setInterestItemStack(prize);
                newHamster.setHoldingInterestItem(true);
                newHamster.setItemInterestTimer(1200);
                SoundEvent sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.random);
                if (sparkleSound != null) {
                    serverWorld.playSound(null, newHamster.blockPosition(), sparkleSound, SoundSource.NEUTRAL, 0.5f, 1.0f);
                }
                newHamster.scheduleTreeHeistCelebration();
            } else {
                UUID ownerUuid;
                Player owner;
                newHamster.setSulking(true);
                newHamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
                if (this.isExhausted && this.hamsterNbt.hasUUID("Owner") && (owner = serverWorld.getPlayerByUUID(ownerUuid = this.hamsterNbt.getUUID("Owner"))) != null) {
                    owner.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.tree_heist_exhausted").withStyle(ChatFormatting.RED), true);
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)owner;
                        ((TreeHeistDepletionCriterion)((Object)ModCriteria.TREE_HEIST_DEPLETION.get())).trigger(serverPlayer);
                    }
                }
            }
            serverWorld.addFreshEntityWithPassengers((Entity)newHamster);
            newHamster.triggerLeafPopEffects(startPoint, true);
            if (success && !this.isExhausted && (celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.random)) != null) {
                serverWorld.playSound(null, newHamster.blockPosition(), celebrateSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        this.discard();
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put("HamsterNBT", (Tag)this.hamsterNbt);
        nbt.putInt("SearchTimer", this.searchTimer);
        nbt.putInt("MaxSearchDuration", this.maxSearchDuration);
        nbt.putInt("RummageTimer", this.rummageTimer);
        if (this.treeAnchor != null) {
            nbt.putLong("TreeAnchor", this.treeAnchor.asLong());
        }
        nbt.putBoolean("IsExhausted", this.isExhausted);
        nbt.putFloat("DropMultiplier", this.dropChanceMultiplier);
        nbt.putBoolean("HasAcornHat", this.hasAcornHat);
        nbt.putInt("DropCooldown", this.dropCooldown);
        ListTag posList = new ListTag();
        for (Long pos : this.validLeafPositions) {
            posList.add((Object)LongTag.valueOf((long)pos));
        }
        nbt.put("ValidLeafPositions", (Tag)posList);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.hamsterNbt = nbt.getCompound("HamsterNBT");
        this.searchTimer = nbt.getInt("SearchTimer");
        this.maxSearchDuration = nbt.getInt("MaxSearchDuration");
        this.rummageTimer = nbt.getInt("RummageTimer");
        if (nbt.contains("TreeAnchor")) {
            this.treeAnchor = BlockPos.of((long)nbt.getLong("TreeAnchor"));
        }
        this.isExhausted = nbt.getBoolean("IsExhausted");
        this.dropChanceMultiplier = nbt.getFloat("DropMultiplier");
        this.hasAcornHat = nbt.getBoolean("HasAcornHat");
        this.dropCooldown = nbt.getInt("DropCooldown");
        this.validLeafPositions.clear();
        if (nbt.contains("ValidLeafPositions", 9)) {
            ListTag list = nbt.getList("ValidLeafPositions", 4);
            for (Tag element : list) {
                if (!(element instanceof LongTag)) continue;
                LongTag nbtLong = (LongTag)element;
                this.validLeafPositions.add(nbtLong.getAsLong());
            }
        }
        this.validationTimer = 20;
    }
}

