/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.fabric.datagen;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Optional;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.CucumberCropBlock;
import net.dawson.adorablehamsterpets.block.custom.GreenBeansCropBlock;
import net.dawson.adorablehamsterpets.block.custom.WildCucumberBushBlock;
import net.dawson.adorablehamsterpets.block.custom.WildGreenBeanBushBlock;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ModModelProvider
extends FabricModelProvider {
    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    private void generateHamsterBedVariantModels(BlockModelGenerators generator) {
        List<String> woodTypes = List.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "pale_oak");
        ResourceLocation baseModelId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"block/hamster_bed");
        for (String wood : woodTypes) {
            ResourceLocation variantModelId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("block/hamster_bed_" + wood));
            ResourceLocation particleTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("block/hamster_bed_" + wood));
            TextureMapping textureMap = new TextureMapping().put(TextureSlot.PARTICLE, particleTexture);
            ModelTemplate variantModel = new ModelTemplate(Optional.of(baseModelId), Optional.empty(), new TextureSlot[]{TextureSlot.PARTICLE});
            variantModel.create(variantModelId, textureMap, generator.modelOutput);
        }
    }

    public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        this.generateHamsterBedVariantModels(blockStateModelGenerator);
        blockStateModelGenerator.createCropBlock((Block)ModBlocks.GREEN_BEANS_CROP.get(), (Property)GreenBeansCropBlock.AGE, new int[]{0, 1, 2, 3});
        blockStateModelGenerator.createCropBlock((Block)ModBlocks.CUCUMBER_CROP.get(), (Property)CucumberCropBlock.AGE, new int[]{0, 1, 2, 3});
        ResourceLocation wildGreenBeanSeededTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"block/wild_green_bean_bush_seeded");
        ResourceLocation wildGreenBeanSeedlessTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"block/wild_green_bean_bush_seedless");
        ResourceLocation wildCucumberSeededTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"block/wild_cucumber_bush_seeded");
        ResourceLocation wildCucumberSeedlessTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"block/wild_cucumber_bush_seedless");
        TextureMapping greenBeanSeededMap = TextureMapping.cross((ResourceLocation)wildGreenBeanSeededTexture);
        TextureMapping greenBeanSeedlessMap = TextureMapping.cross((ResourceLocation)wildGreenBeanSeedlessTexture);
        TextureMapping cucumberSeededMap = TextureMapping.cross((ResourceLocation)wildCucumberSeededTexture);
        TextureMapping cucumberSeedlessMap = TextureMapping.cross((ResourceLocation)wildCucumberSeedlessTexture);
        ResourceLocation greenBeanSeededModelId = ModelTemplates.CROSS.createWithSuffix((Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), "_seeded", greenBeanSeededMap, blockStateModelGenerator.modelOutput);
        ResourceLocation greenBeanSeedlessModelId = ModelTemplates.CROSS.createWithSuffix((Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), "_seedless", greenBeanSeedlessMap, blockStateModelGenerator.modelOutput);
        ResourceLocation cucumberSeededModelId = ModelTemplates.CROSS.createWithSuffix((Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), "_seeded", cucumberSeededMap, blockStateModelGenerator.modelOutput);
        ResourceLocation cucumberSeedlessModelId = ModelTemplates.CROSS.createWithSuffix((Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), "_seedless", cucumberSeedlessMap, blockStateModelGenerator.modelOutput);
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)WildGreenBeanBushBlock.SEEDED, (ResourceLocation)greenBeanSeededModelId, (ResourceLocation)greenBeanSeedlessModelId)));
        blockStateModelGenerator.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)ModBlocks.WILD_CUCUMBER_BUSH.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)WildCucumberBushBlock.SEEDED, (ResourceLocation)cucumberSeededModelId, (ResourceLocation)cucumberSeedlessModelId)));
    }

    public void generateItemModels(ItemModelGenerators itemModelGenerator) {
        itemModelGenerator.generateFlatItem((Item)ModItems.ANNOUNCEMENT_BELL_ICON.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_SPAWN_EGG.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.CUCUMBER.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.SLICED_CUCUMBER.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.GREEN_BEANS.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.STEAMED_GREEN_BEANS.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.CHEESE.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_FOOD_MIX.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.SUNFLOWER_SEEDS.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem(((Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get()).asItem(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem(((Block)ModBlocks.WILD_CUCUMBER_BUSH.get()).asItem(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_BEDDING.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.ACORN.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.ACORN_SHARD.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.ACORN_HAT.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_ACORN.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_IRON.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_GOLD.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_DIAMOND.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_NETHERITE.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_IRON.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_GOLD.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_DIAMOND.get(), ModelTemplates.FLAT_ITEM);
        itemModelGenerator.generateFlatItem((Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_NETHERITE.get(), ModelTemplates.FLAT_ITEM);
        for (RegistrySupplier<Item> bedItemSupplier : ModItems.HAMSTER_BED_ITEMS.values()) {
            itemModelGenerator.generateFlatItem((Item)bedItemSupplier.get(), new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"item/hamster_bed")), Optional.empty(), new TextureSlot[0]));
        }
    }
}

