/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.fabric.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends FabricRecipeProvider {
    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    private void offerHamsterBedRecipe(RecipeOutput exporter, Item planks, WoodVariant variant) {
        Item resultItem = (Item)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)resultItem).pattern(" H ").pattern("HHH").pattern("PPP").define(Character.valueOf('H'), (ItemLike)ModItems.HAMSTER_BEDDING.get()).define(Character.valueOf('P'), (ItemLike)planks).group("hamster_bed").unlockedBy("has_hamster_bedding", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.HAMSTER_BEDDING.get()))).save(exporter, ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("hamster_bed_" + variant.getSerializedName())));
    }

    private void offerHamsterArmorUpgrade(RecipeOutput exporter, Item template, Item material, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{template}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_ARMOR_ACORN.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.COMBAT, (Item)result).unlocks("has_acorn_armor", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_ACORN.get()))).unlocks("has_material", ModRecipeProvider.conditionsFromItem((ItemLike)material)).save(exporter, ModRecipeProvider.getItemPath((ItemLike)result) + "_smithing");
    }

    public void generate(RecipeOutput recipeExporter) {
        ModRecipeProvider.offerSmelting((RecipeOutput)recipeExporter, List.of((ItemLike)ModItems.GREEN_BEANS.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.STEAMED_GREEN_BEANS.get()), (float)0.35f, (int)200, (String)"steamed_green_beans");
        this.offerHamsterBedRecipe(recipeExporter, Items.OAK_PLANKS, WoodVariant.OAK);
        this.offerHamsterBedRecipe(recipeExporter, Items.SPRUCE_PLANKS, WoodVariant.SPRUCE);
        this.offerHamsterBedRecipe(recipeExporter, Items.BIRCH_PLANKS, WoodVariant.BIRCH);
        this.offerHamsterBedRecipe(recipeExporter, Items.JUNGLE_PLANKS, WoodVariant.JUNGLE);
        this.offerHamsterBedRecipe(recipeExporter, Items.ACACIA_PLANKS, WoodVariant.ACACIA);
        this.offerHamsterBedRecipe(recipeExporter, Items.DARK_OAK_PLANKS, WoodVariant.DARK_OAK);
        this.offerHamsterBedRecipe(recipeExporter, Items.MANGROVE_PLANKS, WoodVariant.MANGROVE);
        this.offerHamsterBedRecipe(recipeExporter, Items.CHERRY_PLANKS, WoodVariant.CHERRY);
        this.offerHamsterBedRecipe(recipeExporter, Items.BAMBOO_PLANKS, WoodVariant.BAMBOO);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HAMSTER_FOOD_MIX.get()), (int)1).pattern("SSS").pattern("PCP").pattern("WWW").define(Character.valueOf('S'), (ItemLike)ModItems.SUNFLOWER_SEEDS.get()).define(Character.valueOf('P'), (ItemLike)Items.PUMPKIN_SEEDS).define(Character.valueOf('C'), (ItemLike)Items.CARROT).define(Character.valueOf('W'), (ItemLike)Items.WHEAT_SEEDS).unlockedBy("has_sunflower_seeds", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.SUNFLOWER_SEEDS.get()))).save(recipeExporter, ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_food_mix_from_ingredients"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HAMSTER_BEDDING.get()), (int)2).requires((ItemLike)Items.OAK_LEAVES).requires((ItemLike)Items.BIRCH_LEAVES).requires((ItemLike)Items.DEAD_BUSH).requires((ItemLike)Items.PODZOL).unlockedBy("has_oak_leaves", ModRecipeProvider.conditionsFromItem((ItemLike)Items.OAK_LEAVES)).unlockedBy("has_birch_leaves", ModRecipeProvider.conditionsFromItem((ItemLike)Items.BIRCH_LEAVES)).unlockedBy("has_dead_bush", ModRecipeProvider.conditionsFromItem((ItemLike)Items.DEAD_BUSH)).unlockedBy("has_podzol", ModRecipeProvider.conditionsFromItem((ItemLike)Items.PODZOL)).save(recipeExporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SLICED_CUCUMBER.get()), (int)3).requires((ItemLike)ModItems.CUCUMBER.get()).unlockedBy("has_cucumber", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.CUCUMBER.get()))).save(recipeExporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHEESE.get()), (int)3).requires((ItemLike)Items.MILK_BUCKET).unlockedBy("has_milk_bucket", ModRecipeProvider.conditionsFromItem((ItemLike)Items.MILK_BUCKET)).save(recipeExporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.SUNFLOWER, (int)1).requires((ItemLike)ModBlocks.SUNFLOWER_BLOCK.get()).unlockedBy("has_modded_sunflower", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModBlocks.SUNFLOWER_BLOCK.get()))).save(recipeExporter, ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"vanilla_sunflower_from_modded"));
        ModRecipeProvider.offerStonecuttingRecipe((RecipeOutput)recipeExporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ACORN_SHARD.get()), (ItemLike)((ItemLike)ModItems.ACORN.get()), (int)2);
        ModRecipeProvider.offerStonecuttingRecipe((RecipeOutput)recipeExporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ACORN_HAT.get()), (ItemLike)((ItemLike)ModItems.ACORN.get()), (int)1);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_ACORN.get()), (int)1).pattern(" H ").pattern("SSS").pattern("SSS").define(Character.valueOf('H'), (ItemLike)ModItems.ACORN_HAT.get()).define(Character.valueOf('S'), (ItemLike)ModItems.ACORN_SHARD.get()).unlockedBy("has_acorn_hat", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.ACORN_HAT.get()))).unlockedBy("has_acorn_shard", ModRecipeProvider.conditionsFromItem((ItemLike)((ItemLike)ModItems.ACORN_SHARD.get()))).save(recipeExporter);
        this.offerHamsterArmorUpgrade(recipeExporter, (Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_IRON.get(), Items.IRON_INGOT, (Item)ModItems.HAMSTER_ARMOR_IRON.get());
        this.offerHamsterArmorUpgrade(recipeExporter, (Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_GOLD.get(), Items.GOLD_INGOT, (Item)ModItems.HAMSTER_ARMOR_GOLD.get());
        this.offerHamsterArmorUpgrade(recipeExporter, (Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_DIAMOND.get(), Items.DIAMOND, (Item)ModItems.HAMSTER_ARMOR_DIAMOND.get());
        this.offerHamsterArmorUpgrade(recipeExporter, (Item)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_NETHERITE.get(), Items.NETHERITE_INGOT, (Item)ModItems.HAMSTER_ARMOR_NETHERITE.get());
    }
}

