/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import java.util.Optional;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum HamsterBedComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag serverData = accessor.getServerData();
        RegistryAccess registryLookup = accessor.getLevel().registryAccess();
        Player player = accessor.getPlayer();
        if (serverData.contains("LinkedHamsterName")) {
            boolean isWanderActive;
            MutableComponent hamsterName = Component.Serializer.fromJson((String)serverData.getString("LinkedHamsterName"), (HolderLookup.Provider)registryLookup);
            if (hamsterName != null) {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).withStyle(ChatFormatting.GREEN));
            }
            MutableComponent wanderStatus = (isWanderActive = serverData.getBoolean("WanderModeActive")) ? Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_status.active").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_status.inactive").withStyle(ChatFormatting.RED);
            WanderDistance distance = WanderDistance.valueOf(serverData.getString("WanderDistance").toUpperCase());
            int radius = switch (distance) {
                case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
            };
            tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_status", (Object[])new Object[]{wanderStatus, Component.translatable((String)distance.translationKey()), radius}));
            if (player.isShiftKeyDown()) {
                MutableComponent hintText;
                MutableComponent statusText;
                boolean allowSleep = serverData.getBoolean("AllowSleepInBed");
                MutableComponent sleepStatus = allowSleep ? Component.translatable((String)"tooltip.adorablehamsterpets.jade.sleep_status.allowed").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"tooltip.adorablehamsterpets.jade.sleep_status.prevented").withStyle(ChatFormatting.RED);
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.sleep_status.label", (Object[])new Object[]{sleepStatus}));
                boolean isConfigRespawnEnabled = serverData.getBoolean("ConfigRespawnEnabled");
                boolean isRespawnEnabled = serverData.getBoolean("RespawnEnabled");
                if (!isConfigRespawnEnabled) {
                    statusText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.disabled_config");
                    hintText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.disabled_config");
                } else if (isRespawnEnabled) {
                    statusText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.active");
                    hintText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.active");
                } else {
                    statusText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.inactive");
                    Component tributeName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.resurrectionTributes);
                    hintText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.inactive", (Object[])new Object[]{tributeName.copy().withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})});
                }
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.label", (Object[])new Object[]{statusText}));
                tooltip.add((Component)hintText);
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_controls1").withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_controls2").withStyle(ChatFormatting.GRAY));
                MutableComponent lureName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.lureItems).copy().withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
                MutableComponent repellentName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.bedAvoidanceFoods).copy().withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.lure_hint", (Object[])new Object[]{lureName}).withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.repellent_hint", (Object[])new Object[]{repellentName}).withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.unlink_hint", (Object[])new Object[]{repellentName}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.sneak_for_info").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.unlinked").withStyle(ChatFormatting.GOLD));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            Player player = accessor.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ServerLevel serverWorld = player2.serverLevel();
                Optional<Component> liveName = bedEntity.getLinkedHamsterUuid().map(arg_0 -> ((ServerLevel)serverWorld).getEntity(arg_0)).filter(e -> e instanceof HamsterEntity).map(entity -> {
                    HamsterEntity hamster = (HamsterEntity)entity;
                    if (hamster.hasCustomName()) {
                        return hamster.getName();
                    }
                    return hamster.getDisplayName().copy().append(" " + hamster.getId());
                });
                Component nameToShow = liveName.or(bedEntity::getLinkedHamsterName).orElse(null);
                if (nameToShow != null) {
                    data.putString("LinkedHamsterName", Component.Serializer.toJson((Component)nameToShow, (HolderLookup.Provider)player2.registryAccess()));
                }
            }
            data.putBoolean("WanderModeActive", bedEntity.isWanderModeActive());
            data.putString("WanderDistance", bedEntity.getWanderDistance().getSerializedName());
            data.putBoolean("AllowSleepInBed", bedEntity.isSleepingAllowed());
            data.putBoolean("RespawnEnabled", bedEntity.isRespawnEnabled());
            data.putBoolean("ConfigRespawnEnabled", ((Boolean)Configs.AHP.enableRespawnInBed.get()).booleanValue());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_bed_info");
    }
}

