/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CheeseItem
extends Item {
    public CheeseItem(Item.Properties settings) {
        super(settings);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).copy().withStyle(ChatFormatting.GOLD);
    }

    public DataComponentMap components() {
        FoodProperties dynamicFoodComponent = new FoodProperties.Builder().nutrition(((Integer)Configs.AHP.cheeseNutrition.get()).intValue()).saturationModifier(((Float)Configs.AHP.cheeseSaturation.get()).floatValue()).build();
        DataComponentMap override = DataComponentMap.builder().set(DataComponents.FOOD, (Object)dynamicFoodComponent).build();
        return DataComponentMap.composite((DataComponentMap)super.components(), (DataComponentMap)override);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (Configs.AHP.enableItemTooltips) {
            tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.cheese.hint1").withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.cheese.hint2").withStyle(ChatFormatting.GRAY));
            boolean appleSkinLoaded = Platform.isModLoaded((String)"appleskin");
            if (!appleSkinLoaded) {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.cheese.hint3", (Object[])new Object[]{Configs.AHP.cheeseNutrition.get(), String.format("%.1f", Float.valueOf(((Float)Configs.AHP.cheeseSaturation.get()).floatValue() * (float)((Integer)Configs.AHP.cheeseNutrition.get()).intValue() * 2.0f))}).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else if (!Platform.isModLoaded((String)"emi")) {
            tooltip.add((Component)Component.literal((String)"Adorable Hamster Pets").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)ModSounds.CHEESE_EAT1.get();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 20;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        block6: {
            block5: {
                Player player;
                if (user instanceof Player) {
                    player = (Player)user;
                    int nutrition = (Integer)Configs.AHP.cheeseNutrition.get();
                    float saturation = ((Float)Configs.AHP.cheeseSaturation.get()).floatValue();
                    player.getFoodData().eat(nutrition, saturation);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    SoundEvent randomEatSound = ModSounds.getRandomSoundFrom(ModSounds.CHEESE_EAT_SOUNDS, world.random);
                    if (randomEatSound != null) {
                        world.playSound(null, player.getX(), player.getY(), player.getZ(), randomEatSound, player.getSoundSource(), 1.2f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
                    }
                }
                if (!(user instanceof Player)) break block5;
                player = (Player)user;
                if (player.getAbilities().instabuild) break block6;
            }
            stack.shrink(1);
        }
        return stack;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide) {
            return;
        }
        FoodProperties currentFoodComponent = (FoodProperties)stack.get(DataComponents.FOOD);
        int expectedNutrition = (Integer)Configs.AHP.cheeseNutrition.get();
        float expectedSaturation = ((Float)Configs.AHP.cheeseSaturation.get()).floatValue();
        if (currentFoodComponent != null && (currentFoodComponent.nutrition() != expectedNutrition || currentFoodComponent.saturation() != expectedSaturation)) {
            FoodProperties updatedFoodComponent = new FoodProperties.Builder().nutrition(expectedNutrition).saturationModifier(expectedSaturation).build();
            stack.set(DataComponents.FOOD, (Object)updatedFoodComponent);
        }
    }
}

