/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class HamsterArmorItem
extends Item {
    private final HamsterArmorMaterial material;
    private final ResourceLocation entityTexture;

    public HamsterArmorItem(HamsterArmorMaterial material, Item.Properties settings) {
        super(settings.durability(material.getDurability()));
        this.material = material;
        Object fileName = material == HamsterArmorMaterial.ACORN ? "acorn_armor_base" : "acorn_armor_" + material.getName();
        this.entityTexture = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("textures/entity/hamster/armor/" + (String)fileName + ".png"));
    }

    public HamsterArmorMaterial getMaterial() {
        return this.material;
    }

    public ResourceLocation getEntityTexture() {
        return this.entityTexture;
    }

    public int getEnchantmentValue() {
        return this.material.getEnchantability();
    }

    public static enum HamsterArmorMaterial {
        ACORN("acorn", 120, 15),
        IRON("iron", 350, 9),
        GOLD("gold", 100, 25),
        DIAMOND("diamond", 900, 10),
        NETHERITE("netherite", 1800, 15);

        private final String name;
        private final int durability;
        private final int enchantability;

        private HamsterArmorMaterial(String name, int durability, int enchantability) {
            this.name = name;
            this.durability = durability;
            this.enchantability = enchantability;
        }

        public String getName() {
            return this.name;
        }

        public int getDurability() {
            return this.durability;
        }

        public int getEnchantability() {
            return this.enchantability;
        }
    }
}

