/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.dawson.adorablehamsterpets.block.client.HamsterBedItemRenderer;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WoodVariant variant;

    public HamsterBedItem(Block block, WoodVariant variant, Item.Properties settings) {
        super(block, settings);
        this.variant = variant;
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level world, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!world.isClientSide) {
            BlockEntity be;
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.getRandom());
            if (rustleSound != null) {
                world.playSound(null, pos, rustleSound, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
            if ((be = world.getBlockEntity(pos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
                WoodVariant variant = (WoodVariant)((Object)stack.getOrDefault((DataComponentType)ModDataComponentTypes.WOOD_VARIANT.get(), (Object)this.variant));
                ParticleEffectsUtil.spawnParticles(world, pos, 0.3, ModParticles.getForVariant(variant), 30, 0.1, 0.2, 0.1, 0.0);
            }
        }
        return world.setBlock(pos, (BlockState)state.setValue(HamsterBedBlock.WOOD_VARIANT, (Comparable)((Object)this.variant)), 11);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        WoodVariant stackVariant = (WoodVariant)((Object)stack.getOrDefault((DataComponentType)ModDataComponentTypes.WOOD_VARIANT.get(), (Object)this.variant));
        if (Configs.AHP.enableItemTooltips) {
            if (Screen.hasShiftDown()) {
                MutableComponent hintText;
                MutableComponent statusText;
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.description1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.description2").withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_controls1").withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.wander_controls2").withStyle(ChatFormatting.GRAY));
                MutableComponent lureName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.lureItems).copy().withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
                MutableComponent repellentName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.bedAvoidanceFoods).copy().withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.lure_hint", (Object[])new Object[]{lureName}).withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.repellent_hint", (Object[])new Object[]{repellentName}).withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.jade.unlink_hint", (Object[])new Object[]{repellentName}).withStyle(ChatFormatting.GRAY));
                boolean configEnabled = (Boolean)Configs.AHP.enableRespawnInBed.get();
                if (!configEnabled) {
                    statusText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.disabled_config");
                    hintText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.disabled_config");
                } else {
                    statusText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.inactive");
                    Component tributeName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.resurrectionTributes);
                    hintText = Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.inactive", (Object[])new Object[]{tributeName.copy().withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})});
                }
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.label", (Object[])new Object[]{statusText}));
                tooltip.add((Component)hintText);
                UUID hamsterUuid = (UUID)stack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
                Component hamsterName = (Component)stack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get());
                WanderDistance wanderDistance = (WanderDistance)((Object)stack.get((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get()));
                if (hamsterUuid != null && hamsterName != null) {
                    tooltip.add((Component)Component.literal((String)""));
                    tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).withStyle(ChatFormatting.GREEN));
                    if (wanderDistance != null) {
                        int radius = switch (wanderDistance) {
                            case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                            case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                            default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
                        };
                        tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.wander_distance", (Object[])new Object[]{Component.translatable((String)wanderDistance.translationKey()), radius}).withStyle(ChatFormatting.AQUA));
                    }
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bed.description1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.shift_for_info").withStyle(ChatFormatting.DARK_GRAY));
            }
        } else if (!Platform.isModLoaded((String)"emi")) {
            tooltip.add((Component)Component.literal((String)"Adorable Hamster Pets").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide) {
            return;
        }
        UUID linkedUuid = (UUID)stack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
        if (linkedUuid != null && entity instanceof Player) {
            world.getEntitiesOfClass(HamsterEntity.class, entity.getBoundingBox().inflate(16.0), e -> e.getUUID().equals(linkedUuid)).stream().findFirst().ifPresent(hamster -> {
                Object newName = hamster.hasCustomName() ? hamster.getName() : hamster.getDisplayName().copy().append(" " + hamster.getId());
                Component currentNameOnStack = (Component)stack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get());
                if (currentNameOnStack == null || !currentNameOnStack.equals(newName)) {
                    stack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get(), newName);
                }
            });
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private HamsterBedItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HamsterBedItemRenderer();
                }
                return this.renderer;
            }
        });
    }
}

