/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.advancement.criterion.UsedHamsterBeddingCriterion;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HamsterBeddingItem
extends Item {
    public HamsterBeddingItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (world.isClientSide) {
            Vec3 particlePos;
            BlockHitResult hitResult = HamsterBeddingItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                BlockPos adjacentPos = hitResult.getBlockPos().relative(hitResult.getDirection());
                particlePos = Vec3.atCenterOf((Vec3i)adjacentPos);
            } else {
                particlePos = user.getEyePosition().add(user.getViewVector(1.0f).scale(1.5));
            }
            for (int i = 0; i < 100; ++i) {
                double offsetX = world.random.nextGaussian() * 1.2;
                double offsetY = world.random.nextGaussian() * 1.2;
                double offsetZ = world.random.nextGaussian() * 1.2;
                world.addParticle((ParticleOptions)ModParticles.getForVariant(WoodVariant.OAK), particlePos.x + offsetX, particlePos.y + offsetY, particlePos.z + offsetZ, 0.0, -1.23E-4, 0.0);
            }
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.random);
            if (rustleSound != null) {
                world.playSound(user, user.blockPosition(), rustleSound, SoundSource.PLAYERS, 0.2f, 1.5f);
            }
        }
        if (!world.isClientSide && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ((UsedHamsterBeddingCriterion)((Object)ModCriteria.USED_HAMSTER_BEDDING.get())).trigger(serverPlayer);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (Configs.AHP.enableItemTooltips) {
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bedding.hint1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bedding.hint2").withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bedding.hint3").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.hamster_bedding.hint1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.adorablehamsterpets.shift_for_info").withStyle(ChatFormatting.DARK_GRAY));
            }
        } else if (!Platform.isModLoaded((String)"emi")) {
            tooltip.add((Component)Component.literal((String)"Adorable Hamster Pets").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

