/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterCreeperAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterDiamondAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterThrownCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.advancement.criterion.WitnessGlowingSunflowerCriterion;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.SunflowerBlock;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSniffForOreGoal;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.SyncShoulderDataPayload;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final int AHP_GUIDEBOOK_CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final long HEIST_MEMORY_DURATION = 24000L;
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_HAS_KEY = "AHPHasGuideBook";
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_INIT_KEY = "AHPGuideBookTrackingInit";
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private CompoundTag ahp$shoulderData = new CompoundTag();
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private int ahp$guideBookCheckTimer = 0;
    @Unique
    private int ahp$sunflowerCheckTimer = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private boolean ahp$cachedHasGuideBook = false;
    @Unique
    private boolean ahp$guideBookTrackingInitialized = false;
    @Unique
    private final List<ScheduledTask> adorablehamsterpets$scheduledTasks = new ArrayList<ScheduledTask>();
    @Unique
    private final List<TreeHeistUtil.HeistRecord> ahp$heistHistory = new ArrayList<TreeHeistUtil.HeistRecord>();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.isClientSide) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        if (!this.ahp$shoulderData.isEmpty()) {
            nbt.put("ShoulderHamsters", (Tag)this.ahp$shoulderData);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            ListTag mountOrderList = new ListTag();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)StringTag.valueOf((String)location.name()));
            }
            nbt.put("MountOrderQueue", (Tag)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.putInt("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
        if (!this.ahp$heistHistory.isEmpty()) {
            ListTag historyList = new ListTag();
            long currentTime = this.level().getGameTime();
            for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
                if (currentTime - record.timestamp() >= 24000L) continue;
                CompoundTag tag = new CompoundTag();
                tag.putLong("x", (long)record.pos().getX());
                tag.putLong("y", (long)record.pos().getY());
                tag.putLong("z", (long)record.pos().getZ());
                tag.putLong("t", record.timestamp());
                historyList.add((Object)tag);
            }
            if (!historyList.isEmpty()) {
                nbt.put("AHPHeistHistory", (Tag)historyList);
            }
        }
        nbt.putBoolean(AHP_NBT_GUIDEBOOK_HAS_KEY, this.ahp$cachedHasGuideBook);
        nbt.putBoolean(AHP_NBT_GUIDEBOOK_INIT_KEY, this.ahp$guideBookTrackingInitialized);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("ShoulderHamster", 10)) {
            CompoundTag oldHamsterNbt = nbt.getCompound("ShoulderHamster");
            if (!oldHamsterNbt.isEmpty()) {
                CompoundTag newShoulderPetsNbt = new CompoundTag();
                newShoulderPetsNbt.put(ShoulderLocation.RIGHT_SHOULDER.name(), (Tag)oldHamsterNbt);
                this.ahp$shoulderData = newShoulderPetsNbt;
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.remove("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.getDisplayName().getString());
            }
        } else if (nbt.contains("ShoulderHamsters", 10)) {
            this.ahp$shoulderData = nbt.getCompound("ShoulderHamsters");
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.contains("MountOrderQueue", 9)) {
            ShoulderLocation[] mountOrderList = nbt.getList("MountOrderQueue", 8);
            HashSet<ShoulderLocation> seenLocations = new HashSet<ShoulderLocation>();
            for (Tag tag : mountOrderList) {
                try {
                    ShoulderLocation location = ShoulderLocation.valueOf(tag.getAsString());
                    if (seenLocations.contains((Object)location) || this.getShoulderHamster(location).isEmpty()) continue;
                    this.adorablehamsterpets$mountOrderQueue.add(location);
                    seenLocations.add(location);
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)tag.getAsString());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but empty mount queue. Rebuilding...", (Object)this.getDisplayName().getString());
            for (ShoulderLocation shoulderLocation : ShoulderLocation.values()) {
                if (this.getShoulderHamster(shoulderLocation).isEmpty()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(shoulderLocation);
            }
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.contains("LastGoldMessageIndex", 3) ? nbt.getInt("LastGoldMessageIndex") : -1;
        this.ahp$heistHistory.clear();
        if (nbt.contains("AHPHeistHistory", 9)) {
            ListTag historyList = nbt.getList("AHPHeistHistory", 10);
            for (int i = 0; i < historyList.size(); ++i) {
                CompoundTag tag = historyList.getCompound(i);
                BlockPos blockPos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
                long time = tag.getLong("t");
                this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(blockPos, time));
            }
        }
        if (nbt.contains(AHP_NBT_GUIDEBOOK_HAS_KEY, 1)) {
            this.ahp$cachedHasGuideBook = nbt.getBoolean(AHP_NBT_GUIDEBOOK_HAS_KEY);
        }
        if (nbt.contains(AHP_NBT_GUIDEBOOK_INIT_KEY, 1)) {
            this.ahp$guideBookTrackingInitialized = nbt.getBoolean(AHP_NBT_GUIDEBOOK_INIT_KEY);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        Player self = (Player)this;
        Level world = self.level();
        if (world.isClientSide) {
            return;
        }
        RandomSource random = world.getRandom();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        long currentTime = world.getGameTime();
        this.adorablehamsterpets$scheduledTasks.removeIf(task -> {
            if (currentTime >= task.executionTick()) {
                task.action().run();
                return true;
            }
            return false;
        });
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        this.tickGuideBookTracking();
        if (++this.ahp$sunflowerCheckTimer >= 20) {
            this.ahp$sunflowerCheckTimer = 0;
            if (Configs.AHP_WORLDGEN.enableGlowingSunflowers && !world.isDay()) {
                BlockPos playerPos = self.blockPosition();
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-5, -3, -5), (BlockPos)playerPos.offset(5, 3, 5))) {
                    BlockState state = world.getBlockState(pos);
                    if (!state.is((Block)ModBlocks.SUNFLOWER_BLOCK.get()) || !((Boolean)state.getValue((Property)SunflowerBlock.LIT)).booleanValue()) continue;
                    ((WitnessGlowingSunflowerCriterion)((Object)ModCriteria.WITNESS_GLOWING_SUNFLOWER.get())).trigger((ServerPlayer)self);
                    break;
                }
            }
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isCelebrationOreNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.playSound(null, self.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), SoundSource.NEUTRAL, 2.5f, 1.0f);
                            self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.diamond_nearby").withStyle(ChatFormatting.AQUA), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.nextIntBetweenInclusive(140, 200);
                            ((HamsterDiamondAlertCriterion)((Object)ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.get())).trigger((ServerPlayer)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.playSound(null, self.blockPosition(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.creeper_detected").withStyle(ChatFormatting.RED), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.nextIntBetweenInclusive(100, 160);
                        ((HamsterCreeperAlertCriterion)((Object)ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.get())).trigger((ServerPlayer)self);
                    }
                }
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.level().isClientSide()) {
            HamsterRenderTracker.onPlayerDisconnect(this.getUUID());
        }
    }

    @Inject(method={"stopSleepInBed(ZZ)V"}, at={@At(value="RETURN")})
    private void adorablehamsterpets$onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        Player self = (Player)this;
        if (!self.level().isClientSide && !skipSleepTimer) {
            ServerLevel serverWorld = (ServerLevel)self.level();
            UUID ownerUuid = self.getUUID();
            ArrayList<HamsterEntity> stuckHamsters = new ArrayList<HamsterEntity>();
            for (Entity entity : serverWorld.getEntities((EntityTypeTest)ModEntities.HAMSTER.get(), Entity::isAlive)) {
                HamsterEntity hamster;
                if (!(entity instanceof HamsterEntity) || !(hamster = (HamsterEntity)entity).isTame() || !ownerUuid.equals(hamster.getOwnerUUID()) || !hamster.isStuckSearchingForBed()) continue;
                stuckHamsters.add(hamster);
            }
            for (HamsterEntity hamster : stuckHamsters) {
                hamster.getLinkedBedPos().ifPresent(globalPos -> {
                    if (serverWorld.dimension() == globalPos.dimension()) {
                        BlockPos bedPos = globalPos.pos();
                        BlockState bedState = serverWorld.getBlockState(bedPos);
                        if (bedState.getBlock() instanceof HamsterBedBlock && !((Boolean)bedState.getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                            Vec3 targetCenter = Vec3.atCenterOf((Vec3i)bedPos).add(0.0, 0.1, 0.0);
                            hamster.moveTo(targetCenter.x, targetCenter.y, targetCenter.z, 0.0f, 0.0f);
                            hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                            hamster.setSleeping(true);
                            hamster.setRescueSleeping(true);
                            hamster.setInSittingPose(true);
                            serverWorld.setBlock(bedPos, (BlockState)bedState.setValue((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                            int personality = (Integer)hamster.getEntityData().get(HamsterEntity.ANIMATION_PERSONALITY_ID);
                            int poseIndex = personality >= 1 && personality <= 3 ? personality : 1;
                            hamster.getEntityData().set(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)("anim_hamster_sleep_pose" + poseIndex));
                            hamster.startNapTimer();
                            hamster.setStuckSearchingForBed(false);
                            hamster.setWanderModeActive(true);
                            AdorableHamsterPets.LOGGER.info("Rescued stuck hamster {} to bed at {}", (Object)hamster.getId(), (Object)bedPos);
                        } else {
                            hamster.setStuckSearchingForBed(false);
                        }
                    }
                });
            }
        }
    }

    @Override
    @Unique
    public boolean ahp$computeHasGuideBook(Player player) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Unique
    public void ahp$initGuideBookTracking(boolean currentlyHasGuideBook) {
        this.ahp$cachedHasGuideBook = currentlyHasGuideBook;
        this.ahp$guideBookTrackingInitialized = true;
        this.ahp$guideBookCheckTimer = 0;
    }

    @Override
    @Unique
    public CompoundTag getShoulderHamster(ShoulderLocation location) {
        return this.ahp$shoulderData.getCompound(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, CompoundTag nbt) {
        if (nbt == null || nbt.isEmpty()) {
            this.ahp$shoulderData.remove(location.name());
        } else {
            this.ahp$shoulderData.put(location.name(), (Tag)nbt);
        }
        if (!this.level().isClientSide()) {
            Object object;
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.getId(), this.ahp$shoulderData);
            Player self = (Player)this;
            if (self instanceof ServerPlayer) {
                ServerPlayer serverSelf = (ServerPlayer)self;
                NetworkManager.sendToPlayer((ServerPlayer)serverSelf, (CustomPacketPayload)packet);
            }
            if ((object = self.level()) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)object;
                for (ServerPlayer otherPlayer : serverWorld.players()) {
                    if (otherPlayer == self || !(otherPlayer.distanceToSqr((Entity)self) < 4096.0)) continue;
                    NetworkManager.sendToPlayer((ServerPlayer)otherPlayer, (CustomPacketPayload)packet);
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$setRawShoulderData(CompoundTag nbt) {
        this.ahp$shoulderData = nbt;
    }

    @Override
    @Unique
    public void adorablehamsterpets$syncShoulderData() {
        Player self;
        if (!this.level().isClientSide() && !this.ahp$shoulderData.isEmpty() && (self = (Player)this) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)self;
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.getId(), this.ahp$shoulderData);
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet);
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        BlockPos hitPos;
        ShoulderLocation locationToProcess;
        Player self = (Player)this;
        Level world = self.level();
        if (world.isClientSide) {
            return;
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Player {} has shoulder hamsters but empty queue. Rebuilding...", (Object)self.getName().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).isEmpty()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        RandomSource random = world.getRandom();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        CompoundTag shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.isEmpty()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). Desync probable.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((ServerLevel)world, self, shoulderNbt);
        if (hamster == null) {
            this.setShoulderHamster(locationToProcess, new CompoundTag());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HitResult hitResult = self.pick(5.0, 0.0f, false);
        if (hitResult.getType() == HitResult.Type.BLOCK && world.getBlockState(hitPos = ((BlockHitResult)hitResult).getBlockPos()).is(Blocks.OAK_LEAVES)) {
            TreeHeistUtil.TreeScanResult scanResult = TreeHeistUtil.scanForTree(world, hitPos);
            if (HamsterTreeSearcherEntity.isTreeBlocked(world, scanResult.treeId())) {
                self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.tree_heist.occupied").withStyle(ChatFormatting.RED), true);
                return;
            }
            HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)((EntityType)ModEntities.HAMSTER_TREE_SEARCHER.get()).create(world);
            if (searcher != null) {
                hamster.triggerLeafPopEffects(hitPos, false);
                CompoundTag fullNbt = new CompoundTag();
                hamster.saveWithoutId(fullNbt);
                searcher.initializeSearch(hitPos, scanResult, fullNbt);
                world.addFreshEntity((Entity)searcher);
                if (config.dismountOrder.get() == DismountOrder.LIFO) {
                    this.adorablehamsterpets$mountOrderQueue.pollLast();
                } else {
                    this.adorablehamsterpets$mountOrderQueue.pollFirst();
                }
                this.setShoulderHamster(locationToProcess, new CompoundTag());
                return;
            }
        }
        if (isThrow) {
            Item item;
            if (hamster.isBaby()) {
                self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.baby_throw_refusal").withStyle(ChatFormatting.RED), true);
                return;
            }
            long currentTime = world.getGameTime();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = Math.max(1L, remainingTicks / 20L);
                self.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{totalSecondsRemaining}).withStyle(ChatFormatting.RED), true);
                return;
            }
            hamster.moveTo(self.getX(), self.getEyeY() - 0.1, self.getZ(), self.getYRot(), self.getXRot());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            ItemStack armorStack = hamster.getArmorStack();
            if (!armorStack.isEmpty() && (item = armorStack.getItem()) instanceof HamsterArmorItem) {
                HamsterArmorItem armorItem = (HamsterArmorItem)item;
                if (((Boolean)config.enableArmorPerks.get()).booleanValue() && armorItem.getMaterial() == HamsterArmorItem.HamsterArmorMaterial.IRON) {
                    throwSpeed += ((Double)config.ironArmorThrowSpeedBoost.get()).floatValue();
                }
            }
            Vec3 lookVec = self.getViewVector(1.0f);
            Vec3 throwVec = new Vec3(lookVec.x, lookVec.y + (double)0.1f, lookVec.z).normalize();
            hamster.setDeltaMovement(throwVec.scale((double)throwSpeed));
            hamster.hasImpulse = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new CompoundTag());
        HamsterEntity.spawnFromNbt((ServerLevel)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            world.playSound(null, self.getX(), self.getY(), self.getZ(), (SoundEvent)ModSounds.HAMSTER_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.adorablehamsterpets$scheduledTasks.add(new ScheduledTask(world.getGameTime() + 3L, () -> {
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, random);
                if (celebrationSound != null) {
                    world.playSound(null, self.getX(), self.getY(), self.getZ(), celebrationSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }));
            ((HamsterThrownCriterion)((Object)ModCriteria.HAMSTER_THROWN.get())).trigger((ServerPlayer)self);
        } else {
            world.playSound(null, self.blockPosition(), (SoundEvent)ModSounds.HAMSTER_DISMOUNT.get(), SoundSource.PLAYERS, 0.7f, 1.0f + random.nextFloat() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.nextInt(availableKeys.size()));
                }
                self.displayClientMessage((Component)Component.translatable((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).isEmpty() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).isEmpty() || !this.getShoulderHamster(ShoulderLocation.HEAD).isEmpty();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        if (this.adorablehamsterpets$clientShoulderData == null && this.level().isClientSide) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
        return this.adorablehamsterpets$clientShoulderData;
    }

    @Override
    @Unique
    public void ahp$registerTreeHeist(BlockPos treeId) {
        long time = this.level().getGameTime();
        this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(treeId, time));
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
    }

    @Override
    @Unique
    public float ahp$getHeistProfitability(BlockPos treeId) {
        long time = this.level().getGameTime();
        int initialSize = this.ahp$heistHistory.size();
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
        int prunedSize = this.ahp$heistHistory.size();
        int matchCount = 0;
        ArrayList<Long> matchAges = new ArrayList<Long>();
        for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
            if (!record.pos().equals((Object)treeId)) continue;
            ++matchCount;
            matchAges.add(time - record.timestamp());
        }
        float multiplier = matchCount == 0 ? 1.0f : (matchCount == 1 ? 0.6f : (matchCount == 2 ? 0.3f : 0.0f));
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Profitability] Calculating for Tree Anchor: {}\n  - Current World Time: {}\n  - Player History Size: {} (Pruned from {})\n  - Matches Found for this Tree: {}\n  - Match Ages (ticks ago): {} (Memory Limit: {})\n  - Calculated Multiplier: {}", new Object[]{treeId.toShortString(), time, prunedSize, initialSize, matchCount, matchAges, 24000L, String.format("%.2f", Float.valueOf(multiplier))});
        }
        return multiplier;
    }

    @Override
    @Unique
    public void ahp$clearHeistHistory() {
        this.ahp$heistHistory.clear();
        AdorableHamsterPets.LOGGER.info("[TreeHeist] Cleared heist history for player {}.", (Object)this.getName().getString());
        ((Player)this).displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.heist_history_reset").withStyle(ChatFormatting.WHITE), true);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (!this.ahp$shoulderData.isEmpty()) {
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.getId(), this.ahp$shoulderData);
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet);
        }
    }

    @Unique
    private void tickGuideBookTracking() {
        Player self = (Player)this;
        if (self.level().isClientSide) {
            return;
        }
        if (!(self instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)self;
        if (++this.ahp$guideBookCheckTimer < 20) {
            return;
        }
        this.ahp$guideBookCheckTimer = 0;
        if (!this.ahp$guideBookTrackingInitialized) {
            this.ahp$initGuideBookTracking(this.ahp$computeHasGuideBook((Player)player));
            return;
        }
        boolean hasNow = this.ahp$computeHasGuideBook((Player)player);
        if (hasNow && !this.ahp$cachedHasGuideBook) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayGuidebookEffectsPayload(false));
        }
        this.ahp$cachedHasGuideBook = hasNow;
    }

    @Unique
    private boolean isCelebrationOreNearby(Player player, double radius) {
        Level world = player.level();
        BlockPos center = player.blockPosition();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<BlockPos> exposedOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedOres = new ArrayList<BlockPos>();
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)center.offset(-intRadius, -intRadius, -intRadius), (BlockPos)center.offset(intRadius, intRadius, intRadius))) {
            BlockState state;
            if (!(checkPos.distSqr((Vec3i)center) <= radius * radius) || !ConfigDataCache.isCelebrationOre(state = world.getBlockState(checkPos))) continue;
            if (HamsterSniffForOreGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.immutable());
                continue;
            }
            buriedOres.add(checkPos.immutable());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(Player player, double radius) {
        AABB searchBox;
        Level world = player.level();
        List nearbyCreepers = world.getEntitiesOfClass(Creeper.class, searchBox = new AABB(player.position().subtract(radius, radius, radius), player.position().add(radius, radius, radius)), creeper -> creeper.isAlive() && creeper.getTarget() == player && EntitySelector.ENTITY_STILL_ALIVE.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Unique
    private record ScheduledTask(long executionTick, Runnable action) {
    }
}

