/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.networking;

import dev.architectury.networking.NetworkManager;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.HamsterInputPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayDistantSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestGuidebookPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterMountPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterRidePayload;
import net.dawson.adorablehamsterpets.networking.payload.ResetHeistHistoryPayload;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.networking.payload.SyncShoulderDataPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModPackets {
    public static void registerPayloads() {
        NetworkManager.registerS2CPayloadType(SpawnBeddingParticlesPayload.ID, SpawnBeddingParticlesPayload.CODEC);
        NetworkManager.registerS2CPayloadType(PlayGuidebookEffectsPayload.ID, PlayGuidebookEffectsPayload.CODEC);
        NetworkManager.registerS2CPayloadType(SyncShoulderDataPayload.ID, SyncShoulderDataPayload.CODEC);
        NetworkManager.registerS2CPayloadType(PlayDistantSoundPayload.ID, PlayDistantSoundPayload.CODEC);
    }

    public static void registerC2SPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ThrowHamsterPayload.ID, ThrowHamsterPayload.CODEC, (payload, context) -> context.queue(() -> HamsterEntity.tryThrowFromShoulder((ServerPlayer)context.getPlayer())));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UpdateHamsterRenderStatePayload.ID, UpdateHamsterRenderStatePayload.CODEC, (payload, context) -> context.queue(() -> ModPackets.handleUpdateRenderState(payload, context)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, DismountHamsterPayload.ID, DismountHamsterPayload.CODEC, (payload, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ((PlayerEntityAccessor)player).adorablehamsterpets$dismountShoulderHamster(false);
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RequestGuidebookPayload.ID, RequestGuidebookPayload.CODEC, (payload, context) -> context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ItemStack bookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get());
            DataComponentType bookComponent = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"book"));
            if (bookComponent != null) {
                bookStack.set(bookComponent, (Object)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
                player.getInventory().placeItemBackInInventory(bookStack);
                ((PlayerEntityAccessor)player).ahp$initGuideBookTracking(true);
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayGuidebookEffectsPayload(true));
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RequestHamsterMountPayload.ID, RequestHamsterMountPayload.CODEC, (payload, context) -> context.queue(() -> {
            HamsterEntity hamster;
            Player player = context.getPlayer();
            Entity entity = player.level().getEntity(payload.entityId());
            if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).isOwnedBy((LivingEntity)player) && hamster.distanceToSqr((Entity)player) < 64.0) {
                hamster.tryShoulderMount(player, ItemStack.EMPTY);
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ResetHeistHistoryPayload.ID, ResetHeistHistoryPayload.CODEC, (payload, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof PlayerEntityAccessor) {
                PlayerEntityAccessor accessor = (PlayerEntityAccessor)patt0$temp;
                accessor.ahp$clearHeistHistory();
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RequestHamsterRidePayload.ID, RequestHamsterRidePayload.CODEC, (payload, context) -> context.queue(() -> {
            HamsterEntity hamster;
            if (!((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
                return;
            }
            Player player = context.getPlayer();
            Entity entity = player.level().getEntity(payload.entityId());
            if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).distanceToSqr((Entity)player) < 64.0) {
                hamster.putPlayerOnBack(player);
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, HamsterInputPayload.ID, HamsterInputPayload.CODEC, (payload, context) -> context.queue(() -> {
            HamsterEntity hamster;
            if (!((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
                return;
            }
            Entity patt0$temp = context.getPlayer().getVehicle();
            if (patt0$temp instanceof HamsterEntity && (hamster = (HamsterEntity)patt0$temp).getControllingPassenger() == context.getPlayer()) {
                hamster.setRiderInput(payload.jumpHeld(), payload.sprintHeld());
            }
        }));
    }

    public static void registerS2CPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SpawnBeddingParticlesPayload.ID, SpawnBeddingParticlesPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handleSpawnBeddingParticles(payload)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, PlayGuidebookEffectsPayload.ID, PlayGuidebookEffectsPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handlePlayGuidebookEffects(payload)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, SyncShoulderDataPayload.ID, SyncShoulderDataPayload.CODEC, (payload, context) -> context.queue(() -> {
            Entity entity;
            Minecraft client = Minecraft.getInstance();
            if (client.level != null && (entity = client.level.getEntity(payload.entityId())) instanceof Player && entity instanceof PlayerEntityAccessor) {
                PlayerEntityAccessor accessor = (PlayerEntityAccessor)entity;
                accessor.adorablehamsterpets$setRawShoulderData(payload.data());
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, PlayDistantSoundPayload.ID, PlayDistantSoundPayload.CODEC, (payload, context) -> context.queue(() -> AdorableHamsterPetsClient.handlePlayDistantSound(payload)));
    }

    private static void handleUpdateRenderState(UpdateHamsterRenderStatePayload payload, NetworkManager.PacketContext context) {
        if (payload.isRendering()) {
            HamsterRenderTracker.addPlayer(payload.hamsterEntityId(), context.getPlayer().getUUID());
        } else {
            HamsterRenderTracker.removePlayer(payload.hamsterEntityId(), context.getPlayer().getUUID());
        }
    }
}

