/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class HamsterInventoryScreen
extends AbstractContainerScreen<HamsterInventoryScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/gui/hamster_inventory_gui.png");

    public HamsterInventoryScreen(HamsterInventoryScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = 128;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 6;
        this.inventoryLabelX = 7;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        context.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        int boxX = this.leftPos + 8;
        int boxY = this.topPos + 12;
        int boxWidth = 51;
        int boxHeight = 51;
        int size = 60;
        HamsterEntity hamster = ((HamsterInventoryScreenHandler)this.menu).getHamsterEntity();
        if (hamster != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)boxX, (int)boxY, (int)(boxX + boxWidth), (int)(boxY + boxHeight), (int)size, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)hamster);
        }
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int labelColor = 0x404040;
        MutableComponent customTextLeft = Component.translatable((String)"entity.adorablehamsterpets.hamster.inventory_left_cheek_title");
        this.drawCenteredLabel(context, (Component)customTextLeft, 52, 80, labelColor);
        MutableComponent customTextRight = Component.translatable((String)"entity.adorablehamsterpets.hamster.inventory_right_cheek_title");
        this.drawCenteredLabel(context, (Component)customTextRight, 124, 80, labelColor);
        MutableComponent blingText = Component.translatable((String)"entity.adorablehamsterpets.hamster.inventory_bling_title");
        this.drawCenteredLabel(context, (Component)blingText, 90, 29, labelColor);
        MutableComponent armorText = Component.translatable((String)"entity.adorablehamsterpets.hamster.inventory_armor_title");
        this.drawCenteredLabel(context, (Component)armorText, 142, 29, labelColor);
    }

    private void drawCenteredLabel(GuiGraphics context, Component text, int centerX, int y, int color) {
        int width = this.font.width((FormattedText)text);
        context.drawString(this.font, text, centerX - width / 2, y, color, false);
    }
}

