/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.screen;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.screen.slot.HamsterSlot;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class HamsterInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    @Nullable
    private final HamsterEntity hamsterEntityInstance;
    private static final int INVENTORY_SIZE = 8;
    private static final int BLING_SLOT_INDEX = 6;
    private static final int ARMOR_SLOT_INDEX = 7;

    public HamsterInventoryScreenHandler(int syncId, Inventory playerInventory, @Nullable HamsterEntity hamsterEntity) {
        super((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get(), syncId);
        if (hamsterEntity != null) {
            this.inventory = hamsterEntity;
            this.hamsterEntityInstance = hamsterEntity;
            HamsterInventoryScreenHandler.checkContainerSize((Container)this.inventory, (int)8);
        } else {
            this.inventory = new SimpleContainer(8);
            this.hamsterEntityInstance = null;
        }
        this.inventory.startOpen(playerInventory.player);
        this.setupSlots(playerInventory);
    }

    @Nullable
    public HamsterEntity getHamsterEntity() {
        return this.hamsterEntityInstance;
    }

    private void setupSlots(Inventory playerInventory) {
        int i;
        this.addSlot(new HamsterSlot(this.inventory, 0, 26, 95));
        this.addSlot(new HamsterSlot(this.inventory, 1, 44, 95));
        this.addSlot(new HamsterSlot(this.inventory, 2, 62, 95));
        this.addSlot(new Slot(this, (Container)new SimpleContainer(1), 0, 80, 95){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player playerEntity) {
                return false;
            }

            public boolean isActive() {
                return false;
            }
        });
        this.addSlot(new HamsterSlot(this.inventory, 3, 98, 95));
        this.addSlot(new HamsterSlot(this.inventory, 4, 116, 95));
        this.addSlot(new HamsterSlot(this.inventory, 5, 134, 95));
        this.addSlot(new Slot(this, this.inventory, 6, 82, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is((Item)ModItems.ACORN_HAT.get()) || stack.is(Items.PINK_PETALS);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.inventory, 7, 134, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof HamsterArmorItem;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            int totalHamsterSlots;
            ItemStack sourceStack = slot.getItem();
            itemStack = sourceStack.copy();
            int playerStart = totalHamsterSlots = 9;
            int playerEnd = playerStart + 36;
            if (slotIndex < totalHamsterSlots) {
                boolean isBlingSlot;
                if (slotIndex == 3) {
                    return ItemStack.EMPTY;
                }
                boolean isFromHamster = slot.container == this.inventory;
                boolean isArmorSlot = isFromHamster && slot.getContainerSlot() == 7;
                boolean bl = isBlingSlot = isFromHamster && slot.getContainerSlot() == 6;
                if (!this.moveItemStackTo(sourceStack, playerStart, playerEnd, true)) {
                    return ItemStack.EMPTY;
                }
                if ((isArmorSlot || isBlingSlot) && this.hamsterEntityInstance != null && !this.hamsterEntityInstance.level().isClientSide) {
                    Holder soundEntry = isArmorSlot ? SoundEvents.ARMOR_EQUIP_WOLF : SoundEvents.ARMOR_EQUIP_GENERIC;
                    this.hamsterEntityInstance.playSound((SoundEvent)soundEntry.value(), 0.4f, 0.8f);
                }
            } else if (sourceStack.getItem() instanceof HamsterArmorItem) {
                if (!this.moveItemStackTo(sourceStack, 8, 9, false) && !this.insertIntoPouches(sourceStack)) {
                    return ItemStack.EMPTY;
                }
            } else if (sourceStack.is((Item)ModItems.ACORN_HAT.get()) || sourceStack.is(Items.PINK_PETALS)) {
                if (!this.moveItemStackTo(sourceStack, 7, 8, false) && !this.insertIntoPouches(sourceStack)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (this.hamsterEntityInstance != null && this.hamsterEntityInstance.isItemDisallowed(sourceStack)) {
                    return ItemStack.EMPTY;
                }
                if (!this.insertIntoPouches(sourceStack)) {
                    return ItemStack.EMPTY;
                }
            }
            if (sourceStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (sourceStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, sourceStack);
        }
        return itemStack;
    }

    private boolean insertIntoPouches(ItemStack stack) {
        if (this.moveItemStackTo(stack, 0, 3, false)) {
            return true;
        }
        return this.moveItemStackTo(stack, 4, 7, false);
    }
}

