/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;

public class HamsterAnimationScheduler {
    private final List<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
    private static final Map<String, Integer> ANIMATION_DURATIONS = new HashMap<String, Integer>();

    public void tick(long currentTime) {
        this.tasks.removeIf(task -> {
            if (currentTime >= task.executionTick()) {
                task.action().run();
                return true;
            }
            return false;
        });
    }

    public void scheduleAnimationStop(long currentTime, String controllerName, String animName, HamsterEntity entity) {
        Integer duration = ANIMATION_DURATIONS.get(animName);
        if (duration != null) {
            long executionTick = currentTime + (long)duration.intValue();
            this.tasks.add(new ScheduledTask(executionTick, animName, () -> {
                entity.stopTriggeredAnim(controllerName, animName);
                AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Executed scheduled stop for animation: '{}'", (Object)entity.getId(), (Object)animName);
            }));
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Scheduled stop for animation '{}' in {} ticks (at tick {}).", new Object[]{entity.getId(), animName, duration, executionTick});
        } else {
            AdorableHamsterPets.LOGGER.warn("[HamsterEntity {}] No duration found for triggerable animation '{}'. Cancellation not scheduled.", (Object)entity.getId(), (Object)animName);
        }
    }

    public void scheduleTask(long executionTick, String debugName, Runnable action) {
        this.tasks.add(new ScheduledTask(executionTick, debugName, action));
    }

    static {
        ANIMATION_DURATIONS.put("crash", 32);
        ANIMATION_DURATIONS.put("wakeup_from_ko", 18);
        ANIMATION_DURATIONS.put("standing_headshake", 25);
        ANIMATION_DURATIONS.put("sitting_headshake", 25);
        ANIMATION_DURATIONS.put("moving_headshake", 25);
        ANIMATION_DURATIONS.put("attack", 23);
        ANIMATION_DURATIONS.put("sit1", 13);
        ANIMATION_DURATIONS.put("sit2", 13);
        ANIMATION_DURATIONS.put("sit3", 13);
        ANIMATION_DURATIONS.put("standup1", 13);
        ANIMATION_DURATIONS.put("standup2", 13);
        ANIMATION_DURATIONS.put("standup3", 13);
        ANIMATION_DURATIONS.put("wakeup1", 13);
        ANIMATION_DURATIONS.put("wakeup2", 13);
        ANIMATION_DURATIONS.put("wakeup3", 13);
        ANIMATION_DURATIONS.put("anim_hamster_sit_settle_sleep1", 23);
        ANIMATION_DURATIONS.put("anim_hamster_sit_settle_sleep2", 23);
        ANIMATION_DURATIONS.put("anim_hamster_sit_settle_sleep3", 23);
        ANIMATION_DURATIONS.put("anim_hamster_stand_settle_sleep1", 35);
        ANIMATION_DURATIONS.put("anim_hamster_stand_settle_sleep2", 35);
        ANIMATION_DURATIONS.put("anim_hamster_stand_settle_sleep3", 35);
        ANIMATION_DURATIONS.put("anim_hamster_sulk", 63);
        ANIMATION_DURATIONS.put("anim_hamster_pounce_on_item", 23);
        ANIMATION_DURATIONS.put("anim_hamster_celebrate_chase", 33);
    }

    private record ScheduledTask(long executionTick, String debugName, Runnable action) {
    }
}

