/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;

public class HamsterPlacementUtil {
    private static final Set<PathType> HAZARDOUS_FLOOR_TYPES = EnumSet.of(PathType.LAVA, new PathType[]{PathType.DAMAGE_FIRE, PathType.DANGER_FIRE, PathType.POWDER_SNOW, PathType.DAMAGE_OTHER, PathType.DANGER_OTHER, PathType.DAMAGE_CAUTIOUS, PathType.WATER});

    public static void trySuffocationRescue(HamsterEntity hamster) {
        if (hamster.suffocationGracePeriod > 0 && hamster.isInWall()) {
            Level world = hamster.level();
            BlockPos currentPos = hamster.blockPosition();
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(currentPos, world, 3, hamster);
            safePosOpt.ifPresent(safePos -> {
                hamster.moveTo((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5, hamster.getYRot(), hamster.getXRot());
                hamster.setDeltaMovement(0.0, 0.0, 0.0);
                hamster.hasImpulse = true;
                AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} rescued from {} to safe location {}.", new Object[]{hamster.getId(), currentPos, safePos});
                hamster.suffocationGracePeriod = 0;
            });
        }
    }

    public static Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius, HamsterEntity hamster) {
        return HamsterPlacementUtil.findSafeSpawnPosition(initialTarget, world, searchRadius, Collections.emptySet(), hamster);
    }

    public static Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius, Set<BlockPos> occupiedPositions, HamsterEntity hamster) {
        if (HamsterPlacementUtil.isSafeSpawnLocation(initialTarget, world, hamster) && !occupiedPositions.contains(initialTarget)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos abovePos = initialTarget.above(i);
            if (!HamsterPlacementUtil.isSafeSpawnLocation(abovePos, world, hamster) || occupiedPositions.contains(abovePos)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    BlockPos checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !HamsterPlacementUtil.isSafeSpawnLocation(checkPos = initialTarget.offset(i, 0, j), world, hamster) || occupiedPositions.contains(checkPos)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public static boolean isSafeSpawnLocation(BlockPos pos, Level world, HamsterEntity hamster) {
        PathType bodyType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, pos);
        if (HAZARDOUS_FLOOR_TYPES.contains(bodyType)) {
            return false;
        }
        BlockPos floorPos = pos.below();
        BlockState floorState = world.getBlockState(floorPos);
        PathType floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.getCollisionShape((BlockGetter)world, floorPos).isEmpty()) {
            return false;
        }
        CollisionContext entityContext = CollisionContext.of((Entity)hamster);
        return world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos, entityContext).isEmpty() && world.getBlockState(pos.above()).getCollisionShape((BlockGetter)world, pos.above(), entityContext).isEmpty();
    }
}

