/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class HamsterSeatOffsets {
    private static final double SEAT_Y_INTERCEPT = 0.12;
    private static final double SEAT_Y_SLOPE = -0.56;
    private static final double SEAT_Z_INTERCEPT = 0.0875;
    private static final double SEAT_Z_SLOPE = 0.3125;
    private static final double SEAT_Y_NUDGE = -0.02;
    private static final double SEAT_Z_NUDGE = 0.02;

    private HamsterSeatOffsets() {
    }

    public static double physicsSeatAdjustY(LivingEntity passenger, float mountScale) {
        float s = passenger.getScale();
        return HamsterSeatOffsets.seatY(s) / (double)Math.max(mountScale, 1.0E-6f);
    }

    public static Vec3 visualSeatOffset(LivingEntity passenger, float mountScale) {
        float s = passenger.getScale();
        return new Vec3(0.0, HamsterSeatOffsets.seatY(s, mountScale), HamsterSeatOffsets.seatZ(s));
    }

    private static double seatY(float passengerScale, float mountScale) {
        return 0.12 * (double)mountScale + -0.56 * (double)passengerScale + -0.02;
    }

    private static double seatY(float passengerScale) {
        return 0.12 + -0.56 * (double)passengerScale + -0.02;
    }

    private static double seatZ(float passengerScale) {
        return 0.0875 + 0.3125 * (double)passengerScale + 0.02;
    }
}

