/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import dev.architectury.event.events.common.LootEvent;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLootTableModifiers {
    private static final ResourceLocation OAK_LEAVES_ID = Blocks.OAK_LEAVES.getLootTable().location();
    private static final List<ResourceLocation> COMMON_LOOT_LOCATIONS = List.of(BuiltInLootTables.SPAWN_BONUS_CHEST.location(), BuiltInLootTables.SIMPLE_DUNGEON.location(), BuiltInLootTables.ABANDONED_MINESHAFT.location(), BuiltInLootTables.VILLAGE_PLAINS_HOUSE.location(), BuiltInLootTables.VILLAGE_SAVANNA_HOUSE.location(), BuiltInLootTables.VILLAGE_SNOWY_HOUSE.location(), BuiltInLootTables.VILLAGE_TAIGA_HOUSE.location(), BuiltInLootTables.VILLAGE_DESERT_HOUSE.location(), BuiltInLootTables.VILLAGE_SHEPHERD.location(), BuiltInLootTables.VILLAGE_BUTCHER.location(), BuiltInLootTables.SHIPWRECK_SUPPLY.location(), BuiltInLootTables.PILLAGER_OUTPOST.location(), BuiltInLootTables.UNDERWATER_RUIN_SMALL.location(), BuiltInLootTables.TRIAL_CHAMBERS_SUPPLY.location());
    private static final List<ResourceLocation> UNCOMMON_LOOT_LOCATIONS = List.of(BuiltInLootTables.SIMPLE_DUNGEON.location(), BuiltInLootTables.ABANDONED_MINESHAFT.location(), BuiltInLootTables.DESERT_PYRAMID.location(), BuiltInLootTables.JUNGLE_TEMPLE.location(), BuiltInLootTables.IGLOO_CHEST.location(), BuiltInLootTables.RUINED_PORTAL.location(), BuiltInLootTables.SHIPWRECK_TREASURE.location(), BuiltInLootTables.UNDERWATER_RUIN_BIG.location(), BuiltInLootTables.VILLAGE_ARMORER.location(), BuiltInLootTables.VILLAGE_WEAPONSMITH.location(), BuiltInLootTables.VILLAGE_TOOLSMITH.location());
    private static final List<ResourceLocation> HIGH_TIER_LOOT_LOCATIONS = List.of(BuiltInLootTables.NETHER_BRIDGE.location(), BuiltInLootTables.BASTION_TREASURE.location(), BuiltInLootTables.BASTION_OTHER.location(), BuiltInLootTables.BASTION_BRIDGE.location(), BuiltInLootTables.BASTION_HOGLIN_STABLE.location(), BuiltInLootTables.END_CITY_TREASURE.location(), BuiltInLootTables.STRONGHOLD_CROSSING.location(), BuiltInLootTables.STRONGHOLD_CORRIDOR.location(), BuiltInLootTables.ANCIENT_CITY.location(), BuiltInLootTables.TRIAL_CHAMBERS_REWARD.location(), BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE.location());
    private static final List<ResourceLocation> LEGENDARY_LOOT_LOCATIONS = List.of(BuiltInLootTables.ANCIENT_CITY.location(), BuiltInLootTables.WOODLAND_MANSION.location(), BuiltInLootTables.STRONGHOLD_LIBRARY.location(), BuiltInLootTables.END_CITY_TREASURE.location(), BuiltInLootTables.BURIED_TREASURE.location(), BuiltInLootTables.TRIAL_CHAMBERS_REWARD_UNIQUE.location(), BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE.location(), BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE.location());

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            float advancedChance;
            float basicChance;
            float chance;
            ResourceLocation tableId = key.location();
            AhpWorldGenConfig config = AdorableHamsterPets.WORLD_GEN_CONFIG;
            if (OAK_LEAVES_ID.equals((Object)tableId) && (chance = ((Float)config.oakLeavesAcornChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ACORN.get()))));
            }
            if (COMMON_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.seedLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.GREEN_BEAN_SEEDS.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CUCUMBER_SEEDS.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SUNFLOWER_SEEDS.get())).setWeight(1)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
            }
            if (UNCOMMON_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.standardArmorLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_ACORN.get())).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_IRON.get())).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_GOLD.get())).setWeight(1)));
            }
            if (HIGH_TIER_LOOT_LOCATIONS.contains(tableId)) {
                float netheriteChance;
                float diamondChance = ((Float)config.highTierArmorLootChance.get()).floatValue();
                if (diamondChance > 0.0f) {
                    context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)diamondChance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_DIAMOND.get()))));
                }
                if (((Boolean)config.enableNetheriteArmorLoot.get()).booleanValue() && (netheriteChance = ((Float)config.netheriteArmorLootChance.get()).floatValue()) > 0.0f) {
                    context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)netheriteChance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_NETHERITE.get()))));
                }
            }
            if (LEGENDARY_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.accessoryLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.ACORN_HAT.get()))));
            }
            if (HIGH_TIER_LOOT_LOCATIONS.contains(tableId) && (basicChance = ((Float)config.basicSmithingTemplateLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)basicChance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_IRON.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_GOLD.get())).setWeight(1)));
            }
            if (LEGENDARY_LOOT_LOCATIONS.contains(tableId) && (advancedChance = ((Float)config.advancedSmithingTemplateLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)advancedChance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_DIAMOND.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_NETHERITE.get())).setWeight(1)));
            }
        });
    }
}

