/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsUtil {
    public static <T extends ParticleOptions> void spawnParticles(Level world, Vec3 center, T particle, int count, Vec3 spread, double speed) {
        ParticleEffectsUtil.spawnParticles(world, center, particle, count, spread.x, spread.y, spread.z, speed);
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, Vec3 center, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles(particle, center.x, center.y, center.z, count, spreadX, spreadY, spreadZ, speed);
        } else {
            RandomSource random = world.getRandom();
            for (int i = 0; i < count; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 2.0 * spreadX;
                double offsetY = (random.nextDouble() - 0.5) * 2.0 * spreadY;
                double offsetZ = (random.nextDouble() - 0.5) * 2.0 * spreadZ;
                double vx = (random.nextDouble() - 0.5) * speed;
                double vy = (random.nextDouble() - 0.5) * speed;
                double vz = (random.nextDouble() - 0.5) * speed;
                world.addParticle(particle, center.x + offsetX, center.y + offsetY, center.z + offsetZ, vx, vy, vz);
            }
        }
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, BlockPos pos, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, Vec3.atCenterOf((Vec3i)pos), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, BlockPos pos, double yOffset, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, yOffset, 0.0), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnParticlesOnEntity(Entity entity, T particle, int count, double widthScale, double heightScale, double speed, double yOffset) {
        double spreadX = (double)entity.getBbWidth() * widthScale / 2.0;
        double spreadY = (double)entity.getBbHeight() * heightScale / 2.0;
        double spreadZ = (double)entity.getBbWidth() * widthScale / 2.0;
        double centerY = entity.getY() + (double)entity.getBbHeight() / 2.0 + yOffset;
        Vec3 center = new Vec3(entity.getX(), centerY, entity.getZ());
        ParticleEffectsUtil.spawnParticles(entity.level(), center, particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnMotionTrail(Entity entity, T particle, int countPerTick, double offsetMultiplier, double scatter, double velocityScale, double downwardVelocity) {
        Level world = entity.level();
        Vec3 velocity = entity.getDeltaMovement();
        if (velocity.horizontalDistanceSqr() < 1.0E-6) {
            return;
        }
        RandomSource random = world.getRandom();
        for (int i = 0; i < countPerTick; ++i) {
            double baseX = entity.getX() - velocity.x * offsetMultiplier;
            double baseY = entity.getY() + (double)entity.getBbHeight() / 2.0 - velocity.y * offsetMultiplier;
            double baseZ = entity.getZ() - velocity.z * offsetMultiplier;
            double spawnX = baseX + (random.nextDouble() - 0.5) * ((double)entity.getBbWidth() * 0.8);
            double spawnY = baseY + (random.nextDouble() - 0.5) * ((double)entity.getBbHeight() * 0.05);
            double spawnZ = baseZ + (random.nextDouble() - 0.5) * ((double)entity.getBbWidth() * 0.8);
            Vec3 backwardsVel = velocity.scale(-1.0 * velocityScale);
            double finalVelX = backwardsVel.x + random.nextGaussian() * scatter;
            double finalVelY = backwardsVel.y + random.nextGaussian() * scatter - downwardVelocity;
            double finalVelZ = backwardsVel.z + random.nextGaussian() * scatter;
            world.addParticle(particle, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
        }
    }

    public static void spawnBreadcrumbs(ServerLevel world, @Nullable Path path) {
        if (path == null) {
            return;
        }
        int currentNodeIndex = path.getNextNodeIndex();
        int pathLength = path.getNodeCount();
        for (int i = currentNodeIndex; i < pathLength; ++i) {
            Node node = path.getNode(i);
            Vec3 directionVector = Vec3.ZERO;
            if (i + 1 < pathLength) {
                Node nextNode = path.getNode(i + 1);
                directionVector = new Vec3((double)(nextNode.x - node.x), 0.0, (double)(nextNode.z - node.z)).normalize();
            }
            for (int p = 0; p < 3; ++p) {
                double distanceAlongPath = world.getRandom().nextDouble();
                Vec3 pathOffset = directionVector.scale(distanceAlongPath);
                double offsetY = (world.getRandom().nextDouble() - 0.5) * 0.1;
                ParticleEffectsUtil.spawnParticles((Level)world, new Vec3((double)node.x + 0.5 + pathOffset.x, (double)node.y + 0.5 - 0.38 + offsetY, (double)node.z + 0.5 + pathOffset.z), ParticleTypes.MYCELIUM, 1, 0.2, 0.0, 0.2, 3.0);
            }
        }
    }

    public static void spawnSpinningRing(Level world, BlockPos centerPos, ParticleOptions particle, int count, double radius, double ringThickness, double rotationSpeed, double bobbingHeight, double upwardVelocity, double yOffset) {
        double timeOffset = (double)world.getGameTime() * rotationSpeed;
        double bobbingTimeOffset = (double)world.getGameTime() * (rotationSpeed / 1.5);
        double angleStep = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double angle = timeOffset + (double)i * angleStep;
            double currentRadius = radius + (world.getRandom().nextDouble() - 0.5) * ringThickness;
            double x = (double)centerPos.getX() + 0.5 + Math.cos(angle) * currentRadius;
            double z = (double)centerPos.getZ() + 0.5 + Math.sin(angle) * currentRadius;
            double y = (double)centerPos.getY() + 0.5 + yOffset + Math.sin(bobbingTimeOffset) * bobbingHeight;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.sendParticles(particle, x, y, z, 0, 0.0, upwardVelocity, 0.0, 1.0);
                continue;
            }
            world.addParticle(particle, x, y, z, 0.0, upwardVelocity, 0.0);
        }
    }

    public static <T extends ParticleOptions> void spawnSphericalShell(Level world, Vec3 center, T particle, int count, double baseRadius, double radiusVariance) {
        RandomSource random = world.getRandom();
        for (int i = 0; i < count; ++i) {
            double rZ;
            double rY;
            double rX = random.nextDouble() - 0.5;
            double dist = Math.sqrt(rX * rX + (rY = random.nextDouble() - 0.5) * rY + (rZ = random.nextDouble() - 0.5) * rZ);
            if (dist < 1.0E-4) {
                dist = 1.0;
            }
            double radius = baseRadius + random.nextDouble() * radiusVariance;
            double offsetX = rX / dist * radius;
            double offsetY = rY / dist * radius;
            double offsetZ = rZ / dist * radius;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.sendParticles(particle, center.x + offsetX, center.y + offsetY, center.z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            world.addParticle(particle, center.x + offsetX, center.y + offsetY, center.z + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

