/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TreeHeistUtil {
    private static final int MAX_TRUNK_SEARCH_DIST = 10;
    private static final int MAX_LOG_COUNT = 128;
    private static final int MAX_CANOPY_COUNT = 300;
    private static final int MAX_BUSH_COUNT = 48;
    private static final int MAX_CANOPY_DISTANCE = 5;

    public static TreeScanResult scanForTree(Level world, BlockPos startPos) {
        BlockPos foundLog;
        BlockState startState = world.getBlockState(startPos);
        if (!startState.is(Blocks.OAK_LEAVES)) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Aborted: Start pos {} is not an Oak Leaf block (Found: {}).", (Object)startPos.toShortString(), (Object)startState.getBlock());
            }
            return new TreeScanResult(startPos, Collections.singleton(startPos));
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Starting scan at HitPos: {}. Searching for connected logs...", (Object)startPos.toShortString());
        }
        if ((foundLog = TreeHeistUtil.findConnectedLog(world, startPos)) != null) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] LOG FOUND at {}. Switching to Tree Map Mode.", (Object)foundLog.toShortString());
            }
            return TreeHeistUtil.mapTreeFromLog(world, foundLog);
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] NO LOG FOUND within range. Switching to Floating Bush Mode.");
        }
        return TreeHeistUtil.mapFloatingBush(world, startPos);
    }

    private static BlockPos findConnectedLog(Level world, BlockPos startNode) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(startNode);
        visited.add(startNode);
        int startDist = TreeHeistUtil.getLeafDistance(world.getBlockState(startNode));
        int iterations = 0;
        int maxIterations = 64;
        while (!queue.isEmpty() && iterations < maxIterations) {
            BlockPos current = (BlockPos)queue.poll();
            ++iterations;
            for (Direction dir : Direction.values()) {
                int dist;
                BlockPos neighbor = current.relative(dir);
                if (!visited.add(neighbor)) continue;
                BlockState state = world.getBlockState(neighbor);
                if (state.is(BlockTags.LOGS)) {
                    return neighbor;
                }
                if (!state.is(Blocks.OAK_LEAVES) || (dist = TreeHeistUtil.getLeafDistance(state)) > startDist && dist >= 7 || neighbor.distManhattan((Vec3i)startNode) > 10) continue;
                queue.add(neighbor);
            }
        }
        return null;
    }

    private static TreeScanResult mapTreeFromLog(Level world, BlockPos initialLog) {
        HashSet<BlockPos> treeLogs = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> logQueue = new ArrayDeque<BlockPos>();
        logQueue.add(initialLog);
        treeLogs.add(initialLog);
        BlockPos bottomMostLog = initialLog;
        while (!logQueue.isEmpty() && treeLogs.size() < 128) {
            BlockPos current = (BlockPos)logQueue.poll();
            if (current.getY() < bottomMostLog.getY()) {
                bottomMostLog = current;
            } else if (current.getY() == bottomMostLog.getY() && (current.getX() < bottomMostLog.getX() || current.getX() == bottomMostLog.getX() && current.getZ() < bottomMostLog.getZ())) {
                bottomMostLog = current;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor;
                        if (x == 0 && y == 0 && z == 0 || treeLogs.contains(neighbor = current.offset(x, y, z)) || !world.getBlockState(neighbor).is(BlockTags.LOGS)) continue;
                        treeLogs.add(neighbor);
                        logQueue.add(neighbor);
                    }
                }
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Tree Skeleton Mapped. Total Logs: {}. Anchor Established: {}", (Object)treeLogs.size(), (Object)bottomMostLog.toShortString());
            if (treeLogs.size() >= 128) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Log scan hit MAX limit ({})! Tree might be truncated.", (Object)128);
            }
        }
        HashSet<BlockPos> validCanopy = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> leafQueue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visitedLeaves = new HashSet<BlockPos>();
        for (BlockPos log : treeLogs) {
            for (Direction dir : Direction.values()) {
                int nDist;
                BlockState nState;
                BlockPos n = log.relative(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.getBlockState(n)).is(Blocks.OAK_LEAVES) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5) continue;
                leafQueue.add(n);
            }
        }
        while (!leafQueue.isEmpty() && validCanopy.size() < 300) {
            BlockPos current = (BlockPos)leafQueue.poll();
            BlockState state = world.getBlockState(current);
            if (!state.is(BlockTags.LEAVES)) continue;
            int dist = TreeHeistUtil.getLeafDistance(state);
            validCanopy.add(current);
            for (Direction dir : Direction.values()) {
                int nDist;
                BlockState nState;
                BlockPos n = current.relative(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.getBlockState(n)).is(Blocks.OAK_LEAVES) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5 || nDist < dist) continue;
                leafQueue.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Canopy Mapped. Valid Oak Leaves: {}", (Object)validCanopy.size());
            if (validCanopy.size() >= 300) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Canopy scan hit MAX limit ({})!", (Object)300);
            }
        }
        return new TreeScanResult(bottomMostLog, validCanopy);
    }

    private static TreeScanResult mapFloatingBush(Level world, BlockPos startPos) {
        HashSet<BlockPos> validLeaves = new HashSet<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        validLeaves.add(startPos);
        BlockPos lowestLeaf = startPos;
        while (!queue.isEmpty() && validLeaves.size() < 48) {
            BlockPos current = (BlockPos)queue.poll();
            if (current.getY() < lowestLeaf.getY() || current.getY() == lowestLeaf.getY() && current.getX() < lowestLeaf.getX() || current.getY() == lowestLeaf.getY() && current.getX() == lowestLeaf.getX() && current.getZ() < lowestLeaf.getZ()) {
                lowestLeaf = current;
            }
            for (Direction dir : Direction.values()) {
                BlockPos n = current.relative(dir);
                if (!visited.add(n) || !world.getBlockState(n).is(Blocks.OAK_LEAVES)) continue;
                queue.add(n);
                validLeaves.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Bush Mapped. Size: {}. Anchor: {}", (Object)validLeaves.size(), (Object)lowestLeaf.toShortString());
        }
        return new TreeScanResult(lowestLeaf, validLeaves);
    }

    private static int getLeafDistance(BlockState state) {
        if (state.hasProperty((Property)LeavesBlock.DISTANCE)) {
            return (Integer)state.getValue((Property)LeavesBlock.DISTANCE);
        }
        return 7;
    }

    public static void spawnDebugParticles(Level world, BlockPos anchor, List<Long> leafLongs) {
        if (world.isClientSide || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (anchor != null) {
            ParticleEffectsUtil.spawnSpinningRing(world, anchor, (ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, 10, 0.85, 0.0, 0.7, 0.55, 0.0, 0.0);
        }
        if (!leafLongs.isEmpty()) {
            int particleCount = 200;
            for (int i = 0; i < particleCount; ++i) {
                long leafPosLong = leafLongs.get(world.getRandom().nextInt(leafLongs.size()));
                BlockPos leafPos = BlockPos.of((long)leafPosLong);
                ParticleEffectsUtil.spawnSphericalShell(world, Vec3.atCenterOf((Vec3i)leafPos), ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, 1, 0.7, 0.2);
            }
        }
    }

    public static void spawnDebugParticles(Level world, TreeScanResult result) {
        if (world.isClientSide) {
            return;
        }
        ArrayList<Long> longs = new ArrayList<Long>();
        for (BlockPos p : result.validCanopyPositions()) {
            longs.add(p.asLong());
        }
        TreeHeistUtil.spawnDebugParticles(world, result.treeId(), longs);
    }

    public static BlockPos findExitPosition(Level world, BlockPos startPos) {
        BlockPos check;
        for (int y = 1; y <= 15; ++y) {
            check = startPos.below(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos check2 = startPos.relative(dir);
            if (!TreeHeistUtil.isSafeExit(world, check2)) continue;
            return check2;
        }
        for (int y = 1; y <= 5; ++y) {
            check = startPos.above(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        return startPos;
    }

    private static boolean isSafeExit(Level world, BlockPos pos) {
        if (!world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return false;
        }
        BlockPos below = pos.below();
        if (world.getBlockState(below).getCollisionShape((BlockGetter)world, below).isEmpty()) {
            return true;
        }
        return !TreeHeistUtil.isSmallPocket(world, pos);
    }

    private static boolean isSmallPocket(Level world, BlockPos startPos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        int airCount = 0;
        int limit = 5;
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (++airCount >= limit) {
                return false;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor) || !world.getBlockState(neighbor).getCollisionShape((BlockGetter)world, neighbor).isEmpty()) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return true;
    }

    public static void sendHeistStartMessage(Player player, float profitability) {
        if (!Configs.AHP.enableTreeHeistStartMessage) {
            return;
        }
        String key = "message.adorablehamsterpets.tree_heist_start.high";
        ChatFormatting color = ChatFormatting.WHITE;
        if (profitability < 0.4f) {
            key = "message.adorablehamsterpets.tree_heist_start.low";
        } else if (profitability < 0.9f) {
            key = "message.adorablehamsterpets.tree_heist_start.medium";
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Starting heist for player {}. Profitability: {} ({}%). Selected Message Key: {}", new Object[]{player.getName().getString(), String.format("%.2f", Float.valueOf(profitability)), (int)(profitability * 100.0f), key});
        }
        player.displayClientMessage((Component)Component.translatable((String)key).withStyle(color), true);
    }

    public record TreeScanResult(BlockPos treeId, Set<BlockPos> validCanopyPositions) {
    }

    public record HeistRecord(BlockPos pos, long timestamp) {
    }
}

