/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.gen;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModEntitySpawns {
    public static final Set<Block> VALID_SPAWN_BLOCKS = new HashSet<Block>();
    private static final Set<TagKey<Biome>> PARSED_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> PARSED_INCLUDES = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> PARSED_EXCLUDES = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> PARSED_EXCLUDE_TAGS = new HashSet<TagKey<Biome>>();

    public static void parseConfig() {
        PARSED_TAGS.clear();
        PARSED_INCLUDES.clear();
        PARSED_EXCLUDES.clear();
        PARSED_EXCLUDE_TAGS.clear();
        for (String tagStr : Configs.AHP_WORLDGEN.spawnBiomeTags) {
            try {
                PARSED_TAGS.add((TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tagStr)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.info("[BiomeConfig] Invalid biome tag identifier in config: '{}'", (Object)tagStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.includeBiomes) {
            try {
                PARSED_INCLUDES.add(ResourceLocation.parse((String)biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in include list: '{}'", (Object)biomeIdStr);
            }
        }
        for (String biomeIdStr : Configs.AHP_WORLDGEN.excludeBiomes) {
            try {
                PARSED_EXCLUDES.add(ResourceLocation.parse((String)biomeIdStr));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeConfig] Invalid biome identifier in exclude list: '{}'", (Object)biomeIdStr);
            }
        }
        for (String tagStr : Configs.AHP_WORLDGEN.excludeBiomeTags) {
            try {
                PARSED_EXCLUDE_TAGS.add((TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)tagStr)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.info("[BiomeConfig] Invalid biome exclusion tag identifier in config: '{}'", (Object)tagStr);
            }
        }
        AdorableHamsterPets.LOGGER.info("[BiomeConfig] Parsed {} tags, {} includes, {} exclude IDs, and {} exclude tags.", new Object[]{PARSED_TAGS.size(), PARSED_INCLUDES.size(), PARSED_EXCLUDES.size(), PARSED_EXCLUDE_TAGS.size()});
    }

    public static boolean shouldSpawnInBiome(BiomeModifications.BiomeContext ctx) {
        ResourceLocation biomeId = ctx.getKey().orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        for (TagKey<Biome> tag : PARSED_EXCLUDE_TAGS) {
            if (!ctx.hasTag(tag)) continue;
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (TagKey<Biome> tag : PARSED_TAGS) {
            if (!ctx.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldSpawnInBiomeNeoForge(Holder<Biome> biomeEntry) {
        ResourceLocation biomeId = biomeEntry.unwrapKey().map(ResourceKey::location).orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (PARSED_EXCLUDES.contains(biomeId)) {
            return false;
        }
        for (TagKey<Biome> tag : PARSED_EXCLUDE_TAGS) {
            if (!biomeEntry.is(tag)) continue;
            return false;
        }
        if (PARSED_INCLUDES.contains(biomeId)) {
            return true;
        }
        for (TagKey<Biome> tag : PARSED_TAGS) {
            if (!biomeEntry.is(tag)) continue;
            return true;
        }
        return false;
    }

    static {
        VALID_SPAWN_BLOCKS.add(Blocks.SAND);
        VALID_SPAWN_BLOCKS.add(Blocks.RED_SAND);
        VALID_SPAWN_BLOCKS.add(Blocks.TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.WHITE_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.ORANGE_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.MAGENTA_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.LIGHT_BLUE_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.YELLOW_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.LIME_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.PINK_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.GRAY_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.LIGHT_GRAY_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.CYAN_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.PURPLE_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.BLUE_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.BROWN_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.GREEN_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.RED_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.BLACK_TERRACOTTA);
        VALID_SPAWN_BLOCKS.add(Blocks.STONE);
        VALID_SPAWN_BLOCKS.add(Blocks.DEEPSLATE);
        VALID_SPAWN_BLOCKS.add(Blocks.ANDESITE);
        VALID_SPAWN_BLOCKS.add(Blocks.DIORITE);
        VALID_SPAWN_BLOCKS.add(Blocks.GRANITE);
        VALID_SPAWN_BLOCKS.add(Blocks.GRAVEL);
        VALID_SPAWN_BLOCKS.add(Blocks.DIRT);
        VALID_SPAWN_BLOCKS.add(Blocks.MUD);
        VALID_SPAWN_BLOCKS.add(Blocks.PACKED_MUD);
        VALID_SPAWN_BLOCKS.add(Blocks.GRASS_BLOCK);
        VALID_SPAWN_BLOCKS.add(Blocks.MOSS_BLOCK);
        VALID_SPAWN_BLOCKS.add(Blocks.COARSE_DIRT);
        VALID_SPAWN_BLOCKS.add(Blocks.PODZOL);
        VALID_SPAWN_BLOCKS.add(Blocks.SNOW_BLOCK);
        VALID_SPAWN_BLOCKS.add(Blocks.MYCELIUM);
        VALID_SPAWN_BLOCKS.add(Blocks.SCULK);
    }
}

