/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.gen.feature;

import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.world.gen.feature.ModConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> CUSTOM_SUNFLOWER_PLACED_KEY = ModPlacedFeatures.registerKey("custom_sunflower_placed");
    public static final ResourceKey<PlacedFeature> WILD_GREEN_BEAN_BUSH_PLACED_KEY = ModPlacedFeatures.registerKey("wild_green_bean_bush_placed");
    public static final ResourceKey<PlacedFeature> WILD_CUCUMBER_BUSH_PLACED_KEY = ModPlacedFeatures.registerKey("wild_cucumber_bush_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureRegistryEntryLookup = context.lookup(Registries.CONFIGURED_FEATURE);
        AhpWorldGenConfig config = AdorableHamsterPets.WORLD_GEN_CONFIG;
        ModPlacedFeatures.register(context, CUSTOM_SUNFLOWER_PLACED_KEY, configuredFeatureRegistryEntryLookup.getOrThrow(ModConfiguredFeatures.CUSTOM_SUNFLOWER_PATCH_KEY), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        ModPlacedFeatures.register(context, WILD_GREEN_BEAN_BUSH_PLACED_KEY, configuredFeatureRegistryEntryLookup.getOrThrow(ModConfiguredFeatures.WILD_GREEN_BEAN_BUSH_KEY), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)((Integer)config.wildGreenBeanBushRarity.get())), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        ModPlacedFeatures.register(context, WILD_CUCUMBER_BUSH_PLACED_KEY, configuredFeatureRegistryEntryLookup.getOrThrow(ModConfiguredFeatures.WILD_CUCUMBER_BUSH_KEY), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)((Integer)config.wildCucumberBushRarity.get())), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        ModPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

