/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.neoforge;

import com.mojang.serialization.MapCodec;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.dawson.adorablehamsterpets.world.neoforge.ModBiomeModifiers;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class ConfigurableHamsterSpawnModifier
implements BiomeModifier {
    public static final MapCodec<ConfigurableHamsterSpawnModifier> CODEC = MapCodec.unit(ConfigurableHamsterSpawnModifier::new);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (ModEntitySpawns.shouldSpawnInBiomeNeoForge(biome)) {
            MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
            MobSpawnSettings.SpawnerData spawnEntry = new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HAMSTER.get(), ((Integer)Configs.AHP_WORLDGEN.spawnWeight.get()).intValue(), 1, ((Integer)Configs.AHP_WORLDGEN.maxGroupSize.get()).intValue());
            spawnBuilder.addSpawn(MobCategory.CREATURE, spawnEntry);
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)ModBiomeModifiers.CONFIGURABLE_HAMSTER_SPAWN.get();
    }
}

