/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ModSpawnPlacementsImpl {
    private static final List<SpawnPlacementData<?>> PENDING_PLACEMENTS = new ArrayList();

    public static <T extends Mob> void register(Supplier<? extends EntityType<T>> entityType, SpawnPlacementType location, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        PENDING_PLACEMENTS.add(new SpawnPlacementData<T>(entityType, location, heightmapType, predicate));
    }

    @SubscribeEvent
    public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        for (SpawnPlacementData<?> data : PENDING_PLACEMENTS) {
            data.register(event);
        }
        PENDING_PLACEMENTS.clear();
    }

    private record SpawnPlacementData<T extends Mob>(Supplier<? extends EntityType<T>> entityTypeSupplier, SpawnPlacementType location, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        void register(RegisterSpawnPlacementsEvent event) {
            event.register(this.entityTypeSupplier.get(), this.location, this.heightmapType, this.predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }
    }
}

