/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.client.HamsterBedRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.command.ModClientCommands;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.render.LeafJiggleManager;
import net.dawson.adorablehamsterpets.client.sound.HamsterTreeLoopSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.client.renderer.HamsterTreeSearcherRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.HamsterInputPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayDistantSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterMountPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterRidePayload;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ClientParticleManager;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static int clientSessionTimer = 0;
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;
    private static final Map<Integer, HamsterTreeLoopSoundInstance> activeTreeSounds = new HashMap<Integer, HamsterTreeLoopSoundInstance>();
    private static boolean lastJumpDown = false;
    private static boolean lastSprintDown = false;

    public static void init() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.GREEN_BEANS_CROP.get(), (class_2248)ModBlocks.CUCUMBER_CROP.get(), (class_2248)ModBlocks.SUNFLOWER_BLOCK.get(), (class_2248)ModBlocks.WILD_CUCUMBER_BUSH.get(), (class_2248)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (class_2248)ModBlocks.HAMSTER_BED.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)class_2960.method_60655((String)"adorablehamsterpets", (String)"main"))) {
                ConfigDataCache.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client.");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (class_1935[])new class_1935[]{(class_1935)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerS2CPackets();
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientGuiEvent.RENDER_HUD.register((context, tickCounter) -> announcementHudRenderer.render(context, tickCounter.method_60637(true)));
        ClientCommandRegistrationEvent.EVENT.register(ModClientCommands::register);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            clientSessionTimer = 0;
            ClientParticleManager.INSTANCE.clear();
        });
        EntityEvent.ADD.register((entity, world) -> {
            if (world.method_8608() && entity instanceof HamsterTreeSearcherEntity) {
                HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)entity;
                class_310 client = class_310.method_1551();
                HamsterTreeLoopSoundInstance existingSound = activeTreeSounds.get(searcher.method_5628());
                if (existingSound == null || existingSound.method_4793()) {
                    HamsterTreeLoopSoundInstance newSound = new HamsterTreeLoopSoundInstance(searcher);
                    client.method_1483().method_4873((class_1113)newSound);
                    activeTreeSounds.put(searcher.method_5628(), newSound);
                }
                LeafJiggleManager.INSTANCE.onSearcherAdded(searcher);
            }
            return EventResult.pass();
        });
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (player.method_37908().field_9236 && hand == class_1268.field_5808 && entity instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.method_1434() && hamster.method_6181() && hamster.method_6171((class_1309)player)) {
                    NetworkManager.sendToServer((class_8710)new RequestHamsterMountPayload(hamster.method_5628()));
                    return EventResult.interruptTrue();
                }
                if (((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue() && ModKeyBindings.RIDE_HAMSTER_KEY.method_1434() && !hamster.method_5626((class_1297)player)) {
                    NetworkManager.sendToServer((class_8710)new RequestHamsterRidePayload(hamster.method_5628()));
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.pass();
        });
    }

    public static void initBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedRenderer::new);
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
        EntityRendererRegistry.register(ModEntities.HAMSTER_TREE_SEARCHER, HamsterTreeSearcherRenderer::new);
    }

    private static void onEndClientTick(class_310 client) {
        boolean ridingHamster;
        LeafJiggleManager.INSTANCE.clientTick(client);
        boolean isGuiOpen = client.field_1755 != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.field_1687 != null && !AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
            AnnouncementManager.INSTANCE.syncPatchouliReadState();
            if (AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
                AnnouncementManager.INSTANCE.processDeferredReadMarks();
            }
        }
        if (client.field_1687 != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        boolean bl = ridingHamster = client.field_1724 != null && client.field_1724.method_5854() instanceof HamsterEntity;
        if (ridingHamster && ((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
            boolean jumpDown = client.field_1690.field_1903.method_1434();
            boolean sprintDown = client.field_1690.field_1867.method_1434();
            if (jumpDown != lastJumpDown || sprintDown != lastSprintDown) {
                lastJumpDown = jumpDown;
                lastSprintDown = sprintDown;
                NetworkManager.sendToServer((class_8710)new HamsterInputPayload(jumpDown, sprintDown));
                HamsterEntity hamster = (HamsterEntity)client.field_1724.method_5854();
                hamster.setRiderInput(jumpDown, sprintDown);
            }
        } else if (lastJumpDown || lastSprintDown) {
            lastJumpDown = false;
            lastSprintDown = false;
            NetworkManager.sendToServer((class_8710)new HamsterInputPayload(false, false));
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.method_1436()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((class_8710)new ThrowHamsterPayload());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            NetworkManager.sendToServer((class_8710)new UpdateHamsterRenderStatePayload(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
        AdorableHamsterPetsClient.handleGuidebookWarning(client);
        if (client.field_1687 != null && !client.method_1493()) {
            ClientParticleManager.INSTANCE.tick((class_1937)client.field_1687);
        }
    }

    private static void handleGuidebookWarning(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        String username = client.field_1724.method_7334().getName();
        if (config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
            return;
        }
        int warningTime = (Integer)config.guidebookWarningTimer.get();
        if (clientSessionTimer > warningTime + 145) {
            clientSessionTimer = 0;
        }
        if (++clientSessionTimer == 20 && AdorableHamsterPetsClient.hasGuideBook((class_1657)client.field_1724)) {
            config.playersWhoHaveSeenGuidebookWarning.add(username);
            config.save();
        }
        if (clientSessionTimer == warningTime) {
            if (!AdorableHamsterPetsClient.hasGuideBook((class_1657)client.field_1724)) {
                AdorableHamsterPetsClient.sendWarningPart1((class_1657)client.field_1724);
            } else {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
        if (clientSessionTimer == warningTime + 140) {
            if (!AdorableHamsterPetsClient.hasGuideBook((class_1657)client.field_1724)) {
                AdorableHamsterPetsClient.sendWarningPart2((class_1657)client.field_1724);
            }
            if (!config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
    }

    private static boolean hasGuideBook(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    private static void sendWarningPart1(class_1657 player) {
        class_5250 message = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.only_once").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_27693("\n\n");
        message.method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.header_prefix").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.header_title").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_27693("\n\n");
        int ticks = (Integer)AdorableHamsterPets.CONFIG.guidebookWarningTimer.get();
        int minutes = Math.max(1, ticks / 1200);
        String key = minutes == 1 ? "message.adorablehamsterpets.warning.context.singular" : "message.adorablehamsterpets.warning.context.plural";
        message.method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{minutes}).method_27692(class_124.field_1080));
        player.method_7353((class_2561)message, false);
        player.method_5783((class_3414)ModSounds.HAMSTER_DING.comp_349(), 1.0f, 0.8f);
    }

    private static void sendWarningPart2(class_1657 player) {
        class_5250 message = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.oath_label").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.oath_text").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056})).method_27693("\n\n");
        message.method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.action_button").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/ahp_open_config_screen")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.adorablehamsterpets.warning.action_hover"))))).method_27693("\n\n");
        message.method_10852((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.warning.crafting_help").method_27692(class_124.field_1080));
        player.method_7353((class_2561)message, false);
        player.method_5783((class_3414)ModSounds.HAMSTER_DING.comp_349(), 1.0f, 1.0f);
    }

    private static void handleDismountKeyPress(class_310 client) {
        long delayMillis;
        long currentTime;
        boolean wasKeyPressed;
        boolean hasShoulderHamster;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        try {
            hasShoulderHamster = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
        }
        catch (RuntimeException e) {
            hasShoulderHamster = false;
        }
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            class_304 vanillaSneak = client.field_1690.field_1832;
            class_304 customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.method_23481(false);
                while (vanillaSneak.method_1436()) {
                }
            }
            if (customDismount != null) {
                customDismount.method_23481(false);
                while (customDismount.method_1436()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            isWaitingForSecondSneakPress = false;
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_304 keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.field_1690.field_1832;
        boolean bl = wasKeyPressed = keyToListenFor != null && keyToListenFor.method_1436();
        if (wasKeyPressed) {
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
                    isWaitingForSecondSneakPress = false;
                } else {
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            isWaitingForSecondSneakPress = false;
        }
    }

    public static void handleSpawnBeddingParticles(SpawnBeddingParticlesPayload payload) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2338 spawnPos = payload.pos().method_10093(payload.direction());
        class_243 particleCenter = class_243.method_24953((class_2382)spawnPos);
        class_2400 particleType = ModParticles.getForVariant(payload.variant());
        for (int i = 0; i < 30; ++i) {
            double offsetX = client.field_1687.field_9229.method_43059() * 1.2;
            double offsetY = client.field_1687.field_9229.method_43059() * 1.2;
            double offsetZ = client.field_1687.field_9229.method_43059() * 1.2;
            client.field_1687.method_8406((class_2394)particleType, particleCenter.field_1352 + offsetX, particleCenter.field_1351 + offsetY, particleCenter.field_1350 + offsetZ, 0.0, -1.23E-4, 0.0);
        }
    }

    public static void handlePlayGuidebookEffects(PlayGuidebookEffectsPayload payload) {
        class_746 player;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (payload.closeScreen()) {
            client.method_1507(null);
        }
        if ((player = client.field_1724) == null || client.field_1687 == null) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.guidebook_rediscovered").method_27692(class_124.field_1065), true);
        client.field_1687.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15119, class_3419.field_15248, 0.5f, 1.2f, false);
        client.field_1687.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_17481, class_3419.field_15248, 0.7f, 1.5f, false);
        ParticleEffectsUtil.spawnParticlesOnEntity((class_1297)player, class_2398.field_11215, 50, 0.6, 1.0, 0.5, 0.0);
        ParticleEffectsUtil.spawnParticlesOnEntity((class_1297)player, class_2398.field_11211, 20, 1.0, 1.0, 0.5, 0.0);
    }

    public static void handlePlayDistantSound(PlayDistantSoundPayload payload) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_3414 sound = class_3414.method_47908((class_2960)payload.soundId());
        client.field_1687.method_8486(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), sound, class_3419.field_15254, payload.volume(), payload.pitch(), false);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }
}

