/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.render;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.minecraft.class_1297;
import net.minecraft.class_310;

public class LeafJiggleManager {
    public static final LeafJiggleManager INSTANCE = new LeafJiggleManager();
    public static final int DURATION_TICKS = 20;
    private final Long2ObjectOpenHashMap<Jiggle> activeJiggles = new Long2ObjectOpenHashMap();
    private final Int2LongOpenHashMap searcherLastPositions = new Int2LongOpenHashMap();

    private LeafJiggleManager() {
    }

    public void onSearcherAdded(HamsterTreeSearcherEntity entity) {
        long posLong = entity.method_24515().method_10063();
        this.searcherLastPositions.put(entity.method_5628(), entity.method_24515().method_10063());
        if (entity.method_37908() != null) {
            this.startJiggle(posLong, entity.method_37908().method_8510(), LeafJiggleManager.mixSeed(entity.method_5628(), posLong));
        }
    }

    public void clientTick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        long now = client.field_1687.method_8510();
        ObjectIterator iterator = this.searcherLastPositions.int2LongEntrySet().iterator();
        while (iterator.hasNext()) {
            long lastPosLong;
            HamsterTreeSearcherEntity searcher;
            Int2LongMap.Entry entry = (Int2LongMap.Entry)iterator.next();
            int entityId = entry.getIntKey();
            class_1297 entity = client.field_1687.method_8469(entityId);
            if (!(entity instanceof HamsterTreeSearcherEntity) || !(searcher = (HamsterTreeSearcherEntity)entity).method_5805()) {
                iterator.remove();
                continue;
            }
            long currentPosLong = searcher.method_24515().method_10063();
            if (currentPosLong == (lastPosLong = entry.getLongValue())) continue;
            entry.setValue(currentPosLong);
            this.startJiggle(currentPosLong, now, LeafJiggleManager.mixSeed(entityId, currentPosLong));
        }
        this.activeJiggles.values().removeIf(j -> now - j.startTick > 20L);
    }

    private void startJiggle(long posLong, long now, long seed) {
        this.activeJiggles.put(posLong, (Object)new Jiggle(now, seed));
    }

    public Collection<Long2ObjectMap.Entry<Jiggle>> getActiveJiggles() {
        return this.activeJiggles.long2ObjectEntrySet();
    }

    private static long mixSeed(int entityId, long posLong) {
        long x = posLong ^ (long)entityId * -7046029254386353131L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    public record Jiggle(long startTick, long seed) {
    }
}

