/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.state;

import java.util.EnumMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderHamsterState;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class ClientShoulderHamsterData {
    private static final float SPRING_STIFFNESS = 3.0f;
    private static final float DAMPING_FACTOR = 0.7f;
    private static final float BOUNCINESS_FACTOR = 1.7f;
    private static final float GRAVITY_FORCE = 0.2f;
    private static final float HAMSTER_MASS = 2.0f;
    private static final float FALL_DRAG_MULTIPLIER = 0.4f;
    private static final float SQUASH_STRETCH_INTENSITY = 5.0f;
    private static final float IMPACT_SQUASH_INTENSITY = 5.0f;
    private static final float IMPACT_SQUASH_DECAY = 0.4f;
    private final Map<ShoulderLocation, ShoulderHamsterState> hamsterStates = new EnumMap<ShoulderLocation, ShoulderHamsterState>(ShoulderLocation.class);
    private final Map<ShoulderLocation, Integer> animationAges = new EnumMap<ShoulderLocation, Integer>(ShoulderLocation.class);
    private final Map<ShoulderLocation, PhysicsState> physicsStates = new EnumMap<ShoulderLocation, PhysicsState>(ShoulderLocation.class);
    private double previousPlayerVelocityY = 0.0;
    private boolean wasPlayerOnGroundLastTick = true;
    private int landingCheckGracePeriod = 20;
    private int landingEventWindow = 0;

    public void clientTick(class_742 player) {
        boolean playerJustStartedJumping;
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        boolean bl = playerJustStartedJumping = this.wasPlayerOnGroundLastTick && !player.method_24828();
        if (playerJustStartedJumping) {
            AdorableHamsterPets.LOGGER.trace("[PHYSICS DEBUG] Player JUMP detected at tick {}. Previous Velocity Y: {}", (Object)player.method_37908().method_8510(), (Object)String.format("%.4f", this.previousPlayerVelocityY));
        }
        boolean playerJustLanded = false;
        if (this.landingCheckGracePeriod > 0) {
            --this.landingCheckGracePeriod;
        } else {
            boolean bl2 = playerJustLanded = !this.wasPlayerOnGroundLastTick && player.method_24828();
        }
        if (playerJustLanded) {
            this.landingEventWindow = 7;
            AdorableHamsterPets.LOGGER.trace("[PHYSICS DEBUG] Player LANDING detected. Opening 15-tick impact window.");
        }
        if (this.landingEventWindow > 0) {
            --this.landingEventWindow;
        }
        boolean isSprinting = player.method_5624();
        boolean isWalking = player.method_18798().method_37268() > 1.0E-7 && !isSprinting;
        double playerVelocityY = player.method_18798().field_1351;
        if (player.method_24828() && Math.abs(playerVelocityY) < 0.1) {
            playerVelocityY = 0.0;
        }
        double playerAccelerationY = playerVelocityY - this.previousPlayerVelocityY;
        int delay = 1;
        for (ShoulderLocation location : ShoulderLocation.values()) {
            class_2487 shoulderNbt;
            try {
                shoulderNbt = playerAccessor.getShoulderHamster(location);
            }
            catch (RuntimeException e) {
                continue;
            }
            if (!shoulderNbt.method_33133()) {
                ShoulderHamsterState state = this.hamsterStates.computeIfAbsent(location, l -> new ShoulderHamsterState());
                state.tick(isSprinting, isWalking);
                int currentAge = this.animationAges.getOrDefault((Object)location, 0);
                this.animationAges.put(location, currentAge + 1);
                PhysicsState physics = this.physicsStates.computeIfAbsent(location, l -> new PhysicsState());
                physics.previousOffsetY = physics.hamsterOffsetY;
                physics.previousScaleY = physics.hamsterScaleY;
                physics.impactSquashFactor = this.cosineInterpolate(physics.impactSquashFactor, 0.0f, 0.4f);
                if (physics.impactCooldown > 0) {
                    --physics.impactCooldown;
                }
                if (physics.jumpCooldown > 0) {
                    --physics.jumpCooldown;
                }
                if (playerJustStartedJumping) {
                    physics.jumpCooldown = 3;
                }
                float previousHamsterVelocityY = physics.hamsterVelocityY;
                float inertialForce = (float)(-playerVelocityY * 2.0);
                float springForce = -3.0f * physics.hamsterOffsetY;
                float dampingForce = -0.7f * physics.hamsterVelocityY;
                float gravityForce = -0.2f;
                float totalForce = inertialForce + springForce + dampingForce + gravityForce;
                float acceleration = totalForce / 2.0f;
                physics.hamsterVelocityY += acceleration;
                if (physics.hamsterVelocityY < 0.0f) {
                    physics.hamsterVelocityY *= 0.4f;
                }
                physics.hamsterOffsetY += physics.hamsterVelocityY;
                if (physics.hamsterOffsetY < 0.0f) {
                    if (this.landingEventWindow > 0 && physics.impactCooldown == 0 && physics.jumpCooldown == 0) {
                        physics.impactSquashFactor = Math.abs(physics.hamsterVelocityY) * 5.0f;
                        physics.soundDelayTicks = delay;
                        delay += player.method_59922().method_39332(1, 2);
                        physics.impactCooldown = 5;
                    }
                    physics.hamsterOffsetY = 0.0f;
                    physics.hamsterVelocityY *= -1.7f;
                }
                if (physics.soundDelayTicks > 0) {
                    --physics.soundDelayTicks;
                    if (physics.soundDelayTicks == 0) {
                        class_3414 impactSound;
                        boolean shouldPlaySound;
                        class_310 client = class_310.method_1551();
                        boolean bl3 = shouldPlaySound = !Configs.AHP.silencePhysicsSoundsInFirstPerson || !client.field_1690.method_31044().method_31034();
                        if (shouldPlaySound && (impactSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_IMPACT_SOUNDS, player.method_59922())) != null) {
                            client.method_1483().method_4873((class_1113)new class_1109(impactSound, class_3419.field_15248, 1.0f, 0.9f + player.method_59922().method_43057() * 0.2f, player.method_59922(), player.method_23317(), player.method_23318(), player.method_23321()));
                        }
                    }
                }
                if (physics.impactSquashFactor > 0.001f) {
                    AdorableHamsterPets.LOGGER.trace("[PHYSICS DEBUG]   -> Decaying impact squash for {}: {}", (Object)location, (Object)String.format("%.4f", Float.valueOf(physics.impactSquashFactor)));
                }
                float accelScale = 1.0f - (float)playerAccelerationY * 5.0f;
                float combinedTargetScale = accelScale - physics.impactSquashFactor;
                float clampedTargetScale = class_3532.method_15363((float)combinedTargetScale, (float)0.65f, (float)1.25f);
                physics.hamsterScaleY = this.cosineInterpolate(physics.hamsterScaleY, clampedTargetScale, 0.6f);
                continue;
            }
            this.hamsterStates.remove((Object)location);
            this.animationAges.remove((Object)location);
            this.physicsStates.remove((Object)location);
        }
        this.previousPlayerVelocityY = playerVelocityY;
        this.wasPlayerOnGroundLastTick = player.method_24828();
    }

    public float getRenderOffsetY(ShoulderLocation location, float partialTick) {
        PhysicsState state = this.physicsStates.get((Object)location);
        if (state == null) {
            return 0.0f;
        }
        return this.cosineInterpolate(state.previousOffsetY, state.hamsterOffsetY, partialTick);
    }

    public float getRenderScaleY(ShoulderLocation location, float partialTick) {
        PhysicsState state = this.physicsStates.get((Object)location);
        if (state == null) {
            return 1.0f;
        }
        return this.cosineInterpolate(state.previousScaleY, state.hamsterScaleY, partialTick);
    }

    private float cosineInterpolate(float start, float end, float delta) {
        float transition = (1.0f - (float)Math.cos((double)delta * Math.PI)) * 0.5f;
        return start + transition * (end - start);
    }

    @Nullable
    public ShoulderHamsterState getHamsterState(ShoulderLocation location) {
        return this.hamsterStates.get((Object)location);
    }

    public int getAnimationAge(ShoulderLocation location) {
        return this.animationAges.getOrDefault((Object)location, 0);
    }

    public static class PhysicsState {
        public float hamsterOffsetY = 0.0f;
        public float previousOffsetY = 0.0f;
        public float hamsterVelocityY = 0.0f;
        public float hamsterScaleY = 1.0f;
        public float previousScaleY = 1.0f;
        public float impactSquashFactor = 0.0f;
        public int soundDelayTicks = 0;
        public int impactCooldown = 0;
        public int jumpCooldown = 0;
    }
}

