/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.config;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.fzzyhmstrs.fzzy_config.annotations.NonSync;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigAction;
import me.fzzyhmstrs.fzzy_config.config.ConfigGroup;
import me.fzzyhmstrs.fzzy_config.screen.widget.TextureIds;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import me.fzzyhmstrs.fzzy_config.validation.ValidatedField;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedAny;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedCondition;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedEnum;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.config.ForcedShoulderState;
import net.dawson.adorablehamsterpets.config.IconPositionPreset;
import net.dawson.adorablehamsterpets.config.MountPriority;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.networking.payload.RequestGuidebookPayload;
import net.dawson.adorablehamsterpets.networking.payload.ResetHeistHistoryPayload;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;

@Translation(prefix="adorablehamsterpets.main")
@Translatable.Name(value="Main Settings")
@Translatable.Desc(value="The command center for rodent-based chaos. Tweak physics, nerf cheese, and generally play god with small furry creatures.")
public class AhpConfig
extends Config {
    @Translatable.Name(value="Help & Other Distractions")
    @Translatable.Desc(value="Buttons for when you\u2019re lost, bored, or met a bug that\u2019s not just existential hamster angst.")
    public ConfigGroup helpAndResources = new ConfigGroup("helpAndResources", false);
    @NonSync
    @Translatable.Name(value="I Lost My Book!")
    public ConfigAction giveGuideBook = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.giveGuideBook")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.giveGuideBook.desc")).decoration(TextureIds.INSTANCE.getDECO_BOOK()).build(() -> NetworkManager.sendToServer((class_8710)new RequestGuidebookPayload()));
    @NonSync
    @Translatable.Name(value="Report a Bug")
    public ConfigAction reportBug = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.reportBug")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.reportBug.desc")).decoration(TextureIds.INSTANCE.getDECO_LINK()).build(new class_2558(class_2558.class_2559.field_11749, "https://github.com/DawsonBodenhamer/AdorableHamsterPets-Public/issues"));
    @NonSync
    @Translatable.Name(value="Join Discord")
    public ConfigAction joinDiscord = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.joinDiscord")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.joinDiscord.desc")).decoration(TextureIds.INSTANCE.getDECO_BUTTON_CLICK()).build(new class_2558(class_2558.class_2559.field_11749, "https://discord.gg/w54mk5bqdf"));
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Visit My Website")
    public ConfigAction visitWebsite = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.visitWebsite")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.helpAndResources.visitWebsite.desc")).decoration(TextureIds.INSTANCE.getDECO_LINK()).build(new class_2558(class_2558.class_2559.field_11749, "https://www.fortheking.design"));
    @Translatable.Name(value="UI & Quality of Life")
    @Translatable.Desc(value="Because Sanity is Overrated")
    public ConfigGroup uiPreferences = new ConfigGroup("uiPreferences", true);
    @Translatable.Name(value="Guidebook Settings")
    @Translatable.Desc(value="Settings related to the 'Hamster Tips' guide book and how aggressively I nag you about it.")
    public ConfigGroup guidebookSettings = new ConfigGroup("guidebookSettings", true);
    @NonSync
    @Translatable.Name(value="Auto Guidebook Delivery")
    @Translatable.Desc(value="Hand-delivers the sacred texts on first login.")
    public boolean enableAutoGuidebookDelivery = true;
    @NonSync
    @Translatable.Name(value="Seen Warning Players")
    @Translatable.Desc(value="A list of UUIDs for players who have already seen the missing guidebook warning. Ensures that everyone sees this, but only once unless you delete your name from this list.")
    public List<String> playersWhoHaveSeenGuidebookWarning = new ArrayList<String>();
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Warning Timer")
    @Translatable.Desc(value="How long (in ticks) I wait before realizing you're book-less and panicking. 3600 = 3 minutes.")
    public ValidatedInt guidebookWarningTimer = new ValidatedInt(3600, 6000, 100);
    @NonSync
    @Translatable.Name(value="Mod Item Tooltips")
    @Translatable.Desc(value="Helpful whispers on what the heck that cucumber is for.")
    public boolean enableItemTooltips = true;
    @NonSync
    @Translatable.Name(value="Shoulder Dismount Messages")
    @Translatable.Desc(value="Little status mumbles when your co-pilot disembarks.")
    public boolean enableShoulderDismountMessages = true;
    @NonSync
    @Translatable.Name(value="Jade Hamster Debug Info")
    @Translatable.Desc(value="More stats than anyone asked for. Defaults to off\u2014 mercifully.")
    public boolean enableJadeHamsterDebugInfo = false;
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Action Bar Duration")
    @Translatable.Desc(value="The duration (in ticks) that action bar messages stay on screen. Only affects your personal computer. Vanilla is 60 (3 seconds), which is barely enough time to realize you're reading. Crank this up to savor the text. (20 ticks = 1 second).")
    public ValidatedInt actionBarDuration = new ValidatedInt(100, 300, 40);
    @Translatable.Name(value="Announcements & Update Notes")
    @Translatable.Desc(value="Tweak the little bell icon that appears when I have something important to tell you. Or turn if off if you hate fun.")
    public ConfigGroup announcements = new ConfigGroup("announcements", true);
    @NonSync
    @Translatable.Name(value="Enable Announcements")
    @Translatable.Desc(value="The master switch for all announcement notifications. Turning this off is the same as clicking 'Disable All' in the announcement screen. Announcements can still be viewed in the \u00a7f\u00a7lHamster Tips\u00a7r guide book.")
    public ValidatedBoolean enableNotificationIcons = new ValidatedBoolean(true);
    private boolean updatingAnnouncementToggles = false;
    @NonSync
    @Translatable.Name(value="Mark All as Read")
    public ConfigAction markAllAsRead = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.announcements.markAllAsRead")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.announcements.markAllAsRead.desc")).decoration(TextureIds.INSTANCE.getADD()).build(() -> {
        AnnouncementManager.INSTANCE.markAllAsRead();
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.announcements_marked_read").method_27692(class_124.field_1068), false);
        }
    });
    @NonSync
    @Translatable.Name(value="Announcement History")
    public ConfigAction resetAllAnnouncementDismissals = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.announcements.resetAllAnnouncementDismissals")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.announcements.resetAllAnnouncementDismissals.desc")).decoration(TextureIds.INSTANCE.getRESTORE()).build(() -> {
        AnnouncementManager.INSTANCE.resetClientState();
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.announcements_reset").method_27692(class_124.field_1068), false);
        }
    });
    @NonSync
    @Translatable.Name(value="Snooze Timer (Days)")
    @Translatable.Desc(value="For when you see the update notification and think, 'That's a problem for future me.' Future you will be so proud. This is where you select many days to hide the 'Update Available' notification when you click 'Remind Me Later'.")
    public ValidatedInt snoozeUpdateReminderDays = new ValidatedInt(5, 14, 1);
    @NonSync
    @Translatable.Name(value="HUD Icon Settings")
    @Translatable.Desc(value="Options for the little bell with hamster ears that just hangs out in the corner of your screen when notifications are pending.")
    public ConfigGroup hudIconSettings = new ConfigGroup("hudIconSettings", true);
    @NonSync
    @Translatable.Name(value="Enable HUD Icon")
    @Translatable.Desc(value="Decide if the bell haunts you full-time on the HUD or only ambushes you when you're trying to organize your inventory. If disabled, you will only see notifications when you open an inventory.")
    public ValidatedBoolean enableHudIcon = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> isHudIconEnabled = this.enableHudIcon.map(b -> b, b -> b);
    @NonSync
    @Translatable.Name(value="HUD Icon Position Preset")
    @Translatable.Desc(value="Banish the bell to a corner of your choosing. It's your screen. Establish dominance.")
    public ValidatedCondition<IconPositionPreset> hudIconPositionPreset = new ValidatedEnum((Enum)IconPositionPreset.TOP_LEFT).toCondition(this.isHudIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.hud_icon_enabled"), () -> IconPositionPreset.TOP_LEFT);
    @NonSync
    @Translatable.Name(value="HUD Icon Offset X")
    @Translatable.Desc(value="Shove the icon horizontally. For when 'top-left' isn't specific enough for your discerning taste.")
    public ValidatedCondition<Integer> hudIconOffsetX = new ValidatedInt(10, 500, -500).toCondition(this.isHudIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.hud_icon_enabled"), () -> 10);
    @NonSync
    @Translatable.Name(value="HUD Icon Offset Y")
    @Translatable.Desc(value="Adjust the vertical placement. Does it block your view? Is it not blocking your view enough? The power is yours.")
    public ValidatedCondition<Integer> hudIconOffsetY = new ValidatedInt(10, 500, -500).toCondition(this.isHudIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.hud_icon_enabled"), () -> 10);
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="HUD Icon Scale")
    @Translatable.Desc(value="Make it bigger. Make it smaller. Make it an affront to good taste. I'm not your art director.")
    public ValidatedCondition<Float> hudIconScale = new ValidatedFloat(1.0f, 3.0f, 0.5f).toCondition(this.isHudIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.hud_icon_enabled"), () -> Float.valueOf(1.0f));
    @NonSync
    @Translatable.Name(value="Widget Icon Settings")
    @Translatable.Desc(value="Configure the bell with hamster ears that haunts the corners of your inventory screens.")
    public ConfigGroup widgetIconSettings = new ConfigGroup("widgetIconSettings", true);
    @NonSync
    @Translatable.Name(value="Enable GUI Widget Icon")
    @Translatable.Desc(value="Decide if the bell icon should ambush you while you're sorting your inventory. If disabled, it will only bother you on the main menu or the game HUD if you have those enabled. Your screen, your rules.")
    public ValidatedBoolean enableWidgetIcon = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> isWidgetIconEnabled = this.enableWidgetIcon.map(b -> b, b -> b);
    @NonSync
    @Translatable.Name(value="Survival Inventory")
    @Translatable.Desc(value="Control the icon's placement for standard GUIs. Because nothing says 'immersion' like a perfectly aligned notification bell. Position is relative to the GUI's top-right corner.")
    public ValidatedCondition<WidgetIconOffsets> survivalWidgetIconSettings = new ValidatedAny((Object)new WidgetIconOffsets()).toCondition(this.isWidgetIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.widget_icon_enabled"), WidgetIconOffsets::new);
    @NonSync
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Creative Inventory")
    @Translatable.Desc(value="Control the icon's placement for the creative mode GUI. Because nothing says 'immersion' like a perfectly aligned notification bell. Position is relative to the GUI's top-right corner.")
    public ValidatedCondition<WidgetIconOffsets> creativeWidgetIconSettings = new ValidatedAny((Object)new WidgetIconOffsets()).toCondition(this.isWidgetIconEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.widget_icon_enabled"), WidgetIconOffsets::new);
    @Translatable.Name(value="Falling Leaf Settings")
    @Translatable.Desc(value="Here's where you tweak the behavior of the floaty leaf particles spawned from Hamster Bedding. Didn't know you could spawn particles from Hamster Bedding? Try to keep up.")
    public ConfigGroup particleEffects = new ConfigGroup("particleEffects", true);
    @NonSync
    @Translatable.Name(value="Gust Volume")
    @Translatable.Desc(value="How loud the wind gust sound effect is, for you overachievers who are running 15 different sound physics mods. 1.0 is default, 0.0 is silent.")
    public ValidatedFloat leafGustVolume = new ValidatedFloat(0.3f, 3.0f, 0.0f);
    @NonSync
    @Translatable.Name(value="Dynamic Drift")
    @Translatable.Desc(value="Should the gentle, drift of Hamster Bedding leaf particles slowly change direction over time? If true, it's a slow, majestic rotation. (It takes a bout 3 minutes to make a full 360 degree rotation). If false, you get to pick a static wind direction below.")
    public ValidatedBoolean enableDynamicDriftAngle = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> isDynamicDriftDisabled = this.enableDynamicDriftAngle.map(value -> value == false, value -> value == false);
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Static Drift Angle")
    @Translatable.Desc(value="Set a fixed direction for the universal leaf drift (0-360 degrees). 0 = South, 90 = West, 180 = North, 270 = East. Or just slide it until it looks cool. Whatever. Only works if 'Dynamic Drift' is off.")
    public ValidatedCondition<Integer> staticDriftAngle = new ValidatedInt(0, 360, 0).toCondition(this.isDynamicDriftDisabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.dynamic_drift_off"), () -> 0);
    @Translatable.Name(value="Core Feature Toggles")
    @Translatable.Desc(value="Fundamental hamster hijinks\u2014 fiddle at your own risk.")
    public ConfigGroup core = new ConfigGroup("core", true);
    @Translatable.Name(value="Enable Hamster Throwing")
    @Translatable.Desc(value="Do we yeet the hamster? ('G' by default).")
    public boolean enableHamsterThrowing = true;
    @Translatable.Name(value="Enable Wander Mode")
    @Translatable.Desc(value="For when you need some personal space. Allows tamed hamsters to be linked to a Hamster Bed, letting them wander freely within a set radius instead of clinging to you like melted duct-tape. You're welcome.")
    public ValidatedBoolean enableWanderMode = new ValidatedBoolean(true);
    @Translatable.Name(value="Enable Armor Perks")
    @Translatable.Desc(value="If true, upgraded armor grants special perks. If false (because you hate fun?), armor acts only as a damage shield/visual. Each perk can also be individually configured in 'Armor Settings.'")
    public ValidatedBoolean enableArmorPerks = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> areArmorPerksEnabled = this.enableArmorPerks.map(b -> b, b -> b);
    @Translatable.Name(value="Disable Wild Loot Drops")
    @Translatable.Desc(value="If true, wild hamsters take their cheek-treasures to the grave. Prevents players from creating 'ethical' hamster recycling farms for seeds and nuggets.")
    public boolean disableWildLootDrops = false;
    @Translatable.Name(value="Require Food Mix to Unlock Cheeks")
    @Translatable.Desc(value="Gate cheek-pouch storage behind gourmet cuisine, because drama.")
    public boolean requireFoodMixToUnlockCheeks = true;
    @Translatable.Name(value="Use 'Hampter' as Default Name")
    @Translatable.Desc(value="Changes the default entity name from 'Hamster' to 'Hampter'. Note: This has no visible effect in vanilla Minecraft, as mobs don't show nameplates by default. It's primarily for use with mods like Auto Leveling that display entity names.")
    public boolean useHampterName = false;
    @Translatable.Name(value="Mob Interactions")
    @Translatable.Desc(value="Configure how hamsters interact with (or terrify) other creatures.")
    public ConfigGroup mobInteractions = new ConfigGroup("mobInteractions", true);
    @Translatable.Name(value="Frighten Ravagers")
    @Translatable.Desc(value="Should Ravagers, the hulking beasts of destruction, flee in terror from a tiny ball of fluff? Yes. Yes, they should.")
    public boolean enableRavagerFlee = true;
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Frighten Spiders")
    @Translatable.Desc(value="Turns your hamster into a mobile arachnid-repellent unit. Highly effective.")
    public boolean enableSpiderFlee = true;
    @Translatable.Name(value="Core Cooldown Settings")
    @Translatable.Desc(value="Mandatory hamster union breaks between heroic stunts.")
    public ConfigGroup cooldowns = new ConfigGroup("cooldowns", true);
    @Translatable.Name(value="Cleaning Frequency")
    @Translatable.Desc(value="How often a sitting hamster gets the sudden urge to clean. It's a 1-in-X chance per tick, so lower numbers mean a higher chance for cleaning. For example, 1200 means on average, it'll clean about once a minute. 300 \u2248 every 15 secs, and 5000 \u2248 every 4 mins. Congratulations\u2014 now you know enough to be dangerous.")
    public ValidatedInt cleaningChanceDenominator = new ValidatedInt(1200, 5000, 300);
    @Translatable.Name(value="Throw Cooldown")
    @Translatable.Desc(value="Time-out after using your living projectile. (20 ticks = 1 second)")
    public ValidatedInt hamsterThrowCooldown = new ValidatedInt(2400, 12000, 20);
    @Translatable.Name(value="Green Bean Buff Cooldown")
    @Translatable.Desc(value="When the sugar rush ends, force a breather. (20 ticks = 1 second)")
    public ValidatedInt steamedGreenBeansBuffCooldown = new ValidatedInt(6000, 12000, 20);
    @Translatable.Name(value="Diamond Seeking Cooldown")
    @Translatable.Desc(value="Force a cool-down after striking it rich. Off by default, since this can't happen again anyway without another mount/dismount on the shoulder.")
    public boolean enableIndependentDiamondSeekCooldown = false;
    @Translatable.Name(value="Diamond Seeking Cooldown")
    @Translatable.Desc(value="Cooldown before your hamster can go on another treasure hunt. (20 ticks = 1 second)")
    public ValidatedInt independentOreSeekCooldownTicks = new ValidatedInt(2400, 6000, 20);
    @Translatable.Name(value="Item Thievery Cooldown")
    @Translatable.Desc(value="Mandatory time-out after a successful heist to prevent serial kleptomania. (20 ticks = 1s). WARNING: Increasing this cooldown can dramatically change the item stealing mechanic, since that AI goal sometimes re-runs multiple times in a row when the hamster has trouble pathfinding to the item that it wants to steal. So instead of increasing this, you should probably just stop dropping your diamonds on the ground everywhere, butter fingers.")
    public ValidatedInt stealCooldownTicks = new ValidatedInt(100, 6000, 20);
    @ConfigGroup.Pop
    @Translatable.Name(value="Breeding Cooldown")
    @Translatable.Desc(value="Hamsters need their space. (20 ticks = 1 second)")
    public ValidatedInt breedingCooldownTicks = new ValidatedInt(6000, 24000, 600);
    @Translatable.Name(value="Core Item Tag Overrides")
    @Translatable.Desc(value="For the advanced user who looks at a perfectly functional system and thinks, 'I can make this weirder.' Edit these lists to change what items your hamsters consider food, bait, treasure, and all other interactions. Use item IDs (e.g., 'minecraft:diamond') or tags (e.g., '#minecraft:fishes'). Mess it up? That's a you problem.")
    public ConfigGroup itemTags = new ConfigGroup("itemTags", true);
    @Translatable.Name(value="Taming Baits")
    @Translatable.Desc(value="The official list of bribes for convincing wild fluffballs to join your cause. By default, it's just sliced cucumbers. Feel free to add 'minecraft:nether_star' if you enjoy making poor life choices. Compatible with Cultural Delights by default!")
    public List<String> tamingFoods = new ArrayList<String>(List.of("adorablehamsterpets:sliced_cucumber", "culturaldelights:cut_cucumber"));
    @Translatable.Name(value="Standard Diet")
    @Translatable.Desc(value="The hamster's everyday menu. These items will heal them or, if they're at full health, might give them... ideas about starting a family. Don't make it weird.")
    public List<String> standardFoods = new ArrayList<String>(List.of("adorablehamsterpets:hamster_food_mix", "adorablehamsterpets:sunflower_seeds", "adorablehamsterpets:green_beans", "adorablehamsterpets:cucumber", "adorablehamsterpets:green_bean_seeds", "adorablehamsterpets:cucumber_seeds", "minecraft:apple", "minecraft:carrot", "minecraft:melon_slice", "minecraft:sweet_berries", "minecraft:beetroot", "minecraft:wheat", "minecraft:wheat_seeds", "farmersdelight:cabbage_leaf", "farmersdelight:cabbage_seeds", "farmersdelight:tomato_seeds", "farmersdelight:cooked_rice", "farmersdelight:pumpkin_slice", "culturaldelights:cut_cucumber", "culturaldelights:cucumber_seeds", "culturaldelights:corn_kernels"));
    @Translatable.Name(value="High-Value Heistables")
    @Translatable.Desc(value="The list of items a hamster might try to... 'borrow' if you leave them on the ground. A chase will ensue. You have been warned.")
    public List<String> stealableItems = new ArrayList<String>(List.of("minecraft:diamond"));
    @Translatable.Name(value="Retrievable Items")
    @Translatable.Desc(value="Items the hamster views as gifts or toys to bring back to you. Picking these up triggers Delivery Mode. Default: Acorns.")
    public List<String> retrievableItems = new ArrayList<String>(List.of("adorablehamsterpets:acorn"));
    @Translatable.Name(value="Performance-Enhancers")
    @Translatable.Desc(value="The list of questionable substances that grant your hamster temporary superpowers. By default, it's just steamed green beans.")
    public List<String> buffFoods = new ArrayList<String>(List.of("adorablehamsterpets:steamed_green_beans"));
    @Translatable.Name(value="Lure Items")
    @Translatable.Desc(value="The specific items that convince a tamed hamster your shoulder is the best seat in the house. Also acts as a bribe to lure them into their linked bed. Defaults to cheese, because of course it does.")
    public List<String> lureItems = new ArrayList<String>(List.of("adorablehamsterpets:cheese"));
    @Translatable.Name(value="Rodent Repellent")
    @Translatable.Desc(value="The list of specific items that, when used on a Hamster Bed, will set 'Wander Mode Settings > Allow Sleeping in Bed' to false. For when you need your hamster to stay awake and wander around for... reasons. This can be reversed by using a lure item (cheese by default) on the bed. Sneaking before right-clicking with this item will unlink the bed entirely.")
    public List<String> bedAvoidanceFoods = new ArrayList<String>(List.of("minecraft:rotten_flesh"));
    @Translatable.Name(value="Cheek Pouch Keys")
    @Translatable.Desc(value="The one-time offering required to earn a hamster's ultimate trust, unlocking their cheek inventory. Make it something special. Or don't. See if I care.")
    public List<String> pouchUnlockFoods = new ArrayList<String>(List.of("adorablehamsterpets:hamster_food_mix"));
    @Translatable.Name(value="Picky Eater Solutions")
    @Translatable.Desc(value="Items on this list are so delicious, your hamster will never refuse them, even if you feed it to them twice. For the truly spoiled rodent.")
    public List<String> repeatableFoods = new ArrayList<String>(List.of("adorablehamsterpets:hamster_food_mix", "adorablehamsterpets:steamed_green_beans"));
    @Translatable.Name(value="Passively Munchable Snacks")
    @Translatable.Desc(value="The specific items a hamster will eat directly from its cheek pouch to heal itself when injured. Keep it exclusive, or let them feast on enchanted apples. Your call.")
    public List<String> autoHealFoods = new ArrayList<String>(List.of("adorablehamsterpets:hamster_food_mix"));
    @Translatable.Name(value="Cheek Pouch Smuggling List")
    @Translatable.Desc(value="Fine-tune exactly what your hamster is (and isn't) allowed to carry. The 'Allowed' list acts as a high-priority override to the 'Disallowed' lists and general rules.")
    public ConfigGroup pouchRestrictions = new ConfigGroup("pouchRestrictions", true);
    @Translatable.Name(value="Allowed Items")
    @Translatable.Desc(value="A specific list of items and tags that are allowed in the hamster's cheek pouch. You can add things to this list to bypass the default 'no tools or big blocks' rule, since this overrides the 'disallowed' settings.")
    public List<String> pouchAllowedItems = new ArrayList<String>(List.of("minecraft:torch", "minecraft:soul_torch", "minecraft:redstone_torch", "minecraft:repeater", "minecraft:comparator", "minecraft:lever", "#minecraft:buttons", "#minecraft:pressure_plates", "minecraft:beetroot_seeds", "minecraft:pumpkin_seeds", "minecraft:melon_seeds", "minecraft:pitcher_pod", "minecraft:torchflower_seeds", "#c:seeds", "#forge:seeds"));
    @Translatable.Name(value="Pouch Disallowed Items")
    @Translatable.Desc(value="A list of specific item IDs that are NEVER allowed in the cheek pouch, unless they are on the 'Allowed' list above. Mostly stuff that's too big, too pointy, or just plain illogical. Lol.")
    public List<String> pouchDisallowedItems = new ArrayList<String>(List.of("minecraft:bow", "minecraft:crossbow", "minecraft:trident", "minecraft:fishing_rod", "minecraft:shield", "minecraft:elytra", "minecraft:turtle_helmet", "minecraft:carved_pumpkin", "minecraft:player_head", "minecraft:zombie_head", "minecraft:skeleton_skull", "minecraft:wither_skeleton_skull", "minecraft:creeper_head", "minecraft:dragon_head", "minecraft:piglin_head", "minecraft:minecart", "minecraft:chest_minecart", "minecraft:furnace_minecart", "minecraft:tnt_minecart", "minecraft:hopper_minecart", "minecraft:command_block_minecart", "minecraft:saddle", "minecraft:bucket", "minecraft:water_bucket", "minecraft:lava_bucket", "minecraft:milk_bucket", "minecraft:powder_snow_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket", "minecraft:cod_bucket", "minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:tropical_fish_bucket", "minecraft:item_frame", "minecraft:glow_item_frame", "minecraft:painting", "minecraft:armor_stand", "minecraft:end_crystal", "minecraft:spyglass", "minecraft:nether_star", "minecraft:dragon_egg", "minecraft:bundle"));
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Pouch Disallowed Tags")
    @Translatable.Desc(value="A list of item tags that are NEVER allowed in the cheek pouch, unless they are on the 'Allowed' list above. A broad-spectrum approach to preventing your hamster from swallowing an entire sword.")
    public List<String> pouchDisallowedTags = new ArrayList<String>(List.of("#minecraft:axes", "#minecraft:hoes", "#minecraft:pickaxes", "#minecraft:shovels", "#minecraft:swords", "#minecraft:trimmable_armor", "#minecraft:beds", "#minecraft:banners", "#minecraft:doors", "#minecraft:boats"));
    @Translatable.Name(value="Core Hamster Attributes")
    @Translatable.Desc(value="All the knobs and dials that make your hamster the majestic (or chaotic) creature it is.")
    public ConfigGroup hamsterAttributes = new ConfigGroup("hamsterAttributes", true);
    @Translatable.Name(value="Max Health (Wild)")
    @Translatable.Desc(value="How much abuse a wild hamster can take before it gives up the ghost. Vanilla animals are around 8-10. Set it to 200 (100 hearts) if you enjoy a challenge, or 1 if you're a monster.")
    public ValidatedDouble wildMaxHealth = new ValidatedDouble(8.0, 200.0, 1.0);
    @Translatable.Name(value="Max Health (Tamed)")
    @Translatable.Desc(value="How beefy your tamed fuzzball is. Defaults to double its wild health, because love makes you stronger. Or something. Vanilla wolves have 20 (10 hearts).")
    public ValidatedDouble tamedMaxHealth = new ValidatedDouble(16.0, 200.0, 1.0);
    @Translatable.Name(value="Wander Interval")
    @Translatable.Desc(value="Controls how frequently your hamster feels the urge to walk around. The higher the number, the lazier the hamster (1 in X chance to wander per tick; 20 ticks = 1 second). Set to 0 to disable wandering entirely\u2014 perfect for keeping them still for photoshoots or interrogation. Vanilla's default chance for Wolves is 1 in 120 ticks.")
    public ValidatedInt wanderInterval = new ValidatedInt(110, 10000, 0);
    @Translatable.Name(value="Look-At Duration")
    @Translatable.Desc(value="The minimum time (in ticks) your hamster stares into your soul. Actual duration = this value + a random extra 0 to 4 seconds. Default is 40. Increase to simulate deep contemplation (or emptiness).")
    public ValidatedInt lookAtDuration = new ValidatedInt(20, 600, 20);
    @Translatable.Name(value="Taming Chance")
    @Translatable.Desc(value="Convince a hamster to love you. Taming difficulty (1 in X chance). Higher = more cucumbers sacrificed to fuzzy freeloaders.")
    public ValidatedInt tamingChanceDenominator = new ValidatedInt(3, 20, 1);
    @Translatable.Name(value="Melee Damage")
    @Translatable.Desc(value="Tamed hamster melee damage. Squeak-first, ask questions later.")
    public ValidatedDouble meleeDamage = new ValidatedDouble(2.0, 40.0, 0.0);
    @ConfigGroup.Pop
    @Translatable.Name(value="Throw Damage")
    @Translatable.Desc(value="Damage dealt by thrown hamster. Surprisingly effective against Creepers. How convenient.")
    public ValidatedDouble hamsterThrowDamage = new ValidatedDouble(20.0, 40.0, 0.0);
    @Translatable.Name(value="Armor Settings")
    @Translatable.Desc(value="Here's where you make armor OP. Or turn it off. See if I care.")
    public ConfigGroup armorSettings = new ConfigGroup("armorSettings", true);
    @Translatable.Name(value="Armor Perks")
    @Translatable.Desc(value="Configure the buffs provided by specific armor materials. For Diamond armor perk configuration, remove or add items to the 'Retrievable Items' list in 'Core Item Tag Overrides.'")
    public ConfigGroup armorPerks = new ConfigGroup("armorPerks", true);
    @Translatable.Name(value="Iron")
    @Translatable.Desc(value="Aerodynamics provided by smooth Iron plating. Adds 0.5 to the throw velocity, which is 1.5 by default or 2.5 when under the influence of Steamed Green Beans.")
    public ValidatedCondition<Double> ironArmorThrowSpeedBoost = new ValidatedDouble(0.5, 5.0, 0.0).toCondition(this.areArmorPerksEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.armor_perks_enabled"), () -> 0.0);
    @Translatable.Name(value="Gold")
    @Translatable.Desc(value="The zoom factor provided by Gold Armor. Because flimsier things go faster. Obviously. (+0.20 = +20% Speed)")
    public ValidatedCondition<Double> goldArmorSpeedBoost = new ValidatedDouble(0.2, 2.0, 0.0).toCondition(this.areArmorPerksEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.armor_perks_enabled"), () -> 0.0);
    @Translatable.Name(value="Netherite")
    @Translatable.Desc(value="Configure the individual netherite buffs.")
    public ConfigGroup netheritePerks = new ConfigGroup("netheritePerks", true);
    @Translatable.Name(value="Knockback Resistance")
    @Translatable.Desc(value="The 'Immovable Object' density factor. 0.5 is 50% resistance. 1.0 makes them a neutron star.")
    public ValidatedCondition<Double> netheriteArmorKnockbackResist = new ValidatedDouble(0.5, 1.0, 0.0).toCondition(this.areArmorPerksEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.armor_perks_enabled"), () -> 0.0);
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Throw Damage")
    @Translatable.Desc(value="Heavy things hit harder. Adds this much flat damage to the projectile impact. (1 = 0.5 hearts)")
    public ValidatedCondition<Double> netheriteArmorThrowDamageBonus = new ValidatedDouble(10.0, 100.0, 0.0).toCondition(this.areArmorPerksEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.armor_perks_enabled"), () -> 0.0);
    @NonSync
    @Translatable.Name(value="Enable Armor Visuals")
    @Translatable.Desc(value="Master switch for armor rendering. If false, hamsters will appear unarmored even when equipped. Useful if you prefer the natural look but still want the protection.")
    public boolean enableArmorVisuals = true;
    private final ValidatedField<Boolean> isArmorVisualsEnabled = new ValidatedBoolean(true).map(b -> b, b -> this.enableArmorVisuals);
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Render Acorn Hat")
    @Translatable.Desc(value="Determines whether you are able to see the jaunty little Acorn Hat when hamsters are wearing the base Acorn Armor. Does not affect what other players see, and does not apply to the standalone Acorn Hat accessory.")
    public ValidatedCondition<Boolean> renderAcornHat = new ValidatedBoolean(true).toCondition(this.isArmorVisualsEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.armor_visuals_enabled"), () -> false);
    @Translatable.Name(value="Tree Heist Settings")
    @Translatable.Desc(value="Configure the acorn-gathering operations.")
    public ConfigGroup treeHeist = new ConfigGroup("treeHeist", true);
    @Translatable.Name(value="Acorn Drop Chance")
    @Translatable.Desc(value="The likelihood (0.0 to 1.0) of an acorn dropping each time your hamster rummages. Default is very low at 0.03 (3%), because the hamster rummages roughly ~5 times per second. Crank it up if you want to crash the local squirrel economy. (Maximum output is 1 acorn per second even if you turn it all the way up).")
    public ValidatedFloat acornDropChance = new ValidatedFloat(0.03f, 1.0f, 0.0f);
    @NonSync
    @Translatable.Name(value="Show Start Message")
    @Translatable.Desc(value="Whether to show an action bar message when a Tree Heist begins.")
    public boolean enableTreeHeistStartMessage = true;
    @NonSync
    @Translatable.Name(value="Reset History")
    public ConfigAction resetHeistHistory = new ConfigAction.Builder().title((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.treeHeist.resetHeistHistory")).desc((class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.main.treeHeist.resetHeistHistory.desc")).decoration(TextureIds.INSTANCE.getRESTORE()).build(() -> NetworkManager.sendToServer((class_8710)new ResetHeistHistoryPayload()));
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Debug Mode")
    @Translatable.Desc(value="Shows visual particles for the detected Tree ID (the lowest block of the trunk) and leaf canopy during a heist, and turns on extra logging in the console. Useful for seeing exactly which tree your hamster is searching and/or debugging if things are being weird.")
    public boolean debugTreeDetection = false;
    @Translatable.Name(value="Bed & Wander Mode Settings")
    @Translatable.Desc(value="For when 'following you into lava' is no longer a desirable trait. Tweak the settings for your hamster's newfound, bed-based independence.")
    public ConfigGroup wanderMode = new ConfigGroup("wanderMode", true);
    @Translatable.Name(value="Enable Respawn in Bed")
    @Translatable.Desc(value="The Master Switch. Affects all Hamster Beds. If true, hamsters linked to a bed can be resurrected there. Cheating? Maybe. Convenient? Absolutely.")
    public ValidatedBoolean enableRespawnInBed = new ValidatedBoolean(false);
    @Translatable.Name(value="Resurrection Tributes")
    @Translatable.Desc(value="The specific items accepted by the Hamster Bed to enable the Respawn Protocol. Defaults to the Totem of Undying, because immortality isn't cheap. Accepts item IDs (e.g. 'minecraft:totem_of_undying') or tags.")
    public List<String> resurrectionTributes = new ArrayList<String>(List.of("minecraft:totem_of_undying"));
    @Translatable.Name(value="Avoid Unlinked Beds")
    @Translatable.Desc(value="Should hamsters treat other hamsters' beds as sacred ground? If true, they'll try to politely path around them, but they will only try a few alternate paths before their tiny rodent-patience runs out. If false, they'll trample wherever they please.")
    public boolean avoidUnlinkedBeds = true;
    @Translatable.Name(value="Default Wander Distance")
    @Translatable.Desc(value="The initial wander distance set when a hamster is first linked to a bed. It defaults to medium, because that is the universally accepted starting point for all life choices.")
    public ValidatedEnum<WanderDistance> defaultWanderDistance = new ValidatedEnum((Enum)WanderDistance.MEDIUM);
    @Translatable.Name(value="Distance: Near")
    @Translatable.Desc(value="The radius (in blocks) for the 'Near' wander distance setting. For the clingy hamster who wants freedom, but not too much.")
    public ValidatedInt wanderDistanceNear = new ValidatedInt(8, 64, 1);
    @Translatable.Name(value="Distance: Medium")
    @Translatable.Desc(value="The radius (in blocks) for the 'Medium' wander distance setting. A respectable distance. Not too close, not too far. Perfectly balanced, as all things should be.")
    public ValidatedInt wanderDistanceMedium = new ValidatedInt(16, 64, 1);
    @Translatable.Name(value="Distance: Far")
    @Translatable.Desc(value="The radius (in blocks) for the 'Far' wander distance setting. For the adventurous hamster who might send you a postcard someday. Maybe.")
    public ValidatedInt wanderDistanceFar = new ValidatedInt(32, 64, 1);
    @Translatable.Name(value="Bed Break Notification")
    @Translatable.Desc(value="Get an action bar message when your hamster's bed is broken. Here's where you can turn it off if you prefer... complete immersion.")
    public boolean enableBedBreakMessage = true;
    @Translatable.Name(value="Allow Sleeping in Bed")
    @Translatable.Desc(value="The global override for whether hamsters can sleep in their beds. If enabled, all hamsters in wander mode will seek out their bed to sleep at specific times, regardless of individual bed settings. If disabled, they'll just pass out when sitting, like your old uncle at family gatherings.")
    public ValidatedBoolean allowSleepInBed = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> isSleepInBedAllowed = this.allowSleepInBed.map(b -> b, b -> b);
    @Translatable.Name(value="Circadian Chaos")
    @Translatable.Desc(value="Tired of your hamsters adhering to the rigid tyranny of the day/night cycle? Enable this for a more... unpredictable napping schedule. When enabled, this will override the 'Sleep During the Day' setting.")
    public ValidatedCondition<Boolean> circadianChaos = new ValidatedBoolean(false).toCondition(this.isSleepInBedAllowed, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.sleep_in_bed_allowed"), () -> false);
    private final ValidatedField<Boolean> isCircadianChaosEnabled = this.circadianChaos.map(b -> b, b -> b);
    @Translatable.Name(value="Min Nap Interval")
    @Translatable.Desc(value="The shortest possible time (in seconds) a hamster will stay awake or asleep in bed before considering a change. Defaults to 5 minutes\u2014 for the truly narcoleptic rodent. A random duration between the min and max is chosen each time, so move them further apart for more... unpredictable behavior.")
    public ValidatedCondition<Integer> minNapInBedIntervalSeconds = new ValidatedInt(300, 7000, 5).toCondition(() -> (Boolean)this.allowSleepInBed.get() != false && (Boolean)this.circadianChaos.get() != false, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.circadian_chaos_on"), () -> 300);
    @Translatable.Name(value="Max Nap Interval")
    @Translatable.Desc(value="The longest amount of time (in seconds) a hamster can possibly stay awake or asleep in bed before it gets bored and switches things up. Defaults to 10 minutes.")
    public ValidatedCondition<Integer> maxNapInBedIntervalSeconds = new ValidatedInt(600, 7200, 10).toCondition(() -> (Boolean)this.allowSleepInBed.get() != false && (Boolean)this.circadianChaos.get() != false, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.circadian_chaos_on"), () -> 900);
    @Translatable.Name(value="Sleep During the Day")
    @Translatable.Desc(value="If false, wandering hamsters will sleep in their beds during the night. If true, they'll adopt a more nocturnal, goth-adjacent lifestyle and sleep in the daytime.")
    public ValidatedCondition<Boolean> sleepDuringDay = new ValidatedBoolean(true).toCondition(() -> (Boolean)this.allowSleepInBed.get() != false && (Boolean)this.circadianChaos.get() == false, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.circadian_chaos_overrides"), () -> true);
    @ConfigGroup.Pop
    @Translatable.Name(value="Manual Wake-Up Duration")
    @Translatable.Desc(value="The mandatory grumpiness period if you rudely awaken a hamster from its bed before it was ready. It won't go back to sleep until this timer runs out. (20 ticks = 1 second)")
    public ValidatedCondition<Integer> bedWakeUpCooldown = new ValidatedInt(300, 1200, 20).toCondition(this.isSleepInBedAllowed, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.sleep_in_bed_allowed"), () -> 300);
    @Translatable.Name(value="Shoulder Hamster Settings")
    @Translatable.Desc(value="Settings for your fuzzy parrot of doom.")
    public ConfigGroup shoulder = new ConfigGroup("shoulder", true);
    @Translatable.Name(value="Core Settings")
    @Translatable.Desc(value="Just the basic stuff. You know, detecting creepers, sniffing diamonds. Just average Minecraft stuff really. No big deal. Why are you clapping and squealing? Stop that. You look silly.")
    public ConfigGroup shoulderCore = new ConfigGroup("shoulderCore", true);
    @NonSync
    @Translatable.Name(value="Mount Priority")
    @Translatable.Desc(value="Where should the hamster go first? 'Shoulders First' fills Right then Left then Head. 'Head First' fills Head then Right then Left.")
    public ValidatedEnum<MountPriority> mountPriority = new ValidatedEnum((Enum)MountPriority.SHOULDERS_FIRST);
    @Translatable.Name(value="Retain Shoulder Mounts")
    @Translatable.Desc(value="If true, any hamsters on your shoulder will remain there when you respawn. If false (default), they will remain at your death location, passed out from the sheer shock of seeing you die. They may need a quick pat to wake them up when you return.")
    public boolean keepHamstersOnShoulderOnDeath = false;
    @Translatable.Name(value="Consume Lure Item")
    @Translatable.Desc(value="Should luring a hamster to your shoulder consume the item (e.g., cheese)? Turn this off if you believe your charm alone should be enough. The item will still be required, just not eaten.")
    public boolean consumeLureItem = true;
    @Translatable.Name(value="Enable Force-Mount Keybind")
    @Translatable.Desc(value="Tired of wasting perfectly good cheese? Enable this to use a dedicated keybind (unbound by default). Hold down this key while right-clicking your hamster to hoist them onto your shoulder, no questions asked. Uses a separate key you must set in Settings > Controls > Key Binds.")
    public boolean enableShoulderMountKeybind = false;
    @NonSync
    @Translatable.Name(value="Enable Creeper Detection")
    @Translatable.Desc(value="May save your inventory. Or your ears.")
    public boolean enableShoulderCreeperDetection = true;
    @NonSync
    @Translatable.Name(value="Creeper Detection Radius")
    @Translatable.Desc(value="Adjust paranoia levels. (Distance in blocks)")
    public ValidatedDouble shoulderCreeperDetectionRadius = new ValidatedDouble(16.0, 16.0, 1.0);
    @NonSync
    @Translatable.Name(value="Enable Diamond Detection")
    @Translatable.Desc(value="Because who doesn\u2019t enjoy unsolicited financial advice from a rodent?")
    public boolean enableShoulderDiamondDetection = true;
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Diamond Detection Radius")
    @Translatable.Desc(value="How close (in blocks) you need to be before the squeak says \"bling.\"")
    public ValidatedDouble shoulderDiamondDetectionRadius = new ValidatedDouble(10.0, 20.0, 5.0);
    @Translatable.Name(value="Dismount Settings")
    @Translatable.Desc(value="Here's where you decide how to get the little rascals off your shoulders. Warning: they can be clingy.")
    public ConfigGroup shoulderDismount = new ConfigGroup("shoulderDismount", true);
    @NonSync
    @Translatable.Name(value="Dismount Order")
    @Translatable.Desc(value="Determines the sequence for dismounting hamsters with a key press. LIFO (Last-In, First-Out) dismounts the most recently added hamster. FIFO (First-In, First-Out) dismounts the oldest one.")
    public ValidatedEnum<DismountOrder> dismountOrder = new ValidatedEnum((Enum)DismountOrder.LIFO);
    @NonSync
    @Translatable.Name(value="Dismount Button")
    @Translatable.Desc(value="Choose what action dismounts the hamster. 'SNEAK_KEY' uses your sneak key, obviously. 'CUSTOM_KEYBIND' uses a separate key you must set in Controls > Key Binds.")
    public DismountTriggerType dismountTriggerType = DismountTriggerType.SNEAK_KEY;
    @NonSync
    @Translatable.Name(value="Button\u2011Press Behavior")
    @Translatable.Desc(value="Choose whether a single press or a quick double\u2011tap dismounts the hamster.")
    public ValidatedEnum<DismountPressType> dismountPressType = new ValidatedEnum((Enum)DismountPressType.SINGLE_PRESS);
    private final ValidatedField<Boolean> isDoubleTap = this.dismountPressType.map(pt -> pt == DismountPressType.DOUBLE_TAP, b -> b != false ? DismountPressType.DOUBLE_TAP : DismountPressType.SINGLE_PRESS);
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Double-Tap Delay")
    @Translatable.Desc(value="Max time between sneak key presses to count as a double-tap. (20 ticks = 1 second)")
    public ValidatedCondition<Integer> doubleTapDelayTicks = new ValidatedInt(10, 40, 5).toCondition(this.isDoubleTap, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.double_tap"), () -> 10);
    @NonSync
    @Translatable.Name(value="Animation Settings")
    @Translatable.Desc(value="Control how lively your shoulder-mounted companions are. I mean, I don't like to toot my own horn or anything, but this is pretty great. Now please excuse me while I bask in my humility.")
    public ConfigGroup shoulderAnimations = new ConfigGroup("shoulderAnimations", true);
    @NonSync
    @Translatable.Name(value="Enable Dynamic Animations")
    @Translatable.Desc(value="If true, hamsters on your shoulder will randomly cycle through standing, sitting, and laying down while on the shoulder. If false, they will remain in a single state defined below.")
    public ValidatedBoolean enableDynamicShoulderAnimations = new ValidatedBoolean(true);
    private final ValidatedField<Boolean> dynamicShoulderDisabled = this.enableDynamicShoulderAnimations.map(value -> value == false, value -> value == false);
    @NonSync
    @Translatable.Name(value="Forced Animation State")
    @Translatable.Desc(value="If dynamic animations are disabled, choose the single state shoulder pets should remain in. Sometimes this setting can have a delay before kicking in, but if it doesn't seem to be working at all, try switching the 'Forced State' from one option to another. Usually this just makes it \"work.\" I'm not sure why lol")
    public ValidatedCondition<ForcedShoulderState> forcedShoulderState = new ValidatedEnum((Enum)ForcedShoulderState.ALWAYS_STAND).toCondition(this.dynamicShoulderDisabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.dynamic_shoulder_off"), () -> ForcedShoulderState.ALWAYS_STAND);
    @NonSync
    @Translatable.Name(value="Force Lay Down on Walk")
    @Translatable.Desc(value="False by default. If true, shoulder hamsters will be forced into their 'laying down' animation when you move, as if trying not to fall off. If false, they will continue their normal animation cycle.")
    public boolean forceLayDownOnWalk = false;
    @NonSync
    @Translatable.Name(value="Force Lay Down on Sprint")
    @Translatable.Desc(value="If true, shoulder hamsters will be forced into their 'laying down' animation while you sprint, as if holding on for dear life. If false, they will continue their normal animation cycle.")
    public boolean forceLayDownOnSprint = true;
    @NonSync
    @Translatable.Name(value="Min Animation State Duration")
    @Translatable.Desc(value="The minimum time (in seconds) a shoulder hamster will stay in any one animation state (standing, sitting, or laying down). A random duration between the min and max is chosen for each transition.")
    public ValidatedInt shoulderMinStateSeconds = new ValidatedInt(20, 280, 5);
    @NonSync
    @ConfigGroup.Pop
    @Translatable.Name(value="Max Animation State Duration")
    @Translatable.Desc(value="The maximum time (in seconds) a shoulder hamster will stay in any one animation state (standing, sitting, or laying down). A random duration between the min and max is chosen for each transition.")
    public ValidatedInt shoulderMaxStateSeconds = new ValidatedInt(45, 300, 6);
    @NonSync
    @Translatable.Name(value="Audio Settings")
    @Translatable.Desc(value="For when the squeaks become... a bit much.")
    public ConfigGroup shoulderAudio = new ConfigGroup("shoulderAudio", true);
    @NonSync
    @Translatable.Name(value="Silence Idle Sounds")
    @Translatable.Desc(value="Mutes the ambient squeaks from shoulder-mounted hamsters. The bounce and alert sounds will still play.")
    public boolean silenceShoulderIdleSounds = false;
    @NonSync
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Mute 1st-Person Physics SFX")
    @Translatable.Desc(value="Mutes the hamster landing/bounce sound effect from the physics simulation when you are in first-person view.")
    public boolean silencePhysicsSoundsInFirstPerson = false;
    @Translatable.Name(value="Hamster Yeet Settings")
    @Translatable.Desc(value="For when you need a furry, surprisingly aerodynamic solution.")
    public ConfigGroup yeetSettings = new ConfigGroup("yeetSettings", true);
    @Translatable.Name(value="Throw Velocity")
    @Translatable.Desc(value="The base throw speed of your furry projectile.")
    public ValidatedDouble hamsterThrowVelocity = new ValidatedDouble(1.5, 5.0, 0.1);
    @ConfigGroup.Pop
    @Translatable.Name(value="Throw Velocity (Buffed)")
    @Translatable.Desc(value="The throw speed of your furry projectile when under the influence of Steamed Green Beans. Goes from 'yeet' to 'yote'.")
    public ValidatedDouble hamsterThrowVelocityBuffed = new ValidatedDouble(2.5, 5.0, 0.1);
    @Translatable.Name(value="Tamed Sleep Settings")
    @Translatable.Desc(value="Even digital rodents need beauty sleep\u2014 adjust according to your patience levels.")
    public ConfigGroup tamedSleepSettings = new ConfigGroup("tamedSleepSettings", true);
    @Translatable.Name(value="Threat Radius")
    @Translatable.Desc(value="How close (in blocks) a hostile mob can get before a hamster wakes up from it's power nap.")
    public ValidatedInt tamedSleepThreatDetectionRadiusBlocks = new ValidatedInt(8, 32, 1);
    @Translatable.Name(value="Require Daytime?")
    @Translatable.Desc(value="Choose when your sitting hamster will succumb to drowsiness. 'True' means your sitting hamster will only doze off during the day\u2014 'false' means it can doze off anytime. This setting does not affect the behavior of a hamster when sleeping in a bed.")
    public boolean requireDaytimeForTamedSleep = true;
    @Translatable.Name(value="Min Sit Time Before Drowsy (Secs)")
    @Translatable.Desc(value="Minimum seconds before a sitting hamster gets sleepy.")
    public ValidatedInt tamedQuiescentSitMinSeconds = new ValidatedInt(120, 300, 1);
    @ConfigGroup.Pop
    @Translatable.Name(value="Max Sit Time Before Drowsy (Secs)")
    @Translatable.Desc(value="Maximum seconds before the inevitable deep snooze.")
    public ValidatedInt tamedQuiescentSitMaxSeconds = new ValidatedInt(180, 600, 2);
    @Translatable.Name(value="Food Healing Settings")
    @Translatable.Desc(value="Nutrition\u2014 isn't it wonderful. Tweaks to snacks.")
    public ConfigGroup foodHealing = new ConfigGroup("foodHealing", true);
    @Translatable.Name(value="Food Mix")
    @Translatable.Desc(value="Healing amount from Hamster Food Mix. The good stuff.")
    public ValidatedFloat hamsterFoodMixHealing = new ValidatedFloat(4.0f, 10.0f, 0.0f);
    @ConfigGroup.Pop
    @Translatable.Name(value="Standard Food")
    @Translatable.Desc(value="Healing from basic seeds/crops. Better than nothing\u2026 probably.")
    public ValidatedFloat standardFoodHealing = new ValidatedFloat(2.0f, 5.0f, 0.0f);
    @Translatable.Name(value="Cheese Settings")
    @Translatable.Desc(value="Cheese... the gooey wonder. Some people think it's overpowered. I disagree. Obviously.")
    public ConfigGroup cheeseHealing = new ConfigGroup("cheeseHealing", true);
    @Translatable.Name(value="Cheese Nutrition")
    @Translatable.Desc(value="How many little hunger shanks the cheese restores. Vanilla cooked steak is 8. I know you're thinking of moving it to 20, you monster.")
    public ValidatedInt cheeseNutrition = new ValidatedInt(8, 20, 0);
    @ConfigGroup.Pop
    @Translatable.Name(value="Cheese Saturation")
    @Translatable.Desc(value="How long the hunger effect lasts. Cooked steak is 0.8. Don't get too crazy. Or do. I'm not your conscience.")
    public ValidatedFloat cheeseSaturation = new ValidatedFloat(0.8f, 2.0f, 0.0f);
    @Translatable.Name(value="Green Bean Buff Settings")
    @Translatable.Desc(value="Nutrition, but make it dramatic. Tweaks to caffeine-bean highs.")
    public ConfigGroup greenBeanBuffs = new ConfigGroup("greenBeanBuffs", true);
    @Translatable.Name(value="Duration")
    @Translatable.Desc(value="Steamed beans: power that fades faster than your attention span. (20 ticks = 1 second)")
    public ValidatedInt greenBeanBuffDuration = new ValidatedInt(3600, 12000, 20);
    @Translatable.Name(value="Speed Level")
    @Translatable.Desc(value="Because someone gotta go fast.")
    public ValidatedInt greenBeanBuffAmplifierSpeed = new ValidatedInt(1, 4, 0);
    @Translatable.Name(value="Strength Level")
    @Translatable.Desc(value="Slightly mightier nibbles.")
    public ValidatedInt greenBeanBuffAmplifierStrength = new ValidatedInt(1, 4, 0);
    @Translatable.Name(value="Absorption Level")
    @Translatable.Desc(value="Extra fluff padding for those daring dives.")
    public ValidatedInt greenBeanBuffAmplifierAbsorption = new ValidatedInt(1, 4, 0);
    @ConfigGroup.Pop
    @Translatable.Name(value="Regen Level")
    @Translatable.Desc(value="Heals minor paper-cuts (and fragile egos).")
    public ValidatedInt greenBeanBuffAmplifierRegen = new ValidatedInt(0, 4, 0);
    @Translatable.Name(value="Independent Diamond Seeking Settings")
    @Translatable.Desc(value="Unleash free-range prospectors. What could go wrong?")
    public ConfigGroup independentDiamondSeeking = new ConfigGroup("independentDiamondSeeking", true);
    @Translatable.Name(value="Enable Independent Diamond Seeking")
    @Translatable.Desc(value="Permit hamsters to embark on solo get-rich-quick schemes?")
    public boolean enableIndependentDiamondSeeking = true;
    @Translatable.Name(value="Diamond Seek Scan Radius")
    @Translatable.Desc(value="How far (in blocks) a hamster scans once it\u2019s decided to play prospector.")
    public ValidatedInt diamondSeekRadius = new ValidatedInt(10, 20, 5);
    @Translatable.Name(value="Gold 'Mistake' Chance")
    @Translatable.Desc(value="The probability (0.0 to 1.0) that a hamster will seek gold instead of diamond, if both are available. At 0.5, it's a coin toss. At 1.0, it's guaranteed hamster sulking.")
    public ValidatedFloat goldMistakeChance = new ValidatedFloat(0.33f, 1.0f, 0.0f);
    @Translatable.Name(value="Desirable Ores")
    @Translatable.Desc(value="The list of blocks that smell... shiny. Especially to greedy hamsters. Diamonds by default, but maybe you want them to sniff for Zinc ore? Accepts block IDs (e.g. 'create:zinc_ore') and #tags (e.g. '#c:ores/diamond').")
    public List<String> celebrationOres = new ArrayList<String>(List.of("minecraft:diamond_ore", "minecraft:deepslate_diamond_ore"));
    @ConfigGroup.Pop
    @Translatable.Name(value="Disappointing Ores")
    @Translatable.Desc(value="Blocks that look promising but ultimately lead to a dramatic emotional breakdown. Gold by default, but if you want them to sniff for dirt, I'm not your conscience. Accepts block IDs (e.g. 'create:copper_ore') and #tags (e.g. '#c:ores/gold').")
    public List<String> sulkingOres = new ArrayList<String>(List.of("minecraft:gold_ore", "minecraft:deepslate_gold_ore"));
    @Translatable.Name(value="Chase/Retrieval Settings")
    @Translatable.Desc(value="For when your hamster develops a taste for the finer things in life. Can be configured so they steal or fetch any item\u2014 even from other mods. They steal diamonds and fetch acorns by default.")
    public ConfigGroup itemInterest = new ConfigGroup("itemInterest", true);
    @Translatable.Name(value="Enable Stealing/Fetching")
    @Translatable.Desc(value="Permits hamsters to engage in spontaneous, high-stakes games of keep-away with your valuables, or they might fetch items for you.")
    public boolean enableItemCarrying = true;
    @Translatable.Name(value="Thievery Pounce Chance")
    @Translatable.Desc(value="Probability (0.1 to 1.0) a hamster will succumb to temptation. High by default. You shouldn't leave your diamonds lying around anyway. Does not apply to retrieval.")
    public ValidatedFloat itemThieveryChance = new ValidatedFloat(0.75f, 1.0f, 0.1f);
    @Translatable.Name(value="Minimum Flee Distance")
    @Translatable.Desc(value="The hamster's personal space bubble (in blocks) when stealing your shinies. The discrepancy between the minimum and maximum flee distance determines the randomness.")
    public ValidatedInt minFleeDistance = new ValidatedInt(5, 20, 1);
    @Translatable.Name(value="Maximum Flee Distance")
    @Translatable.Desc(value="The maximum distance (in blocks) before the hamster gets bored and stops running to taunt you with the stolen goods. The discrepancy between the minimum and maximum flee distance determines the randomness.")
    public ValidatedInt maxFleeDistance = new ValidatedInt(20, 40, 5);
    @Translatable.Name(value="Minimum Interest Duration")
    @Translatable.Desc(value="The shortest amount of time (in seconds) the hamster will entertain interest in an item before getting bored and dropping it. The discrepancy between the minimum and maximum duration determines the randomness.")
    public ValidatedInt minStealDurationSeconds = new ValidatedInt(5, 240, 1);
    @ConfigGroup.Pop
    @Translatable.Name(value="Maximum Interest Duration")
    @Translatable.Desc(value="The longest amount of time (in seconds) the hamster will entertain interest in an item before getting bored and dropping it. The discrepancy between the minimum and maximum duration determines the randomness.")
    public ValidatedInt maxStealDurationSeconds = new ValidatedInt(15, 300, 5);
    @Translatable.Name(value="Commissioned Features")
    @Translatable.Desc(value="Specialized, unofficial mechanics that don't necessarily fit the theme of the mod, but were funded by various individuals in the community. Purposefully tucked away in the config to ensure most people don't notice them.")
    public ConfigGroup commissionedFeatures = new ConfigGroup("commissionedFeatures", true);
    @Translatable.Name(value="Hamster Riding Settings")
    @Translatable.Desc(value="Configure hamster-mounted cavalry. Tweak speeds, toggles, and physics. Don't blame me if you accidentally zoom off a cliff after turning up the speed too high.")
    public ConfigGroup hamsterRiding = new ConfigGroup("hamsterRiding", true);
    @Translatable.Name(value="Enable Hamster Riding")
    @Translatable.Desc(value="Adds a keybind to mount hamsters. (It's unbound by default). Allows riding any hamster, but you can only steer your own. \n\nCommissioned by @Saint_Victus.")
    public ValidatedBoolean enableMountableHamsters = new ValidatedBoolean(false);
    private final ValidatedField<Boolean> isRidingEnabled = this.enableMountableHamsters.map(b -> b, b -> b);
    @Translatable.Name(value="Base Ride Speed")
    @Translatable.Desc(value="The casual strolling speed multiplier. 0.25 is the default. Don't ask why.")
    public ValidatedCondition<Double> ridingBaseSpeedMultiplier = new ValidatedDouble(0.25, 0.8, 0.0).toCondition(this.isRidingEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.riding_enabled"), () -> 0.25);
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    @Translatable.Name(value="Sprint Ride Speed")
    @Translatable.Desc(value="The speed multiplier when sprinting. Hold on to your acorn hat. 0.35 is the default. I wish it was a nice round number, but alas, hamster riding is a complex enigma.")
    public ValidatedCondition<Double> ridingSprintSpeedMultiplier = new ValidatedDouble(0.35, 1.0, 0.0).toCondition(this.isRidingEnabled, (class_2561)class_2561.method_43471((String)"config.adorablehamsterpets.condition.riding_enabled"), () -> 0.8);

    public AhpConfig() {
        super(class_2960.method_60655((String)"adorablehamsterpets", (String)"main"));
        this.enableNotificationIcons.setAndUpdate((Object)((Boolean)this.enableHudIcon.get() != false || (Boolean)this.enableWidgetIcon.get() != false ? 1 : 0));
        this.enableNotificationIcons.listenToEntry(ignored -> {
            if (this.updatingAnnouncementToggles) {
                return;
            }
            this.updatingAnnouncementToggles = true;
            try {
                boolean masterValue = (Boolean)this.enableNotificationIcons.get();
                this.enableHudIcon.setAndUpdate((Object)masterValue);
                this.enableWidgetIcon.setAndUpdate((Object)masterValue);
            }
            finally {
                this.updatingAnnouncementToggles = false;
            }
        });
        Consumer<Object> childListener = ignored -> {
            boolean newMasterState;
            if (this.updatingAnnouncementToggles) {
                return;
            }
            boolean bl = newMasterState = (Boolean)this.enableHudIcon.get() != false || (Boolean)this.enableWidgetIcon.get() != false;
            if ((Boolean)this.enableNotificationIcons.get() != newMasterState) {
                this.enableNotificationIcons.setAndUpdate((Object)newMasterState);
            }
        };
        this.enableHudIcon.listenToEntry(e -> childListener.accept(null));
        this.enableWidgetIcon.listenToEntry(e -> childListener.accept(null));
    }

    @Translation(prefix="adorablehamsterpets.main.widgetIconOffsets")
    public static class WidgetIconOffsets {
        @NonSync
        @Translatable.Name(value="Offset X")
        @Translatable.Desc(value="Shove it sideways (in pixels). Increase the number to move it right, decrease to move left.")
        public ValidatedInt offsetX = new ValidatedInt(0, 500, -500);
        @NonSync
        @Translatable.Name(value="Offset Y")
        @Translatable.Desc(value="Shove it vertically (in pixels). Increase the number to move it down, decrease to move up.")
        public ValidatedInt offsetY = new ValidatedInt(0, 500, -500);
    }
}

