/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterCreeperAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterDiamondAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterThrownCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.advancement.criterion.WitnessGlowingSunflowerCriterion;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.SunflowerBlock;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSniffForOreGoal;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.SyncShoulderDataPayload;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityAccessor {
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final int AHP_GUIDEBOOK_CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final long HEIST_MEMORY_DURATION = 24000L;
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_HAS_KEY = "AHPHasGuideBook";
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_INIT_KEY = "AHPGuideBookTrackingInit";
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private class_2487 ahp$shoulderData = new class_2487();
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private int ahp$guideBookCheckTimer = 0;
    @Unique
    private int ahp$sunflowerCheckTimer = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private boolean ahp$cachedHasGuideBook = false;
    @Unique
    private boolean ahp$guideBookTrackingInitialized = false;
    @Unique
    private final List<ScheduledTask> adorablehamsterpets$scheduledTasks = new ArrayList<ScheduledTask>();
    @Unique
    private final List<TreeHeistUtil.HeistRecord> ahp$heistHistory = new ArrayList<TreeHeistUtil.HeistRecord>();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.field_9236) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(class_2487 nbt, CallbackInfo ci) {
        if (!this.ahp$shoulderData.method_33133()) {
            nbt.method_10566("ShoulderHamsters", (class_2520)this.ahp$shoulderData);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            class_2499 mountOrderList = new class_2499();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)class_2519.method_23256((String)location.name()));
            }
            nbt.method_10566("MountOrderQueue", (class_2520)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.method_10569("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
        if (!this.ahp$heistHistory.isEmpty()) {
            class_2499 historyList = new class_2499();
            long currentTime = this.method_37908().method_8510();
            for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
                if (currentTime - record.timestamp() >= 24000L) continue;
                class_2487 tag = new class_2487();
                tag.method_10544("x", (long)record.pos().method_10263());
                tag.method_10544("y", (long)record.pos().method_10264());
                tag.method_10544("z", (long)record.pos().method_10260());
                tag.method_10544("t", record.timestamp());
                historyList.add((Object)tag);
            }
            if (!historyList.isEmpty()) {
                nbt.method_10566("AHPHeistHistory", (class_2520)historyList);
            }
        }
        nbt.method_10556(AHP_NBT_GUIDEBOOK_HAS_KEY, this.ahp$cachedHasGuideBook);
        nbt.method_10556(AHP_NBT_GUIDEBOOK_INIT_KEY, this.ahp$guideBookTrackingInitialized);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("ShoulderHamster", 10)) {
            class_2487 oldHamsterNbt = nbt.method_10562("ShoulderHamster");
            if (!oldHamsterNbt.method_33133()) {
                class_2487 newShoulderPetsNbt = new class_2487();
                newShoulderPetsNbt.method_10566(ShoulderLocation.RIGHT_SHOULDER.name(), (class_2520)oldHamsterNbt);
                this.ahp$shoulderData = newShoulderPetsNbt;
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.method_10551("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.method_5476().getString());
            }
        } else if (nbt.method_10573("ShoulderHamsters", 10)) {
            this.ahp$shoulderData = nbt.method_10562("ShoulderHamsters");
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.method_10573("MountOrderQueue", 9)) {
            ShoulderLocation[] mountOrderList = nbt.method_10554("MountOrderQueue", 8);
            HashSet<ShoulderLocation> seenLocations = new HashSet<ShoulderLocation>();
            for (class_2520 class_25202 : mountOrderList) {
                try {
                    ShoulderLocation location = ShoulderLocation.valueOf(class_25202.method_10714());
                    if (seenLocations.contains((Object)location) || this.getShoulderHamster(location).method_33133()) continue;
                    this.adorablehamsterpets$mountOrderQueue.add(location);
                    seenLocations.add(location);
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)class_25202.method_10714());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but empty mount queue. Rebuilding...", (Object)this.method_5476().getString());
            for (ShoulderLocation shoulderLocation : ShoulderLocation.values()) {
                if (this.getShoulderHamster(shoulderLocation).method_33133()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(shoulderLocation);
            }
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.method_10573("LastGoldMessageIndex", 3) ? nbt.method_10550("LastGoldMessageIndex") : -1;
        this.ahp$heistHistory.clear();
        if (nbt.method_10573("AHPHeistHistory", 9)) {
            class_2499 historyList = nbt.method_10554("AHPHeistHistory", 10);
            for (int i = 0; i < historyList.size(); ++i) {
                class_2487 tag = historyList.method_10602(i);
                class_2338 class_23382 = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
                long time = tag.method_10537("t");
                this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(class_23382, time));
            }
        }
        if (nbt.method_10573(AHP_NBT_GUIDEBOOK_HAS_KEY, 1)) {
            this.ahp$cachedHasGuideBook = nbt.method_10577(AHP_NBT_GUIDEBOOK_HAS_KEY);
        }
        if (nbt.method_10573(AHP_NBT_GUIDEBOOK_INIT_KEY, 1)) {
            this.ahp$guideBookTrackingInitialized = nbt.method_10577(AHP_NBT_GUIDEBOOK_INIT_KEY);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        class_5819 random = world.method_8409();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        long currentTime = world.method_8510();
        this.adorablehamsterpets$scheduledTasks.removeIf(task -> {
            if (currentTime >= task.executionTick()) {
                task.action().run();
                return true;
            }
            return false;
        });
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        this.tickGuideBookTracking();
        if (++this.ahp$sunflowerCheckTimer >= 20) {
            this.ahp$sunflowerCheckTimer = 0;
            if (Configs.AHP_WORLDGEN.enableGlowingSunflowers && !world.method_8530()) {
                class_2338 playerPos = self.method_24515();
                for (class_2338 pos : class_2338.method_10097((class_2338)playerPos.method_10069(-5, -3, -5), (class_2338)playerPos.method_10069(5, 3, 5))) {
                    class_2680 state = world.method_8320(pos);
                    if (!state.method_27852((class_2248)ModBlocks.SUNFLOWER_BLOCK.get()) || !((Boolean)state.method_11654((class_2769)SunflowerBlock.LIT)).booleanValue()) continue;
                    ((WitnessGlowingSunflowerCriterion)((Object)ModCriteria.WITNESS_GLOWING_SUNFLOWER.get())).trigger((class_3222)self);
                    break;
                }
            }
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isCelebrationOreNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), class_3419.field_15254, 2.5f, 1.0f);
                            self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.diamond_nearby").method_27692(class_124.field_1075), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.method_39332(140, 200);
                            ((HamsterDiamondAlertCriterion)((Object)ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.get())).trigger((class_3222)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), class_3419.field_15254, 1.0f, 1.0f);
                        self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.creeper_detected").method_27692(class_124.field_1061), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.method_39332(100, 160);
                        ((HamsterCreeperAlertCriterion)((Object)ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.get())).trigger((class_3222)self);
                    }
                }
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(class_1297.class_5529 reason, CallbackInfo ci) {
        if (!this.method_37908().method_8608()) {
            HamsterRenderTracker.onPlayerDisconnect(this.method_5667());
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="RETURN")})
    private void adorablehamsterpets$onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        if (!self.method_37908().field_9236 && !skipSleepTimer) {
            class_3218 serverWorld = (class_3218)self.method_37908();
            UUID ownerUuid = self.method_5667();
            ArrayList<HamsterEntity> stuckHamsters = new ArrayList<HamsterEntity>();
            for (class_1297 entity : serverWorld.method_18198((class_5575)ModEntities.HAMSTER.get(), class_1297::method_5805)) {
                HamsterEntity hamster;
                if (!(entity instanceof HamsterEntity) || !(hamster = (HamsterEntity)entity).method_6181() || !ownerUuid.equals(hamster.method_6139()) || !hamster.isStuckSearchingForBed()) continue;
                stuckHamsters.add(hamster);
            }
            for (HamsterEntity hamster : stuckHamsters) {
                hamster.getLinkedBedPos().ifPresent(globalPos -> {
                    if (serverWorld.method_27983() == globalPos.comp_2207()) {
                        class_2338 bedPos = globalPos.comp_2208();
                        class_2680 bedState = serverWorld.method_8320(bedPos);
                        if (bedState.method_26204() instanceof HamsterBedBlock && !((Boolean)bedState.method_11654((class_2769)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                            class_243 targetCenter = class_243.method_24953((class_2382)bedPos).method_1031(0.0, 0.1, 0.0);
                            hamster.method_5808(targetCenter.field_1352, targetCenter.field_1351, targetCenter.field_1350, 0.0f, 0.0f);
                            hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                            hamster.setSleeping(true);
                            hamster.setRescueSleeping(true);
                            hamster.method_6179(true);
                            serverWorld.method_8652(bedPos, (class_2680)bedState.method_11657((class_2769)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                            int personality = (Integer)hamster.method_5841().method_12789(HamsterEntity.ANIMATION_PERSONALITY_ID);
                            int poseIndex = personality >= 1 && personality <= 3 ? personality : 1;
                            hamster.method_5841().method_12778(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)("anim_hamster_sleep_pose" + poseIndex));
                            hamster.startNapTimer();
                            hamster.setStuckSearchingForBed(false);
                            hamster.setWanderModeActive(true);
                            AdorableHamsterPets.LOGGER.info("Rescued stuck hamster {} to bed at {}", (Object)hamster.method_5628(), (Object)bedPos);
                        } else {
                            hamster.setStuckSearchingForBed(false);
                        }
                    }
                });
            }
        }
    }

    @Override
    @Unique
    public boolean ahp$computeHasGuideBook(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || !stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Unique
    public void ahp$initGuideBookTracking(boolean currentlyHasGuideBook) {
        this.ahp$cachedHasGuideBook = currentlyHasGuideBook;
        this.ahp$guideBookTrackingInitialized = true;
        this.ahp$guideBookCheckTimer = 0;
    }

    @Override
    @Unique
    public class_2487 getShoulderHamster(ShoulderLocation location) {
        return this.ahp$shoulderData.method_10562(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, class_2487 nbt) {
        if (nbt == null || nbt.method_33133()) {
            this.ahp$shoulderData.method_10551(location.name());
        } else {
            this.ahp$shoulderData.method_10566(location.name(), (class_2520)nbt);
        }
        if (!this.method_37908().method_8608()) {
            Object object;
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.method_5628(), this.ahp$shoulderData);
            class_1657 self = (class_1657)this;
            if (self instanceof class_3222) {
                class_3222 serverSelf = (class_3222)self;
                NetworkManager.sendToPlayer((class_3222)serverSelf, (class_8710)packet);
            }
            if ((object = self.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)object;
                for (class_3222 otherPlayer : serverWorld.method_18456()) {
                    if (otherPlayer == self || !(otherPlayer.method_5858((class_1297)self) < 4096.0)) continue;
                    NetworkManager.sendToPlayer((class_3222)otherPlayer, (class_8710)packet);
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$setRawShoulderData(class_2487 nbt) {
        this.ahp$shoulderData = nbt;
    }

    @Override
    @Unique
    public void adorablehamsterpets$syncShoulderData() {
        class_1657 self;
        if (!this.method_37908().method_8608() && !this.ahp$shoulderData.method_33133() && (self = (class_1657)this) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)self;
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.method_5628(), this.ahp$shoulderData);
            NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)packet);
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        class_2338 hitPos;
        ShoulderLocation locationToProcess;
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Player {} has shoulder hamsters but empty queue. Rebuilding...", (Object)self.method_5477().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).method_33133()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_5819 random = world.method_8409();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        class_2487 shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.method_33133()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). Desync probable.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((class_3218)world, self, shoulderNbt);
        if (hamster == null) {
            this.setShoulderHamster(locationToProcess, new class_2487());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        class_239 hitResult = self.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && world.method_8320(hitPos = ((class_3965)hitResult).method_17777()).method_27852(class_2246.field_10503)) {
            TreeHeistUtil.TreeScanResult scanResult = TreeHeistUtil.scanForTree(world, hitPos);
            if (HamsterTreeSearcherEntity.isTreeBlocked(world, scanResult.treeId())) {
                self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.tree_heist.occupied").method_27692(class_124.field_1061), true);
                return;
            }
            HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)((class_1299)ModEntities.HAMSTER_TREE_SEARCHER.get()).method_5883(world);
            if (searcher != null) {
                hamster.triggerLeafPopEffects(hitPos, false);
                class_2487 fullNbt = new class_2487();
                hamster.method_5647(fullNbt);
                searcher.initializeSearch(hitPos, scanResult, fullNbt);
                world.method_8649((class_1297)searcher);
                if (config.dismountOrder.get() == DismountOrder.LIFO) {
                    this.adorablehamsterpets$mountOrderQueue.pollLast();
                } else {
                    this.adorablehamsterpets$mountOrderQueue.pollFirst();
                }
                this.setShoulderHamster(locationToProcess, new class_2487());
                return;
            }
        }
        if (isThrow) {
            class_1792 class_17922;
            if (hamster.method_6109()) {
                self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.baby_throw_refusal").method_27692(class_124.field_1061), true);
                return;
            }
            long currentTime = world.method_8510();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = Math.max(1L, remainingTicks / 20L);
                self.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{totalSecondsRemaining}).method_27692(class_124.field_1061), true);
                return;
            }
            hamster.method_5808(self.method_23317(), self.method_23320() - 0.1, self.method_23321(), self.method_36454(), self.method_36455());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            class_1799 armorStack = hamster.getArmorStack();
            if (!armorStack.method_7960() && (class_17922 = armorStack.method_7909()) instanceof HamsterArmorItem) {
                HamsterArmorItem armorItem = (HamsterArmorItem)class_17922;
                if (((Boolean)config.enableArmorPerks.get()).booleanValue() && armorItem.getMaterial() == HamsterArmorItem.HamsterArmorMaterial.IRON) {
                    throwSpeed += ((Double)config.ironArmorThrowSpeedBoost.get()).floatValue();
                }
            }
            class_243 lookVec = self.method_5828(1.0f);
            class_243 throwVec = new class_243(lookVec.field_1352, lookVec.field_1351 + (double)0.1f, lookVec.field_1350).method_1029();
            hamster.method_18799(throwVec.method_1021((double)throwSpeed));
            hamster.field_6007 = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new class_2487());
        HamsterEntity.spawnFromNbt((class_3218)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            world.method_43128(null, self.method_23317(), self.method_23318(), self.method_23321(), (class_3414)ModSounds.HAMSTER_THROW.get(), class_3419.field_15248, 1.0f, 1.0f);
            this.adorablehamsterpets$scheduledTasks.add(new ScheduledTask(world.method_8510() + 3L, () -> {
                class_3414 celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, random);
                if (celebrationSound != null) {
                    world.method_43128(null, self.method_23317(), self.method_23318(), self.method_23321(), celebrationSound, class_3419.field_15248, 1.0f, 1.0f);
                }
            }));
            ((HamsterThrownCriterion)((Object)ModCriteria.HAMSTER_THROWN.get())).trigger((class_3222)self);
        } else {
            world.method_8396(null, self.method_24515(), (class_3414)ModSounds.HAMSTER_DISMOUNT.get(), class_3419.field_15248, 0.7f, 1.0f + random.method_43057() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.method_43048(availableKeys.size()));
                }
                self.method_7353((class_2561)class_2561.method_43471((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).method_33133() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).method_33133() || !this.getShoulderHamster(ShoulderLocation.HEAD).method_33133();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        if (this.adorablehamsterpets$clientShoulderData == null && this.method_37908().field_9236) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
        return this.adorablehamsterpets$clientShoulderData;
    }

    @Override
    @Unique
    public void ahp$registerTreeHeist(class_2338 treeId) {
        long time = this.method_37908().method_8510();
        this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(treeId, time));
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
    }

    @Override
    @Unique
    public float ahp$getHeistProfitability(class_2338 treeId) {
        long time = this.method_37908().method_8510();
        int initialSize = this.ahp$heistHistory.size();
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
        int prunedSize = this.ahp$heistHistory.size();
        int matchCount = 0;
        ArrayList<Long> matchAges = new ArrayList<Long>();
        for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
            if (!record.pos().equals((Object)treeId)) continue;
            ++matchCount;
            matchAges.add(time - record.timestamp());
        }
        float multiplier = matchCount == 0 ? 1.0f : (matchCount == 1 ? 0.6f : (matchCount == 2 ? 0.3f : 0.0f));
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Profitability] Calculating for Tree Anchor: {}\n  - Current World Time: {}\n  - Player History Size: {} (Pruned from {})\n  - Matches Found for this Tree: {}\n  - Match Ages (ticks ago): {} (Memory Limit: {})\n  - Calculated Multiplier: {}", new Object[]{treeId.method_23854(), time, prunedSize, initialSize, matchCount, matchAges, 24000L, String.format("%.2f", Float.valueOf(multiplier))});
        }
        return multiplier;
    }

    @Override
    @Unique
    public void ahp$clearHeistHistory() {
        this.ahp$heistHistory.clear();
        AdorableHamsterPets.LOGGER.info("[TreeHeist] Cleared heist history for player {}.", (Object)this.method_5477().getString());
        ((class_1657)this).method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.heist_history_reset").method_27692(class_124.field_1068), true);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        if (!this.ahp$shoulderData.method_33133()) {
            SyncShoulderDataPayload packet = new SyncShoulderDataPayload(this.method_5628(), this.ahp$shoulderData);
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)packet);
        }
    }

    @Unique
    private void tickGuideBookTracking() {
        class_1657 self = (class_1657)this;
        if (self.method_37908().field_9236) {
            return;
        }
        if (!(self instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)self;
        if (++this.ahp$guideBookCheckTimer < 20) {
            return;
        }
        this.ahp$guideBookCheckTimer = 0;
        if (!this.ahp$guideBookTrackingInitialized) {
            this.ahp$initGuideBookTracking(this.ahp$computeHasGuideBook((class_1657)player));
            return;
        }
        boolean hasNow = this.ahp$computeHasGuideBook((class_1657)player);
        if (hasNow && !this.ahp$cachedHasGuideBook) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new PlayGuidebookEffectsPayload(false));
        }
        this.ahp$cachedHasGuideBook = hasNow;
    }

    @Unique
    private boolean isCelebrationOreNearby(class_1657 player, double radius) {
        class_1937 world = player.method_37908();
        class_2338 center = player.method_24515();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<class_2338> exposedOres = new ArrayList<class_2338>();
        ArrayList<class_2338> buriedOres = new ArrayList<class_2338>();
        for (class_2338 checkPos : class_2338.method_10097((class_2338)center.method_10069(-intRadius, -intRadius, -intRadius), (class_2338)center.method_10069(intRadius, intRadius, intRadius))) {
            class_2680 state;
            if (!(checkPos.method_10262((class_2382)center) <= radius * radius) || !ConfigDataCache.isCelebrationOre(state = world.method_8320(checkPos))) continue;
            if (HamsterSniffForOreGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.method_10062());
                continue;
            }
            buriedOres.add(checkPos.method_10062());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(class_1657 player, double radius) {
        class_238 searchBox;
        class_1937 world = player.method_37908();
        List nearbyCreepers = world.method_8390(class_1548.class, searchBox = new class_238(player.method_19538().method_1023(radius, radius, radius), player.method_19538().method_1031(radius, radius, radius)), creeper -> creeper.method_5805() && creeper.method_5968() == player && class_1301.field_6154.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Unique
    private record ScheduledTask(long executionTick, Runnable action) {
    }
}

