/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class ClientParticleManager {
    public static final ClientParticleManager INSTANCE = new ClientParticleManager();
    private final Map<String, EmitterEntry> activeEmitters = new ConcurrentHashMap<String, EmitterEntry>();
    private static final int DEFAULT_TIMEOUT_TICKS = 60;

    private ClientParticleManager() {
    }

    public void addOrUpdate(class_2338 pos, String effectId, Consumer<class_1937> logic, BiPredicate<class_1937, class_2338> validityCheck) {
        String key = pos.method_10063() + ":" + effectId;
        this.activeEmitters.compute(key, (k, current) -> {
            if (current == null) {
                return new EmitterEntry(pos.method_10062(), logic, validityCheck, 60);
            }
            current.timeoutTicks = 60;
            current.logic = logic;
            current.validityCheck = validityCheck;
            return current;
        });
    }

    public void tick(class_1937 world) {
        if (world == null) {
            return;
        }
        Iterator<Map.Entry<String, EmitterEntry>> iterator = this.activeEmitters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, EmitterEntry> entry = iterator.next();
            EmitterEntry emitter = entry.getValue();
            if (emitter.validityCheck != null && !emitter.validityCheck.test(world, emitter.pos)) {
                iterator.remove();
                continue;
            }
            emitter.logic.accept(world);
            --emitter.timeoutTicks;
            if (emitter.timeoutTicks > 0) continue;
            iterator.remove();
        }
    }

    public void clear() {
        this.activeEmitters.clear();
    }

    private static class EmitterEntry {
        final class_2338 pos;
        Consumer<class_1937> logic;
        BiPredicate<class_1937, class_2338> validityCheck;
        int timeoutTicks;

        EmitterEntry(class_2338 pos, Consumer<class_1937> logic, BiPredicate<class_1937, class_2338> validityCheck, int timeoutTicks) {
            this.pos = pos;
            this.logic = logic;
            this.validityCheck = validityCheck;
            this.timeoutTicks = timeoutTicks;
        }
    }
}

