/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_7;

public class HamsterPlacementUtil {
    private static final Set<class_7> HAZARDOUS_FLOOR_TYPES = EnumSet.of(class_7.field_14, new class_7[]{class_7.field_3, class_7.field_9, class_7.field_33534, class_7.field_17, class_7.field_5, class_7.field_43351, class_7.field_18});

    public static void trySuffocationRescue(HamsterEntity hamster) {
        if (hamster.suffocationGracePeriod > 0 && hamster.method_5757()) {
            class_1937 world = hamster.method_37908();
            class_2338 currentPos = hamster.method_24515();
            Optional<class_2338> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(currentPos, world, 3, hamster);
            safePosOpt.ifPresent(safePos -> {
                hamster.method_5808((double)safePos.method_10263() + 0.5, safePos.method_10264(), (double)safePos.method_10260() + 0.5, hamster.method_36454(), hamster.method_36455());
                hamster.method_18800(0.0, 0.0, 0.0);
                hamster.field_6007 = true;
                AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} rescued from {} to safe location {}.", new Object[]{hamster.method_5628(), currentPos, safePos});
                hamster.suffocationGracePeriod = 0;
            });
        }
    }

    public static Optional<class_2338> findSafeSpawnPosition(class_2338 initialTarget, class_1937 world, int searchRadius, HamsterEntity hamster) {
        return HamsterPlacementUtil.findSafeSpawnPosition(initialTarget, world, searchRadius, Collections.emptySet(), hamster);
    }

    public static Optional<class_2338> findSafeSpawnPosition(class_2338 initialTarget, class_1937 world, int searchRadius, Set<class_2338> occupiedPositions, HamsterEntity hamster) {
        if (HamsterPlacementUtil.isSafeSpawnLocation(initialTarget, world, hamster) && !occupiedPositions.contains(initialTarget)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            class_2338 abovePos = initialTarget.method_10086(i);
            if (!HamsterPlacementUtil.isSafeSpawnLocation(abovePos, world, hamster) || occupiedPositions.contains(abovePos)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    class_2338 checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !HamsterPlacementUtil.isSafeSpawnLocation(checkPos = initialTarget.method_10069(i, 0, j), world, hamster) || occupiedPositions.contains(checkPos)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public static boolean isSafeSpawnLocation(class_2338 pos, class_1937 world, HamsterEntity hamster) {
        class_7 bodyType = LandPathNodeMakerInvoker.callGetCommonNodeType((class_1922)world, pos);
        if (HAZARDOUS_FLOOR_TYPES.contains(bodyType)) {
            return false;
        }
        class_2338 floorPos = pos.method_10074();
        class_2680 floorState = world.method_8320(floorPos);
        class_7 floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((class_1922)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.method_26220((class_1922)world, floorPos).method_1110()) {
            return false;
        }
        class_3726 entityContext = class_3726.method_16195((class_1297)hamster);
        return world.method_8320(pos).method_26194((class_1922)world, pos, entityContext).method_1110() && world.method_8320(pos.method_10084()).method_26194((class_1922)world, pos.method_10084(), entityContext).method_1110();
    }
}

