/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsUtil {
    public static <T extends class_2394> void spawnParticles(class_1937 world, class_243 center, T particle, int count, class_243 spread, double speed) {
        ParticleEffectsUtil.spawnParticles(world, center, particle, count, spread.field_1352, spread.field_1351, spread.field_1350, speed);
    }

    public static <T extends class_2394> void spawnParticles(class_1937 world, class_243 center, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(particle, center.field_1352, center.field_1351, center.field_1350, count, spreadX, spreadY, spreadZ, speed);
        } else {
            class_5819 random = world.method_8409();
            for (int i = 0; i < count; ++i) {
                double offsetX = (random.method_43058() - 0.5) * 2.0 * spreadX;
                double offsetY = (random.method_43058() - 0.5) * 2.0 * spreadY;
                double offsetZ = (random.method_43058() - 0.5) * 2.0 * spreadZ;
                double vx = (random.method_43058() - 0.5) * speed;
                double vy = (random.method_43058() - 0.5) * speed;
                double vz = (random.method_43058() - 0.5) * speed;
                world.method_8406(particle, center.field_1352 + offsetX, center.field_1351 + offsetY, center.field_1350 + offsetZ, vx, vy, vz);
            }
        }
    }

    public static <T extends class_2394> void spawnParticles(class_1937 world, class_2338 pos, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, class_243.method_24953((class_2382)pos), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends class_2394> void spawnParticles(class_1937 world, class_2338 pos, double yOffset, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, class_243.method_24955((class_2382)pos).method_1031(0.0, yOffset, 0.0), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends class_2394> void spawnParticlesOnEntity(class_1297 entity, T particle, int count, double widthScale, double heightScale, double speed, double yOffset) {
        double spreadX = (double)entity.method_17681() * widthScale / 2.0;
        double spreadY = (double)entity.method_17682() * heightScale / 2.0;
        double spreadZ = (double)entity.method_17681() * widthScale / 2.0;
        double centerY = entity.method_23318() + (double)entity.method_17682() / 2.0 + yOffset;
        class_243 center = new class_243(entity.method_23317(), centerY, entity.method_23321());
        ParticleEffectsUtil.spawnParticles(entity.method_37908(), center, particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends class_2394> void spawnMotionTrail(class_1297 entity, T particle, int countPerTick, double offsetMultiplier, double scatter, double velocityScale, double downwardVelocity) {
        class_1937 world = entity.method_37908();
        class_243 velocity = entity.method_18798();
        if (velocity.method_37268() < 1.0E-6) {
            return;
        }
        class_5819 random = world.method_8409();
        for (int i = 0; i < countPerTick; ++i) {
            double baseX = entity.method_23317() - velocity.field_1352 * offsetMultiplier;
            double baseY = entity.method_23318() + (double)entity.method_17682() / 2.0 - velocity.field_1351 * offsetMultiplier;
            double baseZ = entity.method_23321() - velocity.field_1350 * offsetMultiplier;
            double spawnX = baseX + (random.method_43058() - 0.5) * ((double)entity.method_17681() * 0.8);
            double spawnY = baseY + (random.method_43058() - 0.5) * ((double)entity.method_17682() * 0.05);
            double spawnZ = baseZ + (random.method_43058() - 0.5) * ((double)entity.method_17681() * 0.8);
            class_243 backwardsVel = velocity.method_1021(-1.0 * velocityScale);
            double finalVelX = backwardsVel.field_1352 + random.method_43059() * scatter;
            double finalVelY = backwardsVel.field_1351 + random.method_43059() * scatter - downwardVelocity;
            double finalVelZ = backwardsVel.field_1350 + random.method_43059() * scatter;
            world.method_8406(particle, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
        }
    }

    public static void spawnBreadcrumbs(class_3218 world, @Nullable class_11 path) {
        if (path == null) {
            return;
        }
        int currentNodeIndex = path.method_39();
        int pathLength = path.method_38();
        for (int i = currentNodeIndex; i < pathLength; ++i) {
            class_9 node = path.method_40(i);
            class_243 directionVector = class_243.field_1353;
            if (i + 1 < pathLength) {
                class_9 nextNode = path.method_40(i + 1);
                directionVector = new class_243((double)(nextNode.field_40 - node.field_40), 0.0, (double)(nextNode.field_38 - node.field_38)).method_1029();
            }
            for (int p = 0; p < 3; ++p) {
                double distanceAlongPath = world.method_8409().method_43058();
                class_243 pathOffset = directionVector.method_1021(distanceAlongPath);
                double offsetY = (world.method_8409().method_43058() - 0.5) * 0.1;
                ParticleEffectsUtil.spawnParticles((class_1937)world, new class_243((double)node.field_40 + 0.5 + pathOffset.field_1352, (double)node.field_39 + 0.5 - 0.38 + offsetY, (double)node.field_38 + 0.5 + pathOffset.field_1350), class_2398.field_11219, 1, 0.2, 0.0, 0.2, 3.0);
            }
        }
    }

    public static void spawnSpinningRing(class_1937 world, class_2338 centerPos, class_2394 particle, int count, double radius, double ringThickness, double rotationSpeed, double bobbingHeight, double upwardVelocity, double yOffset) {
        double timeOffset = (double)world.method_8510() * rotationSpeed;
        double bobbingTimeOffset = (double)world.method_8510() * (rotationSpeed / 1.5);
        double angleStep = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double angle = timeOffset + (double)i * angleStep;
            double currentRadius = radius + (world.method_8409().method_43058() - 0.5) * ringThickness;
            double x = (double)centerPos.method_10263() + 0.5 + Math.cos(angle) * currentRadius;
            double z = (double)centerPos.method_10260() + 0.5 + Math.sin(angle) * currentRadius;
            double y = (double)centerPos.method_10264() + 0.5 + yOffset + Math.sin(bobbingTimeOffset) * bobbingHeight;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199(particle, x, y, z, 0, 0.0, upwardVelocity, 0.0, 1.0);
                continue;
            }
            world.method_8406(particle, x, y, z, 0.0, upwardVelocity, 0.0);
        }
    }

    public static <T extends class_2394> void spawnSphericalShell(class_1937 world, class_243 center, T particle, int count, double baseRadius, double radiusVariance) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < count; ++i) {
            double rZ;
            double rY;
            double rX = random.method_43058() - 0.5;
            double dist = Math.sqrt(rX * rX + (rY = random.method_43058() - 0.5) * rY + (rZ = random.method_43058() - 0.5) * rZ);
            if (dist < 1.0E-4) {
                dist = 1.0;
            }
            double radius = baseRadius + random.method_43058() * radiusVariance;
            double offsetX = rX / dist * radius;
            double offsetY = rY / dist * radius;
            double offsetZ = rZ / dist * radius;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199(particle, center.field_1352 + offsetX, center.field_1351 + offsetY, center.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            world.method_8406(particle, center.field_1352 + offsetX, center.field_1351 + offsetY, center.field_1350 + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

