/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.client.HamsterBedRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.command.ModClientCommands;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.render.LeafJiggleManager;
import net.dawson.adorablehamsterpets.client.sound.HamsterTreeLoopSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.client.renderer.HamsterTreeSearcherRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ClientParticleManager;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static int clientSessionTimer = 0;
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;
    private static final Map<Integer, HamsterTreeLoopSoundInstance> activeTreeSounds = new HashMap<Integer, HamsterTreeLoopSoundInstance>();
    private static boolean lastJumpDown = false;
    private static boolean lastSprintDown = false;

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (Block)ModBlocks.HAMSTER_BED.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"main"))) {
                ConfigDataCache.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerCommonPackets();
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientGuiEvent.RENDER_HUD.register((context, tickDelta) -> announcementHudRenderer.render(context, tickDelta));
        ClientCommandRegistrationEvent.EVENT.register(ModClientCommands::register);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            clientSessionTimer = 0;
            ClientParticleManager.INSTANCE.clear();
        });
        EntityEvent.ADD.register((entity, world) -> {
            if (world.m_5776_() && entity instanceof HamsterTreeSearcherEntity) {
                HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)entity;
                Minecraft client = Minecraft.m_91087_();
                HamsterTreeLoopSoundInstance existingSound = activeTreeSounds.get(searcher.m_19879_());
                if (existingSound == null || existingSound.m_7801_()) {
                    HamsterTreeLoopSoundInstance newSound = new HamsterTreeLoopSoundInstance(searcher);
                    client.m_91106_().m_120367_((SoundInstance)newSound);
                    activeTreeSounds.put(searcher.m_19879_(), newSound);
                }
                LeafJiggleManager.INSTANCE.onSearcherAdded(searcher);
            }
            return EventResult.pass();
        });
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (player.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && entity instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.m_90857_() && hamster.m_21824_() && hamster.m_21830_((LivingEntity)player)) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.RequestHamsterMountC2SPacket(hamster.m_19879_()));
                    return EventResult.interruptTrue();
                }
                if (((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue() && ModKeyBindings.RIDE_HAMSTER_KEY.m_90857_() && !hamster.m_20363_((Entity)player)) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.RequestHamsterRideC2SPacket(hamster.m_19879_()));
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.pass();
        });
    }

    public static void initBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedRenderer::new);
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
        EntityRendererRegistry.register(ModEntities.HAMSTER_TREE_SEARCHER, HamsterTreeSearcherRenderer::new);
    }

    private static void onEndClientTick(Minecraft client) {
        boolean ridingHamster;
        LeafJiggleManager.INSTANCE.clientTick(client);
        boolean isGuiOpen = client.f_91080_ != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.f_91073_ != null && !AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
            AnnouncementManager.INSTANCE.syncPatchouliReadState();
            if (AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
                AnnouncementManager.INSTANCE.processDeferredReadMarks();
            }
        }
        if (client.f_91073_ != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.f_91074_ == null || client.f_91073_ == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        boolean bl = ridingHamster = client.f_91074_ != null && client.f_91074_.m_20202_() instanceof HamsterEntity;
        if (ridingHamster && ((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
            boolean jumpDown = client.f_91066_.f_92089_.m_90857_();
            boolean sprintDown = client.f_91066_.f_92091_.m_90857_();
            if (jumpDown != lastJumpDown || sprintDown != lastSprintDown) {
                lastJumpDown = jumpDown;
                lastSprintDown = sprintDown;
                ModPackets.CHANNEL.sendToServer((Object)new ModPackets.HamsterInputC2SPacket(jumpDown, sprintDown));
                HamsterEntity hamster = (HamsterEntity)client.f_91074_.m_20202_();
                hamster.setRiderInput(jumpDown, sprintDown);
            }
        } else if (lastJumpDown || lastSprintDown) {
            lastJumpDown = false;
            lastSprintDown = false;
            ModPackets.CHANNEL.sendToServer((Object)new ModPackets.HamsterInputC2SPacket(false, false));
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.m_90859_()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.f_91074_.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.f_91077_ != null && client.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.ThrowHamsterC2SPacket());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entityId.intValue());
            buf.writeBoolean(false);
            ModPackets.CHANNEL.sendToServer((Object)new ModPackets.UpdateRenderStateC2SPacket(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
        AdorableHamsterPetsClient.handleGuidebookWarning(client);
        if (client.f_91073_ != null && !client.m_91104_()) {
            ClientParticleManager.INSTANCE.tick((Level)client.f_91073_);
        }
    }

    private static void handleGuidebookWarning(Minecraft client) {
        if (client.f_91074_ == null) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        String username = client.f_91074_.m_36316_().getName();
        if (config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
            return;
        }
        int warningTime = (Integer)config.guidebookWarningTimer.get();
        if (clientSessionTimer > warningTime + 145) {
            clientSessionTimer = 0;
        }
        if (++clientSessionTimer == 20 && AdorableHamsterPetsClient.hasGuideBook((Player)client.f_91074_)) {
            config.playersWhoHaveSeenGuidebookWarning.add(username);
            config.save();
        }
        if (clientSessionTimer == warningTime) {
            if (!AdorableHamsterPetsClient.hasGuideBook((Player)client.f_91074_)) {
                AdorableHamsterPetsClient.sendWarningPart1((Player)client.f_91074_);
            } else {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
        if (clientSessionTimer == warningTime + 140) {
            if (!AdorableHamsterPetsClient.hasGuideBook((Player)client.f_91074_)) {
                AdorableHamsterPetsClient.sendWarningPart2((Player)client.f_91074_);
            }
            if (!config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
    }

    private static boolean hasGuideBook(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    private static void sendWarningPart1(Player player) {
        MutableComponent message = Component.m_237113_((String)"\n").m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.only_once").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_130946_("\n\n");
        message.m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.header_prefix").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.header_title").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_130946_("\n\n");
        int ticks = (Integer)AdorableHamsterPets.CONFIG.guidebookWarningTimer.get();
        int minutes = Math.max(1, ticks / 1200);
        String key = minutes == 1 ? "message.adorablehamsterpets.warning.context.singular" : "message.adorablehamsterpets.warning.context.plural";
        message.m_7220_((Component)Component.m_237110_((String)key, (Object[])new Object[]{minutes}).m_130940_(ChatFormatting.GRAY));
        player.m_5661_((Component)message, false);
        player.m_5496_((SoundEvent)ModSounds.HAMSTER_DING.get(), 1.0f, 0.8f);
    }

    private static void sendWarningPart2(Player player) {
        MutableComponent message = Component.m_237113_((String)"\n").m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.oath_label").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.oath_text").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC})).m_130946_("\n\n");
        message.m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.action_button").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ahp_open_config_screen")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.adorablehamsterpets.warning.action_hover"))))).m_130946_("\n\n");
        message.m_7220_((Component)Component.m_237115_((String)"message.adorablehamsterpets.warning.crafting_help").m_130940_(ChatFormatting.GRAY));
        player.m_5661_((Component)message, false);
        player.m_5496_((SoundEvent)ModSounds.HAMSTER_DING.get(), 1.0f, 1.0f);
    }

    private static void handleDismountKeyPress(Minecraft client) {
        long delayMillis;
        long currentTime;
        boolean wasKeyPressed;
        boolean hasShoulderHamster;
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return;
        }
        try {
            hasShoulderHamster = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
        }
        catch (RuntimeException e) {
            hasShoulderHamster = false;
        }
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            KeyMapping vanillaSneak = client.f_91066_.f_92090_;
            KeyMapping customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.m_7249_(false);
                while (vanillaSneak.m_90859_()) {
                }
            }
            if (customDismount != null) {
                customDismount.m_7249_(false);
                while (customDismount.m_90859_()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            isWaitingForSecondSneakPress = false;
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        KeyMapping keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.f_91066_.f_92090_;
        boolean bl = wasKeyPressed = keyToListenFor != null && keyToListenFor.m_90859_();
        if (wasKeyPressed) {
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
                    isWaitingForSecondSneakPress = false;
                } else {
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            isWaitingForSecondSneakPress = false;
        }
    }

    public static void handleSyncShoulderData(int entityId, CompoundTag data) {
        Entity entity;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && (entity = client.f_91073_.m_6815_(entityId)) instanceof PlayerEntityAccessor) {
            PlayerEntityAccessor accessor = (PlayerEntityAccessor)entity;
            accessor.adorablehamsterpets$setRawShoulderData(data);
        }
    }

    public static void handleSpawnBeddingParticles(ModPackets.SpawnBeddingParticlesS2CPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        BlockPos spawnPos = packet.pos().m_121945_(packet.direction());
        Vec3 particleCenter = Vec3.m_82512_((Vec3i)spawnPos);
        SimpleParticleType particleType = ModParticles.getForVariant(packet.variant());
        for (int i = 0; i < 30; ++i) {
            double offsetX = client.f_91073_.f_46441_.m_188583_() * 1.2;
            double offsetY = client.f_91073_.f_46441_.m_188583_() * 1.2;
            double offsetZ = client.f_91073_.f_46441_.m_188583_() * 1.2;
            client.f_91073_.m_7106_((ParticleOptions)particleType, particleCenter.f_82479_ + offsetX, particleCenter.f_82480_ + offsetY, particleCenter.f_82481_ + offsetZ, 0.0, -1.23E-4, 0.0);
        }
    }

    public static void handlePlayGuidebookEffects(ModPackets.PlayGuidebookEffectsS2CPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return;
        }
        if (packet.closeScreen()) {
            client.m_91152_(null);
        }
        LocalPlayer player = client.f_91074_;
        ClientLevel world = client.f_91073_;
        if (player == null || world == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.guidebook_rediscovered").m_130940_(ChatFormatting.GOLD), true);
        world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.5f, 1.2f, false);
        world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11713_, SoundSource.PLAYERS, 0.7f, 1.5f, false);
        ParticleEffectsUtil.spawnParticlesOnEntity((Entity)player, ParticleTypes.f_123809_, 50, 0.6, 1.0, 0.5, 0.0);
        ParticleEffectsUtil.spawnParticlesOnEntity((Entity)player, ParticleTypes.f_123748_, 20, 1.0, 1.0, 0.5, 0.0);
    }

    public static void handlePlayDistantSound(ModPackets.PlayDistantSoundS2CPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)packet.soundId());
        client.f_91073_.m_7785_(client.f_91074_.m_20185_(), client.f_91074_.m_20186_(), client.f_91074_.m_20189_(), sound, SoundSource.NEUTRAL, packet.volume(), packet.pitch(), false);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }
}

