/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.render;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;

public class LeafJiggleManager {
    public static final LeafJiggleManager INSTANCE = new LeafJiggleManager();
    public static final int DURATION_TICKS = 20;
    private final Long2ObjectOpenHashMap<Jiggle> activeJiggles = new Long2ObjectOpenHashMap();
    private final Int2LongOpenHashMap searcherLastPositions = new Int2LongOpenHashMap();

    private LeafJiggleManager() {
    }

    public void onSearcherAdded(HamsterTreeSearcherEntity entity) {
        long posLong = entity.m_20183_().m_121878_();
        this.searcherLastPositions.put(entity.m_19879_(), entity.m_20183_().m_121878_());
        if (entity.m_9236_() != null) {
            this.startJiggle(posLong, entity.m_9236_().m_46467_(), LeafJiggleManager.mixSeed(entity.m_19879_(), posLong));
        }
    }

    public void clientTick(Minecraft client) {
        if (client.f_91073_ == null) {
            return;
        }
        long now = client.f_91073_.m_46467_();
        ObjectIterator iterator = this.searcherLastPositions.int2LongEntrySet().iterator();
        while (iterator.hasNext()) {
            long lastPosLong;
            HamsterTreeSearcherEntity searcher;
            Int2LongMap.Entry entry = (Int2LongMap.Entry)iterator.next();
            int entityId = entry.getIntKey();
            Entity entity = client.f_91073_.m_6815_(entityId);
            if (!(entity instanceof HamsterTreeSearcherEntity) || !(searcher = (HamsterTreeSearcherEntity)entity).m_6084_()) {
                iterator.remove();
                continue;
            }
            long currentPosLong = searcher.m_20183_().m_121878_();
            if (currentPosLong == (lastPosLong = entry.getLongValue())) continue;
            entry.setValue(currentPosLong);
            this.startJiggle(currentPosLong, now, LeafJiggleManager.mixSeed(entityId, currentPosLong));
        }
        this.activeJiggles.values().removeIf(j -> now - j.startTick > 20L);
    }

    private void startJiggle(long posLong, long now, long seed) {
        this.activeJiggles.put(posLong, (Object)new Jiggle(now, seed));
    }

    public Collection<Long2ObjectMap.Entry<Jiggle>> getActiveJiggles() {
        return this.activeJiggles.long2ObjectEntrySet();
    }

    private static long mixSeed(int entityId, long posLong) {
        long x = posLong ^ (long)entityId * -7046029254386353131L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    public record Jiggle(long startTick, long seed) {
    }
}

