/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.dawson.adorablehamsterpets.client.render.LeafJiggleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LeafJiggleRenderer {
    private static final float AMPLITUDE = 0.05f;
    private static final float ROTATION_AMPLITUDE = 4.0f;
    private static final float OSCILLATION_CYCLES = 6.0f;

    public static void render(Minecraft client, PoseStack matrices, MultiBufferSource vertexConsumers, Vec3 cameraPos, float tickDelta) {
        if (client.f_91073_ == null) {
            return;
        }
        long worldTime = client.f_91073_.m_46467_();
        BlockRenderDispatcher blockRenderManager = client.m_91289_();
        for (Long2ObjectMap.Entry<LeafJiggleManager.Jiggle> entry : LeafJiggleManager.INSTANCE.getActiveJiggles()) {
            LeafJiggleManager.Jiggle jiggle;
            float age;
            BlockState state;
            long posLong = entry.getLongKey();
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            if (!client.f_91073_.m_7232_(pos.m_123341_() >> 4, pos.m_123343_() >> 4) || !(state = client.f_91073_.m_8055_(pos)).m_204336_(BlockTags.f_13035_) || (age = (float)(worldTime - (jiggle = (LeafJiggleManager.Jiggle)entry.getValue()).startTick()) + tickDelta) < 0.0f || age > 20.0f) continue;
            float p = age / 20.0f;
            float envelope = 0.5f - 0.5f * Mth.m_14089_((float)((float)(Math.PI * 2 * (double)p)));
            float w = 1.8849556f;
            RandomSource r = RandomSource.m_216335_((long)jiggle.seed());
            float phaseX = r.m_188501_() * ((float)Math.PI * 2);
            float phaseZ = r.m_188501_() * ((float)Math.PI * 2);
            float phaseRotX = r.m_188501_() * ((float)Math.PI * 2);
            float phaseRotY = r.m_188501_() * ((float)Math.PI * 2);
            float phaseRotZ = r.m_188501_() * ((float)Math.PI * 2);
            float dx = envelope * 0.05f * Mth.m_14089_((float)(w * age + phaseX));
            float dy = 0.0f;
            float dz = envelope * 0.05f * Mth.m_14031_((float)(w * age + phaseZ));
            float rotX = envelope * 4.0f * Mth.m_14031_((float)(w * age + phaseRotX));
            float rotY = envelope * 4.0f * Mth.m_14089_((float)(w * age + phaseRotY));
            float rotZ = envelope * 4.0f * Mth.m_14031_((float)(w * age + phaseRotZ));
            matrices.m_85836_();
            matrices.m_85837_((double)pos.m_123341_() - cameraPos.f_82479_, (double)pos.m_123342_() - cameraPos.f_82480_, (double)pos.m_123343_() - cameraPos.f_82481_);
            matrices.m_85837_(0.5, 0.5, 0.5);
            matrices.m_252880_(dx, dy, dz);
            matrices.m_252781_(Axis.f_252529_.m_252977_(rotX));
            matrices.m_252781_(Axis.f_252436_.m_252977_(rotY));
            matrices.m_252781_(Axis.f_252403_.m_252977_(rotZ));
            matrices.m_85837_(-0.5, -0.5, -0.5);
            int light = LevelRenderer.m_109537_((BlockAndTintGetter)client.f_91073_, (BlockState)state, (BlockPos)pos);
            BakedModel model = blockRenderManager.m_110910_(state);
            VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110457_());
            blockRenderManager.m_110937_().m_234379_((BlockAndTintGetter)client.f_91073_, model, state, pos, matrices, buffer, false, RandomSource.m_216327_(), state.m_60726_(pos), OverlayTexture.f_118083_);
            matrices.m_85849_();
        }
    }
}

